/*
 * Decompiled with CFR 0.152.
 */
package ianywhere.ml.jdbcodbc.jdbc3;

import ianywhere.ml.jdbcodbc.IResource;
import ianywhere.ml.jdbcodbc.jdbc3.IIStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class IResultSetMetaData
implements ResultSetMetaData {
    private IIStatement istmt;

    IResultSetMetaData(IIStatement iIStatement) {
        this.istmt = iIStatement;
    }

    public String getCatalogName(int n) throws SQLException {
        return this.istmt.getColStrAttr(17, n);
    }

    public String getColumnClassName(int n) throws SQLException {
        throw new SQLException(IResource.getString("NYI"));
    }

    public int getColumnCount() throws SQLException {
        return this.istmt.getColNumAttr(1001, 1);
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        return this.istmt.getColNumAttr(6, n);
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.istmt.getColStrAttr(18, n);
    }

    public String getColumnName(int n) throws SQLException {
        return this.istmt.getColStrAttr(1011, n);
    }

    private int convertTypeIfNecessary(int n, int n2) throws SQLException {
        int n3 = this.istmt.getColNumAttr(1013, n);
        if (n3 != 0) {
            return n2;
        }
        switch (n2) {
            case 1: 
            case 12: {
                return -1;
            }
            case -3: 
            case -2: {
                return -4;
            }
        }
        return n2;
    }

    public int getColumnType(int n) throws SQLException {
        switch (this.istmt.getColNumAttr(2, n)) {
            case -7: {
                return -7;
            }
            case -6: {
                return -6;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return -5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case -8: 
            case 1: {
                return this.convertTypeIfNecessary(n, 1);
            }
            case -9: 
            case 12: {
                return this.convertTypeIfNecessary(n, 12);
            }
            case -10: 
            case -1: {
                return -1;
            }
            case 9: 
            case 91: {
                return 91;
            }
            case 10: 
            case 92: {
                return 92;
            }
            case 11: 
            case 93: {
                return 93;
            }
            case -2: {
                return this.convertTypeIfNecessary(n, -2);
            }
            case -3: {
                return this.convertTypeIfNecessary(n, -3);
            }
            case -4: {
                return -4;
            }
            case -98: {
                return -4;
            }
            case -99: {
                return -1;
            }
            case -154: {
                return 93;
            }
            case -11: {
                return -3;
            }
        }
        return 1111;
    }

    public String getColumnTypeName(int n) throws SQLException {
        return this.istmt.getColStrAttr(14, n);
    }

    public int getPrecision(int n) throws SQLException {
        return this.istmt.getColNumAttr(1005, n);
    }

    public int getScale(int n) throws SQLException {
        return this.istmt.getColNumAttr(1006, n);
    }

    public String getSchemaName(int n) throws SQLException {
        return this.istmt.getColStrAttr(16, n);
    }

    public String getTableName(int n) throws SQLException {
        return this.istmt.getColStrAttr(15, n);
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return this.istmt.getColNumAttr(11, n) == 1;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        return this.istmt.getColNumAttr(12, n) == 1;
    }

    public boolean isCurrency(int n) throws SQLException {
        return this.istmt.getColNumAttr(9, n) == 1;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    public int isNullable(int n) throws SQLException {
        switch (this.istmt.getColNumAttr(1008, n)) {
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        return 2;
    }

    public boolean isReadOnly(int n) throws SQLException {
        return this.istmt.getColNumAttr(10, n) == 0;
    }

    public boolean isSearchable(int n) throws SQLException {
        return this.istmt.getColNumAttr(13, n) != 0;
    }

    public boolean isSigned(int n) throws SQLException {
        return this.istmt.getColNumAttr(8, n) != 1;
    }

    public boolean isWritable(int n) throws SQLException {
        return this.istmt.getColNumAttr(10, n) == 1;
    }
}

