/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.utils.Debug;
import java.io.CharConversionException;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class TdsOutputStream
extends FilterOutputStream
implements DataOutput {
    protected byte[] _numbuf = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected static final int LOW_BYTE = 255;
    protected static final long D_LOW_BYTE = 255L;
    private boolean a = false;

    public TdsOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
    }

    public void write(int n2) throws IOException {
        this.out.write(n2);
    }

    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray, 0, byArray.length);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public final void writeUTF(String string) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public final void writeChar(int n2) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public final void writeBytes(String string) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public final void writeChars(String string) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public final void writeByte(int n2) throws IOException {
        this.write(n2);
    }

    public void setBigEndian(boolean bl) {
        this.a = !bl;
    }

    public boolean getBigEndian() {
        return !this.a;
    }

    public final void writeShort(int n2) throws IOException {
        if (this.a) {
            this._numbuf[1] = (byte)(n2 >>> 8 & 0xFF);
            this._numbuf[0] = (byte)(n2 >>> 0 & 0xFF);
        } else {
            this._numbuf[0] = (byte)(n2 >>> 8 & 0xFF);
            this._numbuf[1] = (byte)(n2 >>> 0 & 0xFF);
        }
        this.write(this._numbuf, 0, 2);
    }

    public final void writeInt(int n2) throws IOException {
        if (this.a) {
            this._numbuf[3] = (byte)(n2 >>> 24 & 0xFF);
            this._numbuf[2] = (byte)(n2 >>> 16 & 0xFF);
            this._numbuf[1] = (byte)(n2 >>> 8 & 0xFF);
            this._numbuf[0] = (byte)(n2 >>> 0 & 0xFF);
        } else {
            this._numbuf[0] = (byte)(n2 >>> 24 & 0xFF);
            this._numbuf[1] = (byte)(n2 >>> 16 & 0xFF);
            this._numbuf[2] = (byte)(n2 >>> 8 & 0xFF);
            this._numbuf[3] = (byte)(n2 >>> 0 & 0xFF);
        }
        this.write(this._numbuf, 0, 4);
    }

    public final void writeLongAsUnsignedInt(long l2) throws IOException {
        if (this.a) {
            this._numbuf[3] = (byte)(l2 >>> 24 & 0xFFL);
            this._numbuf[2] = (byte)(l2 >>> 16 & 0xFFL);
            this._numbuf[1] = (byte)(l2 >>> 8 & 0xFFL);
            this._numbuf[0] = (byte)(l2 >>> 0 & 0xFFL);
        } else {
            this._numbuf[0] = (byte)(l2 >>> 24 & 0xFFL);
            this._numbuf[1] = (byte)(l2 >>> 16 & 0xFFL);
            this._numbuf[2] = (byte)(l2 >>> 8 & 0xFFL);
            this._numbuf[3] = (byte)(l2 >>> 0 & 0xFFL);
        }
        this.write(this._numbuf, 0, 4);
    }

    public final void writeLong(long l2) throws IOException {
        if (this.a) {
            this._numbuf[7] = (byte)((int)(l2 >>> 56) & 0xFF);
            this._numbuf[6] = (byte)((int)(l2 >>> 48) & 0xFF);
            this._numbuf[5] = (byte)((int)(l2 >>> 40) & 0xFF);
            this._numbuf[4] = (byte)((int)(l2 >>> 32) & 0xFF);
            this._numbuf[3] = (byte)((int)(l2 >>> 24) & 0xFF);
            this._numbuf[2] = (byte)((int)(l2 >>> 16) & 0xFF);
            this._numbuf[1] = (byte)((int)(l2 >>> 8) & 0xFF);
            this._numbuf[0] = (byte)((int)(l2 >>> 0) & 0xFF);
        } else {
            this._numbuf[0] = (byte)((int)(l2 >>> 56) & 0xFF);
            this._numbuf[1] = (byte)((int)(l2 >>> 48) & 0xFF);
            this._numbuf[2] = (byte)((int)(l2 >>> 40) & 0xFF);
            this._numbuf[3] = (byte)((int)(l2 >>> 32) & 0xFF);
            this._numbuf[4] = (byte)((int)(l2 >>> 24) & 0xFF);
            this._numbuf[5] = (byte)((int)(l2 >>> 16) & 0xFF);
            this._numbuf[6] = (byte)((int)(l2 >>> 8) & 0xFF);
            this._numbuf[7] = (byte)((int)(l2 >>> 0) & 0xFF);
        }
        this.write(this._numbuf, 0, 8);
    }

    public final void writeFloat(float f2) throws IOException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    public final void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public final int size() {
        return -1;
    }

    public void writeString(String string) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public void writeStringLen(String string, int n2) throws IOException {
        int n3 = 0;
        if (string != null) {
            byte[] byArray = this.toBytes(string);
            n3 = byArray.length;
            if (n3 > n2) {
                ErrorMessage.raiseIOException("JZ0TS", string);
            }
            this.write(byArray);
        }
        for (int i2 = n3; i2 < n2; ++i2) {
            this.write(0);
        }
        this.write(n3);
    }

    public byte[] stringToByte(String string) throws IOException {
        try {
            return this.toBytes(string);
        }
        catch (CharConversionException charConversionException) {
            ErrorMessage.raiseIOException("JZ0I6", charConversionException.toString());
            Debug.asrt(null, false);
            return null;
        }
    }

    public final byte[] intToBytes(int n2) {
        if (this.a) {
            this._numbuf[3] = (byte)(n2 >>> 24 & 0xFF);
            this._numbuf[2] = (byte)(n2 >>> 16 & 0xFF);
            this._numbuf[1] = (byte)(n2 >>> 8 & 0xFF);
            this._numbuf[0] = (byte)(n2 >>> 0 & 0xFF);
        } else {
            this._numbuf[0] = (byte)(n2 >>> 24 & 0xFF);
            this._numbuf[1] = (byte)(n2 >>> 16 & 0xFF);
            this._numbuf[2] = (byte)(n2 >>> 8 & 0xFF);
            this._numbuf[3] = (byte)(n2 >>> 0 & 0xFF);
        }
        return this._numbuf;
    }

    protected abstract byte[] toBytes(String var1) throws CharConversionException;

    protected int getStringByteLen(String string) throws IOException {
        return string == null ? 0 : this.toBytes(string).length;
    }

    public abstract String getCharset();
}

