/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.Convert;
import com.sybase.jdbc3.jdbc.DateObject;
import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.JdbcDataObject;
import com.sybase.jdbc3.jdbc.Param;
import com.sybase.jdbc3.jdbc.Protocol;
import com.sybase.jdbc3.jdbc.ProtocolContext;
import com.sybase.jdbc3.jdbc.SybCallableStatement;
import com.sybase.jdbc3.jdbc.SybStatement;
import com.sybase.jdbc3.tds.SybTimestamp;
import com.sybase.jdbc3.tds.TdsNumeric;
import com.sybase.jdbc3.utils.CacheManager;
import com.sybase.jdbc3.utils.Cacheable;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ParamManager
implements Cacheable {
    public static final int PARAM_BY_NAME = 1;
    public static final int PARAM_BY_INDEX = 2;
    protected Param[] _params;
    protected int _next = -1;
    protected int _last = -1;
    private int z = -1;
    protected ArrayList _paramMdList = new ArrayList();
    protected SybStatement _stmt;
    protected ProtocolContext _context;
    protected Protocol _protocol;
    protected CacheManager _stmtMgr;
    private CacheManager w;
    private boolean B = false;
    private boolean F = false;
    private boolean E = false;
    protected boolean _hasLiteralParam = false;
    protected boolean _paramMarkersHaveBeenParsed = false;
    protected boolean _dontProcessParamMarkers = false;
    protected boolean _setHasBeenCalled = false;
    private String A = null;
    private boolean C = false;
    private ParamManager y = null;
    protected int _paramSetType = 0;
    private static final int D = 1;
    private static final int v = 2;
    private static final int G = 4;
    private static final String x = "RETURN_VALUE";

    public ParamManager(int n2, int[] nArray, SybStatement sybStatement) throws SQLException {
        int n3;
        this._stmt = sybStatement;
        this._context = sybStatement._context;
        this._stmtMgr = sybStatement._statementManager;
        this._protocol = this._context._protocol;
        this._params = this._protocol.paramArray(this._context, n2);
        for (n3 = 0; n3 < n2; n3 += 1) {
            this._params[n3]._paramMarkerOffset = nArray[n3];
        }
        this.w = new CacheManager(this._context._is);
        n3 = this._context._conn._props.getBoolean(14) ? 1 : 0;
        this.w.setReReadable(n3 != 0);
        int n4 = this._context._conn._props.getInteger(13);
        if (n3) {
            n4 = -1;
        }
        this.w.setCacheSize(n4);
        this.w.setChunkSize(256);
        this.w.setAbortOnCacheOverflow(true);
    }

    public ParamManager(ParamManager paramManager, SybStatement sybStatement) throws SQLException {
        boolean bl;
        this._stmt = sybStatement;
        this._context = sybStatement._context;
        this._stmtMgr = sybStatement._statementManager;
        this._protocol = this._context._protocol;
        boolean bl2 = paramManager._params.length;
        this._params = this._protocol.paramArray(this._context, bl2 ? 1 : 0);
        for (bl = false; bl < bl2; bl += 1) {
            this._params[bl]._paramMarkerOffset = paramManager._params[bl]._paramMarkerOffset;
        }
        this.w = this._context._conn.getSharedCacheManager();
        if (this.w == null) {
            this.w = new CacheManager(this._context._is);
            bl = this._context._conn._props.getBoolean(14);
            this.w.setReReadable(bl);
            int n2 = this._context._conn._props.getInteger(13);
            if (bl) {
                n2 = -1;
            }
            this.w.setCacheSize(n2);
            this.w.setChunkSize(256);
            this.w.setAbortOnCacheOverflow(true);
            this._context._conn.setSharedCacheManager(this.w);
        }
        if (paramManager.C) {
            this._hasLiteralParam = paramManager._hasLiteralParam;
            this.A = paramManager.A;
            this._paramMarkersHaveBeenParsed = true;
        }
        this.y = paramManager;
    }

    public ParamManager(int n2, SybStatement sybStatement) throws SQLException {
        this(n2, sybStatement._context);
        this._stmt = sybStatement;
    }

    public ParamManager(int n2, ProtocolContext protocolContext) throws SQLException {
        this._context = protocolContext;
        this._protocol = this._context._protocol;
        this._params = this._protocol.paramArray(n2, this.w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        if (this.F) {
            return;
        }
        try {
            if (this.B) {
                if (this.z >= 0 && this._params[this.z]._outValue == null) {
                    this.getOutValueAt(this.z + 1);
                }
                if (!this.E) {
                    this.clearParams(false);
                }
            }
            this.w.clear();
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOECheckDead(sQLException);
        }
        finally {
            this._stmtMgr.dead(this);
        }
    }

    public void setManager(CacheManager cacheManager) {
    }

    public void reset() throws IOException {
    }

    public void resetInputStream(InputStream inputStream) {
    }

    public void cache() throws IOException {
        if (this.F) {
            return;
        }
        this.F = true;
        this.w.register(this);
        this.w.open(this);
        this.w.doneReading();
        this.w.dead(this);
        this.F = false;
        this._stmtMgr.doneReading();
    }

    public void open(boolean bl) {
    }

    public int getState() {
        return 1;
    }

    public int getNext() {
        return this._next;
    }

    public Param[] getParams() {
        return this._params;
    }

    public ProtocolContext getContext() {
        return this._context;
    }

    protected synchronized void clearParams(boolean bl) throws IOException {
        if (this.E) {
            return;
        }
        if (this.B) {
            this.E = true;
            this._stmtMgr.open(this);
            this.cache();
            this.E = false;
            this.B = false;
        }
        this.clearParamArray(bl);
        this.w.clear();
        this.w.allDead();
    }

    protected synchronized void clearParamArray(boolean bl) throws IOException {
        int n2 = 0;
        if (this._params.length > 0 && this._params[0]._sqlType == -998) {
            n2 = 1;
            this._params[0].clear(false);
        }
        for (int i2 = n2; i2 < this._params.length; ++i2) {
            this._params[i2].clear(bl);
        }
        this._next = -1;
        this._last = -1;
    }

    private void int(int n2) throws SQLException {
        if (n2 < 1 || n2 > this._params.length) {
            ErrorMessage.raiseError("JZ0SB", "" + n2);
        }
    }

    private void do(int n2) throws SQLException {
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2000: {
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SL", "" + n2);
            }
        }
    }

    public void setParamMd(ResultSet resultSet) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        while (resultSet.next()) {
            if (x.equalsIgnoreCase(resultSet.getString("COLUMN_NAME")) && resultSet.getInt("COLUMN_TYPE") == 0) {
                if (!this._stmt._sendAsRpc) {
                    ((SybCallableStatement)this._stmt).extractParams();
                }
                if (n2 == 0 && !this._stmt._hasReturn) {
                    ++n2;
                    continue;
                }
            } else if (this._stmt._rowFmtIdxList != null && this._stmt._rowFmtIdxList.size() > 0) {
                int n4;
                try {
                    n4 = (Integer)this._stmt._rowFmtIdxList.get(n3);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
                if (n4 != n2) continue;
                ++n3;
            }
            Param param = this._protocol.getParam();
            param._sqlType = resultSet.getInt("DATA_TYPE");
            param._sqlTypeName = resultSet.getString("TYPE_NAME");
            switch (resultSet.getInt("COLUMN_TYPE")) {
                case 1: {
                    param._regType = 1;
                    break;
                }
                case 2: {
                    param._regType = 2;
                    break;
                }
                case 4: {
                    param._regType = 4;
                    break;
                }
                default: {
                    param._regType = 0;
                }
            }
            param._precision = resultSet.getInt("PRECISION");
            param._scale = resultSet.getInt("SCALE");
            switch (resultSet.getInt("NULLABLE")) {
                case 0: {
                    param._isNullable = 0;
                    break;
                }
                case 1: {
                    param._isNullable = 1;
                    break;
                }
                default: {
                    param._isNullable = 2;
                }
            }
            switch (resultSet.getInt("SS_DATA_TYPE")) {
                case 38: 
                case 48: 
                case 52: 
                case 56: 
                case 59: 
                case 60: 
                case 62: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 122: 
                case 191: {
                    param._isSigned = true;
                    break;
                }
                default: {
                    param._isSigned = false;
                }
            }
            this._paramMdList.add(param);
            ++n2;
        }
    }

    public void setParamMd(ResultSetMetaData resultSetMetaData, boolean bl) throws SQLException {
        block3: {
            block2: {
                if (bl) break block2;
                Vector vector = this._stmt._rowFmtIdxList;
                if (vector == null || vector.size() <= 0) break block3;
                for (int i2 = 0; i2 < vector.size(); ++i2) {
                    int n2 = (Integer)vector.get(i2);
                    this._paramMdList.add(i2, this.a(resultSetMetaData, n2, bl));
                }
                break block3;
            }
            for (int i3 = 1; i3 <= resultSetMetaData.getColumnCount(); ++i3) {
                this._paramMdList.add(this.a(resultSetMetaData, i3, bl));
            }
        }
    }

    private Param a(ResultSetMetaData resultSetMetaData, int n2, boolean bl) throws SQLException {
        Param param = this._protocol.getParam();
        param._sqlType = resultSetMetaData.getColumnType(n2);
        param._sqlTypeName = resultSetMetaData.getColumnTypeName(n2);
        param._regType = 1;
        param._precision = resultSetMetaData.getPrecision(n2);
        param._scale = resultSetMetaData.getScale(n2);
        param._isSigned = resultSetMetaData.isSigned(n2);
        param._isNullable = bl ? 2 : (resultSetMetaData.isNullable(n2) == 1 ? 1 : 0);
        return param;
    }

    public void setParam(String string, int n2, Object object, int n3) throws SQLException {
        this.try();
        int n4 = this.getParamIndexByName(string);
        this.doSetParam(n4, n2, object, n3);
        this._params[n4 - 1]._name = string;
    }

    public void setParam(int n2, int n3, Object object, int n4) throws SQLException {
        this.byte();
        this.doSetParam(n2, n3, object, n4);
    }

    protected void doSetParam(int n2, int n3, Object object, int n4) throws SQLException {
        this.int(n2);
        Param param = this._params[--n2];
        if (param._sqlType == -998) {
            ErrorMessage.raiseError("JZ0SC");
        }
        try {
            param.clear(false);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        switch (n3) {
            case 2: {
                if (!(object instanceof BigDecimal)) break;
                TdsNumeric.checkRange((BigDecimal)object, n4);
                break;
            }
        }
        param._sqlType = n3;
        param._inValue = object;
        param._scale = n4;
        this._setHasBeenCalled = true;
    }

    public void registerParam(String string, int n2, int n3) throws SQLException {
        this.try();
        int n4 = this.getParamIndexByName(string);
        this.doRegisterParam(n4, n2);
        this._params[n4 - 1]._name = string;
        this._params[n4 - 1]._scale = n3;
    }

    public void registerParam(int n2, int n3, int n4) throws SQLException {
        this.registerParam(n2, n3);
        this._params[n2 - 1]._scale = n4;
    }

    public void registerParam(String string, int n2) throws SQLException {
        this.try();
        int n3 = this.getParamIndexByName(string);
        this.doRegisterParam(n3, n2);
        this._params[n3 - 1]._name = string;
    }

    public void registerParam(int n2, int n3) throws SQLException {
        this.byte();
        this.doRegisterParam(n2, n3);
    }

    protected void doRegisterParam(int n2, int n3) throws SQLException {
        this.int(n2);
        this.do(n3);
        if (--n2 > this.z) {
            this.z = n2;
        }
        this._params[n2]._regType = n3;
        if (this._stmt._hasReturn && n2 == 0) {
            this._stmt._returnHasBeenRegistered = true;
        }
    }

    public void registerParam(String string, int n2, String string2) throws SQLException {
        this.try();
        int n3 = this.getParamIndexByName(string);
        this.doRegisterParam(n3, n2);
        this._params[n3 - 1]._name = string;
        this._params[n3 - 1]._outParamClassName = string2;
    }

    public void registerParam(int n2, int n3, String string) throws SQLException {
        this.registerParam(n2, n3);
        this._params[--n2]._outParamClassName = string;
    }

    private void int() throws SQLException {
        if (this._next < 0) {
            ErrorMessage.raiseError("JZ0SF");
        }
    }

    public JdbcDataObject getOutValueAt(String string) throws SQLException {
        this.try();
        int n2 = this.getParamIndexByName(string);
        return this.doGetOutValueAt(n2);
    }

    public JdbcDataObject getOutValueAt(int n2) throws SQLException {
        this.byte();
        return this.doGetOutValueAt(n2);
    }

    protected JdbcDataObject doGetOutValueAt(int n2) throws SQLException {
        this.int();
        this.int(n2);
        if (this._params[--n2]._regType == -999 || this._stmt._hasReturn && n2 == 0 && !this._stmt._returnHasBeenRegistered) {
            ErrorMessage.raiseError("JZ0SB", "" + n2);
        }
        while (this._params[n2]._outValue == null) {
            this.nextOutParam();
            while (this._params[n2]._outValue == null) {
                this.new();
            }
        }
        this._last = n2;
        return this._params[n2]._outValue;
    }

    public Object getOutObjectAt(String string) throws SQLException {
        this.try();
        int n2 = this.getParamIndexByName(string);
        return this.doGetOutObjectAt(n2);
    }

    public Object getOutObjectAt(int n2) throws SQLException {
        this.byte();
        return this.doGetOutObjectAt(n2);
    }

    protected Object doGetOutObjectAt(int n2) throws SQLException {
        Object object = null;
        JdbcDataObject jdbcDataObject = this.doGetOutValueAt(n2);
        switch (this._params[--n2]._regType) {
            case -6: 
            case 5: {
                object = Convert.objectToShort(jdbcDataObject.getObject());
                break;
            }
            case -5: {
                Object object2 = jdbcDataObject.getObject();
                if (object2 == null) {
                    object = null;
                    break;
                }
                if (object2 instanceof Integer) {
                    object = new Long(((Integer)object2).longValue());
                    break;
                }
                if (object2 instanceof BigDecimal) {
                    object = new Long(((BigDecimal)object2).longValue());
                    break;
                }
                if (!(object2 instanceof Long)) break;
                object = object2;
                break;
            }
            case 2: 
            case 3: {
                if (this._params[n2]._scale != -999) {
                    object = jdbcDataObject.getBigDecimal(this._params[n2]._scale);
                    break;
                }
                object = jdbcDataObject.getBigDecimal(-1);
                break;
            }
            case 6: {
                object = Convert.objectToDouble(jdbcDataObject.getObject());
                break;
            }
            case 91: {
                object = Convert.objectToDate(jdbcDataObject.getDateObject(91, null));
                break;
            }
            case 92: {
                object = Convert.objectToTime(jdbcDataObject.getDateObject(92, null));
                break;
            }
            case 93: {
                object = Convert.objectToTimestamp(jdbcDataObject.getDateObject(93, null));
                break;
            }
            default: {
                object = jdbcDataObject.getObject();
            }
        }
        return object;
    }

    public boolean hasInParams() {
        if (this._params.length == 0) {
            return false;
        }
        return this._params.length > 1 || this._params[0]._sqlType != -998;
    }

    protected boolean wasNull() throws SQLException {
        this.int();
        if (this._last < 0 || this._params[this._last]._outValue == null) {
            ErrorMessage.raiseError("JZ0SD");
        }
        return this._params[this._last]._outValue.isNull();
    }

    protected void getParameter() throws SQLException {
        this.int();
        this._protocol.param(this);
    }

    public int nextOutParam(String string) {
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            if (this._params[i2]._name == null || !this._params[i2]._name.equalsIgnoreCase(string) || this._params[i2]._regType == -999) continue;
            return i2;
        }
        return -1;
    }

    public int nextOutParam() {
        if (this._next < this._params.length && this._params[this._next]._outValue != null) {
            ++this._next;
        }
        while (this._next < this._params.length && this._params[this._next]._regType == -999) {
            ++this._next;
        }
        return this._next;
    }

    public void registerParam(Cacheable cacheable) throws SQLException {
        this.nextOutParam();
        try {
            this.B = true;
            this.w.register(cacheable);
            this.w.open(cacheable);
            this._stmtMgr.register(this);
            this._stmtMgr.open(this);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    public void registerStatus(Cacheable cacheable) throws SQLException {
        if (this._params.length > 0 && this._params[0]._sqlType == -998) {
            this.registerParam(cacheable);
        } else {
            try {
                cacheable.clear();
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
    }

    private int new() throws SQLException {
        int n2 = this._next;
        while (true) {
            try {
                while (true) {
                    int n3 = this._stmt.nextResult();
                    switch (n3) {
                        case 3: {
                            return n3;
                        }
                        case 0: {
                            ErrorMessage.raiseError("JZ0SG");
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                this._stmt.handleSQLE(sQLException);
                continue;
            }
            break;
        }
    }

    public void checkParams(Protocol protocol, boolean bl) throws SQLException {
        boolean bl2 = false;
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            this.for(i2);
            this._params[i2].prepareForSend(protocol, i2, bl);
            bl2 |= this._params[i2]._sendAsLiteral;
        }
        if (this._paramMarkersHaveBeenParsed) {
            if (!this._setHasBeenCalled) {
                this._dontProcessParamMarkers = true;
            } else if (!bl2 && !this._hasLiteralParam) {
                this._dontProcessParamMarkers = true;
            }
        }
        this._hasLiteralParam = bl2;
    }

    public void parseParamsAgain() {
        this._paramMarkersHaveBeenParsed = false;
    }

    public void send(OutputStream outputStream) throws IOException, SQLException {
        this._next = 0;
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            this._params[i2].send(outputStream, this._context._maxFieldSize);
        }
    }

    public int getLength() {
        int n2 = 0;
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            n2 += this._params[i2].getLength();
        }
        return n2;
    }

    public void adjustOffsets(int n2) {
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            this._params[i2]._paramMarkerOffset += n2;
        }
    }

    protected void literalizeAll() {
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            this._params[i2]._sendAsLiteral = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processParamMarkers(String string) throws SQLException {
        if (this._params.length == 0) {
            return null;
        }
        if (this._dontProcessParamMarkers) {
            this._dontProcessParamMarkers = false;
            this._setHasBeenCalled = false;
            return this.A;
        }
        int n2 = 0;
        if (this._params[n2]._sqlType == -998) {
            ++n2;
        }
        if (n2 == this._params.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n3 = 0;
        try {
            while (n2 < this._params.length) {
                if (this._params[n2]._sqlType != -998) {
                    stringBuffer.append(string.substring(n3, this._params[n2]._paramMarkerOffset));
                    stringBuffer.append(this._params[n2].literalValue(this._protocol, n2, this._context._maxFieldSize));
                    n3 = this._params[n2]._paramMarkerOffset + 1;
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        if (n3 < string.length()) {
            stringBuffer.append(string.substring(n3));
        }
        this.A = stringBuffer.toString();
        if (!this._hasLiteralParam && this.y != null && !this.y.C) {
            ParamManager paramManager = this.y;
            synchronized (paramManager) {
                if (!this.y.C) {
                    this.y.A = this.A;
                    this.y._hasLiteralParam = this._hasLiteralParam;
                    this.y.C = true;
                }
            }
        }
        this._dontProcessParamMarkers = false;
        this._setHasBeenCalled = false;
        this._paramMarkersHaveBeenParsed = true;
        return this.A;
    }

    public int makeFormats() throws IOException {
        int n2 = 0;
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            if (!this._params[i2].makeFormat(this._protocol)) continue;
            ++n2;
        }
        return n2;
    }

    public void sendFormats(DataOutput dataOutput) throws IOException {
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            this._params[i2].sendFormat(dataOutput);
        }
    }

    public int getParamIndexByName(String string) {
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            if (this._params[i2]._name != null && !this._params[i2]._name.equalsIgnoreCase(string)) continue;
            return i2 + 1;
        }
        return 0;
    }

    public int getParamSetType() {
        return this._paramSetType;
    }

    private void try() throws SQLException {
        if (this._paramSetType == 2) {
            ErrorMessage.raiseError("JZ0SV");
        }
        if (this._paramSetType != 1) {
            this._paramSetType = 1;
        }
    }

    private void byte() throws SQLException {
        if (this._paramSetType == 1) {
            ErrorMessage.raiseError("JZ0SV");
        } else if (this._paramSetType != 2) {
            this._paramSetType = 2;
        }
    }

    private void for(int n2) throws SQLException {
        if (this._params[n2]._sqlType == 93) {
            try {
                if (this._params[n2]._inValue != null) {
                    SybTimestamp.checkNanos((DateObject)this._params[n2]._inValue);
                }
            }
            catch (SQLException sQLException) {
                this._stmt.handleSQLE(sQLException);
            }
        }
    }

    protected String getColumnNames() {
        StringBuffer stringBuffer = null;
        for (int i2 = 0; i2 < this._params.length; ++i2) {
            if (this._stmt._hasReturn && i2 == 0 || this._params[i2]._name == null) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append("'");
            stringBuffer.append(this._params[i2]._name);
            stringBuffer.append("',");
        }
        if (stringBuffer != null) {
            return stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        return null;
    }
}

