/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.DateObject;
import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.tds.SybTimestamp;
import com.sybase.jdbc3.utils.HexConverts;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class Convert {
    private static final long a = 255L;

    private Convert() {
    }

    public static final String objectToString(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof byte[]) {
            return HexConverts.hexConvert((byte[])object);
        }
        if (object instanceof Reader) {
            ErrorMessage.raiseError("JZ0IR");
        }
        return object.toString();
    }

    public static final InputStream objectToStream(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new StringBufferInputStream((String)object);
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        if (object instanceof InputStream) {
            ErrorMessage.raiseError("JZ0IS");
        }
        ErrorMessage.raiseError("JZ0TE", "String, byte[]");
        return null;
    }

    public static final Reader objectToReader(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new StringReader((String)object);
        }
        if (object instanceof byte[]) {
            return new InputStreamReader(new ByteArrayInputStream((byte[])object));
        }
        if (object instanceof InputStream) {
            return new InputStreamReader((InputStream)object);
        }
        if (object instanceof Reader) {
            ErrorMessage.raiseError("JZ0IS");
        }
        ErrorMessage.raiseError("JZ0TC");
        return null;
    }

    public static Boolean objectToBoolean(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof String && !((String)object).trim().equals("0") && !((String)object).trim().equals("1")) {
            return new Boolean((String)object);
        }
        double d2 = Convert.objectToDoubleValue(object);
        return new Boolean(d2 != 0.0);
    }

    public static Integer objectToUSmallInt(Object object) throws SQLException {
        boolean bl = false;
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        long l2 = Convert.objectToLongValue(object);
        Convert.checkUSmallIntOflo(l2);
        return new Integer((int)l2);
    }

    public static Integer objectToUInt(Object object) throws SQLException {
        boolean bl = false;
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        long l2 = Convert.objectToLongValue(object);
        Convert.checkUintOflo(l2);
        return new Integer((int)l2);
    }

    public static BigDecimal objectToUBigInt(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = Convert.objectToBigDecimal(object);
            Convert.checkUBigintOflo(bigDecimal);
            return bigDecimal;
        }
        if (object instanceof String || object instanceof Long) {
            try {
                BigDecimal bigDecimal = new BigDecimal(Convert.numString(object));
                Convert.checkUBigintOflo(bigDecimal);
                return bigDecimal;
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            }
        }
        BigDecimal bigDecimal = Convert.objectToBigDecimal(object);
        Convert.checkUBigintOflo(bigDecimal);
        return new BigDecimal(Convert.objectToDoubleValue(object));
    }

    public static Integer objectToInt(Object object) throws SQLException {
        boolean bl = false;
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        long l2 = Convert.objectToLongValue(object);
        Convert.checkIntOflo(l2);
        return new Integer((int)l2);
    }

    public static Short objectToShort(Object object) throws SQLException {
        boolean bl = false;
        if (object == null) {
            return null;
        }
        if (object instanceof Short) {
            return (Short)object;
        }
        long l2 = Convert.objectToLongValue(object);
        Convert.checkShortOflo(l2);
        return new Short((short)l2);
    }

    public static Long objectToLong(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        BigDecimal bigDecimal = Convert.objectToBigDecimal(object);
        Convert.checkLongOflo(bigDecimal);
        long l2 = Convert.objectToLongValue(object);
        return new Long(l2);
    }

    public static Float objectToFloat(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Float) {
            return (Float)object;
        }
        return new Float(Convert.objectToDoubleValue(object));
    }

    public static Double objectToDouble(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        return new Double(Convert.objectToDoubleValue(object));
    }

    public static double objectToDoubleValue(Object object) throws SQLException {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Long) {
            return ((Long)object).doubleValue();
        }
        if (object instanceof Short) {
            return ((Short)object).doubleValue();
        }
        if (object instanceof byte[]) {
            return Convert.bufToDouble((byte[])object);
        }
        if (object instanceof String) {
            try {
                return new Double(Convert.numString(object));
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            }
        }
        ErrorMessage.raiseError("JZ0TE", "Double, Float, BigDecimal, Boolean, Integer, Long, Short, byte[], String");
        return 0.0;
    }

    public static long objectToLongValue(Object object) throws SQLException {
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Short) {
            return ((Short)object).longValue();
        }
        if (object instanceof Double) {
            return ((Double)object).longValue();
        }
        if (object instanceof Float) {
            return ((Float)object).longValue();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).longValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof byte[]) {
            return Convert.bufToLong((byte[])object);
        }
        if (object instanceof String) {
            try {
                return new Long(Convert.numString(object));
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            }
        }
        ErrorMessage.raiseError("JZ0TE", "Double, Float, BigDecimal, Boolean, Integer, Long, Short, byte[], String");
        return 0L;
    }

    public static BigDecimal objectToBigDecimal(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof String || object instanceof Long) {
            try {
                return new BigDecimal(Convert.numString(object));
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            }
        }
        return new BigDecimal(Convert.objectToDoubleValue(object));
    }

    public static byte[] objectToBytes(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            String string = (String)object;
            int n2 = string.length();
            if (n2 == 0) {
                return new byte[0];
            }
            if ((n2 & 1) == 0) {
                byte[] byArray = new byte[string.length() / 2 - 1];
                int n3 = 2;
                int n4 = 0;
                while (n3 < string.length()) {
                    byArray[n4] = (byte)(16 * Convert.hexToDecimal(string.charAt(n3)) + Convert.hexToDecimal(string.charAt(n3 + 1)));
                    n3 += 2;
                    ++n4;
                }
                return byArray;
            }
        }
        ErrorMessage.raiseError("JZ0TE", "Double, Float, BigDecimal, Integer, Long");
        return null;
    }

    public static Date objectToDate(Object object) throws SQLException {
        Object object2;
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof String) {
            object2 = Convert.numString(object);
            int n2 = ((String)object2).indexOf(" ");
            if (n2 > 0) {
                object2 = ((String)object2).substring(0, n2);
            }
            try {
                return Date.valueOf((String)object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorMessage.raiseError("JZ009", illegalArgumentException.toString());
            }
        }
        if (object instanceof Timestamp) {
            object2 = (Timestamp)object;
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime((java.util.Date)object2);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return new Date(calendar.getTime().getTime());
        }
        if (object instanceof DateObject) {
            object2 = (Calendar)((DateObject)object).getCalendar().clone();
            ((Calendar)object2).set(11, 0);
            ((Calendar)object2).set(12, 0);
            ((Calendar)object2).set(13, 0);
            ((Calendar)object2).set(14, 0);
            return new Date(((Calendar)object2).getTime().getTime());
        }
        ErrorMessage.raiseError("JZ0TC");
        return null;
    }

    public static Calendar objectToCalendar(Object object, Calendar calendar) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Calendar) {
            return (Calendar)object;
        }
        Calendar calendar2 = calendar;
        if (calendar2 == null) {
            calendar2 = Calendar.getInstance();
        }
        calendar.clear();
        if (object instanceof Date) {
            calendar.setTime((java.util.Date)object);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        } else if (object instanceof Time) {
            calendar.setTime((java.util.Date)object);
            calendar.set(6, 1);
            calendar.set(1, 1970);
        } else if (object instanceof Timestamp) {
            calendar.setTime((java.util.Date)object);
            calendar.set(14, ((Timestamp)object).getNanos() / 1000000);
        } else {
            ErrorMessage.raiseError("JZ0TC");
        }
        return calendar;
    }

    public static Time objectToTime(Object object) throws SQLException {
        Object object2;
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof String) {
            object2 = Convert.numString(object);
            int n2 = ((String)object2).indexOf(" ");
            if (n2 > 0) {
                object2 = ((String)object2).substring(n2 + 1, n2 + 9);
            }
            try {
                return Time.valueOf((String)object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorMessage.raiseError("JZ009", illegalArgumentException.toString());
            }
        }
        if (object instanceof Timestamp) {
            object2 = (Timestamp)object;
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime((java.util.Date)object2);
            calendar.set(1, 1970);
            calendar.set(2, 0);
            calendar.set(5, 1);
            return new Time(calendar.getTime().getTime());
        }
        if (object instanceof DateObject) {
            object2 = (Calendar)((DateObject)object).getCalendar().clone();
            ((Calendar)object2).set(6, 1);
            ((Calendar)object2).set(1, 1970);
            return new Time(((Calendar)object2).getTime().getTime());
        }
        ErrorMessage.raiseError("JZ0TE", "java.sql.Time, java.sql.Timestamp, String");
        return null;
    }

    public static Timestamp objectToTimestamp(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof String) {
            try {
                return Timestamp.valueOf(Convert.numString(object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorMessage.raiseError("JZ009", illegalArgumentException.toString());
            }
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return new SybTimestamp(calendar.getTime().getTime());
        }
        if (object instanceof Time) {
            Time time = (Time)object;
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(time);
            calendar.set(1, 1970);
            calendar.set(2, 0);
            calendar.set(5, 1);
            return new SybTimestamp(calendar.getTime().getTime());
        }
        if (object instanceof DateObject) {
            return ((DateObject)object).toSybTimestamp();
        }
        ErrorMessage.raiseError("JZ0TC");
        return null;
    }

    public static DateObject objectToDateObject(Object object, Calendar calendar) throws SQLException {
        return Convert.objectToDateObject(object, 93, calendar);
    }

    public static DateObject objectToDateObject(Object object, int n2, Calendar calendar) throws SQLException {
        Object object2 = object;
        DateObject dateObject = null;
        if (object2 == null) {
            return null;
        }
        if (object instanceof DateObject) {
            return (DateObject)object;
        }
        if (!(object2 instanceof Calendar)) {
            Calendar calendar2 = null;
            switch (n2) {
                case 91: {
                    object2 = Convert.objectToDate(object2);
                    dateObject = new DateObject(object2, calendar);
                    calendar2 = dateObject.getCalendar();
                    calendar2.set(11, 0);
                    calendar2.set(12, 0);
                    calendar2.set(13, 0);
                    calendar2.set(14, 0);
                    break;
                }
                case 92: {
                    object2 = Convert.objectToTime(object2);
                    dateObject = new DateObject(object2, calendar);
                    calendar2 = dateObject.getCalendar();
                    calendar2.set(6, 1);
                    calendar2.set(1, 1970);
                    break;
                }
                case 93: {
                    object2 = Convert.objectToTimestamp(object2);
                    dateObject = new DateObject(object2, calendar);
                    break;
                }
                default: {
                    ErrorMessage.raiseError("JZ0TC");
                }
            }
            return dateObject;
        }
        return new DateObject(object2, calendar);
    }

    public static String numString(Object object) throws SQLException {
        int n2;
        String string = Convert.objectToString(object);
        int n3 = string.length();
        block6: for (n2 = 0; n2 < n3; ++n2) {
            switch (string.charAt(n2)) {
                case '\t': 
                case '\n': 
                case ' ': 
                case '+': {
                    continue block6;
                }
            }
        }
        --n3;
        block7: while (n3 > n2) {
            switch (string.charAt(n3)) {
                case '\t': 
                case '\n': 
                case ' ': {
                    break;
                }
                default: {
                    break block7;
                }
            }
            --n3;
        }
        return string.substring(n2, n3 + 1);
    }

    public static byte hexToDecimal(char c2) throws SQLException {
        switch (c2) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        ErrorMessage.raiseError("JZ0HC", "" + c2);
        return 0;
    }

    public static void checkByteOflo(long l2) throws SQLException {
        if (l2 < -128L || l2 > 127L) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkIntOflo(long l2) throws SQLException {
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkShortOflo(long l2) throws SQLException {
        if (l2 < -32768L || l2 > 32767L) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkUSmallIntOflo(long l2) throws SQLException {
        if (l2 < 0L || l2 > 65535L) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkUintOflo(long l2) throws SQLException {
        if (l2 < 0L || l2 > Long.parseLong("4294967295")) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkUBigintOflo(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal.compareTo(new BigDecimal("0")) == -1 || bigDecimal.compareTo(new BigDecimal("18446744073709551615")) == 1) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkLongOflo(double d2) throws SQLException {
        if (d2 < -9.223372036854776E18 || d2 > 9.223372036854776E18) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkLongOflo(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal.compareTo(new BigDecimal("-9223372036854775808")) == -1 || bigDecimal.compareTo(new BigDecimal("9223372036854775807")) == 1) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static BigDecimal setScale(BigDecimal bigDecimal, int n2) throws SQLException {
        if (bigDecimal != null && n2 >= 0) {
            try {
                bigDecimal = bigDecimal.setScale(n2, 4);
            }
            catch (ArithmeticException arithmeticException) {
                ErrorMessage.raiseError("JZ009", arithmeticException.getMessage());
            }
        }
        return bigDecimal;
    }

    public static long bufToLong(byte[] byArray) throws SQLException {
        long l2 = 0L;
        switch (byArray.length) {
            case 1: {
                l2 = 0xFFL & (long)byArray[0];
                break;
            }
            case 2: {
                l2 = (0xFFL & (long)byArray[0]) << 8 | 0xFFL & (long)byArray[1];
                break;
            }
            case 4: {
                l2 = (0xFFL & (long)byArray[0]) << 24 | (0xFFL & (long)byArray[1]) << 16 | (0xFFL & (long)byArray[2]) << 8 | 0xFFL & (long)byArray[3];
                break;
            }
            case 8: {
                l2 = (0xFFL & (long)byArray[0]) << 56 | (0xFFL & (long)byArray[1]) << 48 | (0xFFL & (long)byArray[2]) << 40 | (0xFFL & (long)byArray[3]) << 32 | (0xFFL & (long)byArray[4]) << 24 | (0xFFL & (long)byArray[5]) << 16 | (0xFFL & (long)byArray[6]) << 8 | 0xFFL & (long)byArray[7];
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        return l2;
    }

    public static double bufToDouble(byte[] byArray) throws SQLException {
        double d2 = 0.0;
        switch (byArray.length) {
            case 4: {
                d2 = (0xFFL & (long)byArray[0]) << 24 | (0xFFL & (long)byArray[1]) << 16 | (0xFFL & (long)byArray[2]) << 8 | 0xFFL & (long)byArray[3];
                break;
            }
            case 8: {
                d2 = (0xFFL & (long)byArray[0]) << 56 | (0xFFL & (long)byArray[1]) << 48 | (0xFFL & (long)byArray[2]) << 40 | (0xFFL & (long)byArray[3]) << 32 | (0xFFL & (long)byArray[4]) << 24 | (0xFFL & (long)byArray[5]) << 16 | (0xFFL & (long)byArray[6]) << 8 | 0xFFL & (long)byArray[7];
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        return d2;
    }
}

