/*
 * Decompiled with CFR 0.152.
 */
package utility;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;

public class ziputil {
    private static TMainWin MainWin = Aspect.MainWin;
    private static boolean Debug = false;

    public static String addFileToZip(String string, String[] stringArray, boolean bl, String string2) {
        int n;
        ZipEntry zipEntry;
        String string3;
        int n2;
        ZipOutputStream zipOutputStream;
        File file;
        String string4 = "";
        File file2 = null;
        String[] stringArray2 = new String[stringArray.length];
        String string5 = "";
        String string6 = "";
        String string7 = "";
        byte[] byArray = new byte[1024];
        boolean bl2 = false;
        if (Debug) {
            MainWin.appendToLog("zipuil", "addFileToZip", Thread.currentThread(), null, 10, "addFileToZip() started");
        }
        if (string2.length() > 0) {
            string7 = charutil.replaceChar(string2, '\\', '/').toUpperCase();
        }
        String[] stringArray3 = dosutil.splitPath(string);
        file2 = new File(string);
        string5 = file2.getAbsolutePath();
        if (file2.exists()) {
            stringArray3 = dosutil.splitPath(string);
            try {
                if (Debug) {
                    MainWin.appendToLog("zipuil", "addFileToZip", Thread.currentThread(), null, 10, "Renaming existing archive");
                }
                String string8 = "";
                if (stringArray3[0] != null) {
                    string8 = stringArray3[0];
                }
                if (stringArray3[1] != null) {
                    string8 = string8 + stringArray3[1];
                }
                if ((file = File.createTempFile("$$$", ".tmp", new File(string8 = dosutil.addTrailingSlash(string8)))).exists()) {
                    file.delete();
                }
                file2.renameTo(file);
                file2 = new File(string8 + file.getName());
                string6 = file2.getAbsolutePath();
            }
            catch (Exception exception) {
                MainWin.appendToLog("zipuil", "addFileToZip", Thread.currentThread(), null, 10, "Error renaming existing archive: " + exception.toString());
                return exception.toString();
            }
            bl2 = true;
        }
        if (bl2) {
            // empty if block
        }
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return fileNotFoundException.toString();
        }
        catch (IOException iOException) {
            return iOException.toString();
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray3 = dosutil.splitPath(stringArray[n2]);
            stringArray2[n2] = stringArray3[2];
            if (stringArray3[3] != null) {
                int n3 = n2;
                stringArray2[n3] = stringArray2[n3] + stringArray3[3];
            }
            file = new File(stringArray[n2]);
            boolean bl3 = false;
            if (file.getAbsolutePath().equalsIgnoreCase(string5)) {
                bl3 = true;
            }
            if (file.getAbsolutePath().equalsIgnoreCase(string6)) {
                bl3 = true;
            }
            if (bl3) continue;
            if (Debug) {
                MainWin.appendToLog("zipuil", "addFileToZip", Thread.currentThread(), null, 10, "Adding file to archive: " + file.getAbsoluteFile());
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(stringArray[n2]);
                if (bl) {
                    String string9 = string2.length() > 0 ? ((string3 = charutil.replaceChar(stringArray[n2], '\\', '/').toUpperCase()).startsWith(string7) ? stringArray[n2].substring(string7.length()) : stringArray[n2]) : stringArray[n2];
                    zipEntry = new ZipEntry(string9);
                } else {
                    zipEntry = new ZipEntry(stringArray2[n2]);
                }
                zipOutputStream.putNextEntry(zipEntry);
                while ((n = fileInputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.closeEntry();
                continue;
            }
            catch (Exception exception) {
                if (string4.length() > 0) {
                    string4 = string4 + "\n";
                }
                string4 = string4 + exception.toString();
                if (Aspect.MainWin == null) {
                    System.out.println("Error updating archive1 " + string + " file=" + stringArray[n2]);
                    continue;
                }
                Aspect.MainWin.appendToLog("ziputil", "addFileToZip", Thread.currentThread(), exception, 4, "Error updating archive1 " + string + " file=" + stringArray[n2]);
            }
        }
        if (bl2) {
            boolean bl4;
            if (Debug) {
                MainWin.appendToLog("zipuil", "addFileToZip", Thread.currentThread(), null, 10, "Adding files from original archive");
            }
            ZipInputStream zipInputStream = null;
            try {
                zipInputStream = new ZipInputStream(new FileInputStream(file2));
                zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    string3 = zipEntry.getName();
                    if (Debug) {
                        MainWin.appendToLog("zipuil", "addFileToZip", Thread.currentThread(), null, 10, "Evaluating entry: " + zipEntry.getName());
                    }
                    boolean bl5 = false;
                    for (n2 = 0; !bl5 && n2 < stringArray.length; ++n2) {
                        if (bl) {
                            String string10 = stringArray[n2];
                            if (string2.length() > 0 && (string10 = charutil.replaceChar(stringArray[n2], '\\', '/').toUpperCase()).startsWith(string7)) {
                                string10 = stringArray[n2].substring(string7.length());
                            }
                            if (!string3.equalsIgnoreCase(string10)) continue;
                            bl5 = true;
                            continue;
                        }
                        if (!string3.equalsIgnoreCase(stringArray2[n2])) continue;
                        bl5 = true;
                    }
                    if (!bl5) {
                        if (Debug) {
                            MainWin.appendToLog("zipuil", "addFileToZip", Thread.currentThread(), null, 10, "Adding file from original archive:" + string3);
                        }
                        try {
                            zipOutputStream.putNextEntry(new ZipEntry(string3));
                            while ((n = zipInputStream.read(byArray)) > 0) {
                                zipOutputStream.write(byArray, 0, n);
                            }
                            zipOutputStream.closeEntry();
                        }
                        catch (Exception exception) {
                            if (string4.length() > 0) {
                                string4 = string4 + "\n";
                            }
                            string4 = string4 + exception.toString();
                            Aspect.MainWin.appendToLog("ziputil", "addFileToZip", Thread.currentThread(), exception, 4, "Error updating archive2 " + string);
                        }
                    } else if (Debug) {
                        MainWin.appendToLog("zipuil", "addFileToZip", Thread.currentThread(), null, 10, "New archive already contains file from original archive:" + string3);
                    }
                    zipEntry = zipInputStream.getNextEntry();
                }
            }
            catch (Exception exception) {
                if (string4.length() > 0) {
                    string4 = string4 + "\n";
                }
                string4 = string4 + exception.toString();
                Aspect.MainWin.appendToLog("ziputil", "addFileToZip", Thread.currentThread(), exception, 4, "Error updating archive2 " + string);
            }
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(bl4 = file2.delete())) {
                System.out.println("Unable to delete " + file2.getName());
            }
        }
        try {
            zipOutputStream.close();
        }
        catch (Exception exception) {
            if (string4.length() > 0) {
                string4 = string4 + "\n";
            }
            string4 = string4 + exception.toString();
            Aspect.MainWin.appendToLog("ziputil", "addFileToZip", Thread.currentThread(), exception, 4, "Error updating archive3 " + string);
        }
        if (string4.length() == 0) {
            string4 = "ok";
        }
        return string4;
    }

    public static String addFilesToArchive(String string, String string2, boolean bl, boolean bl2, String string3, String string4) {
        String string5 = "";
        String string6 = dosutil.listMatchingFiles(string2, 1, bl2, true, 0, string4);
        String[] stringArray = charutil.getSubStringArray(string6, '|', false);
        string5 = stringArray != null && stringArray.length > 0 ? ziputil.addFileToZip(string, stringArray, bl, string3) : "Nothing to do.";
        return string5;
    }

    public static String[] getZipContents(String string, boolean bl) {
        String[] stringArray;
        ZipInputStream zipInputStream = null;
        File file = new File(string);
        if (!file.exists()) {
            Aspect.MainWin.appendToLog("ziputil", "getZipContents", Thread.currentThread(), null, 4, "Cannot locate zip file named: " + string);
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                stringArray = zipEntry.getName();
                String string2 = Long.toString(zipEntry.getSize());
                long l = zipEntry.getTime();
                String string3 = Long.toString(l);
                if (bl) {
                    string3 = dateutil.formatDate(new Date(l), "MM-dd-yyyy HH:mm:sszzz");
                }
                arrayList.add((String)stringArray + '\n' + string2 + '\n' + string3);
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception exception) {
            Aspect.MainWin.appendToLog("ziputil", "getZipContents", Thread.currentThread(), exception, 4, "Error getting archive contents: " + string);
        }
        if (zipInputStream != null) {
            try {
                zipInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public static byte[] zipString(String string) {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            ZipEntry zipEntry = new ZipEntry("String");
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray2 = new byte[string.length()];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = (byte)string.charAt(i);
            }
            zipOutputStream.write(byArray2);
            zipOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
            MainWin.appendToLog("ziputil", "zipString", Thread.currentThread(), exception, 3, "Error zipping string: " + string);
        }
        return byArray;
    }

    public static String unzipString(byte[] byArray) {
        StringBuilder stringBuilder;
        block4: {
            stringBuilder = new StringBuilder();
            try {
                int n;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);
                byte[] byArray2 = new byte[2048];
                byte[] byArray3 = new byte[]{};
                int n2 = 0;
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                do {
                    if ((n = zipInputStream.read(byArray2)) <= 0) continue;
                    byArray3 = (byte[])charutil.arrayGrow(byArray3, byArray3.length + n);
                    System.arraycopy(byArray2, 0, byArray3, n2, n);
                    n2 += n;
                } while (n > 0);
                for (int i = 0; i < byArray3.length; ++i) {
                    stringBuilder.append((char)byArray3[i]);
                }
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                exception.printStackTrace();
                if (MainWin == null) break block4;
                MainWin.appendToLog("ziputil", "unzipString", Thread.currentThread(), exception, 3, "Error unzipping string.");
            }
        }
        return stringBuilder.toString();
    }

    public static byte[] gzipString(String string) {
        return ziputil.gzipString(string, "");
    }

    public static byte[] gzipString(String string, String string2) {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            byte[] byArray2 = null;
            if (string2.length() > 0) {
                byArray2 = string.getBytes(string2);
            } else {
                byArray2 = new byte[string.length()];
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray2[i] = (byte)string.charAt(i);
                }
            }
            gZIPOutputStream.write(byArray2);
            gZIPOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
            MainWin.appendToLog("ziputil", "zipString", Thread.currentThread(), exception, 3, "Error zipping string: " + string);
        }
        return byArray;
    }

    public static String gunzipString(byte[] byArray) throws IOException {
        return ziputil.gunzipString(byArray, "");
    }

    public static String gunzipString(byte[] byArray, String string) throws IOException {
        StringBuilder stringBuilder = null;
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            byte[] byArray2 = new byte[byArray.length * 10];
            byte[] byArray3 = new byte[byArray.length * 10];
            int n2 = 0;
            do {
                if ((n = gZIPInputStream.read(byArray2, 0, byArray2.length)) <= 0) continue;
                if (byArray3.length <= n2 + n) {
                    byArray3 = (byte[])charutil.arrayGrow(byArray3, byArray3.length + n + byArray.length * 10);
                }
                System.arraycopy(byArray2, 0, byArray3, n2, n);
                n2 += n;
            } while (n > 0);
            gZIPInputStream.close();
            byteArrayInputStream.close();
            stringBuilder = string.length() > 0 ? new StringBuilder(new String(byArray3, 0, n2, string)) : new StringBuilder(new String(byArray3, 0, n2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (MainWin != null) {
                MainWin.appendToLog("ziputil", "unzipString", Thread.currentThread(), exception, 3, "Error unzipping string.");
            }
            stringBuilder = new StringBuilder();
        }
        return stringBuilder.toString();
    }

    public static boolean verifyArchive(String string) {
        File file = new File(string);
        if (!file.exists()) {
            Aspect.MainWin.appendToLog("ziputil", "verifyArchive", Thread.currentThread(), null, 4, "Cannot locate zip file named: " + string);
            return false;
        }
        ZipFile zipFile = null;
        ZipInputStream zipInputStream = null;
        boolean bl = false;
        try {
            zipFile = new ZipFile(string);
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string2 = zipEntry.getName();
                long l = zipEntry.getSize();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                inputStream.close();
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            Aspect.MainWin.appendToLog("ziputil", "verifyArchive", Thread.currentThread(), exception, 4, "Error getting archive contents: " + string);
            return false;
        }
        if (zipInputStream != null) {
            try {
                zipInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            return true;
        }
        Aspect.MainWin.appendToLog("ziputil", "verifyArchive", Thread.currentThread(), null, 4, "Error in archive : " + string);
        return false;
    }

    public static String unzip(String string, String string2) {
        String string3 = charutil.replaceChar(string, '/', '\\');
        String string4 = charutil.replaceChar(dosutil.removeTrailingSlash(string2), '/', '\\');
        System.out.println("zipFilePath=" + string3);
        System.out.println("destDir=" + string4);
        System.out.println("_destDir=" + string2);
        File file = new File(string4);
        if (!file.exists()) {
            file.mkdirs();
        }
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(string3);
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                int n2;
                String string5 = zipEntry.getName();
                File file2 = new File(string4 + File.separator + string5);
                System.out.println("Unzipping to " + file2.getAbsolutePath());
                new File(file2.getParent()).mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                while ((n2 = zipInputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n2);
                }
                fileOutputStream.close();
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
                ++n;
            }
            zipInputStream.closeEntry();
            zipInputStream.close();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return "Ok: Unzipped " + n + " files";
    }
}

