/*
 * Decompiled with CFR 0.152.
 */
package utility.transport;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import resources.TApplication;
import scripts.TExecScript;
import scrollwin.table.TScrollTable;
import utility.TDriverMerge;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.email.TSendMail;
import utility.ftp.TFtpClient;
import utility.objectutil;
import utility.transport.TTransportRecord;
import utility.ziputil;

public class TTransport {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    private static boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTTransport");
    public static boolean IsProcessing = false;
    private static TAspectDriver drvTransports = null;

    public static void setStatusMessage(String string) {
        Application.setTokenValue("AspectTransportUtilityStatus", string);
    }

    private static String getBaseDirectory(String string) {
        if (dosutil.isDirectory(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        StringBuilder stringBuilder2 = new StringBuilder();
        charutil.replace_char(stringBuilder, stringBuilder, '*', 'x');
        charutil.replace_char(stringBuilder, stringBuilder, '?', 'x');
        String[] stringArray = dosutil.splitPath(stringBuilder.toString());
        if (stringArray[0] != null) {
            stringBuilder2.append(stringArray[0]);
        }
        if (stringArray[1] != null) {
            stringBuilder2.append(stringArray[1]);
        }
        return stringBuilder2.toString();
    }

    public static String transportCopy(TTransportRecord tTransportRecord) {
        String string;
        String[] stringArray = tTransportRecord.getSourceFilename();
        String string2 = string = tTransportRecord.getDestinationFilename();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n = tTransportRecord.getOverwriteOptions();
        String string3 = tTransportRecord.getSourcePassword();
        String string4 = tTransportRecord.getDestinationPassword();
        String string5 = "";
        boolean bl = tTransportRecord.getAppend();
        boolean bl2 = dosutil.isDirectory(string);
        if (stringArray == null || stringArray.length == 0) {
            stringBuilder.append("Source not found");
        } else {
            int n2;
            string5 = TTransport.getBaseDirectory(tTransportRecord.getSourceBaseFilename()).toUpperCase();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                String string6;
                if (tTransportRecord.getRecurseDirectories() && bl2) {
                    String[] stringArray2 = dosutil.splitPath(stringArray[n2]);
                    stringBuilder2.setLength(0);
                    if (stringArray2[0] != null) {
                        stringBuilder2.append(stringArray2[0]);
                    }
                    if (stringArray2[1] != null) {
                        stringBuilder2.append(stringArray2[1]);
                    }
                    if (stringBuilder2.toString().toUpperCase().startsWith(string5)) {
                        stringBuilder2.delete(0, string5.length());
                    }
                    if (stringBuilder2.length() > 0 && (stringBuilder2.charAt(0) == '/' || stringBuilder2.charAt(0) == '\\')) {
                        stringBuilder2.deleteCharAt(0);
                    }
                    string2 = dosutil.addTrailingSlash(string) + stringBuilder2.toString();
                    if (stringArray2[2] != null) {
                        string2 = string2 + stringArray2[2];
                    }
                    if (stringArray2[3] != null) {
                        string2 = string2 + stringArray2[3];
                    }
                } else {
                    string2 = string;
                }
                if ((string6 = dosutil.copyFile(stringArray[n2], string2, n, bl, string3, string4, "")).equalsIgnoreCase("ok")) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("; ");
                }
                stringBuilder.append(string6);
            }
            if (stringBuilder.length() == 0 && tTransportRecord.getMove()) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    String string7 = dosutil.formatURL(stringArray[n2]);
                    if (string7.toUpperCase().startsWith("FILE")) {
                        File file = new File(stringArray[n2]);
                        dosutil.deleteFile(file);
                        continue;
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("; ");
                    }
                    stringBuilder.append("Cannot delete file '" + stringArray[n2] + "'");
                }
            }
            if (stringBuilder.length() == 0) {
                stringBuilder.append("Ok");
            }
        }
        if (stringBuilder.toString().toUpperCase().startsWith("OK")) {
            return "Ok.  Copied to " + string + ".";
        }
        return stringBuilder.toString();
    }

    public static String transportMerge(TTransportRecord tTransportRecord) {
        String string = tTransportRecord.getSource();
        String string2 = tTransportRecord.getDestination();
        String string3 = tTransportRecord.getMergeSourceFilter();
        String string4 = tTransportRecord.getMergeDestFilter();
        String string5 = tTransportRecord.getMergeKeyFields();
        String string6 = tTransportRecord.getMergeFieldsToMerge();
        String string7 = tTransportRecord.getMergeAliasFields();
        boolean bl = tTransportRecord.getAppend();
        TAspectDriver tAspectDriver = new TAspectDriver(string, 0, false, true, "");
        TAspectDriver tAspectDriver2 = new TAspectDriver(string2, 1, false, true, "");
        TTransport.setStatusMessage("Merging files...");
        TDriverMerge tDriverMerge = new TDriverMerge(bl, tAspectDriver2, string4, tAspectDriver, string3, string5, string6, string7, false);
        tDriverMerge.merge();
        tAspectDriver.dispose();
        tAspectDriver2.dispose();
        return "ok";
    }

    public static String transportZipAdd(TTransportRecord tTransportRecord) {
        String[] stringArray = tTransportRecord.getSourceFilename();
        String string = tTransportRecord.getDestinationFilename();
        String string2 = tTransportRecord.getZipBaseDirectory();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = tTransportRecord.getZipIncludePaths();
        if (stringArray == null || stringArray.length == 0) {
            stringBuilder.append("Source not found");
        } else {
            TTransport.setStatusMessage("Adding files to archive...");
            stringBuilder.append(ziputil.addFileToZip(string, stringArray, bl, string2));
        }
        return stringBuilder.toString();
    }

    public static String transportZipExtract(TTransportRecord tTransportRecord) {
        return "Extracting from an archive is not yet implemented.";
    }

    public static String transportFtpSend(TTransportRecord tTransportRecord) {
        String[] stringArray = tTransportRecord.getSourceFilename();
        if (stringArray == null || stringArray.length == 0) {
            return "Source not found";
        }
        Date date = new Date();
        String string = tTransportRecord.getFTPAccount();
        String string2 = tTransportRecord.getDestinationFilename();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String[] stringArray2 = dosutil.splitPath(tTransportRecord.getSourceBaseFilename());
        StringBuilder stringBuilder3 = new StringBuilder();
        if (stringArray2[0] != null) {
            stringBuilder3.append(stringArray2[0]);
        }
        if (stringArray2[1] != null) {
            stringBuilder3.append(stringArray2[1]);
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].substring(stringBuilder3.length());
            stringArray2 = dosutil.splitPath(string3);
            stringBuilder2.setLength(0);
            stringBuilder2.append(string2);
            charutil.replace_char(stringBuilder2, stringBuilder2, '\\', '/');
            if (stringBuilder2.charAt(stringBuilder2.length() - 1) == '/') {
                stringBuilder2.append(stringArray2[2]);
                stringBuilder2.append(stringArray2[3]);
                charutil.replace_char(stringBuilder2, stringBuilder2, '\\', '/');
            }
            File file = new File(stringArray[i]);
            long l = file.length();
            string3 = "Sending " + stringArray[i] + " as " + stringBuilder2 + " (" + l + " bytes)";
            if (Debug) {
                MainWin.appendToLog("TTransport", "transportFtpSend", Thread.currentThread(), null, 10, string3);
            }
            TTransport.setStatusMessage(string3);
            String string4 = "";
            int n2 = 10000000;
            if (l > (long)n2) {
                string4 = "Error: Size of " + stringArray[i] + " exceeds maximum of " + n2;
                tTransportRecord.appendMessage(string3 + " Result: " + string4);
                tTransportRecord.setResult(2);
            } else {
                if (string.length() > 0) {
                    string4 = TFtpClient.transferFile(string, stringArray[i], stringBuilder2.toString(), 0);
                } else {
                    String string5 = tTransportRecord.getFTPHost();
                    String string6 = tTransportRecord.getFTPUserName();
                    String string7 = tTransportRecord.getFTPPassword();
                    boolean bl = tTransportRecord.getFTPPassive();
                    string4 = TFtpClient.transferFile(string5, string6, string7, bl, stringArray[i], stringBuilder2.toString(), 0);
                }
                tTransportRecord.appendMessage(string3 + " Result: " + string4);
            }
            if (string4.toUpperCase().startsWith("OK")) continue;
            ++n;
        }
        if (n > 0) {
            return Integer.toString(n) + " errors";
        }
        tTransportRecord.setFtpTransferDuration((int)(new Date().getTime() - date.getTime()) / 1000);
        return "Ok";
    }

    public static String transportFtpReceive(TTransportRecord tTransportRecord) {
        String string = tTransportRecord.getFTPAccount();
        String string2 = tTransportRecord.getDestinationFilename();
        String string3 = tTransportRecord.getSourceFilename()[0];
        String string4 = "ok";
        File file = new File(string2);
        TTransport.setStatusMessage("Receiving file by ftp...");
        string4 = TFtpClient.transferFile(string, string2, string3, 1);
        return string4;
    }

    public static String transportPrint(TTransportRecord tTransportRecord) {
        return "Print is not yet implemented";
    }

    public static String transportConvertToPDF(TTransportRecord tTransportRecord) {
        return "Convert to pdf is not yet implemented";
    }

    public static String transportConvertToHTML(TTransportRecord tTransportRecord) {
        return "Convert to html is not yet implemented";
    }

    public static String transportConvertToXML(TTransportRecord tTransportRecord) {
        return "Convert to xml is not yet implemented";
    }

    public static String transportConvertToAscii(TTransportRecord tTransportRecord) {
        String string = tTransportRecord.getSource();
        String string2 = tTransportRecord.getDestination();
        String string3 = tTransportRecord.getExportStructure();
        boolean bl = tTransportRecord.getExportFieldDescriptions();
        boolean bl2 = tTransportRecord.getExportFieldIDs();
        boolean bl3 = tTransportRecord.getExportFieldDataTypes();
        boolean bl4 = tTransportRecord.getExportVirtualFields();
        TAspectDriver tAspectDriver = new TAspectDriver(string, 0, false, true, "");
        TTransport.setStatusMessage("Exporting to ascii...");
        if (string3.equals("0")) {
            string3 = tAspectDriver.AppDriverObj.StructureIndex.toString();
        }
        tAspectDriver.exportToAscii(string2, string3, bl, bl2, bl3, bl4, tTransportRecord.getDelimiter(), false, false);
        return "ok";
    }

    public static String transportSendEmail(TTransportRecord tTransportRecord) {
        int n;
        CharSequence charSequence;
        Object object;
        Object object2;
        String string = tTransportRecord.getEmailAccount();
        String string2 = tTransportRecord.getEmailToAddress();
        String string3 = tTransportRecord.getEmailSubject();
        String string4 = tTransportRecord.getEmailBody();
        String[] stringArray = tTransportRecord.getSourceFilename();
        String string5 = tTransportRecord.getEmailBodyFileName();
        if (string5.length() > 0 && (object2 = ((TAsciiInput)(object = new TAsciiInput(string5, '\u0000'))).get_entire_file()) != null) {
            charSequence = new StringBuilder();
            for (n = 0; n < ((byte[])object2).length; ++n) {
                charSequence.append((char)object2[n]);
            }
            if (string4.length() > 0) {
                string4 = string4 + "\n";
            }
            string4 = string4 + charSequence.toString();
        }
        string4 = charutil.replaceAllSubstrings(string4, "&", "//ampersand//");
        object = "";
        if (string.trim().length() == 0 || string.equalsIgnoreCase("Aspect Mail Server") || string.equals("0")) {
            object2 = new TExecScript("GreenLight_sendMail_Client", null, new TFormulaEvaluator());
            charSequence = "From=aspect@aspect-software.net&To=" + string2 + "&Subject=" + string3 + "&Body=" + string4 + "&BodyFilename=" + string5;
            charSequence = (String)charSequence + "&CC=&BCC=";
            if (stringArray != null) {
                System.out.println("TTransport adding " + stringArray.length + " attachments");
                charSequence = (String)charSequence + "&Attachment=";
                for (n = 0; n < stringArray.length; ++n) {
                    if (n > 0) {
                        charSequence = (String)charSequence + ";";
                    }
                    charSequence = (String)charSequence + stringArray[n];
                    System.out.println("TTransport added attachment: " + stringArray[n]);
                }
            } else {
                System.out.println("TTransport no attachments");
            }
            ((TExecScript)object2).setParameters((String)charSequence);
            ((TExecScript)object2).executeScript();
            object = objectutil.convertToString(((TExecScript)object2).getScriptResult());
        } else {
            object = TSendMail.sendMail(string, string2, string3, string4, stringArray, "", "");
        }
        if (((String)object).toUpperCase().startsWith("OK")) {
            object2 = charutil.getSubStringArray(string2, ';', true);
            object = object2 != null && ((byte[])object2).length > 10 ? "Ok. Mail sent to: " + ((byte[])object2).length + " recipients." : "Ok. Mail sent to: " + string2;
        }
        return object;
    }

    public static String transportToAspectServer(TTransportRecord tTransportRecord) {
        System.out.println("Transport to Aspect Server");
        String[] stringArray = tTransportRecord.getSourceFilename();
        if (stringArray == null || stringArray.length == 0) {
            return "Source not found";
        }
        String string = tTransportRecord.getDestination();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = dosutil.splitPath(stringArray[i]);
            StringBuilder stringBuilder2 = new StringBuilder();
            if (stringArray2[2] != null) {
                stringBuilder2.append(stringArray2[2]);
            }
            if (stringArray2[3] != null) {
                stringBuilder2.append(stringArray2[3]);
            }
            if (stringBuilder2.length() <= 0) continue;
            TExecScript tExecScript = new TExecScript("GreenLight_Send_File", null, new TFormulaEvaluator());
            String[] stringArray3 = new String[]{tTransportRecord.getAspectServer(), stringArray[i], stringBuilder2.toString(), string};
            tExecScript.setParameters(stringArray3);
            tExecScript.executeScript();
            if (stringBuilder.length() > 0) {
                stringBuilder.append("<br>");
            }
            stringBuilder.append(tExecScript.getScriptResult());
        }
        return stringBuilder.toString();
    }

    public static String transportFromAspectServer(TTransportRecord tTransportRecord) {
        TExecScript tExecScript = new TExecScript("GreenLight_Client_Receive_File", null, new TFormulaEvaluator());
        String[] stringArray = new String[]{tTransportRecord.getAspectServer(), tTransportRecord.getDestinationFilename(), tTransportRecord.getSourceFilename()[0]};
        tExecScript.setParameters(stringArray);
        tExecScript.start();
        while (!tExecScript.isFinished()) {
            Thread.yield();
        }
        return (String)tExecScript.getScriptResult();
    }

    public static String transportLibrarySend(TTransportRecord tTransportRecord) {
        String string = tTransportRecord.getDestination();
        TExecScript tExecScript = new TExecScript("Library_postToLibrary_Client/?" + string, null, new TFormulaEvaluator());
        tExecScript.executeScript();
        return (String)tExecScript.getScriptResult();
    }

    public static String transportLibraryReceive(TTransportRecord tTransportRecord) {
        return "Library receive transport is not functional";
    }

    public static Object executeScript(String string, String string2) {
        if (string.length() == 0 || string.equals("0")) {
            return null;
        }
        TExecScript tExecScript = new TExecScript(string, null, new TFormulaEvaluator());
        if (string2 != null && string2.length() > 0) {
            tExecScript.setParameters(charutil.getSubStringArray(string2, '|', true));
        }
        tExecScript.executeScript();
        return tExecScript.getScriptResult();
    }

    public static void recordLibraryHistory(String string, int n, String string2) {
        String[] stringArray = new String[6];
        switch (n) {
            case 10: {
                stringArray[0] = "7";
                break;
            }
            case 5: {
                stringArray[0] = "8";
                break;
            }
            case 15: {
                stringArray[0] = "9";
                break;
            }
            case 1: {
                stringArray[0] = "10";
                break;
            }
            default: {
                MainWin.appendToLog("TTransport", "recordLibraryHistory", Thread.currentThread(), null, 4, "Cannot record document history for method = " + n);
                return;
            }
        }
        stringArray[1] = string;
        stringArray[2] = "";
        stringArray[3] = "";
        stringArray[4] = "";
        stringArray[5] = string2;
        TExecScript tExecScript = new TExecScript("Library_appendHistory", null, new TFormulaEvaluator());
        tExecScript.setParameters(stringArray);
        tExecScript.start();
    }

    public static String processTransport(String string) {
        Object object;
        String[] stringArray;
        int n;
        if (Debug) {
            MainWin.appendToLog("TTransport", "execTransport", Thread.currentThread(), null, 10, "processTransport(" + string + ")");
        }
        TAspectDriver tAspectDriver = new TAspectDriver("Aspect_Transport_Queue", 1, true, true, "");
        TTransportRecord tTransportRecord = new TTransportRecord(tAspectDriver, "");
        tAspectDriver.setActiveFilter("(result=4) and (ID=\"" + string + "\")", true);
        int n2 = tAspectDriver.getRecordCount();
        for (n = 0; n < n2; ++n) {
            File file;
            tTransportRecord.setRecord(n);
            if (!tTransportRecord.getDeleteSourceAfterExecute()) continue;
            stringArray = tTransportRecord.getSourceFilename();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].toUpperCase().indexOf("LIBRARY/QUEUE") <= 0) continue;
                    file = new File(stringArray[i]);
                    dosutil.deleteFile(file);
                }
            }
            if (((String)(object = tTransportRecord.getEmailBodyFileName())).length() <= 0 || ((String)object).toUpperCase().indexOf("LIBRARY/QUEUE") <= 0) continue;
            file = new File((String)object);
            dosutil.deleteFile(file);
        }
        stringArray = new String[]{"Time_Queued"};
        tAspectDriver.setSortOptions(stringArray, false);
        tAspectDriver.setActiveFilter("(result=0) and (ID=\"" + string + "\")", true);
        n2 = tAspectDriver.getRecordCount();
        if (n2 == 0) {
            object = "There are no transports to process for " + string + " at " + dateutil.formatDate(new Date(), "MM-dd-yyyy hh:mm:ss");
            Application.setTokenValue("Aspect_Common_Transport_Msg", (String)object);
            tAspectDriver.dispose();
            return object;
        }
        object = MainWin.getTablePanelWithDriverID("Aspect_Transport_Queue");
        for (n = 0; n < n2; ++n) {
            String string2;
            Object object2;
            tTransportRecord.setRecord(n);
            int n3 = tTransportRecord.getAttemptsMade() + 1;
            int n4 = tTransportRecord.getMaximumAttempts();
            boolean bl = false;
            if (n3 > 0) {
                object2 = tTransportRecord.getTimeOfLastAttempt();
                int n5 = tTransportRecord.getHoursBetweenAttempts() * 60 + tTransportRecord.getMinutesBetweenAttempts();
                long l = (new Date().getTime() - ((Date)object2).getTime()) / 1000L / 60L;
                if (l < (long)n5) {
                    bl = true;
                    if (Debug) {
                        System.out.println("minutes between: " + n5 + " minutes elapsed: " + l);
                    }
                }
            }
            if (bl) continue;
            Application.setTokenValue("Aspect_Common_Transport_Msg", " Processing: " + tTransportRecord.getDescription() + " at " + dateutil.formatDate(new Date(), "MM-dd-yyyy HH:mm:ss"));
            tTransportRecord.setAttemptsMade(n3);
            object2 = tTransportRecord.getExecScriptBefore();
            if (!((String)object2).equalsIgnoreCase("0")) {
                Object object3 = TTransport.executeScript((String)object2, tTransportRecord.getExecScriptBeforeArgs());
                if (object3 instanceof Double) {
                    int n6 = ((Double)object3).intValue();
                    if (n6 >= 0 && n6 <= TTransportRecord.MaxResult) {
                        string2 = "Pre-script returned " + TTransportRecord.arResultString[n6];
                        tTransportRecord.appendMessage(string2);
                        if (n6 == 2) {
                            MainWin.appendToLog("TTransport", "transportRecord", Thread.currentThread(), null, 4, string2);
                            return string2;
                        }
                    } else {
                        string2 = "Pre-script returned " + objectutil.convertToString(object3);
                        tTransportRecord.appendMessage(string2);
                    }
                } else {
                    String string3 = "Pre-script returned " + objectutil.convertToString(object3);
                    tTransportRecord.appendMessage(string3);
                }
            }
            String string4 = "";
            switch (tTransportRecord.getTransportMethod()) {
                case 0: {
                    string4 = "No transport defined";
                    break;
                }
                case 1: {
                    string4 = TTransport.transportCopy(tTransportRecord);
                    break;
                }
                case 2: {
                    string4 = TTransport.transportMerge(tTransportRecord);
                    break;
                }
                case 3: {
                    string4 = TTransport.transportZipAdd(tTransportRecord);
                    break;
                }
                case 4: {
                    string4 = TTransport.transportZipExtract(tTransportRecord);
                    break;
                }
                case 5: {
                    string4 = TTransport.transportFtpSend(tTransportRecord);
                    break;
                }
                case 6: {
                    string4 = TTransport.transportFtpReceive(tTransportRecord);
                    break;
                }
                case 7: {
                    string4 = TTransport.transportPrint(tTransportRecord);
                    break;
                }
                case 8: {
                    string4 = TTransport.transportConvertToPDF(tTransportRecord);
                    break;
                }
                case 9: {
                    string4 = TTransport.transportConvertToHTML(tTransportRecord);
                    break;
                }
                case 10: {
                    string4 = TTransport.transportSendEmail(tTransportRecord);
                    break;
                }
                case 11: {
                    string4 = TTransport.transportConvertToXML(tTransportRecord);
                    break;
                }
                case 12: {
                    string4 = TTransport.transportConvertToAscii(tTransportRecord);
                    break;
                }
                case 13: {
                    string4 = TTransport.transportToAspectServer(tTransportRecord);
                    break;
                }
                case 14: {
                    string4 = TTransport.transportFromAspectServer(tTransportRecord);
                    break;
                }
                case 15: {
                    string4 = TTransport.transportLibrarySend(tTransportRecord);
                    break;
                }
                case 16: {
                    string4 = TTransport.transportLibraryReceive(tTransportRecord);
                }
            }
            object2 = tTransportRecord.getExecScriptBefore();
            if (!((String)object2).equalsIgnoreCase("0")) {
                TTransport.executeScript(tTransportRecord.getExecScriptAfter(), tTransportRecord.getExecScriptAfterArgs());
            }
            TTransport.setStatusMessage(string4);
            tTransportRecord.appendMessage(string4);
            Application.setTokenValue("Aspect_Common_Transport_Msg", " Processing complete: " + tTransportRecord.getDescription() + ": " + string4 + " at " + dateutil.formatDate(new Date(), "MM-dd-yyyy HH:mm:ss"));
            if (tTransportRecord.getisLibraryDocument()) {
                TTransport.recordLibraryHistory(tTransportRecord.getID(), tTransportRecord.getTransportMethod(), tTransportRecord.getDescription() + ": " + string4);
            }
            tTransportRecord.setTimeOfLastAttempt(new Date());
            if (tTransportRecord.getTransportMethod() != 0) {
                if (string4.toUpperCase().startsWith("OK")) {
                    tTransportRecord.setResult(1);
                } else if (n3 >= n4) {
                    tTransportRecord.setResult(2);
                }
            }
            if (tTransportRecord.getResult() > 0 && tTransportRecord.getDeleteSourceAfterExecute()) {
                File file;
                String[] stringArray2 = tTransportRecord.getSourceFilename();
                if (stringArray2 != null) {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (stringArray2[i].toUpperCase().indexOf("QUEUE") <= 0) continue;
                        file = new File(stringArray2[i]);
                        dosutil.deleteFile(file);
                    }
                }
                if ((string2 = tTransportRecord.getEmailBodyFileName()).length() > 0 && string2.toUpperCase().indexOf("QUEUE") > 0) {
                    file = new File(string2);
                    dosutil.deleteFile(file);
                }
            }
            if (object == null) continue;
            ((TScrollTable)object).AspectDriver.clearBuffer();
            ((TScrollTable)object).redrawTable();
        }
        tAspectDriver.dispose();
        return "ok";
    }

    public static int countQueuedTransports() {
        if (drvTransports == null) {
            drvTransports = new TAspectDriver("Aspect_Transport_Queue", 1, true, true, "");
        }
        drvTransports.setActiveFilter("(result=0)", true);
        return drvTransports.getRecordCount();
    }

    public static String processTransports(final String string) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                Application.setTokenValue("Aspect_Common_Transport_Last_Processed", Long.toString(new Date().getTime()));
                if (Debug) {
                    MainWin.appendToLog("TTransport", "execTransport", Thread.currentThread(), null, 10, "processTransports(" + string + ")");
                }
                if (IsProcessing) {
                    String string4 = "Transports are already being processed.";
                    if (Debug) {
                        MainWin.appendToLog("TTransport", "processTransports", Thread.currentThread(), null, 3, string4);
                    }
                    return;
                }
                IsProcessing = true;
                if (drvTransports == null) {
                    drvTransports = new TAspectDriver("Aspect_Transport_Queue", 1, true, true, "");
                }
                String string5 = "(result=0)";
                if (string.length() > 0) {
                    string5 = string5 + " and (ID=\"" + string + "\")";
                }
                String[] stringArray = new String[]{"Time_Queued"};
                drvTransports.setSortOptions(stringArray, false);
                drvTransports.setActiveFilter(string5, true);
                int n = drvTransports.getRecordCount();
                if (n == 0) {
                    String string2 = string.length() == 0 ? "There are no transports to process" : "There are no transports pending for the transport with the ID " + string;
                    if (Debug) {
                        MainWin.appendToLog("TTransport", "processTransports", Thread.currentThread(), null, 3, string2);
                    }
                    Application.setTokenValue("Aspect_Common_Transport_Msg", string2 + " at " + dateutil.formatDate(new Date(), "MM-dd-yyyy HH:mm:ss"));
                    IsProcessing = false;
                    return;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < n; ++i) {
                    String string3 = ((String)drvTransports.getField("ID", i)).toUpperCase();
                    if (arrayList.contains(string3)) continue;
                    arrayList.add(string3);
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    TTransport.processTransport((String)arrayList.get(i));
                }
                drvTransports.clearWriteBuffer();
                IsProcessing = false;
            }
        };
        thread.setName("TransportQueue");
        thread.setPriority(1);
        thread.start();
        return "ok";
    }

    public static String execTransport(String string, String string2) {
        if (Debug) {
            MainWin.appendToLog("TTransport", "execTransport", Thread.currentThread(), null, 10, "execTransport(" + string + "," + string2 + ")");
        }
        TAspectDriver tAspectDriver = new TAspectDriver("AspectTransport", 1, true, true, "");
        String[] stringArray = new String[]{"VirtualIndex"};
        tAspectDriver.setSortOptions(stringArray, false);
        tAspectDriver.setActiveFilter("(Enabled) and (ID=\"" + string + "\")", true);
        int n = tAspectDriver.getRecordCount();
        if (n == 0) {
            String string3 = "No transport records are defined or enabled for the transport with the ID " + string;
            MainWin.appendToLog("TTransport", "execTransport", Thread.currentThread(), null, 4, string3);
            tAspectDriver.dispose();
            return string3;
        }
        if (Debug) {
            MainWin.appendToLog("TTransport", "execTransport", Thread.currentThread(), null, 10, "Adding " + n + " records for transport " + string);
        }
        TAspectDriver tAspectDriver2 = new TAspectDriver("Aspect_Transport_Queue", 1, true, true, "");
        TTransportRecord tTransportRecord = new TTransportRecord(tAspectDriver, string2);
        TScrollTable tScrollTable = MainWin.getTablePanelWithDriverID("Aspect_Transport_Queue");
        for (int i = 0; i < n; ++i) {
            int n2;
            tTransportRecord.setRecord(i);
            String string4 = "(ID=\"" + tTransportRecord.getID() + "\") and (Result=0) ";
            string4 = string4 + "and (Source=\"" + tTransportRecord.getSource() + "\") ";
            string4 = string4 + "and (Destination=\"" + tTransportRecord.getDestination() + "\") ";
            tAspectDriver2.setActiveFilter(string4, true);
            int n3 = tAspectDriver2.getRecordCount();
            if (n3 > 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    tAspectDriver2.putField("Result", n2, (Object)new Integer(4));
                }
            }
            n2 = tAspectDriver.getAbsoluteDiskIndex(i);
            int n4 = tAspectDriver.copyRecordToDriver(n2, tAspectDriver2, -1);
            if (tScrollTable == null) continue;
            tScrollTable.AspectDriver.clearBuffer();
            int n5 = tScrollTable.AspectDriver.addToFilterList(n4);
            tScrollTable.setSelectedRow(n5, true);
            tScrollTable.getTableModel().fireTableRowsInserted(n5, n5);
        }
        tAspectDriver.dispose();
        tAspectDriver2.dispose();
        TTransport.processTransport(string);
        return "ok";
    }

    public static String cancelTransportQueueRecord(String[] stringArray, int n) {
        TAspectDriver tAspectDriver = new TAspectDriver("Aspect_Transport_Queue", 1, true, true, "");
        TTransportRecord tTransportRecord = new TTransportRecord(tAspectDriver, "");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n2 = tAspectDriver.getMatchingRecord("TransportID=" + string);
            System.out.println("TTransport cancelTranspotrQueueRecord strTransportID=" + string + " intRecord=" + n2);
            if (n2 >= 0) {
                tTransportRecord.setRecord(n2);
                if (tTransportRecord.getResult() == 0 && tTransportRecord.getDeleteSourceAfterExecute()) {
                    String string2;
                    File file;
                    String[] stringArray2 = tTransportRecord.getSourceFilename();
                    if (stringArray2 != null) {
                        for (int j = 0; j < stringArray2.length; ++j) {
                            if (stringArray2[j].toUpperCase().indexOf("QUEUE") <= 0 || !(file = new File(stringArray2[j])).exists()) continue;
                            if (Debug) {
                                System.out.println("Deleting " + stringArray2[j]);
                            }
                            dosutil.deleteFile(file);
                        }
                    }
                    if ((string2 = tTransportRecord.getEmailBodyFileName()).length() > 0 && string2.toUpperCase().indexOf("QUEUE") > 0) {
                        file = new File(string2);
                        dosutil.deleteFile(file);
                    }
                }
                if (n < 0) {
                    tAspectDriver.deleteRecord(n2);
                    continue;
                }
                tTransportRecord.setResult(n);
                continue;
            }
            System.out.println("cancelTransportQueueRecord cannot locate transport with ID=" + string + " records=" + stringArray.length);
        }
        tAspectDriver.dispose();
        return "ok";
    }

    public static boolean addTransport(TTransportRecord tTransportRecord) {
        TAspectDriver tAspectDriver = new TAspectDriver("Aspect_Transport_Queue", 1, true, true, "");
        TTransportRecord tTransportRecord2 = new TTransportRecord(tAspectDriver, "");
        tAspectDriver.setActiveFilter("(true)", true);
        int n = tAspectDriver.getRecordCount();
        for (int i = 0; i < n; ++i) {
            tTransportRecord2.setRecord(i);
            if (!tTransportRecord2.getID().equalsIgnoreCase(tTransportRecord.ID) || tTransportRecord2.getTransportMethod() != tTransportRecord.TransportMethod || !tTransportRecord2.getDestination().equals(tTransportRecord.Destination) || tTransportRecord2.getResult() != 0) continue;
            String[] stringArray = new String[]{tTransportRecord2.getTransportID()};
            TTransport.cancelTransportQueueRecord(stringArray, 4);
        }
        int n2 = tAspectDriver.initializeNewRecord();
        tAspectDriver.putFieldAbsolute("Description", n2, (Object)tTransportRecord.Description);
        tAspectDriver.putFieldAbsolute("ID", n2, (Object)tTransportRecord.ID);
        tAspectDriver.putFieldAbsolute("TransportMethod", n2, (Object)tTransportRecord.TransportMethod);
        tAspectDriver.putFieldAbsolute("Destination", n2, (Object)tTransportRecord.Destination);
        tAspectDriver.putFieldAbsolute("EmailSubject", n2, (Object)tTransportRecord.EmailSubject);
        tAspectDriver.putFieldAbsolute("EmailBody", n2, (Object)tTransportRecord.EmailBody);
        tAspectDriver.putFieldAbsolute("EmailBodyFileName", n2, (Object)tTransportRecord.EmailBodyFileName);
        tAspectDriver.putFieldAbsolute("Source", n2, (Object)tTransportRecord.Source);
        tAspectDriver.putFieldAbsolute("Maximum_Attempts", n2, (Object)tTransportRecord.Maximum_Attempts);
        tAspectDriver.putFieldAbsolute("Minutes_Between_Attempts", n2, (Object)tTransportRecord.Minutes_Between_Attempts);
        tAspectDriver.putFieldAbsolute("Delete_Source_After_Execute", n2, (Object)tTransportRecord.Delete_Source_After_Execute);
        tAspectDriver.putFieldAbsolute("isLibraryDocument", n2, (Object)tTransportRecord.isLibraryDocument);
        tAspectDriver.putFieldAbsolute("Library_Client_ID", n2, (Object)tTransportRecord.Library_Client_ID);
        tAspectDriver.putFieldAbsolute("FTPAccount", n2, (Object)tTransportRecord.FTPAccount);
        tAspectDriver.putFieldAbsolute("FTPHost", n2, (Object)tTransportRecord.FTPHost);
        tAspectDriver.putFieldAbsolute("FTPUserName", n2, (Object)tTransportRecord.FTPUserName);
        tAspectDriver.putFieldAbsolute("FTPPassword", n2, (Object)tTransportRecord.FTPPassword);
        tAspectDriver.putFieldAbsolute("FTPPassive", n2, (Object)tTransportRecord.FTPPassive);
        tAspectDriver.putFieldAbsolute("TransportOverwriteOptions", n2, (Object)tTransportRecord.OverwriteOption);
        tAspectDriver.dispose();
        return true;
    }
}

