/*
 * Decompiled with CFR 0.152.
 */
package utility.taskscheduler;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TDriverInterface;
import drivers.aspect.TDriverStructRecord;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiInput;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.objectutil;
import utility.security.TPasswordService;
import utility.transport.TTransport;
import utility.transport.TTransportRecord;

public class TScheduledTask {
    private static TMainWin MainWin = Aspect.MainWin;
    private static boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTScheduledTask");
    private static Hashtable hashCalculatingState = new Hashtable();
    private TDriverStructRecord[] arDSRec;
    private static String[] strFieldIDs = new String[]{"Category1", "Category2", "TaskName", "TaskDescription", "TaskEnabled", "TaskInitialStartTime", "TaskIntervalType", "TaskLastExecuted", "TaskCatchUpMissedTasks", "TaskYearsBetweenExecution", "TaskMonthsBetweenExecution", "TaskDaysBetweenExecution", "TaskHoursBetweenExecution", "TaskMinutesBetweenExecution", "TaskSecondsBetweenExecution", "TaskExecuteSun", "TaskExecuteMon", "TaskExecuteTue", "TaskExecuteWed", "TaskExecuteThu", "TaskExecuteFri", "TaskExecuteSat", "TaskWindowForExecution", "TaskNextExecution", "TaskEventType", "TaskTarget", "TaskParams", "TaskConditional_Expression", "TaskResult", "TaskFinish_Time", "TaskMessage", "TaskAltName", "TaskState_Function", "TaskLast_State", "TaskLast_Content_Update", "TaskContent", "TaskContent_Is_External", "TaskPost_To_Ftp_Enabled", "TaskPost_To_Ftp_Host", "TaskPost_To_Ftp_Filename", "TaskPost_To_Email_Enabled", "TaskPost_To_Email_AddressTo", "TaskPost_To_Email_IncludeInBody", "TaskPost_To_Email_Body", "TaskPost_To_Email_Subject", "TaskPost_To_File_Enabled", "TaskPost_To_File_Filename", "TaskPost_To_File_Overwrite", "TaskPost_To_Email_FileExt", "TaskLast_State_Check", "TaskExpression", "TaskLastResultMessage", "TaskState_Expression_Description", "TaskConditional_Expression_Description", "Elapse_Time_Eval_Condition", "Elapse_Time_Eval_State", "Specific_Day_Of_Month"};
    private static final int cRequiredFields = strFieldIDs.length;
    private TDriverInterface driver = null;
    private int RecordNumber = 0;
    public String TaskCategory1 = "";
    public String TaskCategory2 = "";
    public String TaskName = "";
    public String TaskNameForThread = null;
    public String TaskDescription = "";
    public boolean TaskEnabled = false;
    public Date TaskInitialStartTime = new Date();
    public int TaskIntervalType = 0;
    public Date TaskLastExecuted = new Date();
    public boolean TaskCatchUpMissedTasks = false;
    public int TaskYearsBetweenExecution = 0;
    public int TaskMonthsBetweenExecution = 0;
    public int TaskDaysBetweenExecution = 0;
    public int TaskHoursBetweenExecution = 0;
    public int TaskMinutesBetweenExecution = 0;
    public int TaskSecondsBetweenExecution = 0;
    public boolean TaskExecuteSun = false;
    public boolean TaskExecuteMon = false;
    public boolean TaskExecuteTue = false;
    public boolean TaskExecuteWed = false;
    public boolean TaskExecuteThu = false;
    public boolean TaskExecuteFri = false;
    public boolean TaskExecuteSat = false;
    public int TaskWindowForExecution = 0;
    public Date TaskNextExecution = new Date();
    public int TaskEventType = 0;
    public String TaskTarget = "";
    public String TaskParams = "";
    public String TaskConditionalExpression = "";
    public String TaskFrequency = "";
    public int TaskResult = -1;
    public Date TaskFinish_Time = new Date();
    public String TaskMessage = "";
    public String TaskAltName = "";
    public String TaskState_Function = "";
    public String TaskLast_State = "";
    public Date TaskLast_Content_Update = null;
    public String TaskContent = "";
    public boolean TaskContent_Is_External = false;
    public Date TaskLastStateCheck = new Date();
    public String TaskExpression = "";
    public String TaskLastResultMessage = "";
    public String TaskState_Expression_Description = "";
    public String TaskConditional_Expression_Description = "";
    public int Elapse_Time_Eval_Condition = 0;
    public int Elapse_Time_Eval_State = 0;
    public int Specific_Day_Of_Month = 1;
    private Date SeedForNextExecTime = null;

    public TScheduledTask(TDriverInterface tDriverInterface, int n) {
        this.driver = tDriverInterface;
        this.RecordNumber = n;
        this.arDSRec = this.getDSRecArray();
        this.TaskCategory1 = this.getString(this.arDSRec[0]);
        this.TaskCategory2 = this.getString(this.arDSRec[1]);
        this.TaskName = this.getString(this.arDSRec[2]);
        if (this.TaskName.trim().length() == 0) {
            TDriverStructRecord tDriverStructRecord = this.driver.getDriverStruct().getField("name");
            if (tDriverStructRecord != null) {
                this.TaskName = this.getString(tDriverStructRecord);
            }
            if (this.TaskName.trim().length() == 0 && (tDriverStructRecord = this.driver.getDriverStruct().getField("document_name")) != null) {
                this.TaskName = this.getString(tDriverStructRecord);
            }
        }
        this.TaskDescription = this.getString(this.arDSRec[3]);
        this.TaskEnabled = this.getBoolean(this.arDSRec[4]);
        this.TaskInitialStartTime = this.getDate(this.arDSRec[5]);
        this.TaskIntervalType = this.getInt(this.arDSRec[6]);
        this.TaskLastExecuted = this.getDate(this.arDSRec[7]);
        this.TaskCatchUpMissedTasks = this.getBoolean(this.arDSRec[8]);
        this.TaskYearsBetweenExecution = this.getInt(this.arDSRec[9]);
        this.TaskMonthsBetweenExecution = this.getInt(this.arDSRec[10]);
        this.TaskDaysBetweenExecution = this.getInt(this.arDSRec[11]);
        this.TaskHoursBetweenExecution = this.getInt(this.arDSRec[12]);
        this.TaskMinutesBetweenExecution = this.getInt(this.arDSRec[13]);
        this.TaskSecondsBetweenExecution = this.getInt(this.arDSRec[14]);
        this.TaskExecuteSun = this.getBoolean(this.arDSRec[15]);
        this.TaskExecuteMon = this.getBoolean(this.arDSRec[16]);
        this.TaskExecuteTue = this.getBoolean(this.arDSRec[17]);
        this.TaskExecuteWed = this.getBoolean(this.arDSRec[18]);
        this.TaskExecuteThu = this.getBoolean(this.arDSRec[19]);
        this.TaskExecuteFri = this.getBoolean(this.arDSRec[20]);
        this.TaskExecuteSat = this.getBoolean(this.arDSRec[21]);
        this.TaskWindowForExecution = this.getInt(this.arDSRec[22]);
        this.TaskEventType = this.getInt(this.arDSRec[24]);
        this.TaskTarget = this.getString(this.arDSRec[25]);
        this.TaskParams = this.getString(this.arDSRec[26]);
        this.TaskConditionalExpression = this.getString(this.arDSRec[27]);
        this.TaskResult = this.getInt(this.arDSRec[28]);
        this.TaskFinish_Time = this.getDate(this.arDSRec[29]);
        this.TaskMessage = this.getString(this.arDSRec[30]);
        this.TaskAltName = this.getString(this.arDSRec[31]);
        this.TaskState_Function = this.getString(this.arDSRec[32]);
        this.TaskLast_State = this.getString(this.arDSRec[33]);
        this.TaskLast_Content_Update = this.getDate(this.arDSRec[34]);
        this.TaskContent = this.getString(this.arDSRec[35]);
        this.TaskContent_Is_External = this.getBoolean(this.arDSRec[36]);
        this.TaskLastStateCheck = this.getDate(this.arDSRec[49]);
        this.TaskExpression = this.getString(this.arDSRec[50]);
        this.TaskLastResultMessage = this.getString(this.arDSRec[51]);
        this.TaskState_Expression_Description = this.getString(this.arDSRec[52]);
        this.TaskConditional_Expression_Description = this.getString(this.arDSRec[53]);
        this.Elapse_Time_Eval_Condition = this.getInt(this.arDSRec[54]);
        this.Elapse_Time_Eval_State = this.getInt(this.arDSRec[55]);
        this.Specific_Day_Of_Month = this.getInt(this.arDSRec[56]);
        this.TaskNextExecution = this.calcNextExecTime();
    }

    public String getNameForThread() {
        if (this.TaskNameForThread == null) {
            this.TaskNameForThread = TScheduledTask.getNameForThread(this.driver.getAppDriversObject().DriverID.toString(), this.TaskName);
        }
        return this.TaskNameForThread;
    }

    public TDriverStructRecord[] getDSRecArray() {
        TDriverStructRecord[] tDriverStructRecordArray = new TDriverStructRecord[cRequiredFields];
        for (int i = 0; i < cRequiredFields; ++i) {
            tDriverStructRecordArray[i] = this.driver.getDriverStructRecord(strFieldIDs[i]);
        }
        return tDriverStructRecordArray;
    }

    public boolean getBoolean(TDriverStructRecord tDriverStructRecord) {
        if (tDriverStructRecord == null) {
            return false;
        }
        Object object = this.driver.getField(tDriverStructRecord, this.RecordNumber);
        String string = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
        return charutil.boolval(string);
    }

    public int getInt(TDriverStructRecord tDriverStructRecord) {
        if (tDriverStructRecord == null) {
            return 0;
        }
        Object object = this.driver.getField(tDriverStructRecord, this.RecordNumber);
        String string = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
        return charutil.ival(string);
    }

    public String getString(TDriverStructRecord tDriverStructRecord) {
        if (tDriverStructRecord == null) {
            return "";
        }
        Object object = this.driver.getField(tDriverStructRecord, this.RecordNumber);
        if (!(object instanceof String)) {
            object = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
        }
        return (String)object;
    }

    public Date getDate(TDriverStructRecord tDriverStructRecord) {
        if (tDriverStructRecord == null) {
            return null;
        }
        Object object = this.driver.getField(tDriverStructRecord, this.RecordNumber);
        if (object instanceof Date) {
            return (Date)object;
        }
        String string = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
        return (Date)objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, string, this.RecordNumber);
    }

    public Date calcNextExecTime() {
        Object object;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        Date date = new Date();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = true;
        if (this.TaskExecuteSun) {
            bl2 = false;
        }
        if (this.TaskExecuteMon) {
            bl2 = false;
        }
        if (this.TaskExecuteTue) {
            bl2 = false;
        }
        if (this.TaskExecuteWed) {
            bl2 = false;
        }
        if (this.TaskExecuteThu) {
            bl2 = false;
        }
        if (this.TaskExecuteFri) {
            bl2 = false;
        }
        if (this.TaskExecuteSat) {
            bl2 = false;
        }
        if (bl2) {
            Date date2 = new Date();
            date2.setTime(0L);
            gregorianCalendar.setTime(date2);
            return gregorianCalendar.getTime();
        }
        if (this.SeedForNextExecTime == null) {
            gregorianCalendar2.setTime(this.TaskInitialStartTime);
        } else {
            gregorianCalendar2.setTime(this.SeedForNextExecTime);
        }
        if (gregorianCalendar2.get(1) < 2008) {
            object = "The initial start time for the task named " + this.TaskName + " in task scheduler: " + this.driver.getAppDriversObject().DriverID + " uses an old initial start time.";
            MainWin.appendToLog("TScheduledTask", "calcNextExecTime", Thread.currentThread(), null, 10, (String)object);
        }
        gregorianCalendar.setTime(gregorianCalendar2.getTime());
        if (this.TaskIntervalType >= 1 && this.TaskIntervalType <= 4) {
            int n = this.TaskIntervalType - 1 + 1;
            do {
                Date date3 = gregorianCalendar.getTime();
                date3.setTime(date3.getTime() + 86400000L);
                gregorianCalendar.setTime(date3);
                int n2 = gregorianCalendar.get(5);
                int n3 = (int)Math.floor((n2 - 1) / 7) + 1;
                if (n3 != n) continue;
                int n4 = gregorianCalendar.get(7);
                bl2 = false;
                switch (n4) {
                    case 1: {
                        if (!this.TaskExecuteSun) break;
                        bl2 = true;
                        break;
                    }
                    case 2: {
                        if (!this.TaskExecuteMon) break;
                        bl2 = true;
                        break;
                    }
                    case 3: {
                        if (!this.TaskExecuteTue) break;
                        bl2 = true;
                        break;
                    }
                    case 4: {
                        if (!this.TaskExecuteWed) break;
                        bl2 = true;
                        break;
                    }
                    case 5: {
                        if (!this.TaskExecuteThu) break;
                        bl2 = true;
                        break;
                    }
                    case 6: {
                        if (!this.TaskExecuteFri) break;
                        bl2 = true;
                        break;
                    }
                    case 7: {
                        if (!this.TaskExecuteSat) break;
                        bl2 = true;
                    }
                }
            } while (!bl2);
        } else if (this.TaskIntervalType == 5) {
            bl2 = false;
            do {
                gregorianCalendar = dateutil.adjustTime(gregorianCalendar, 86400000);
                GregorianCalendar gregorianCalendar3 = dateutil.adjustTime(gregorianCalendar, 604800000);
                if (gregorianCalendar.get(2) == gregorianCalendar3.get(2)) continue;
                int n = gregorianCalendar.get(7);
                switch (n) {
                    case 1: {
                        if (!this.TaskExecuteSun) break;
                        bl2 = true;
                        break;
                    }
                    case 2: {
                        if (!this.TaskExecuteMon) break;
                        bl2 = true;
                        break;
                    }
                    case 3: {
                        if (!this.TaskExecuteTue) break;
                        bl2 = true;
                        break;
                    }
                    case 4: {
                        if (!this.TaskExecuteWed) break;
                        bl2 = true;
                        break;
                    }
                    case 5: {
                        if (!this.TaskExecuteThu) break;
                        bl2 = true;
                        break;
                    }
                    case 6: {
                        if (!this.TaskExecuteFri) break;
                        bl2 = true;
                        break;
                    }
                    case 7: {
                        if (!this.TaskExecuteSat) break;
                        bl2 = true;
                    }
                }
            } while (!bl2);
        } else if (this.TaskIntervalType == 6) {
            bl2 = false;
            do {
                int n;
                if ((n = (gregorianCalendar = dateutil.adjustTime(gregorianCalendar, 86400000)).get(5)) != 1) continue;
                bl2 = true;
            } while (!bl2);
        } else if (this.TaskIntervalType == 7) {
            gregorianCalendar = dateutil.adjustTime(gregorianCalendar, 86400000);
            bl2 = false;
            do {
                int n;
                if ((n = (gregorianCalendar = dateutil.adjustTime(gregorianCalendar, 86400000)).get(5)) != 1) continue;
                gregorianCalendar = dateutil.adjustTime(gregorianCalendar, -86400000);
                bl2 = true;
            } while (!bl2);
        } else if (this.TaskIntervalType == 9) {
            Date date4;
            if (this.Specific_Day_Of_Month == 0 || this.Specific_Day_Of_Month > 31) {
                Date date5 = new Date();
                date5.setTime(0L);
                gregorianCalendar.setTime(date5);
                return gregorianCalendar.getTime();
            }
            gregorianCalendar = dateutil.adjustTime(gregorianCalendar, 86400000);
            object = null;
            GregorianCalendar gregorianCalendar4 = null;
            int n = 0;
            bl2 = false;
            do {
                GregorianCalendar gregorianCalendar5;
                int n5;
                if ((date4 = (gregorianCalendar = dateutil.adjustTime(gregorianCalendar, 86400000)).getTime()).getTime() > date.getTime()) {
                    ++n;
                }
                if ((n5 = gregorianCalendar.get(5)) == this.Specific_Day_Of_Month) {
                    if (bl) {
                        if (date4.getTime() > this.TaskLastExecuted.getTime()) {
                            bl2 = true;
                        }
                    } else if (date4.getTime() > date.getTime()) {
                        bl2 = true;
                    }
                }
                if (n5 != 1 || (gregorianCalendar5 = dateutil.adjustTime(gregorianCalendar, -86400000)).getTime().getTime() <= this.TaskLastExecuted.getTime()) continue;
                if (object == null) {
                    object = new GregorianCalendar();
                    ((Calendar)object).setTime(gregorianCalendar5.getTime());
                }
                gregorianCalendar4 = new GregorianCalendar();
                gregorianCalendar4.setTime(gregorianCalendar5.getTime());
            } while (n < 31 && !bl2);
            if (!bl2) {
                date4 = new Date();
                date4.setTime(0L);
                gregorianCalendar.setTime(date4);
                if (bl) {
                    if (object != null) {
                        gregorianCalendar.setTime(((Calendar)object).getTime());
                    } else if (gregorianCalendar4 != null) {
                        gregorianCalendar.setTime(gregorianCalendar4.getTime());
                    }
                } else if (gregorianCalendar4 != null) {
                    gregorianCalendar.setTime(gregorianCalendar4.getTime());
                }
            }
        } else if (this.TaskIntervalType == 0) {
            Date date6;
            boolean bl3;
            boolean bl4;
            if (this.SeedForNextExecTime == null && (bl4 = TimeZone.getDefault().inDaylightTime(this.TaskInitialStartTime)) != (bl3 = TimeZone.getDefault().inDaylightTime(new Date()))) {
                date6 = gregorianCalendar.getTime();
                if (bl4) {
                    date6.setTime(date6.getTime() + 3600000L);
                } else {
                    date6.setTime(date6.getTime() - 3600000L);
                }
                gregorianCalendar.setTime(date6);
            }
            int n = gregorianCalendar.get(5);
            for (int i = 9; i <= 14; ++i) {
                int n6 = 0;
                switch (i) {
                    case 9: {
                        n6 = this.TaskYearsBetweenExecution;
                        break;
                    }
                    case 10: {
                        n6 = this.TaskMonthsBetweenExecution;
                        break;
                    }
                    case 11: {
                        n6 = this.TaskDaysBetweenExecution;
                        break;
                    }
                    case 12: {
                        n6 = this.TaskHoursBetweenExecution;
                        break;
                    }
                    case 13: {
                        n6 = this.TaskMinutesBetweenExecution;
                        break;
                    }
                    case 14: {
                        n6 = this.TaskSecondsBetweenExecution;
                    }
                }
                if (n6 <= 0) continue;
                do {
                    switch (i) {
                        case 9: {
                            gregorianCalendar.set(1, gregorianCalendar.get(1) + n6);
                            break;
                        }
                        case 10: {
                            gregorianCalendar.set(2, gregorianCalendar.get(2) + n6);
                            int n7 = gregorianCalendar.get(5);
                            if (n7 >= n) break;
                            date6 = gregorianCalendar.getTime();
                            date6.setTime(date6.getTime() - (long)(n7 * 86400000));
                            gregorianCalendar.setTime(date6);
                            break;
                        }
                        case 11: {
                            date6 = gregorianCalendar.getTime();
                            date6.setTime(date6.getTime() + (long)(n6 * 86400000));
                            gregorianCalendar.setTime(date6);
                            break;
                        }
                        case 12: {
                            date6 = gregorianCalendar.getTime();
                            date6.setTime(date6.getTime() + (long)(n6 * 3600000));
                            gregorianCalendar.setTime(date6);
                            break;
                        }
                        case 13: {
                            date6 = gregorianCalendar.getTime();
                            date6.setTime(date6.getTime() + (long)(n6 * 60000));
                            gregorianCalendar.setTime(date6);
                            break;
                        }
                        case 14: {
                            date6 = gregorianCalendar.getTime();
                            date6.setTime(date6.getTime() + (long)(n6 * 1000));
                            gregorianCalendar.setTime(date6);
                        }
                    }
                    date6 = gregorianCalendar.getTime();
                    bl2 = false;
                    if (bl) {
                        if (date6.getTime() <= this.TaskLastExecuted.getTime()) continue;
                        bl2 = true;
                        continue;
                    }
                    if (date6.getTime() <= date.getTime()) continue;
                    bl2 = true;
                } while (!bl2);
            }
            this.SeedForNextExecTime = gregorianCalendar.getTime();
        } else {
            Date date7 = new Date();
            date7.setTime(0L);
            gregorianCalendar.setTime(date7);
        }
        return gregorianCalendar.getTime();
    }

    public Date getNextExecTime() {
        return this.TaskNextExecution;
    }

    public void setNextExecTime() {
        this.TaskNextExecution.setTime(this.calcNextExecTime().getTime());
    }

    public boolean getIsEnabled() {
        return this.TaskEnabled;
    }

    public String getTaskName() {
        return this.TaskName;
    }

    public String getDriverID() {
        if (this.driver == null) {
            return "";
        }
        return this.driver.getAppDriversObject().DriverID.toString();
    }

    public String getTaskDescription() {
        return this.TaskDescription;
    }

    public String getTaskCategory1() {
        return this.TaskCategory1;
    }

    public String getTaskCategory2() {
        return this.TaskCategory2;
    }

    public String getTaskConditionalExpression() {
        return this.TaskConditionalExpression;
    }

    public int getTaskEventType() {
        return this.TaskEventType;
    }

    public String getTaskTarget() {
        return this.TaskTarget;
    }

    public String getTaskParams() {
        return this.TaskParams;
    }

    public String getTaskExpression() {
        return this.TaskExpression;
    }

    public String getTaskLastResultMessage() {
        return this.TaskLastResultMessage;
    }

    public void setTaskLastResultMessage(String string) {
        if (this.TaskLastResultMessage.equals(string)) {
            return;
        }
        this.TaskLastResultMessage = string;
        this.driver.putField("TaskLastResultMessage", this.RecordNumber, (Object)string);
    }

    public int getInterval() {
        if (this.TaskIntervalType != 0) {
            return -1;
        }
        int n = 0;
        n += this.TaskDaysBetweenExecution * 86400;
        n += this.TaskHoursBetweenExecution * 3600;
        n += this.TaskMinutesBetweenExecution * 60;
        return n += this.TaskSecondsBetweenExecution * 1;
    }

    public void setTaskResult(int n) {
        this.TaskResult = n;
        this.driver.putField("TaskResult", this.RecordNumber, (Object)new Integer(this.TaskResult));
    }

    public void setTaskMessage(String string) {
        if (this.TaskMessage.equals(string)) {
            return;
        }
        this.TaskMessage = string;
        this.driver.putField("TaskMessage", this.RecordNumber, (Object)this.TaskMessage);
    }

    public void setTaskFinish_Time(Date date) {
        this.TaskFinish_Time = date;
        this.driver.putField("TaskFinish_Time", this.RecordNumber, (Object)this.TaskFinish_Time);
    }

    public Date getTaskLastExecuted() {
        return this.TaskLastExecuted;
    }

    public void setTaskLastExecuted(Date date) {
        this.TaskLastExecuted.setTime(date.getTime());
        this.driver.putField("TaskLastExecuted", this.RecordNumber, (Object)date);
    }

    public void setTaskLastStateCheck(Date date) {
        this.TaskLastStateCheck = date;
        if (this.arDSRec[49] != null) {
            this.driver.putField(this.arDSRec[49], this.RecordNumber, (Object)date);
        }
    }

    public String getTaskState_Function() {
        return this.TaskState_Function;
    }

    public void setTaskLast_Content_Update(Date date) {
        this.TaskLast_Content_Update = date;
        this.driver.putField("TaskLast_Content_Update", this.RecordNumber, (Object)date);
    }

    public Object getField(String string) {
        return this.driver.getField(string, this.RecordNumber);
    }

    public String getTaskContent() {
        System.out.println("TScheduledTask getTaskContent TaskContent_Is_External=" + this.TaskContent_Is_External + " TaskContent=" + this.TaskContent);
        if (!this.TaskContent_Is_External) {
            return this.TaskContent;
        }
        return TAsciiInput.getContent(this.TaskContent);
    }

    public void setTaskContent(String string) {
        if (string.length() < 256) {
            File file;
            if (this.TaskContent_Is_External && (file = new File(this.TaskContent)).exists()) {
                file.delete();
                if (file.exists()) {
                    System.gc();
                    file.delete();
                }
            }
            this.TaskContent = string;
            this.TaskContent_Is_External = false;
            this.driver.putField("TaskContent", this.RecordNumber, (Object)this.TaskContent);
            this.driver.putField("TaskContent_Is_External", this.RecordNumber, (Object)false);
        } else {
            String string2 = TMainWin.Application.getTemporaryFiles() + TPasswordService.generateSalt(6) + ".$$$";
            if (this.TaskContent_Is_External) {
                string2 = this.TaskContent;
            }
            TAsciiOutput.writeContent(string2, string);
            this.TaskContent = string2;
            this.TaskContent_Is_External = true;
            this.driver.putField("TaskContent", this.RecordNumber, (Object)this.TaskContent);
            this.driver.putField("TaskContent_Is_External", this.RecordNumber, (Object)new Boolean(true));
        }
    }

    public boolean writeToFile(String string) {
        System.out.println("TScheduledTask writeToFile TaskContent_Is_External=" + this.TaskContent_Is_External);
        if (this.TaskContent_Is_External) {
            File file = new File(this.TaskContent);
            if (!file.exists()) {
                return false;
            }
            dosutil.copyFile(this.TaskContent, string, false);
            return true;
        }
        System.out.println("TScheduledTask writeToFile TaskContent=" + this.TaskContent.substring(0, Math.min(this.TaskContent.length(), 128)));
        if (this.TaskContent.trim().length() == 0) {
            System.out.println("TScheduledTask content length is zero.  Getting content");
            this.TaskContent = this.getString(this.arDSRec[35]);
        }
        TAsciiOutput.writeContent(string, this.TaskContent);
        return true;
    }

    public void setTaskLast_State(String string) {
        this.TaskLast_State = string;
        this.driver.putField("TaskLast_State", this.RecordNumber, (Object)string);
    }

    public String getCurrentState() {
        this.TaskState_Function = this.getString(this.arDSRec[32]);
        String string = TMainWin.Application.parse_tokens(this.TaskState_Function);
        if (string.trim().length() == 0) {
            return "";
        }
        if (!string.startsWith("=")) {
            string = "=" + string;
        }
        TFormulaEvaluator tFormulaEvaluator = this.driver.getFormulaEvaluator();
        String string2 = TFormulaEvaluator.convertToString(tFormulaEvaluator.getFormulaValue(string, this.RecordNumber, -1));
        String string3 = TPasswordService.encrypt(string2, "aaa", 1);
        string3 = string3.substring(0, Math.min(32, string3.length()));
        return string3;
    }

    public boolean hasState() {
        return this.TaskState_Function.trim().length() != 0;
    }

    public String stateChanged() {
        if (this.TaskState_Function.trim().length() == 0) {
            return null;
        }
        String string = this.getCurrentState();
        if (string.equals(this.TaskLast_State)) {
            return null;
        }
        return string;
    }

    public boolean executeTransport() {
        Object object;
        String string;
        if (this.getBoolean(this.arDSRec[37])) {
            string = TMainWin.Application.getTemporaryFiles() + this.TaskName + TPasswordService.generateSalt(4) + ".ftp";
            if (this.writeToFile(string)) {
                object = new TTransportRecord(null, "");
                ((TTransportRecord)object).ID = this.driver.getAppDriversObject().DriverID.toString() + "_" + this.TaskName;
                ((TTransportRecord)object).Description = this.TaskName;
                ((TTransportRecord)object).TransportMethod = 5;
                ((TTransportRecord)object).FTPAccount = this.getString(this.arDSRec[38]);
                ((TTransportRecord)object).Destination = this.getString(this.arDSRec[39]);
                ((TTransportRecord)object).Source = string;
                ((TTransportRecord)object).Delete_Source_After_Execute = true;
                ((TTransportRecord)object).Maximum_Attempts = 24;
                ((TTransportRecord)object).Minutes_Between_Attempts = 60;
                TTransport.addTransport((TTransportRecord)object);
            }
        }
        if (this.getBoolean(this.arDSRec[40])) {
            MainWin.appendToLog("TScheduledTask", "executeTransport", Thread.currentThread(), null, 3, "TScheduledTask executeTransport email task driver is " + this.driver.getAppDriversObject().DriverID.toString());
            if (this.driver.getAppDriversObject().DriverID.toString().equalsIgnoreCase("GreenLight_Email_Task")) {
                MainWin.appendToLog("TScheduledTask", "executeTransport", Thread.currentThread(), null, 3, "TScheduledTask executeTransport adding email transport using agent");
                string = (String)this.driver.getField("ID", this.RecordNumber);
                object = objectutil.convertToString(TFormulaEvaluator.eval("execAgentAction(\"createEmailTaskTransport\",\"EmailTaskID=" + string + "\")"));
            } else {
                MainWin.appendToLog("TScheduledTask", "executeTransport", Thread.currentThread(), null, 3, "TScheduledTask executeTransport adding email transport directly");
                string = this.getString(this.arDSRec[48]);
                if (!string.startsWith(".")) {
                    string = "." + string;
                }
                if (this.writeToFile((String)(object = TMainWin.Application.getTemporaryFiles() + this.TaskName + TPasswordService.generateSalt(4) + string))) {
                    TTransportRecord tTransportRecord = new TTransportRecord(null, "");
                    tTransportRecord.ID = this.driver.getAppDriversObject().DriverID.toString() + "_" + this.TaskName;
                    tTransportRecord.Description = this.TaskName;
                    tTransportRecord.TransportMethod = 10;
                    tTransportRecord.EmailAccount = "";
                    tTransportRecord.Destination = this.getString(this.arDSRec[41]);
                    tTransportRecord.EmailSubject = this.getString(this.arDSRec[44]);
                    tTransportRecord.EmailBody = this.getString(this.arDSRec[43]);
                    tTransportRecord.EmailBodyFileName = this.getBoolean(this.arDSRec[42]) ? object : "";
                    tTransportRecord.Source = object;
                    tTransportRecord.Delete_Source_After_Execute = true;
                    tTransportRecord.Maximum_Attempts = 24;
                    tTransportRecord.Minutes_Between_Attempts = 60;
                    TTransport.addTransport(tTransportRecord);
                }
            }
        }
        if (this.getBoolean(this.arDSRec[45])) {
            string = TMainWin.Application.getTemporaryFiles() + this.TaskName + TPasswordService.generateSalt(4) + ".copy";
            if (this.writeToFile(string)) {
                object = new TTransportRecord(null, "");
                ((TTransportRecord)object).ID = this.driver.getAppDriversObject().DriverID.toString() + "_" + this.TaskName;
                ((TTransportRecord)object).Description = this.TaskName;
                ((TTransportRecord)object).TransportMethod = 1;
                ((TTransportRecord)object).Source = string;
                ((TTransportRecord)object).Destination = this.getString(this.arDSRec[46]);
                ((TTransportRecord)object).OverwriteOption = this.getInt(this.arDSRec[46]);
                ((TTransportRecord)object).Delete_Source_After_Execute = true;
                ((TTransportRecord)object).Maximum_Attempts = 24;
                ((TTransportRecord)object).Minutes_Between_Attempts = 60;
                TTransport.addTransport((TTransportRecord)object);
            }
        }
        return true;
    }

    public boolean shouldExecute() {
        if (TMainWin.Application.getTokenValue("DisableTaskScheduler").equalsIgnoreCase("true")) {
            return false;
        }
        if (!this.TaskEnabled) {
            this.setTaskMessage("Not enabled");
            return false;
        }
        if (this.TaskIntervalType == 8) {
            this.setTaskMessage("Manual execution only");
            return false;
        }
        if (this.TaskNextExecution.getTime() == 0L) {
            this.setTaskMessage("Next execution time is invalid");
            return false;
        }
        if (this.getInterval() == 0) {
            this.setTaskMessage("No interval specified");
            return false;
        }
        Date date = new Date();
        if (date.getTime() >= this.TaskNextExecution.getTime()) {
            Comparable<Date> comparable;
            if (this.TaskEventType != 2) {
                if (this.TaskEventType == 3) {
                    if (this.TaskExpression.trim().length() == 0) {
                        this.setTaskMessage("No target defined");
                        this.setNextExecTime();
                        return false;
                    }
                } else if (this.TaskTarget.trim().length() == 0) {
                    this.setTaskMessage("No target defined");
                    this.setNextExecTime();
                    return false;
                }
            }
            if (this.TaskConditionalExpression.trim().length() > 0) {
                comparable = new Date();
                this.driver.clearBuffer();
                Object object = this.driver.getFormulaEvaluator().getFormulaValue(this.TaskConditionalExpression, this.RecordNumber, -1);
                if (object == null) {
                    String string = "Invalid conditional expression";
                    System.out.println("Task Scheduler: " + string + " in driver " + this.driver.getAppDriversObject().DriverID.toString() + " RecordNumber=" + this.RecordNumber);
                    System.out.println("Condition=" + this.TaskConditionalExpression);
                    if (this.TaskConditional_Expression_Description.length() > 0) {
                        string = string + ": " + this.TaskConditional_Expression_Description;
                    }
                    this.setTaskMessage(string);
                    this.setNextExecTime();
                    return false;
                }
                if (!TFormulaEvaluator.convertToBoolean(object)) {
                    String string = "Suspended";
                    if (this.TaskConditional_Expression_Description.length() > 0) {
                        string = string + ": " + this.TaskConditional_Expression_Description;
                    }
                    this.setTaskMessage(string);
                    this.setNextExecTime();
                    return false;
                }
                this.driver.putField("Elapse_Time_Eval_Condition", this.RecordNumber, (Object)((int)(new Date().getTime() - ((Date)comparable).getTime())));
                this.driver.clearWriteBuffer();
            }
            if (TScheduledTask.getRunningTaskCount(this.driver.getAppDriversObject().DriverID.toString(), this.TaskName) > 0) {
                this.setTaskMessage("Running");
                this.setNextExecTime();
                return false;
            }
            comparable = new GregorianCalendar();
            ((Calendar)comparable).setTime(date);
            int n = ((Calendar)comparable).get(7);
            boolean bl = false;
            if (n == 1 && !this.TaskExecuteSun) {
                bl = true;
            }
            if (n == 2 && !this.TaskExecuteMon) {
                bl = true;
            }
            if (n == 3 && !this.TaskExecuteTue) {
                bl = true;
            }
            if (n == 4 && !this.TaskExecuteWed) {
                bl = true;
            }
            if (n == 5 && !this.TaskExecuteThu) {
                bl = true;
            }
            if (n == 6 && !this.TaskExecuteFri) {
                bl = true;
            }
            if (n == 7 && !this.TaskExecuteSat) {
                bl = true;
            }
            if (bl) {
                this.setTaskMessage("Not enabled on this day");
                this.setNextExecTime();
                return false;
            }
            this.setTaskLastStateCheck(new Date());
            if (this.hasState()) {
                Date date2 = new Date();
                String string = this.getNameForThread().toUpperCase();
                if (hashCalculatingState.containsKey(string)) {
                    MainWin.appendToLog("TScheduledTask", "shouldExecute", Thread.currentThread(), null, 4, "Aborting task because state function is still executing: " + this.TaskName);
                    this.setTaskMessage("Already calculating state");
                    this.setNextExecTime();
                    return false;
                }
                hashCalculatingState.put(string, "");
                String string2 = this.stateChanged();
                hashCalculatingState.remove(string);
                this.driver.putField("Elapse_Time_Eval_State", this.RecordNumber, (Object)((int)(new Date().getTime() - date2.getTime())));
                this.driver.clearWriteBuffer();
                if (string2 != null) {
                    this.setTaskLast_State(string2);
                } else {
                    this.setNextExecTime();
                    this.setTaskResult(2);
                    this.setTaskMessage("No change in state");
                    this.setNextExecTime();
                    return false;
                }
            }
            this.setTaskMessage("Executing");
            return true;
        }
        return false;
    }

    public static String getNameForThread(String string, String string2) {
        return "Task_" + string + "-" + string2;
    }

    public static int getRunningTaskCount(String string, String string2) {
        String string3 = TScheduledTask.getNameForThread(string, string2);
        Thread[] threadArray = new Thread[Thread.activeCount() + 10];
        Thread.enumerate(threadArray);
        int n = 0;
        for (int i = 0; i < threadArray.length; ++i) {
            if (threadArray[i] == null || !threadArray[i].getName().equalsIgnoreCase(string3)) continue;
            ++n;
        }
        return n;
    }
}

