/*
 * Decompiled with CFR 0.152.
 */
package utility.sockets;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import resources.TApplication;
import utility.ziputil;

public class TSSLSocketWrapper {
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("TSSLSocketWrapper");
    private TApplication Application = null;
    private Socket socket = null;
    private DataOutputStream dataOutputStream = null;
    private DataInputStream dataInputStream = null;
    private String IconTokenID = null;
    private String SendingIcon = null;
    private String ReceivingIcon = null;
    private String InactiveIcon = null;
    private boolean IsValid = false;
    private long TtlBytesWritten = 0L;
    private long TtlBytesRead = 0L;
    private long FlushCount = 0L;
    private int szSendBuffer = 0;
    private int szRecvBuffer = 0;

    public TSSLSocketWrapper(TApplication tApplication, Socket socket) {
        this.Application = tApplication;
        this.socket = socket;
        this.init();
    }

    public TSSLSocketWrapper(TApplication tApplication, String string, int n) {
        this.Application = tApplication;
        try {
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            this.socket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
            this.init();
            if (this.Debug) {
                this.MainWin.appendToLog("TSSLSocketWrapper", "<init>", Thread.currentThread(), null, 10, "Opened socket: " + string + ", " + n);
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.MainWin.appendToLog("TSSLSocketWrapper", "<init>", Thread.currentThread(), null, 4, "Could not open socket(" + string + "," + n + ") : " + unknownHostException.toString());
        }
        catch (IOException iOException) {
            this.MainWin.appendToLog("TSSLSocketWrapper", "<init>", Thread.currentThread(), null, 4, "Could not open socket(" + string + "," + n + ") : " + iOException.toString());
        }
    }

    public void init() {
        if (this.socket == null) {
            return;
        }
        try {
            this.socket.setTcpNoDelay(true);
            this.socket.setReceiveBufferSize(16384);
            this.socket.setSendBufferSize(16384);
            this.socket.setTrafficClass(24);
            this.szSendBuffer = this.socket.getSendBufferSize();
            this.szRecvBuffer = this.socket.getReceiveBufferSize();
            this.dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.dataInputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.IsValid = true;
        }
        catch (Exception exception) {
            System.out.println("TSSLSocketWrapper.init: " + exception.toString());
        }
    }

    public void dispose() {
        this.IsValid = false;
        this.close();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public String getIPAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public long getBytesWritten() {
        return this.TtlBytesWritten;
    }

    public long getBytesRead() {
        return this.TtlBytesRead;
    }

    public long getFlushCount() {
        return this.FlushCount;
    }

    public boolean isConnected() {
        if (this.socket == null) {
            return false;
        }
        if (this.IsValid) {
            try {
                return this.socket.isConnected();
            }
            catch (Exception exception) {
                System.out.println("TSSLSocketWrapper.isConnected: " + exception.toString());
            }
        }
        return false;
    }

    public void close() {
        if (this.socket == null) {
            return;
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            System.out.println("TSSLSocketWrapper.close: " + exception.toString());
        }
    }

    public boolean available() {
        boolean bl = false;
        try {
            this.socket.setSoTimeout(2);
            this.dataInputStream.mark(1);
            this.dataInputStream.read();
            bl = true;
            this.dataInputStream.reset();
            this.socket.setSoTimeout(0);
            return true;
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public int readInt() {
        if (!this.isConnected()) {
            return 0;
        }
        int n = 0;
        try {
            n = this.dataInputStream.readInt();
            this.TtlBytesRead += 4L;
        }
        catch (Exception exception) {
            System.out.println("TSSLSocketWrapper.readInt: " + exception.toString());
            exception.printStackTrace();
            this.IsValid = false;
        }
        return n;
    }

    public void writeInt(int n, boolean bl) {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.dataOutputStream.writeInt(n);
            if (bl) {
                this.flush();
            }
            this.TtlBytesWritten += 4L;
        }
        catch (Exception exception) {
            this.IsValid = false;
            System.out.println("TSSLSocketWrapper.writeInt: " + exception.toString());
        }
    }

    public String readString() {
        if (!this.isConnected()) {
            return "";
        }
        try {
            int n;
            int n2 = this.readInt();
            byte[] byArray = new byte[n2];
            this.TtlBytesRead += 4L;
            int n3 = 0;
            do {
                n = Math.min(n2 - n3, this.szRecvBuffer - 4);
                int n4 = this.dataInputStream.read(byArray, n3, n);
                this.TtlBytesRead += (long)n4;
            } while ((n3 += n) < n2);
            return ziputil.gunzipString(byArray);
        }
        catch (Exception exception) {
            System.out.println("TSSLSocketWrapper.readString: " + exception.toString());
            this.IsValid = false;
            return "";
        }
    }

    public void writeString(String string, boolean bl) {
        if (!this.isConnected()) {
            return;
        }
        byte[] byArray = ziputil.gzipString(string);
        int n = byArray.length;
        try {
            this.writeInt(n, false);
            this.TtlBytesWritten += 4L;
            if (n > 0) {
                int n2;
                int n3 = 0;
                do {
                    n2 = Math.min(n - n3, this.szSendBuffer - 4);
                    this.dataOutputStream.write(byArray, n3, n2);
                    this.TtlBytesWritten += (long)n2;
                } while ((n3 += n2) < n);
            }
        }
        catch (Exception exception) {
            this.IsValid = false;
            System.out.println("TSSLSocketWrapper.writeString: " + exception.toString());
        }
        if (bl) {
            this.flush();
        }
    }

    public void flush() {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.dataOutputStream.flush();
            ++this.FlushCount;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeCommand(int n, boolean bl) {
        this.writeInt(n, bl);
    }

    public int readCommand() {
        int n = this.readInt();
        this.TtlBytesRead += 4L;
        return n;
    }

    public int getNativeDataType(Object object) {
        int n = 0;
        if (object instanceof Boolean) {
            n = 1;
        } else if (object instanceof Byte) {
            n = 2;
        } else if (object instanceof String) {
            n = 3;
        } else if (object instanceof Short) {
            n = 8;
        } else if (object instanceof Integer) {
            n = 6;
        } else if (object instanceof Float) {
            n = 5;
        } else if (object instanceof Double) {
            n = 4;
        } else if (object instanceof Long) {
            n = 7;
        } else if (object instanceof Date) {
            n = 11;
        }
        return n;
    }

    public void writeData(int n, Object object, boolean bl) {
        if (!this.isConnected()) {
            return;
        }
        int n2 = 0;
        try {
            n2 = this.getNativeDataType(object);
            this.dataOutputStream.writeInt(n2);
            this.TtlBytesWritten += 4L;
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    this.dataOutputStream.writeBoolean((Boolean)object);
                    ++this.TtlBytesWritten;
                    break;
                }
                case 2: {
                    this.dataOutputStream.writeByte(((Byte)object).byteValue());
                    ++this.TtlBytesWritten;
                    break;
                }
                case 3: {
                    this.writeString((String)object, false);
                    this.TtlBytesWritten += 2L;
                    break;
                }
                case 8: {
                    this.dataOutputStream.writeShort(((Short)object).shortValue());
                    this.TtlBytesWritten += 2L;
                    break;
                }
                case 6: {
                    this.dataOutputStream.writeInt((Integer)object);
                    this.TtlBytesWritten += 4L;
                    break;
                }
                case 5: {
                    this.dataOutputStream.writeFloat(((Float)object).floatValue());
                    this.TtlBytesWritten += 4L;
                    break;
                }
                case 4: {
                    this.dataOutputStream.writeDouble((Double)object);
                    this.TtlBytesWritten += 8L;
                    break;
                }
                case 7: {
                    this.dataOutputStream.writeLong((Long)object);
                    this.TtlBytesWritten += 8L;
                    break;
                }
                case 11: {
                    this.dataOutputStream.writeLong(((Date)object).getTime());
                    this.TtlBytesWritten += 8L;
                }
            }
            if (bl) {
                this.flush();
            }
        }
        catch (Exception exception) {
            System.out.println("TSSLSocketWrapper.writeData: " + exception.toString());
            System.out.println("Value class: " + object.getClass().getName() + " Native Type " + n2);
        }
    }

    public Object readData() {
        Object object = null;
        int n = 0;
        try {
            n = this.dataInputStream.readInt();
            this.TtlBytesRead += 4L;
            switch (n) {
                case 0: {
                    object = null;
                    break;
                }
                case 1: {
                    object = new Boolean(this.dataInputStream.readBoolean());
                    ++this.TtlBytesRead;
                    break;
                }
                case 2: {
                    object = new Byte(this.dataInputStream.readByte());
                    ++this.TtlBytesRead;
                    break;
                }
                case 3: {
                    object = this.readString();
                    this.TtlBytesRead += 2L;
                    break;
                }
                case 8: {
                    object = new Short(this.dataInputStream.readShort());
                    this.TtlBytesRead += 2L;
                    break;
                }
                case 6: {
                    object = new Integer(this.dataInputStream.readInt());
                    this.TtlBytesRead += 4L;
                    break;
                }
                case 5: {
                    object = new Float(this.dataInputStream.readFloat());
                    this.TtlBytesRead += 4L;
                    break;
                }
                case 4: {
                    object = new Double(this.dataInputStream.readDouble());
                    this.TtlBytesRead += 8L;
                    break;
                }
                case 7: {
                    object = new Long(this.dataInputStream.readLong());
                    this.TtlBytesRead += 8L;
                    break;
                }
                case 11: {
                    object = new Date(this.dataInputStream.readLong());
                    this.TtlBytesRead += 8L;
                    break;
                }
                case 9: {
                    object = new Integer(this.dataInputStream.readInt());
                    this.TtlBytesRead += 4L;
                    break;
                }
                case 10: {
                    object = new Integer(this.dataInputStream.readInt());
                    this.TtlBytesRead += 4L;
                    break;
                }
                default: {
                    System.out.println("TSSLSocketWrapper.readData: Unrecognized data type: " + n);
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("TSSLSocketWrapper.readData: " + exception.toString());
            System.out.println("Obj class: " + object.getClass().getName() + " Native Type " + n);
        }
        return object;
    }
}

