/*
 * Decompiled with CFR 0.152.
 */
package utility.socketqueue;

import aspect.Aspect;
import aspect.TMainWin;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import scripts.TExecScript;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.http.THttpRequest;
import utility.socketqueue.TSocketQueueSocket;

public class TSocketQueue
extends Thread {
    private ArrayList arSockets = new ArrayList();
    private boolean Terminate = false;
    private String sDebugMsg = "";
    private Date dtDebug = new Date();
    private static Date tmSocketQueueLastLoop = new Date();
    private static Date tmSocketQueueSentErrMsg = new Date(0L);
    private static long durationprocessSocketRequest = 0L;
    private boolean bAspect_Initialized = false;

    public TSocketQueue() {
        super("TSocketQueue");
        this.setPriority(1);
    }

    public void dispose() {
        this.arSockets.clear();
        this.Terminate = true;
    }

    public int getQueueCount() {
        return this.arSockets.size();
    }

    public ArrayList getQueue() {
        return this.arSockets;
    }

    public void setQueue(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            this.arSockets.add(arrayList.get(i));
        }
    }

    public Date getLastLoopTime() {
        return tmSocketQueueLastLoop;
    }

    public boolean isFunctioning() {
        long l = new Date().getTime() - tmSocketQueueLastLoop.getTime();
        if (l > 60000L) {
            return false;
        }
        return this.isAlive();
    }

    public long getDurationProcessSocketRequestDuration() {
        return durationprocessSocketRequest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processSocketRequest(Socket socket, String string, String string2, TFormulaEvaluator tFormulaEvaluator) {
        if (!this.bAspect_Initialized) {
            this.bAspect_Initialized = TMainWin.Application.getTokenValue("Aspect_Initialized").equalsIgnoreCase("true");
            if (!this.bAspect_Initialized) {
                return;
            }
        }
        ++TFormulaEvaluator.intSocketRequests;
        if (this.arSockets.size() > 20) {
            System.out.println("Error: processSocketRequest: too many sockets queues");
            ++TFormulaEvaluator.intSocketIgnored;
            THttpRequest tHttpRequest = new THttpRequest(socket);
            try {
                socket.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        String string3 = socket.getRemoteSocketAddress().toString();
        string3 = charutil.removeChar(string3, '/');
        if ((string3 = string3.substring(0, string3.indexOf(":"))).indexOf("127.0.0.1") < 0) {
            if (TMainWin.Application.getTokenValue("SupportIPAddresses").indexOf(string3) < 0) {
                if (!string3.equals(TMainWin.Application.getTokenValue("ExternalIPAddress"))) {
                    this.arSockets.add(new TSocketQueueSocket(socket, string, string2, tFormulaEvaluator));
                    ++TFormulaEvaluator.intSocketProcessed;
                    return;
                }
            }
        }
        this.arSockets.add(new TSocketQueueSocket(socket, string, string2, tFormulaEvaluator));
        ++TFormulaEvaluator.intSocketProcessed;
    }

    @Override
    public void run() {
        int n = 12;
        int n2 = 35;
        if (!Aspect.MainWin.isRunningOnServer()) {
            n2 += 10;
        }
        Date date = new Date();
        Date date2 = new Date();
        do {
            int n3 = this.arSockets.size();
            int n4 = TExecScript.countScripts("GreenLight_Client_Listener_Socket");
            if (n3 > 0 && n4 < n && Thread.activeCount() < n2) {
                long l = new Date().getTime();
                ++TFormulaEvaluator.countprocessSocketRequest;
                this.sDebugMsg = "a_queued: " + Integer.toString(n3) + " scripts: " + Integer.toString(n4);
                this.dtDebug = new Date();
                while (n3 > 0 && n4 < n && Thread.activeCount() < n2) {
                    TSocketQueueSocket tSocketQueueSocket = (TSocketQueueSocket)this.arSockets.get(0);
                    if (tSocketQueueSocket != null) {
                        int n5 = (int)(new Date().getTime() - tSocketQueueSocket.timeAdded.getTime());
                        TFormulaEvaluator.intSocketQueueTime += (long)n5;
                        try {
                            if (tSocketQueueSocket.socket.isClosed() || tSocketQueueSocket.socket.getInputStream() == null) {
                                System.out.println("removing closed socket from queue");
                            } else {
                                this.sDebugMsg = "process: " + tSocketQueueSocket.RemoteIP;
                                this.dtDebug = new Date();
                                TExecScript tExecScript = new TExecScript(tSocketQueueSocket.ScriptID, null, tSocketQueueSocket.FormulaEvaluator);
                                tExecScript.setSocket(tSocketQueueSocket.socket, tSocketQueueSocket.SocketName);
                                tExecScript.start();
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("socket inputstream is null");
                        }
                    }
                    if (!this.Terminate && this.arSockets.size() > 0) {
                        this.arSockets.remove(0);
                    }
                    n3 = this.arSockets.size();
                    n4 = TExecScript.countScripts("GreenLight_Client_Listener_Socket");
                }
                date = new Date();
                this.sDebugMsg = "b_queued: " + Integer.toString(n3) + " scripts: " + Integer.toString(n4);
                this.dtDebug = new Date();
                durationprocessSocketRequest += date.getTime() - l;
            } else {
                if (n3 > 10) {
                    if (new Date().getTime() - TMainWin.ProgramStartTime.getTime() > 300000L) {
                        Aspect.MainWin.dumpState("TSocketQueue", "Too many threads");
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n3 > 0 && new Date().getTime() - date.getTime() > 5000L) {
                    this.sDebugMsg = "c_queued: " + Integer.toString(n3) + " scripts: " + Integer.toString(n4);
                    this.dtDebug = new Date();
                    if (new Date().getTime() - date2.getTime() > 10000L) {
                        Aspect.MainWin.appendToLog("TSocketQueue", "run", Thread.currentThread(), null, 3, "Queued sockets: " + this.arSockets.size() + " scriptCount: " + n4 + " Threads:" + Thread.activeCount());
                        date2 = new Date();
                    }
                }
            }
            this.sDebugMsg = "d_queued: " + Integer.toString(n3) + " scripts: " + Integer.toString(n4);
            this.dtDebug = new Date();
            tmSocketQueueLastLoop = new Date();
        } while (!this.Terminate);
    }
}

