/*
 * Decompiled with CFR 0.152.
 */
package utility.session;

import aspect.Aspect;
import aspect.TMainWin;
import java.util.Date;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.dateutil;
import utility.netutil;

public class TSessionObj {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    int DiskIndex = -1;
    String ID = "";
    String BrowserID = "";
    Date TimeOpened = null;
    Date LastAccess = null;
    int AccessCount = 0;
    String CompanyID = "";
    String HashID = "";
    String UserAgent = "";
    String Password = "";
    String IPAddress = "";
    boolean Closed = false;
    Date Closed_Time = new Date(0L);
    int Closed_Reason = 0;

    public TSessionObj(String string) {
        this.ID = string;
    }

    public String getID() {
        return this.ID;
    }

    public void setBrowserID(String string) {
        this.BrowserID = string;
    }

    public String getBrowserID() {
        return this.BrowserID;
    }

    public void setDiskIndex(int n) {
        this.DiskIndex = n;
    }

    public int getDiskIndex() {
        return this.DiskIndex;
    }

    public void setTimeOpened(Date date) {
        this.TimeOpened = date;
    }

    public void setLastAccess(Date date) {
        this.LastAccess = date;
    }

    public Date getLastAccess() {
        return this.LastAccess;
    }

    public void setAccessCount(int n) {
        this.AccessCount = n;
    }

    public int getAccessCount() {
        return this.AccessCount;
    }

    public void setCompanyID(String string) {
        this.CompanyID = string;
    }

    public void setHashID(String string) {
        this.HashID = string.trim();
    }

    public void setUserAgent(String string) {
        this.UserAgent = string.trim();
    }

    public void setPassword(String string) {
        this.Password = string.trim();
    }

    public String getPassword() {
        return this.Password;
    }

    public void setIPAddress(String string) {
        this.IPAddress = string.trim();
    }

    public void setClosed(boolean bl) {
        this.Closed = bl;
    }

    public void setClosedTime(Date date) {
        this.Closed_Time = date;
    }

    public void setClosedReason(int n) {
        this.Closed_Reason = n;
    }

    public String getClosedReasonText() {
        if (!this.Closed) {
            return "Not closed";
        }
        return (String)new TFormulaEvaluator().getFormulaValue("lookup(\"Aspect_Session_Closed_Reason\"," + this.Closed_Reason + ")");
    }

    public boolean isValid(String string) {
        String string2 = "";
        if (this.HashID.length() == 0) {
            string2 = "Missing Hash ID";
        } else if (this.UserAgent.length() == 0 && !this.ID.equalsIgnoreCase("local")) {
            MainWin.appendToLog("TSessionObj", "isValid", Thread.currentThread(), null, 4, "TSessionObj isValid() Missing user-agent");
        } else if (this.Password.length() == 0) {
            MainWin.appendToLog("TSessionObj", "isValid", Thread.currentThread(), null, 4, "TSessionObj isValid() Allowing blank password");
        } else if (this.IPAddress.length() == 0) {
            MainWin.appendToLog("TSessionObj", "isValid", Thread.currentThread(), null, 4, "TSessionObj isValid() Missing IP Address");
        } else if (this.Closed) {
            string2 = "Session is closed: " + this.getClosedReasonText();
        } else if (this.ID.equalsIgnoreCase("local") && !this.IPAddress.equals("127.0.0.1")) {
            string2 = "Session ID is local but IP is not.  IP=" + this.IPAddress;
        } else if (!this.IPAddress.equals(string)) {
            String string3 = netutil.getLocalIP();
            if (string3.equals(string)) {
                return true;
            }
            if (string.trim().length() == 0) {
                System.out.println("Current IP address is blank");
                new Throwable().printStackTrace();
            }
        }
        if (string2.length() == 0) {
            return true;
        }
        MainWin.appendToLog("TSessionObj", "isValid", Thread.currentThread(), null, 4, "Invalid session [" + this.ID + "]: " + string2);
        return false;
    }

    public String toString() {
        String string = "Record=" + Integer.toString(this.DiskIndex) + "|ID=" + this.ID;
        string = this.TimeOpened == null ? string + "|Time Opened=null" : string + "|Time Opened=" + dateutil.formatDate(this.TimeOpened, "yy-MM-dd HH:mm:ss");
        string = this.LastAccess == null ? string + "|LastAccess=null" : string + "|LastAccess=" + dateutil.formatDate(this.LastAccess, "yy-MM-dd HH:mm:ss");
        string = string + "|IP=" + this.IPAddress + "|Pass=" + this.Password + "|BrowserID=" + this.BrowserID;
        string = string + "|AccessCount=" + this.AccessCount + "|CompanyID=" + this.CompanyID + "|HashID=" + this.HashID + "|Closed=" + this.Closed;
        string = string + "|Closed_Time=" + dateutil.formatDate(this.Closed_Time, "yy-MM-dd HH:mm:ss") + "|Closed Reason=" + this.Closed_Reason + "|User-Agent=" + this.UserAgent;
        return string;
    }
}

