/*
 * Decompiled with CFR 0.152.
 */
package utility.session;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TDriverStructRecord;
import drivers.files.TBinaryFile;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.notifications.TNotification;
import utility.notifications.TNotificationServer;
import utility.security.TPasswordService;
import utility.session.TSessionObj;

public class TSession {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    private static TBinaryFile drvSession = null;
    private static int FIELD_COUNT = 14;
    private static int FIELD_ID = 0;
    private static int FIELD_USED = 1;
    private static int FIELD_BROWSER_ID = 2;
    private static int FIELD_TIME_OPENED = 3;
    private static int FIELD_LAST_ACCESS = 4;
    private static int FIELD_ACCESS_COUNT = 5;
    private static int FIELD_HASHID = 6;
    private static int FIELD_USER_AGENT = 7;
    private static int FIELD_PASSWORD = 8;
    private static int FIELD_IPADDRESS = 9;
    private static int FIELD_CLOSED = 10;
    private static int FIELD_CLOSED_TIME = 11;
    private static int FIELD_CLOSED_REASON = 12;
    private static int FIELD_COMPANYID = 13;
    private static String[] FieldID = new String[]{"ID", "Used", "Browser_ID", "Time_Opened", "Last_Access", "Access_Count", "HashID", "User_Agent", "Password", "IPAddress", "Closed", "Closed_Time", "Closed_Reason", "CompanyID"};
    public static int CLOSED_REASON_UNDEFINED = 0;
    public static int CLOSED_REASON_LOGGEDOFF = 1;
    public static int CLOSED_REASON_TIMEDOUT = 2;
    public static int CLOSED_REASON_IPADDRCHANGED = 3;
    public static int CLOSED_REASON_REPLACED = 4;
    private static TDriverStructRecord[] DSRec = new TDriverStructRecord[FIELD_COUNT];
    private static Hashtable hSession = new Hashtable();
    private static String LoginPage = null;
    private static String LoginPageMobile = null;
    private static TSessionObj StaticSession = null;

    public void openSessionDriver() {
        int n;
        TAppDriversObject tAppDriversObject = TSession.Application.AppDrivers.getAppDriversObject("Aspect_Session");
        TFormulaEvaluator tFormulaEvaluator = new TFormulaEvaluator();
        TAppDriversObject tAppDriversObject2 = new TAppDriversObject(tAppDriversObject);
        String string = TFormulaEvaluator.convertToString(tFormulaEvaluator.getFormulaValue(tAppDriversObject2.FileName, 0, 0));
        tAppDriversObject2.FileName.setLength(0);
        tAppDriversObject2.FileName.append(TMainWin.Application.parse_tokens(string));
        drvSession = new TBinaryFile(Application, tAppDriversObject2, 1, false);
        try {
            drvSession.makeEditableFile();
            System.out.println("drvSession isValid=" + drvSession.isValid());
            System.out.println("drvSession Filename=" + TSession.drvSession.FileName);
        }
        catch (Exception exception) {
            System.out.println("Error in openSessionDriver: " + exception.toString());
        }
        for (n = 0; n < FIELD_COUNT; ++n) {
            TSession.DSRec[n] = TSession.drvSession.DriverStruct.getField(FieldID[n]);
        }
        n = drvSession.getRecordCount();
        for (int i = 0; i < n; ++i) {
            boolean bl = (Boolean)drvSession.getField(DSRec[FIELD_USED], i);
            if (!bl) continue;
            String string2 = (String)drvSession.getField(DSRec[FIELD_ID], i);
            String string3 = (String)drvSession.getField(DSRec[FIELD_BROWSER_ID], i);
            Date date = (Date)drvSession.getField(DSRec[FIELD_TIME_OPENED], i);
            String string4 = (String)drvSession.getField(DSRec[FIELD_COMPANYID], i);
            String string5 = (String)drvSession.getField(DSRec[FIELD_HASHID], i);
            String string6 = (String)drvSession.getField(DSRec[FIELD_USER_AGENT], i);
            String string7 = (String)drvSession.getField(DSRec[FIELD_PASSWORD], i);
            String string8 = (String)drvSession.getField(DSRec[FIELD_IPADDRESS], i);
            boolean bl2 = (Boolean)drvSession.getField(DSRec[FIELD_CLOSED], i);
            Date date2 = (Date)drvSession.getField(DSRec[FIELD_CLOSED_TIME], i);
            int n2 = (Integer)drvSession.getField(DSRec[FIELD_CLOSED_REASON], i);
            TSessionObj tSessionObj = new TSessionObj(string2);
            tSessionObj.setDiskIndex(i);
            tSessionObj.setBrowserID(string3);
            tSessionObj.setTimeOpened(date);
            tSessionObj.setCompanyID(string4);
            tSessionObj.setHashID(string5);
            tSessionObj.setUserAgent(string6);
            tSessionObj.setPassword(string7);
            tSessionObj.setIPAddress(string8);
            tSessionObj.setClosed(bl2);
            tSessionObj.setClosedTime(date2);
            tSessionObj.setClosedReason(n2);
            hSession.put(string2, tSessionObj);
        }
    }

    public static TSessionObj getLocalSession(String string) {
        if (StaticSession == null) {
            StaticSession = new TSessionObj("local");
            StaticSession.setTimeOpened(new Date());
            StaticSession.setHashID(Application.getAspectHashID());
            StaticSession.setUserAgent(string);
            StaticSession.setPassword(TNotification.encryptPassword(Application.getTokenValue("Aspect_BackOffice_PollPasswd")));
            StaticSession.setIPAddress("127.0.0.1");
        } else {
            StaticSession.setPassword(TNotification.encryptPassword(Application.getTokenValue("Aspect_BackOffice_PollPasswd")));
        }
        return StaticSession;
    }

    public boolean sessionExists(String string) {
        return hSession.containsKey(string);
    }

    public TSessionObj getSession(String string) {
        if (string.trim().length() == 0) {
            return null;
        }
        if (string.equalsIgnoreCase("local")) {
            return StaticSession;
        }
        if (!this.sessionExists(string)) {
            System.out.println("getSession returns null.  Available sessions are:");
            Enumeration enumeration = hSession.keys();
            while (enumeration.hasMoreElements()) {
                System.out.println("\t" + (String)enumeration.nextElement());
            }
            return null;
        }
        TSessionObj tSessionObj = (TSessionObj)hSession.get(string);
        tSessionObj.setLastAccess(new Date());
        tSessionObj.setAccessCount(tSessionObj.getAccessCount() + 1);
        drvSession.putField(DSRec[FIELD_LAST_ACCESS], tSessionObj.getDiskIndex(), (Object)tSessionObj.getLastAccess());
        drvSession.putField(DSRec[FIELD_ACCESS_COUNT], tSessionObj.getDiskIndex(), (Object)tSessionObj.getAccessCount());
        drvSession.clearWriteBuffer();
        return tSessionObj;
    }

    public boolean clearSessions() {
        try {
            TSession.drvSession.F.setLength(0L);
            hSession.clear();
            return true;
        }
        catch (Exception exception) {
            MainWin.appendToLog("TSession", "clearSessions", Thread.currentThread(), exception, 4, "Error: " + exception.toString());
            return false;
        }
    }

    public TSessionObj addSession(String string, String string2, String string3, String string4, String string5) {
        TSessionObj tSessionObj;
        MainWin.appendToLog("TSession", "addSession", Thread.currentThread(), null, 3, "TSession.addSession IP=" + string4 + " Browser=" + string5);
        Enumeration enumeration = hSession.keys();
        while (enumeration.hasMoreElements()) {
            tSessionObj = (TSessionObj)hSession.get(enumeration.nextElement());
            if (tSessionObj.Closed || !tSessionObj.BrowserID.equals(string5) || !tSessionObj.IPAddress.equals(string4)) continue;
            MainWin.appendToLog("TSession", "addSession", Thread.currentThread(), null, 3, "TSession.addSession returning existing session: " + tSessionObj.ID);
            return tSessionObj;
        }
        tSessionObj = new TSessionObj(TPasswordService.generateSalt(8));
        MainWin.appendToLog("TSession", "addSession", Thread.currentThread(), null, 3, "TSession.addSession added new session: " + tSessionObj.ID);
        tSessionObj.setTimeOpened(new Date());
        tSessionObj.setHashID(string);
        tSessionObj.setUserAgent(string3);
        tSessionObj.setPassword(string2);
        tSessionObj.setIPAddress(string4);
        tSessionObj.setBrowserID(string5);
        hSession.put(tSessionObj.getID(), tSessionObj);
        this.writeSessionObj(tSessionObj);
        if (string3.trim().length() == 0) {
            MainWin.appendToLog("TSession", "addSession", Thread.currentThread(), null, 4, "TSession addSession() missing user-agent");
        }
        if (string4.trim().length() == 0) {
            MainWin.appendToLog("TSession", "addSession", Thread.currentThread(), null, 4, "TSession addSession() missing IP Address");
        }
        return tSessionObj;
    }

    public boolean setPassword(TSessionObj tSessionObj, String string) {
        if (tSessionObj == null) {
            MainWin.appendToLog("TSession", "setSessionPassword", Thread.currentThread(), null, 4, "Session is null in setSessionPassword");
            return false;
        }
        tSessionObj.setPassword(TNotification.encryptPassword(string));
        this.writeSessionObj(tSessionObj);
        return true;
    }

    public boolean closeSession(String string, int n) {
        if (!this.sessionExists(string)) {
            MainWin.appendToLog("TSession", "closeSession", Thread.currentThread(), null, 4, "Error in CloseSession.  Cannot locate session with ID: " + string);
            return false;
        }
        TSessionObj tSessionObj = (TSessionObj)hSession.get(string);
        tSessionObj.setClosed(true);
        tSessionObj.setClosedReason(n);
        tSessionObj.setClosedTime(new Date());
        drvSession.putField(DSRec[FIELD_CLOSED], tSessionObj.getDiskIndex(), (Object)new Boolean(tSessionObj.Closed));
        drvSession.putField(DSRec[FIELD_CLOSED_TIME], tSessionObj.getDiskIndex(), (Object)tSessionObj.Closed_Time);
        drvSession.putField(DSRec[FIELD_CLOSED_REASON], tSessionObj.getDiskIndex(), (Object)new Integer(tSessionObj.Closed_Reason));
        MainWin.appendToLog("TSession", "closeSession", Thread.currentThread(), null, 3, "CloseSession closed session with ID: " + string);
        drvSession.clearWriteBuffer();
        return true;
    }

    public boolean isSessionValid(TSessionObj tSessionObj, String string) {
        if (tSessionObj == null) {
            MainWin.appendToLog("TSession", "isSessionValid", Thread.currentThread(), null, 4, "Session is null in isSessionValid");
            return false;
        }
        return tSessionObj.isValid(string);
    }

    public void writeSessionObj(TSessionObj tSessionObj) {
        int n = tSessionObj.getDiskIndex();
        if (n < 0) {
            n = drvSession.initializeNewRecord(true);
            tSessionObj.setDiskIndex(n);
        }
        drvSession.putField(DSRec[FIELD_ID], n, (Object)tSessionObj.ID);
        drvSession.putField(DSRec[FIELD_BROWSER_ID], n, (Object)tSessionObj.BrowserID);
        drvSession.putField(DSRec[FIELD_TIME_OPENED], n, (Object)tSessionObj.TimeOpened);
        drvSession.putField(DSRec[FIELD_LAST_ACCESS], n, (Object)tSessionObj.LastAccess);
        drvSession.putField(DSRec[FIELD_ACCESS_COUNT], n, (Object)tSessionObj.AccessCount);
        drvSession.putField(DSRec[FIELD_COMPANYID], n, (Object)tSessionObj.CompanyID);
        drvSession.putField(DSRec[FIELD_HASHID], n, (Object)tSessionObj.HashID);
        drvSession.putField(DSRec[FIELD_USER_AGENT], n, (Object)tSessionObj.UserAgent);
        drvSession.putField(DSRec[FIELD_PASSWORD], n, (Object)tSessionObj.Password);
        drvSession.putField(DSRec[FIELD_IPADDRESS], n, (Object)tSessionObj.IPAddress);
        drvSession.putField(DSRec[FIELD_CLOSED], n, (Object)new Boolean(tSessionObj.Closed));
        drvSession.putField(DSRec[FIELD_CLOSED_TIME], n, (Object)tSessionObj.Closed_Time);
        drvSession.putField(DSRec[FIELD_CLOSED_REASON], n, (Object)new Integer(tSessionObj.Closed_Reason));
        drvSession.clearWriteBuffer();
    }

    public TSessionObj processLogin(String string, String string2, String string3) {
        if (string.trim().length() == 0) {
            MainWin.appendToLog("TSession", "processLogin", Thread.currentThread(), null, 4, "Error: TSession: Missing session ID during login");
            return null;
        }
        if (string2.trim().length() < 8) {
            MainWin.appendToLog("TSession", "processLogin", Thread.currentThread(), null, 4, "Error: Missing or invalid company ID during login: " + string2);
            return null;
        }
        TSessionObj tSessionObj = this.getSession(string);
        if (tSessionObj == null) {
            MainWin.appendToLog("TSession", "processLogin", Thread.currentThread(), null, 4, "Error: Invalid session ID during login: " + string);
            return null;
        }
        if (MainWin.isRunningOnServer()) {
            TFormulaEvaluator.getNotificationServer();
            if (TNotificationServer.Notification_ServerSide.validateLogin(string2, string3)) {
                this.setPassword(tSessionObj, string3);
                tSessionObj.setCompanyID(string2);
                tSessionObj.Closed = false;
                tSessionObj.Closed_Reason = 0;
                this.writeSessionObj(tSessionObj);
                MainWin.appendToLog("TCache", "TSession", Thread.currentThread(), null, 3, "TSession: Login successful for session: " + string);
                return tSessionObj;
            }
        } else {
            String string4 = Application.getTokenValue("Aspect_BackOffice_Pref_CompanyPollingID");
            String string5 = Application.getTokenValue("Aspect_BackOffice_PollPasswd");
            String string6 = string4.length() >= 8 ? string4.substring(0, 8) : "";
            String string7 = string2.substring(0, 8);
            if (string7.equalsIgnoreCase(string6) && string3.equals(string5)) {
                this.setPassword(tSessionObj, string3);
                tSessionObj.setCompanyID(string2);
                tSessionObj.Closed = false;
                tSessionObj.Closed_Reason = 0;
                this.writeSessionObj(tSessionObj);
                MainWin.appendToLog("TCache", "TSession", Thread.currentThread(), null, 3, "TSession: Login successful for session: " + string);
                return tSessionObj;
            }
            if (!string2.equals(string4)) {
                MainWin.appendToLog("TCache", "TSession", Thread.currentThread(), null, 3, "TSession: Login error: Bad company ID: " + string2);
            }
            if (!string3.equals(string5)) {
                MainWin.appendToLog("TCache", "TSession", Thread.currentThread(), null, 3, "TSession: Login error: Bad password");
            }
        }
        MainWin.appendToLog("TCache", "getCachedContent", Thread.currentThread(), null, 4, "TSession: Login failed for session: " + string);
        return null;
    }

    public String getSessionInfo(String string) {
        if (!this.sessionExists(string)) {
            String string2 = "Error in getSessionInfo.  Cannot locate session with ID: " + string;
            MainWin.appendToLog("TSession", "getSessionInfo", Thread.currentThread(), null, 4, string2);
            return string2;
        }
        TSessionObj tSessionObj = (TSessionObj)hSession.get(string);
        String string3 = tSessionObj.toString();
        MainWin.appendToLog("TSession", "getSessionInfo", Thread.currentThread(), null, 3, string3);
        return string3;
    }
}

