/*
 * Decompiled with CFR 0.152.
 */
package utility.print;

import aspect.Aspect;
import aspect.TMainWin;
import controls.TDesktopPane;
import controls.TInternalFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyVetoException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.MatteBorder;
import javax.swing.event.InternalFrameEvent;
import resources.TApplication;
import scrollwin.TScrollWin;
import utility.charutil;

public class TPrintPreview
extends TInternalFrame {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTPrintPreview");
    private static TApplication Application = TMainWin.Application;
    private TDesktopPane Desktop = null;
    protected TPreviewPanel PreviewPanel = null;
    protected PrinterJob prnJob = null;
    protected Printable PrintableObj = null;
    protected PageFormat pageFormat = null;
    protected JComboBox cbxScale = null;
    protected int PageWidth = 0;
    protected int PageHeight = 0;
    public int WindowID = 0;

    public TPrintPreview(TDesktopPane tDesktopPane, Printable printable, String string, int n) {
        super(string);
        this.Desktop = tDesktopPane;
        this.WindowID = n;
        this.PrintableObj = printable;
    }

    public void createAndShowGui() {
        JToolBar jToolBar = new JToolBar();
        JButton jButton = new JButton("Print", new ImageIcon("/images/print.gif"));
        jButton.addActionListener(new TPrintButtonListener());
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(new Insets(4, 6, 4, 6));
        jToolBar.add(jButton);
        jButton = new JButton("Close");
        jButton.addActionListener(new TCloseButtonListener());
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(new Insets(2, 6, 2, 6));
        jToolBar.add(jButton);
        jButton = new JButton("Setup");
        jButton.addActionListener(new TSetupButtonListener());
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(new Insets(2, 6, 2, 6));
        jToolBar.add(jButton);
        String[] stringArray = new String[]{"10%", "25%", "50%", "75%", "100%", "150%", "200%", "300%"};
        this.cbxScale = new JComboBox<String>(stringArray);
        this.cbxScale.addActionListener(new TCbxScaleListener());
        this.cbxScale.setMaximumSize(this.cbxScale.getPreferredSize());
        this.cbxScale.setEditable(true);
        this.cbxScale.setSelectedItem("100%");
        jToolBar.addSeparator();
        jToolBar.add(this.cbxScale);
        this.getContentPane().add((Component)jToolBar, "North");
        this.PreviewPanel = new TPreviewPanel();
        this.prnJob = PrinterJob.getPrinterJob();
        if (!this.prnJob.printDialog()) {
            return;
        }
        this.pageFormat = this.prnJob.defaultPage();
        if (this.Debug) {
            String string = "Orientation=";
            string = this.pageFormat.getOrientation() == 1 ? string + "Portrait" : (this.pageFormat.getOrientation() == 0 ? string + "Landscape" : string + "Reverse Landscape");
            string = string + " Page width=" + this.pageFormat.getWidth() + " Page height=" + this.pageFormat.getHeight();
            MainWin.appendToLog("TPrintPreview", "createAndShowGui", Thread.currentThread(), null, 3, string);
        }
        if (this.pageFormat.getHeight() == 0.0 || this.pageFormat.getWidth() == 0.0) {
            System.err.println("Unable to determine default page size");
            return;
        }
        this.PageWidth = (int)this.pageFormat.getWidth();
        this.PageHeight = (int)this.pageFormat.getHeight();
        int n = 100;
        int n2 = this.PageWidth * n / 100;
        int n3 = this.PageHeight * n / 100;
        int n4 = 0;
        try {
            boolean bl = false;
            while (!bl) {
                if (this.Debug) {
                    MainWin.appendToLog("TPrintPreview", "createAndShowGui", Thread.currentThread(), null, 3, "Printing page " + n4);
                }
                BufferedImage bufferedImage = new BufferedImage(this.PageWidth, this.PageHeight, 1);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.PageWidth, this.PageHeight);
                if (this.PrintableObj.print(graphics, this.pageFormat, n4) != 0) {
                    bl = true;
                    continue;
                }
                TPreviewPage tPreviewPage = new TPreviewPage(n2, n3, bufferedImage);
                this.PreviewPanel.add(tPreviewPage);
                ++n4;
            }
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
            System.err.println("Printing error: " + printerException.toString());
        }
        JScrollPane jScrollPane = new JScrollPane(this.PreviewPanel);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.Desktop.add(this);
        try {
            Rectangle rectangle = this.Desktop.getBounds();
            int n5 = (int)((double)rectangle.width * 0.1);
            int n6 = (int)((double)rectangle.height * 0.1);
            rectangle.x = TScrollWin.NewFrameLocation;
            rectangle.width -= n5 * 2;
            rectangle.y = TScrollWin.NewFrameLocation;
            rectangle.height -= n6 * 2;
            if (rectangle.x + rectangle.width > this.Desktop.getWidth() || rectangle.y + rectangle.height > TMainWin.Desktop.getHeight()) {
                rectangle.x = 0;
                rectangle.y = 0;
            }
            TScrollWin.NewFrameLocation = rectangle.x + TScrollWin.FrameDistance;
            this.setBounds(rectangle);
            this.setSize(rectangle.width, rectangle.height);
            this.setSelected(true);
            this.setMaximizable(true);
            this.setResizable(true);
            this.setBackground(Color.white);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setVisible(true);
        this.setMaximum(true);
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        TPrintPreview.Application.AppAction.enableDriverCommands(null);
        MainWin.enableMainWinToolbarDriverCommands(false, null);
        TPrintPreview.Application.AppAction.enableActionType(11, true);
        TPrintPreview.Application.AppAction.enableActionType(15, true);
        boolean bl = true;
        if (MainWin.getWindowCount() == 1) {
            bl = false;
        }
        TPrintPreview.Application.AppAction.enableActionType(13, bl);
        TPrintPreview.Application.AppAction.enableActionType(14, bl);
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        MainWin.ScrollWinClosed(this, this.WindowID);
    }

    class TCbxScaleListener
    implements ActionListener {
        TCbxScaleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    String string = TPrintPreview.this.cbxScale.getSelectedItem().toString();
                    if (string.endsWith("%")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    string = string.trim();
                    int n = charutil.ival(string);
                    int n2 = TPrintPreview.this.PageWidth * n / 100;
                    int n3 = TPrintPreview.this.PageHeight * n / 100;
                    if (TPrintPreview.this.PreviewPanel == null) {
                        return;
                    }
                    Component[] componentArray = TPrintPreview.this.PreviewPanel.getComponents();
                    for (int i = 0; i < componentArray.length; ++i) {
                        if (!(componentArray[i] instanceof TPreviewPage)) continue;
                        TPreviewPage tPreviewPage = (TPreviewPage)componentArray[i];
                        tPreviewPage.setScaledSize(n2, n3);
                    }
                    TPrintPreview.this.PreviewPanel.doLayout();
                    if (TPrintPreview.this.PreviewPanel.getParent() != null && TPrintPreview.this.PreviewPanel.getParent().getParent() != null) {
                        TPrintPreview.this.PreviewPanel.getParent().getParent().validate();
                    }
                }
            };
            thread.setPriority(1);
            thread.start();
        }
    }

    class TSetupButtonListener
    implements ActionListener {
        TSetupButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TPrintPreview.this.pageFormat = TPrintPreview.this.prnJob.pageDialog(TPrintPreview.this.pageFormat);
            TPrintPreview.this.PageWidth = (int)TPrintPreview.this.pageFormat.getWidth();
            TPrintPreview.this.PageHeight = (int)TPrintPreview.this.pageFormat.getHeight();
            Component[] componentArray = TPrintPreview.this.PreviewPanel.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof TPreviewPage)) continue;
                TPrintPreview.this.PreviewPanel.remove(componentArray[i]);
            }
            Thread thread = new Thread(){

                @Override
                public void run() {
                    String string = TPrintPreview.this.cbxScale.getSelectedItem().toString();
                    if (string.endsWith("%")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    string = string.trim();
                    int n = charutil.ival(string);
                    int n2 = TPrintPreview.this.PageWidth * n / 100;
                    int n3 = TPrintPreview.this.PageHeight * n / 100;
                    int n4 = 0;
                    try {
                        boolean bl = false;
                        while (!bl) {
                            System.out.println("printing page " + n4);
                            BufferedImage bufferedImage = new BufferedImage(TPrintPreview.this.PageWidth, TPrintPreview.this.PageHeight, 1);
                            Graphics graphics = bufferedImage.getGraphics();
                            graphics.setColor(Color.white);
                            graphics.fillRect(0, 0, TPrintPreview.this.PageWidth, TPrintPreview.this.PageHeight);
                            if (TPrintPreview.this.PrintableObj.print(graphics, TPrintPreview.this.pageFormat, n4) != 0) {
                                bl = true;
                                continue;
                            }
                            TPreviewPage tPreviewPage = new TPreviewPage(n2, n3, bufferedImage);
                            TPrintPreview.this.PreviewPanel.add(tPreviewPage);
                            ++n4;
                        }
                    }
                    catch (PrinterException printerException) {
                        printerException.printStackTrace();
                        System.err.println("Printing error: " + printerException.toString());
                    }
                    TPrintPreview.this.PreviewPanel.doLayout();
                    TPrintPreview.this.PreviewPanel.getParent().getParent().validate();
                }
            };
            thread.setPriority(1);
            thread.start();
        }
    }

    class TCloseButtonListener
    implements ActionListener {
        TCloseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TPrintPreview.this.dispose();
        }
    }

    class TPrintButtonListener
    implements ActionListener {
        TPrintButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TPrintPreview.this.prnJob.setPrintable(TPrintPreview.this.PrintableObj);
                TPrintPreview.this.setCursor(Cursor.getPredefinedCursor(3));
                TPrintPreview.this.prnJob.print();
                TPrintPreview.this.setCursor(Cursor.getPredefinedCursor(0));
                TPrintPreview.this.dispose();
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
                System.err.println("Printing error: " + printerException.toString());
            }
        }
    }

    class TPreviewPage
    extends JPanel {
        protected int m_w;
        protected int m_h;
        protected Image m_source;
        protected Image m_img;

        public TPreviewPage(int n, int n2, Image image) {
            this.m_w = n;
            this.m_h = n2;
            this.m_source = image;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.m_img.flush();
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public void setScaledSize(int n, int n2) {
            this.m_w = n;
            this.m_h = n2;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(this.m_w + insets.left + insets.right, this.m_h + insets.top + insets.bottom);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage(this.m_img, 0, 0, this);
            this.paintBorder(graphics);
        }
    }

    class TPreviewPanel
    extends JPanel {
        protected int H_GAP = 16;
        protected int V_GAP = 10;

        TPreviewPanel() {
        }

        @Override
        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            int n2 = dimension.width;
            int n3 = dimension.height;
            Dimension dimension2 = this.getParent().getSize();
            int n4 = Math.max((dimension2.width - this.H_GAP) / (n2 + this.H_GAP), 1);
            int n5 = n / n4;
            if (n5 * n4 < n) {
                ++n5;
            }
            int n6 = n4 * (n2 + this.H_GAP) + this.H_GAP;
            int n7 = n5 * (n3 + this.V_GAP) + this.V_GAP;
            Insets insets = this.getInsets();
            return new Dimension(n6 + insets.left + insets.right, n7 + insets.top + insets.bottom);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void doLayout() {
            Insets insets = this.getInsets();
            int n = insets.left + this.H_GAP;
            int n2 = insets.top + this.V_GAP;
            int n3 = this.getComponentCount();
            if (n3 == 0) {
                return;
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            int n4 = dimension.width;
            int n5 = dimension.height;
            Dimension dimension2 = this.getParent().getSize();
            int n6 = Math.max((dimension2.width - this.H_GAP) / (n4 + this.H_GAP), 1);
            int n7 = n3 / n6;
            if (n7 * n6 < n3) {
                ++n7;
            }
            int n8 = 0;
            for (int i = 0; i < n7; ++i) {
                for (int j = 0; j < n6; ++j) {
                    if (n8 >= n3) {
                        return;
                    }
                    component = this.getComponent(n8++);
                    component.setBounds(n, n2, n4, n5);
                    n += n4 + this.H_GAP;
                }
                n2 += n5 + this.V_GAP;
                n = insets.left + this.H_GAP;
            }
        }
    }
}

