/*
 * Decompiled with CFR 0.152.
 */
package utility.paypal;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.RandomAccessFile;
import java.util.Date;
import resources.TApplication;
import utility.TFile;
import utility.charutil;
import utility.dateutil;

public class TPaypalManager {
    private TMainWin MainWin = Aspect.MainWin;
    private TApplication Application = TMainWin.Application;

    public synchronized boolean recordTransaction(String string) {
        Date date = new Date();
        string = charutil.replaceAllSubstrings(string, "|", "~pipe~");
        string = charutil.replaceAllSubstrings(string, "\r", "~cr~");
        string = charutil.replaceAllSubstrings(string, "\n", "~lf~");
        string = charutil.replaceAllSubstrings(string, "\"", "~qt~");
        string = charutil.replaceAllSubstrings(string, "&", "|");
        string = dateutil.formatDate(date, "MM-dd-yyyy HH:mm:ss") + "|" + string + "\r\n";
        String string2 = this.Application.getHomeDir() + "billing\\paypal_" + dateutil.formatDate(date, "yyyy-MM-dd") + ".txt";
        try {
            new TFile(string2).validatePathToFile(true);
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rwd");
            randomAccessFile.seek(randomAccessFile.length());
            randomAccessFile.writeBytes(string);
            randomAccessFile.close();
            this.MainWin.appendToLog("TPaypalManager", "recordTransaction", Thread.currentThread(), null, 3, "Ok: Recorded paypal transaction " + string);
        }
        catch (Exception exception) {
            this.MainWin.appendToLog("TPaypalManager", "recordTransaction", Thread.currentThread(), exception, 4, "ERROR: Paypal: " + exception.toString());
            return false;
        }
        return true;
    }
}

