/*
 * Decompiled with CFR 0.152.
 */
package utility.notifications;

import aspect.Aspect;
import aspect.TMainWin;
import cache.TCacheObj;
import cache.TCacheServerInfo;
import java.util.Date;
import java.util.Hashtable;
import resources.TApplication;
import utility.TScriptSocket;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.notifications.TNotification;
import utility.notifications.TNotification_ClientSide;
import utility.security.TPasswordService;
import utility.session.TSessionObj;
import utility.ziputil;

public class TProxyHandler {
    private TMainWin MainWin = Aspect.MainWin;
    private TApplication Application = TMainWin.Application;
    private Hashtable hashSocket = new Hashtable();
    private Hashtable hashRequest = new Hashtable();
    private Hashtable hashRemoteIP = new Hashtable();

    public void addSocketWidgetRequest(TScriptSocket tScriptSocket, String string, TSessionObj tSessionObj) {
        String[] stringArray;
        String string2;
        if (TNotification.DebugNotifications) {
            this.MainWin.appendToLog("TProxyHandler", "addSocketWidgetRequest", Thread.currentThread(), null, 3, "TProxyHandler: addSocketWidgetRequest() started");
        }
        String string3 = TPasswordService.generateSalt(16);
        if (string.toUpperCase().indexOf("GET_RUNNING_SCRIPTS") >= 0) {
            string3 = "DIAG_" + TPasswordService.generateSalt(4);
        }
        if ((string2 = charutil.getParamValue(stringArray = charutil.getSubStringArray(string, '&', false), "Source")).trim().length() == 0) {
            string2 = this.Application.getAspectHashID();
        }
        TNotification tNotification = new TNotification(string3, this.Application.getAspectHashID(), string2, TNotification.NOTIFICATION_PROXY_WIDGET, string + "&SuppressDisplay=true", -1, "", "", new Date(), tSessionObj.getPassword(), 5);
        TNotification_ClientSide.sendNotification(tNotification);
        this.hashSocket.put(string3.toUpperCase(), new TProxyHandlerSocket(string3, tScriptSocket));
    }

    public void addSocket(TScriptSocket tScriptSocket, String string, String string2) {
        if (TNotification.DebugNotifications) {
            this.MainWin.appendToLog("TProxyHandler", "addSocket", Thread.currentThread(), null, 3, "\tTProxyHandler: addSocket() started");
        }
        String string3 = TPasswordService.generateSalt(16);
        String[] stringArray = charutil.getSubStringArray(tScriptSocket.getRequestArguments(), '&', false);
        String string4 = charutil.getParamValue(stringArray, "HashID");
        if (string4.length() == 0) {
            if (TNotification.DebugNotifications) {
                System.out.println("TProxyHandler.addSocket: no customer ID specified");
            }
            this.sendResponse(tScriptSocket, "No customer ID specified.");
            tScriptSocket.dispose();
            return;
        }
        String string5 = charutil.getParamValue(stringArray, "p");
        if (string5.length() == 0) {
            if (TNotification.DebugNotifications) {
                System.out.println("TProxyHandler.addSocket: no password specified");
            }
            this.sendResponse(tScriptSocket, "Missing password.");
            tScriptSocket.dispose();
            return;
        }
        int n = charutil.ival(charutil.getParamValue(stringArray, "type"));
        String string6 = charutil.replaceChar(charutil.getParamValue(stringArray, "data"), '|', '&');
        TNotification tNotification = new TNotification(string3, this.Application.getAspectHashID(), string4, n, string6, -1, "", "", new Date(), TNotification.encryptPassword(string5), 5);
        if (TNotification.DebugNotifications) {
            this.MainWin.appendToLog("TProxyHandler", "getNotifications", Thread.currentThread(), null, 3, "\tTProxyHandler: sending proxy notification through server: " + tNotification.toString());
        }
        TNotification_ClientSide.sendNotification(tNotification);
        this.hashSocket.put(string3.toUpperCase(), new TProxyHandlerSocket(string3, tScriptSocket));
    }

    public void addRequest(TCacheObj tCacheObj, TNotification tNotification, String string) {
        if (TNotification.DebugNotifications) {
            this.MainWin.appendToLog("TProxyHandler", "addRequest", Thread.currentThread(), null, 3, "TProxyHandler.addRequest: Sending notification");
        }
        if ((tNotification.Type == TNotification.NOTIFICATION_GET_WIDGET || tNotification.Type == TNotification.NOTIFICATION_PROXY_WIDGET) && tNotification.Data.toUpperCase().indexOf("SUPPRESSDISPLAY") < 0) {
            tNotification.Data = tNotification.Data + "&SuppressDisplay=true";
        }
        TNotification_ClientSide.sendNotification(tNotification);
        this.hashRequest.put(tNotification.ID.toUpperCase(), tCacheObj);
        this.hashRemoteIP.put(tNotification.ID.toUpperCase(), string);
    }

    public void sendResponse(TScriptSocket tScriptSocket, String string) {
        Object object;
        String string2 = string;
        tScriptSocket.setTimeout(1000);
        tScriptSocket.setResponseHttpVersion("HTTP/1.1");
        tScriptSocket.setResponseCode("200");
        tScriptSocket.setResponseCodeText("OK");
        tScriptSocket.setResponseHeaderValue("Content-type", "text/html");
        tScriptSocket.setResponseHeaderValue("Access-Control-Allow-Origin", "*");
        String string3 = tScriptSocket.getRequestHeaderValue("accept-encoding");
        if (string3.toUpperCase().indexOf("GZIP") >= 0) {
            object = ziputil.gzipString(string2);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < ((Object)object).length; ++i) {
                stringBuilder.append((char)object[i]);
            }
            string2 = stringBuilder.toString();
            tScriptSocket.setResponseHeaderValue("Content-Encoding", "gzip");
        }
        if (((String)(object = (Object)tScriptSocket.getRequestArgumentValue("cache-control"))).length() > 0) {
            if (((String)object).toUpperCase().indexOf("NOCACHE") >= 0) {
                tScriptSocket.setResponseHeaderValue("cache-control", "public, max-age=0");
            } else {
                tScriptSocket.setResponseHeaderValue("cache-control", (String)object);
            }
        }
        tScriptSocket.setResponseHeaderValue("Server-name", "Aspect Software");
        tScriptSocket.setResponseHeaderValue("Content-length", Integer.toString(string2.length()));
        tScriptSocket.setResponseContent(string2);
        tScriptSocket.sendResponse();
        tScriptSocket.flush();
    }

    public boolean handleNotification(TNotification tNotification) {
        String string;
        if (TNotification.DebugNotifications) {
            this.MainWin.appendToLog("TProxyHandler", "handleNotification", Thread.currentThread(), null, 3, "TProxyHandler.handleNotification: " + tNotification.ID + "\t" + tNotification.ParentID);
        }
        if ((string = tNotification.ParentID.toUpperCase()).length() == 0) {
            if (TNotification.DebugNotifications) {
                this.MainWin.appendToLog("TProxyHandler", "handleNotification", Thread.currentThread(), null, 3, "TProxyHandler.handleNotification: No parent ID specified in notification with ID " + tNotification.ID);
            }
            return false;
        }
        if (this.hashSocket.containsKey(string)) {
            if (TNotification.DebugNotifications) {
                this.MainWin.appendToLog("TProxyHandler", "handleNotification", Thread.currentThread(), null, 3, "TProxyHandler.handleNotification: found socket");
            }
            if (tNotification.isDiagnostic()) {
                this.MainWin.appendToLog("TProxyHandler", "handleNotification", Thread.currentThread(), null, 3, "TProxyHandler.handleNotification: " + tNotification.toString());
            }
            TProxyHandlerSocket tProxyHandlerSocket = (TProxyHandlerSocket)this.hashSocket.get(string);
            if (tNotification.Data.toUpperCase().indexOf("OK: GETFILECONTENT=") >= 0) {
                if (tNotification.AttachedFilename.length() > 0) {
                    if (dosutil.fileExists(tNotification.AttachedFilename)) {
                        this.sendResponse(tProxyHandlerSocket.socket, TAsciiInput.getEntireFile(tNotification.AttachedFilename));
                    } else {
                        System.out.println("TProxyHandler attachment does not exist: " + tNotification.AttachedFilename);
                    }
                } else {
                    System.out.println("TProxyHandler no attachment specified");
                }
            } else {
                String string2 = tNotification.Data;
                if (string2.toUpperCase().indexOf("__CONTAINERREQUESTSERVER__") >= 0) {
                    String string3 = tProxyHandlerSocket.socket.getRemoteIP();
                    String string4 = string3.trim().length() == 0 ? "127.0.0.1" : string3;
                    TCacheServerInfo tCacheServerInfo = new TCacheServerInfo(string4);
                    string2 = charutil.replaceAllSubstrings(string2, "__CONTAINERREQUESTSERVER__", tCacheServerInfo.getServer());
                }
                this.sendResponse(tProxyHandlerSocket.socket, string2);
            }
            tProxyHandlerSocket.socket.dispose();
            this.hashSocket.remove(string);
            return true;
        }
        if (this.hashRequest.containsKey(string)) {
            Object object;
            Object object2;
            if (TNotification.DebugNotifications) {
                this.MainWin.appendToLog("TProxyHandler", "handleNotification", Thread.currentThread(), null, 3, "TProxyHandler.handleNotification: found request.  Setting content.");
            }
            if (tNotification.isDiagnostic()) {
                this.MainWin.appendToLog("TProxyHandler", "handleNotification", Thread.currentThread(), null, 3, "TProxyHandler.handleNotification: " + tNotification.toString());
            }
            TCacheObj tCacheObj = (TCacheObj)this.hashRequest.get(string);
            String string5 = (String)this.hashRemoteIP.get(string);
            if (tNotification.Type == TNotification.NOTIFICATION_REQUESTFILES) {
                this.MainWin.appendToLog("TProxyHandler", "handleNotification", Thread.currentThread(), null, 3, "TProxyHandler.handleNotification: Processing request for files");
                object2 = tNotification;
                object = new Thread((TNotification)object2){
                    final /* synthetic */ TNotification val$finalNotification;
                    {
                        this.val$finalNotification = tNotification;
                    }

                    @Override
                    public void run() {
                        this.val$finalNotification.processNotification();
                    }
                };
                ((Thread)object).setName("ProcessNotification3");
                ((Thread)object).setPriority(1);
                ((Thread)object).start();
            }
            if (!tCacheObj.isBinary()) {
                object2 = charutil.replaceSubstring(tNotification.Data, "$NotificationID$", tNotification.ID);
                object2 = charutil.replaceSubstring((String)object2, "$NotificationParentID$", tNotification.ParentID);
                object = new Date();
                object2 = charutil.replaceSubstring((String)object2, "$NotificationDate$", dateutil.formatDate((Date)object, "MM-dd-yyyy"));
                object2 = charutil.replaceSubstring((String)object2, "$NotificationTime$", dateutil.formatDate((Date)object, "HH:mm:ss"));
                object2 = charutil.replaceSubstring((String)object2, "$CacheID$", tCacheObj.ID);
                String string6 = string5.trim().length() == 0 ? "127.0.0.1" : string5;
                TCacheServerInfo tCacheServerInfo = new TCacheServerInfo(string6);
                if (((String)object2).toUpperCase().indexOf("__REQUESTSERVER__") >= 0) {
                    object2 = charutil.replaceAllSubstrings((String)object2, "__RequestServer__", tCacheServerInfo.getServer());
                }
                if (((String)object2).toUpperCase().indexOf("OK: GETFILECONTENT=") >= 0) {
                    if (tNotification.AttachedFilename.length() > 0) {
                        if (dosutil.fileExists(tNotification.AttachedFilename)) {
                            tCacheObj.setContentFromFile(tNotification.AttachedFilename);
                            if (TNotification.DebugNotifications) {
                                this.MainWin.appendToLog("TProxyHandler", "handleNotification", Thread.currentThread(), null, 3, "TProxyHandler.handleNotification: got binary file: " + tNotification.AttachedFilename);
                            }
                        } else {
                            this.MainWin.appendToLog("TProxyHandler", "handleNotification", Thread.currentThread(), null, 4, "TProxyHandler.handleNotification: could not find file attachment for binary file");
                            object2 = "";
                        }
                    } else {
                        this.MainWin.appendToLog("TProxyHandler", "handleNotification", Thread.currentThread(), null, 4, "TProxyHandler.handleNotification: no attachment specified for binary file transfer");
                        object2 = "";
                    }
                } else if (((String)object2).toUpperCase().indexOf("ERROR: GETFILECONTENT=") >= 0) {
                    this.MainWin.appendToLog("TProxyHandler", "handleNotification", Thread.currentThread(), null, 4, "TProxyHandler.handleNotification: Bad filename in request for binary file");
                    object2 = "";
                } else {
                    tCacheObj.setContent((String)object2);
                }
            } else {
                if (TNotification.DebugNotifications) {
                    this.MainWin.appendToLog("TProxyHandler", "handleNotification", Thread.currentThread(), null, 3, "TProxyHandler.handleNotification: calling setContent");
                }
                tCacheObj.setContent(tNotification.Data);
                if (TNotification.DebugNotifications) {
                    this.MainWin.appendToLog("TProxyHandler", "handleNotification", Thread.currentThread(), null, 3, "TProxyHandler.handleNotification: calling setContent complete");
                }
            }
            tCacheObj.setUpdated(new Date());
            tCacheObj.setNotificationID(tNotification.ID);
            tCacheObj.setNotificationParentID(tNotification.ParentID);
            this.hashRequest.remove(string);
            this.hashRemoteIP.remove(string);
            if (TNotification.DebugNotifications) {
                this.MainWin.appendToLog("TProxyHandler", "handleNotification", Thread.currentThread(), null, 3, "TProxyHandler.handleNotification complete");
            }
            return true;
        }
        if (TNotification.DebugNotifications) {
            this.MainWin.appendToLog("TProxyHandler", "handleNotification", Thread.currentThread(), null, 3, "TProxyHandler.handleNotification: Did not find a socket or request for notification " + tNotification.ParentID);
        }
        return false;
    }

    public class TProxyHandlerSocket {
        String ID;
        TScriptSocket socket;

        private TProxyHandlerSocket(String string, TScriptSocket tScriptSocket) {
            this.ID = string;
            this.socket = tScriptSocket;
        }
    }
}

