/*
 * Decompiled with CFR 0.152.
 */
package utility.notifications;

import aspect.Aspect;
import aspect.TMainWin;
import cache.TCacheObj;
import cache.TCacheServerInfo;
import cache.TDataCollection;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import resources.TAppDriversObject;
import resources.TApplication;
import scripts.TExecScript;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiInput;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.notifications.TNotificationServer;
import utility.notifications.TNotificationTrace;
import utility.notifications.TNotification_ClientSide;
import utility.objectutil;
import utility.security.TPasswordService;
import utility.taskscheduler.TTaskScheduler;
import utility.ziputil;

public class TNotification {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    public static boolean DebugNotifications = false;
    public static int NOTIFICATION_UNDEFINED = 0;
    public static int NOTIFICATION_RECEIPT = 1;
    public static int NOTIFICATION_DELIVERY_CONFIRMED = 2;
    public static int NOTIFICATION_GET_RECIPIENT_LIST = 3;
    public static int NOTIFICATION_TEXT = 4;
    public static int NOTIFICATION_PING = 5;
    public static int NOTIFICATION_EXECSCRIPT = 6;
    public static int NOTIFICATION_CRITICAL_ERROR = 7;
    public static int NOTIFICATION_ASPECT6_DOWNLOAD = 8;
    public static int NOTIFICATION_NEW_LICENSE = 9;
    public static int NOTIFICATION_NEW_CUSTOMER = 10;
    public static int NOTIFICATION_PAYMENT_PROCESSED = 11;
    public static int NOTIFICATION_SERVER_RECEIPT = 12;
    public static int NOTIFICATION_GET_WIDGET = 13;
    public static int NOTIFICATION_EXPIRED = 14;
    public static int NOTIFICATION_RECIPIENT_NOT_CONNECTED = 15;
    public static int NOTIFICATION_REQUESTFILES = 16;
    public static int NOTIFICATION_RECEIVEDFILES = 17;
    public static int NOTIFICATION_EXECTASK = 18;
    public static int NOTIFICATION_PROXY_WIDGET = 19;
    public static int NOTIFICATION_REQUESTDRIVERDATA = 20;
    public static int NOTIFICATION_UPDATEDRIVERDATA = 21;
    public static int NOTIFICATION_PROCESSITEM = 22;
    public static int NOTIFICATION_GETCOLLECTION = 23;
    public static int NOTIFICATION_ACKNOWLEDGEFILES = 24;
    private static String[] arTypeDescription = new String[]{"Undefined", "Receipt", "Delivery Confirmed", "Get Recipient List", "Text", "Ping", "ExecScript", "Critical Error", "Aspect6 Download", "New License", "New Customer", "Payment Processed", "Server Receipt", "Get Widget", "Expired without delivery", "Recipient Not Available", "Request Files", "Files Sent", "Exec Task", "Proxy Widget Request", "Driver Request", "Driver Update", "Process Item", "Get Collection", "Acknowledge File Transfer"};
    public Date Server_Time = new Date();
    public Date Time = new Date();
    public String ID = null;
    public String From = null;
    public String To = null;
    public String Data = null;
    public int Type = 0;
    public int TimeToLive = 1440;
    public int DiskIndex = -1;
    public int Attempts = 0;
    public Date dtLastAttempt = new Date();
    public boolean IsValid = false;
    public String ReplyTo = null;
    public String FromName = "";
    public String ToName = "";
    public String ParentID = "";
    public String EncryptedPassword = "";
    public String ExternalFilename = "";
    public String AttachedFilename = "";
    public String OriginalFilename = "";
    public String UserExternalDataFilename = "";
    public boolean isCompanyBreakout = false;
    public String TaskSchedulerID = "";
    public String TaskName = "";
    public String Text = "";
    public static Hashtable hashProcessing = new Hashtable();
    Date ProcessingStarted = null;

    public TNotification(String string) {
        String[] stringArray = charutil.getSubStringArray(string, '\n', false);
        if (stringArray != null && stringArray.length > 6) {
            String[] stringArray2;
            this.ID = stringArray[0].trim();
            this.From = stringArray[1].trim();
            this.FromName = stringArray[2].trim();
            this.To = stringArray[3].trim();
            this.ToName = stringArray[4].trim();
            this.Type = charutil.ival(stringArray[5].trim());
            this.Data = charutil.replaceAllSubstrings(stringArray[6].trim(), "%lf%", "\n");
            this.Data = charutil.replaceAllSubstrings(this.Data, "%q%", "\"");
            this.ReplyTo = this.From;
            if (stringArray.length > 7) {
                this.ReplyTo = stringArray[7].trim();
            }
            this.ParentID = "";
            if (stringArray.length > 8) {
                this.ParentID = stringArray[8].trim();
            }
            if (stringArray.length > 9) {
                this.Time = new Date(charutil.lval(stringArray[9].trim()));
            }
            if (stringArray.length > 10) {
                this.EncryptedPassword = stringArray[10].trim();
            }
            if (stringArray.length > 11) {
                this.TimeToLive = charutil.ival(stringArray[11]);
                if (this.TimeToLive <= 0) {
                    System.out.println("Invalid TTL in notification: " + this.toString());
                    System.out.println("Initialize with string: " + string);
                    new Throwable().printStackTrace();
                    this.TimeToLive = 1440;
                }
            }
            if (stringArray.length > 12) {
                this.AttachedFilename = stringArray[12];
            }
            if (stringArray.length > 13) {
                this.OriginalFilename = stringArray[13];
            }
            if ((stringArray2 = charutil.getSubStringArray(this.Data, '&', true)) != null) {
                this.TaskSchedulerID = charutil.getParamValue(stringArray2, "TaskSchedulerID");
                this.TaskName = charutil.getParamValue(stringArray2, "TaskName");
                this.Text = charutil.getParamValue(stringArray2, "Text");
            }
            this.IsValid = true;
        } else if (stringArray != null && stringArray.length > 5) {
            this.ID = stringArray[0];
            this.FromName = this.From = stringArray[1];
            this.ToName = this.To = stringArray[2];
            this.Type = charutil.ival(stringArray[3]);
            this.ReplyTo = this.From;
            this.Data = charutil.replaceAllSubstrings(stringArray[4].trim(), "%lf%", "\n");
            String[] stringArray3 = charutil.getSubStringArray(this.Data, '&', true);
            if (stringArray3 != null) {
                this.TaskSchedulerID = charutil.getParamValue(stringArray3, "TaskSchedulerID");
                this.TaskName = charutil.getParamValue(stringArray3, "TaskName");
                this.Text = charutil.getParamValue(stringArray3, "Text");
            }
            this.IsValid = true;
        } else {
            System.out.println("Invalid notification: " + charutil.replaceChar(string, '\n', '\t'));
        }
    }

    public TNotification(String string, String string2, String string3, int n, String string4, int n2, String string5, String string6, Date date, String string7, int n3) {
        this.ID = string;
        this.Time = date;
        this.From = string2;
        this.To = string3;
        this.Type = n;
        this.Data = charutil.replaceAllSubstrings(string4.trim().trim(), "%lf%", "\n");
        this.Data = charutil.replaceAllSubstrings(this.Data, "%q%", "\"");
        this.ReplyTo = string5;
        if (this.ReplyTo.trim().length() == 0) {
            this.ReplyTo = this.From;
        }
        this.ParentID = string6;
        this.EncryptedPassword = string7;
        this.TimeToLive = n3;
        this.DiskIndex = n2;
    }

    public TNotification(TNotification tNotification) {
        this.Server_Time = tNotification.Server_Time;
        this.Time = tNotification.Time;
        this.ID = tNotification.ID;
        this.From = tNotification.From;
        this.FromName = tNotification.FromName;
        this.To = tNotification.To;
        this.ToName = tNotification.ToName;
        this.Data = tNotification.Data;
        this.Type = tNotification.Type;
        this.ReplyTo = tNotification.ReplyTo;
        this.IsValid = tNotification.IsValid;
        this.ParentID = tNotification.ParentID;
        this.Time = tNotification.Time;
        this.EncryptedPassword = tNotification.EncryptedPassword;
        this.TimeToLive = tNotification.TimeToLive;
        this.ExternalFilename = tNotification.ExternalFilename;
        this.AttachedFilename = tNotification.AttachedFilename;
        this.OriginalFilename = tNotification.OriginalFilename;
    }

    public boolean isDiagnostic() {
        return this.ID.toUpperCase().startsWith("DIAG") || this.ParentID.toUpperCase().startsWith("DIAG");
    }

    public void setAttachedFilename(String string) {
        this.AttachedFilename = string;
        String[] stringArray = dosutil.splitPath(this.AttachedFilename);
        this.OriginalFilename = "";
        if (stringArray[2] != null) {
            this.OriginalFilename = stringArray[2];
        }
        if (stringArray[3] != null) {
            this.OriginalFilename = this.OriginalFilename + stringArray[3];
        }
    }

    public void setUserExternalDataFilename(String string) {
        this.UserExternalDataFilename = string;
    }

    public boolean isExpired() {
        int n = (int)(new Date().getTime() - this.Server_Time.getTime()) / 1000 / 60;
        return n > 5;
    }

    public String getTypeName() {
        if (this.Type < 0 || this.Type >= arTypeDescription.length) {
            return "Undefined Type-" + Integer.toString(this.Type);
        }
        return arTypeDescription[this.Type];
    }

    public static String getTypeName(int n) {
        if (n < 0 || n >= arTypeDescription.length) {
            return "Undefined Type-" + Integer.toString(n);
        }
        return arTypeDescription[n];
    }

    public String toString() {
        String string = this.Data;
        if (string.length() > 64) {
            string = string.substring(0, 64) + "...";
        }
        String string2 = "";
        try {
            if (this.Type == NOTIFICATION_RECEIPT) {
                string2 = arTypeDescription[this.Type] + " From:" + this.From + " For " + this.ID;
            } else if (this.Type == NOTIFICATION_SERVER_RECEIPT) {
                string2 = arTypeDescription[this.Type] + " To:" + this.To + " For " + this.ID;
            } else if (this.Type == NOTIFICATION_DELIVERY_CONFIRMED) {
                string2 = arTypeDescription[this.Type] + " From:" + this.From + " To:" + this.To + " For " + this.ID + " Ttl=" + this.TimeToLive;
            } else if (this.Type == NOTIFICATION_RECIPIENT_NOT_CONNECTED) {
                string2 = arTypeDescription[this.Type] + " To:" + this.To + " For " + this.ParentID + " using ID:" + this.ID;
            } else {
                string2 = arTypeDescription[this.Type] + " Attempt:" + this.Attempts + " From:" + this.From + " To:" + this.To + " ID:" + this.ID + " Parent ID:" + this.ParentID + "  TTL: " + this.TimeToLive + " Time: " + dateutil.formatDate(this.Time, "HH:mm:ss") + " Size: " + this.Data.length() + " ReplyTo: " + this.ReplyTo + " Attached File=" + this.AttachedFilename;
                boolean bl = true;
                for (int i = 0; i < string.length(); ++i) {
                    if ((byte)string.charAt(i) >= 0 && (byte)string.charAt(i) <= 127) continue;
                    bl = false;
                }
                string2 = bl ? string2 + " Data:" + string : string2 + " Data:(binary data)";
            }
            string2 = charutil.replaceChar(string2, '\n', ' ');
            string2 = charutil.removeChar(string2, '\r');
        }
        catch (Exception exception) {
            MainWin.appendToLog("TNotification", "toString", Thread.currentThread(), null, 3, "Error in TNotification.toString(): " + exception.toString());
        }
        return string2;
    }

    public String toSendString() {
        String string = "";
        if (this.Data != null) {
            string = charutil.replaceAllSubstrings(this.Data, "\n", "%lf%");
            string = charutil.replaceAllSubstrings(string, "\"", "%q%");
        } else {
            MainWin.appendToLog("TNotification", "toSendString", Thread.currentThread(), null, 3, "Null data value in toSendString()");
            new Throwable().printStackTrace();
        }
        String string2 = this.ID + "\n" + this.From + "\n" + this.FromName + "\n" + this.To + "\n" + this.ToName + "\n" + Integer.toString(this.Type) + "\n" + string + "\n" + this.ReplyTo + "\n" + this.ParentID;
        string2 = string2 + "\n" + Long.toString(this.Time.getTime()) + "\n" + this.EncryptedPassword + "\n" + Integer.toString(this.TimeToLive) + "\n" + this.AttachedFilename + "\n" + this.OriginalFilename;
        return string2;
    }

    public static String toHtmlTable() {
        if (hashProcessing.size() == 0) {
            return "No notifications are currently being processed<br>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table>\n");
        stringBuilder.append("<tr>");
        stringBuilder.append("<th align='left'>ID</th>\n");
        stringBuilder.append("<th align='left'>Parent ID</th>\n");
        stringBuilder.append("<th align='left'>From</th>\n");
        stringBuilder.append("<th align='left'>To</th>\n");
        stringBuilder.append("<th align='left'>Time</th>\n");
        stringBuilder.append("<th align='left'>Type</th>\n");
        stringBuilder.append("<th align='left'>Size</th>\n");
        stringBuilder.append("<th align='left'>Ttl</th>\n");
        stringBuilder.append("<th align='left'>Processing Started</th>\n");
        stringBuilder.append("<th align='left'>Data</th>\n");
        stringBuilder.append("<th align='left'>Attached File</th>\n");
        Enumeration enumeration = hashProcessing.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            TNotification tNotification = (TNotification)hashProcessing.get(string);
            String string2 = tNotification.Data;
            String[] stringArray = charutil.getSubStringArray(string2, '&', true);
            if (stringArray != null) {
                String string3 = Application.getTokenValue("Greenlight_Server_Stats_Exclude_Text").toUpperCase();
                String[] stringArray2 = charutil.getSubStringArray(string3, '|', false);
                string2 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    boolean bl = false;
                    if (stringArray2 != null) {
                        for (int j = 0; j < stringArray2.length; ++j) {
                            if (!stringArray[i].trim().toUpperCase().startsWith(stringArray2[j])) continue;
                            bl = true;
                        }
                    }
                    if (bl) continue;
                    if (string2.length() > 0) {
                        string2 = string2 + "& ";
                    }
                    string2 = string2 + stringArray[i];
                }
            }
            if (string2.length() > 512) {
                string2 = string2.substring(0, 512) + "...";
            }
            string2 = charutil.replaceAllSubstrings(string2, "<", "&lt;");
            string2 = charutil.replaceAllSubstrings(string2, ">", "&gt;");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>" + tNotification.ID + "</td>");
            stringBuilder.append("<td>" + tNotification.ParentID + "</td>");
            stringBuilder.append("<td>" + tNotification.From + "</td>");
            stringBuilder.append("<td>" + tNotification.To + "</td>");
            stringBuilder.append("<td>" + dateutil.formatDate(tNotification.Time, "HH:mm:ss") + "</td>");
            stringBuilder.append("<td>" + arTypeDescription[tNotification.Type] + "</td>");
            stringBuilder.append("<td>" + tNotification.Data.length() + "</td>");
            stringBuilder.append("<td>" + tNotification.TimeToLive + "</td>");
            stringBuilder.append("<td>" + dateutil.formatDate(tNotification.ProcessingStarted, "HH:mm:ss:") + "</td>");
            stringBuilder.append("<td>" + string2 + "</td>");
            stringBuilder.append("<td>" + tNotification.AttachedFilename + "</td>");
            stringBuilder.append("</tr>\n");
        }
        stringBuilder.append("</table>\n");
        return stringBuilder.toString();
    }

    public String toReceiptString() {
        String string = this.ID + "\n" + Application.getAspectHashID() + "\n" + "" + "\n" + "" + "\n" + "" + "\n" + "1" + "\n" + "" + "\n" + "" + "\n" + this.ParentID + "\n" + "" + "\n" + "" + "\n" + "5";
        return string;
    }

    public static String encryptPassword(String string) {
        String string2 = TPasswordService.encrypt(string, "abc", 16);
        if (string2.length() > 8) {
            string2 = string2.substring(0, 8);
        }
        return string2;
    }

    public static String encryptPassword() {
        return TNotification.encryptPassword(Application.getTokenValue("Aspect_BackOffice_PollPasswd"));
    }

    public boolean processNotification() {
        this.ProcessingStarted = new Date();
        hashProcessing.put(this.ID, this);
        if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotification", Thread.currentThread(), null, 3, "TNotification: Process notification: " + this.ID + " Type=" + this.Type);
        }
        if (TFormulaEvaluator.NotificationTrace != null) {
            TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_CLIENT_PROCESSSTART, this);
        }
        if (this.Data.toUpperCase().indexOf("CHECKTHREADRESPONSE") < 0) {
            Application.setTokenValue("tmLastNotificationProcessed_" + this.Type, Long.toString(new Date().getTime()));
        }
        long l = 0L;
        boolean bl = false;
        if (this.Type == NOTIFICATION_EXECSCRIPT || this.Type == NOTIFICATION_GET_WIDGET || this.Type == NOTIFICATION_PROXY_WIDGET || this.Type == NOTIFICATION_REQUESTFILES || this.Type == NOTIFICATION_RECEIVEDFILES || this.Type == NOTIFICATION_EXECTASK || this.Type == NOTIFICATION_REQUESTDRIVERDATA || this.Type == NOTIFICATION_UPDATEDRIVERDATA || this.Type == NOTIFICATION_PROCESSITEM || this.Type == NOTIFICATION_ACKNOWLEDGEFILES) {
            l = TExecScript.getNewScriptInstance();
            if (this.isDiagnostic()) {
                MainWin.appendToLog("TNotification", "addNotification", Thread.currentThread(), null, 3, "TNotification+: Process " + this.toString());
            }
            if (!charutil.suppressMsg(this.Data)) {
                MainWin.appendToLog("TNotification", "processNotification", Thread.currentThread(), null, 21, "TNotification: Process " + this.getTypeName() + " From:" + this.From + " ID:" + this.ID, this.ID, this.ParentID, this.Type, this.TimeToLive, this.From, this.To, "", 0L, this.Data.length(), this.AttachedFilename, l);
            }
            if (this.Data == null) {
                System.out.println("Notification.Data = null");
            }
            bl = true;
        }
        Date date = new Date();
        boolean bl2 = false;
        if (this.Type == NOTIFICATION_EXECSCRIPT) {
            bl2 = this.processNotificationScript();
        } else if (this.Type == NOTIFICATION_GET_WIDGET || this.Type == NOTIFICATION_PROXY_WIDGET) {
            bl2 = this.processNotificationGetWidget();
        } else if (this.Type == NOTIFICATION_REQUESTFILES) {
            bl2 = this.processNotificationRequestFiles();
        } else if (this.Type == NOTIFICATION_RECEIVEDFILES) {
            bl2 = this.processNotificationReceivedFiles();
        } else if (this.Type == NOTIFICATION_ACKNOWLEDGEFILES) {
            bl2 = this.processNotificationAcknowledgeFiles();
        } else if (this.Type == NOTIFICATION_EXECTASK) {
            bl2 = this.processNotificationExecTask();
        } else if (this.Type == NOTIFICATION_REQUESTDRIVERDATA) {
            bl2 = this.processNotificationRequestDriverData();
        } else if (this.Type == NOTIFICATION_UPDATEDRIVERDATA) {
            bl2 = this.processNotificationUpdateDriverData();
        } else if (this.Type == NOTIFICATION_PROCESSITEM) {
            bl2 = this.processNotificationProcessItem();
        }
        if (TFormulaEvaluator.NotificationTrace != null) {
            TFormulaEvaluator.NotificationTrace.addTrace(TNotificationTrace.TRACETYPE_CLIENT_PROCESSEND, this);
        }
        hashProcessing.remove(this.ID);
        if (bl) {
            int n = (int)(new Date().getTime() - date.getTime());
            if (this.isDiagnostic()) {
                MainWin.appendToLog("TNotification", "addNotification", Thread.currentThread(), null, 3, "TNotification+: Process complete [" + Integer.toString(n) + "ms] " + this.toString());
            }
            if (!charutil.suppressMsg(this.Data)) {
                MainWin.appendToLog("TNotification", "processNotification", Thread.currentThread(), null, 22, "TNotification: Process complete [" + Integer.toString(n) + "ms] " + this.getTypeName() + " From:" + this.From + " ID:" + this.ID, this.ID, this.ParentID, this.Type, this.TimeToLive, this.From, this.To, this.Data, n, this.Data.length(), this.AttachedFilename, l);
            }
            return bl2;
        }
        if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotification", Thread.currentThread(), null, 3, "TNotification: No processing done: " + this.ID);
        }
        if (this.isDiagnostic()) {
            MainWin.appendToLog("TNotification", "addNotification", Thread.currentThread(), null, 3, "TNotification+: No Processing required for " + this.toString());
        }
        return true;
    }

    public boolean processNotificationRequestFiles() {
        Object object;
        String[] stringArray;
        Object object2;
        int n;
        String[] stringArray2;
        CharSequence charSequence;
        String[] stringArray3;
        Object object3;
        String string;
        boolean bl = false;
        boolean bl2 = false;
        if (this.EncryptedPassword.equals(TNotification.encryptPassword())) {
            bl2 = true;
        } else if (this.EncryptedPassword.equals(Application.getTokenValue("AspectSupportNotificationPass"))) {
            bl2 = true;
            bl = true;
        }
        boolean bl3 = false;
        if (!bl2 && TNotification.encryptPassword().equals(Application.getTokenValue("AspectSupportNotificationPass"))) {
            TFormulaEvaluator.getNotificationClient();
            int n2 = TNotification_ClientSide.drvClientNotification.getMatchingRecord("ID=\"" + this.ParentID + "\"", 0);
            if (n2 >= 0) {
                bl2 = true;
                bl3 = true;
            }
        }
        if (!bl2) {
            String string2 = "Cannot process request for files because an invalid password was given.  Encrypted password: " + this.EncryptedPassword;
            if (this.ReplyTo.length() > 0) {
                TFormulaEvaluator.getNotificationClient();
                TNotification_ClientSide.sendNotification(this.ReplyTo, 4, string2, 15);
            }
            MainWin.appendToLog("TNotification", "processNotificationRequestFiles", Thread.currentThread(), null, 4, string2);
            return false;
        }
        String string3 = this.Data;
        if (this.ExternalFilename.length() > 0) {
            string3 = TAsciiInput.getContent(this.ExternalFilename);
        }
        if ((string = this.ParentID).length() == 0) {
            string = this.ID;
        }
        String string4 = charutil.getParamValue(string3, "LocalFilespec", '&');
        MainWin.appendToLog("TNotification", "processNotificationRequestFiles", Thread.currentThread(), null, 3, "LocalFilespec1: " + string4);
        string4 = charutil.replaceAllSubstrings(string4, "\\quote\\", "\"");
        if (string4.startsWith("@")) {
            string4 = string4.substring(1);
        }
        if (string4.startsWith("=")) {
            string4 = TFormulaEvaluator.convertToString(TFormulaEvaluator.eval(string4));
        }
        MainWin.appendToLog("TNotification", "processNotificationRequestFiles", Thread.currentThread(), null, 3, "LocalFilespec2: " + string4);
        String string5 = charutil.getParamValue(string3, "RemoteFilespec", '&').trim();
        MainWin.appendToLog("TNotification", "processNotificationRequestFiles", Thread.currentThread(), null, 3, "RemoteFilespec1: " + string5);
        string5 = charutil.replaceAllSubstrings(string5, "\\\\quote\\\\", "\"");
        if (string5.startsWith("@")) {
            string5 = string5.substring(1);
        }
        if (string5.startsWith("=")) {
            string5 = TFormulaEvaluator.convertToString(TFormulaEvaluator.eval(string5));
        }
        MainWin.appendToLog("TNotification", "processNotificationRequestFiles", Thread.currentThread(), null, 3, "RemoteFilespec2: " + string5);
        boolean bl4 = charutil.boolval(charutil.getParamValue(string3, "recurse", '&'));
        int n3 = charutil.ival(charutil.getParamValue(string3, "DirLevel", '&'));
        String string6 = charutil.getParamValue(string3, "ExcludeFilespec", '&').trim();
        boolean bl5 = charutil.boolval(charutil.getParamValue(string3, "replace", '&'));
        boolean bl6 = charutil.boolval(charutil.getParamValue(string3, "TimestampOnly", '&'));
        String string7 = charutil.getParamValue(string3, "TaskSchedulerID", '&');
        String string8 = charutil.getParamValue(string3, "TaskName", '&');
        String string9 = charutil.replaceAllSubstrings(charutil.getParamValue(string3, "ExistingFiles", '&'), "//amp//", "&");
        String string10 = charutil.getParamValue(string3, "From", '&');
        String string11 = charutil.getParamValue(string3, "Fileset", '&');
        String string12 = charutil.getParamValue(string3, "FilesetCRC", '&');
        if (string5.indexOf(91) >= 0) {
            string5 = charutil.replaceChar(string5, '[', '{');
            string5 = charutil.replaceChar(string5, ']', '}');
            string5 = Application.parse_tokens(string5);
        }
        if (string6.indexOf(91) >= 0) {
            string6 = charutil.replaceChar(string6, '[', '{');
            string6 = charutil.replaceChar(string6, ']', '}');
            string6 = Application.parse_tokens(string6);
        }
        if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotificationRequestFiles", Thread.currentThread(), null, 3, "Process request files started: " + string4);
        }
        String[] stringArray4 = charutil.getSubStringArray(string3, '&', true);
        string3 = "";
        if (stringArray4 != null) {
            for (int i = 0; i < stringArray4.length; ++i) {
                if (stringArray4[i].toUpperCase().startsWith("TEXT=") || stringArray4[i].toUpperCase().startsWith("SUBJECT=")) continue;
                if (string3.length() > 0) {
                    string3 = string3 + "&";
                }
                string3 = string3 + stringArray4[i];
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String[] stringArray5 = charutil.getSubStringArray(string4, ';', false);
        if (stringArray5 == null || stringArray5.length == 0) {
            string3 = string3 + "&files=0&message=A filespec was not supplied";
            string3 = string3 + "&Subject=Unable to send files";
            string3 = string3 + "&text=A filespec was not supplied";
            string3 = string3 + "&Fileset=" + string11 + "&FilesetCRC=" + string12;
            TFormulaEvaluator.getNotificationClient();
            TNotification_ClientSide.sendNotification(this.ReplyTo, NOTIFICATION_RECEIVEDFILES, string3, string, 15, "", "");
            MainWin.appendToLog("TNotification", "processNotificationRequestFiles", Thread.currentThread(), null, 4, "Invalid filespec: " + string4);
            return false;
        }
        boolean bl7 = false;
        if (string5.length() > 0) {
            bl7 = true;
        }
        String[] stringArray6 = null;
        if (bl7) {
            stringArray6 = charutil.getSubStringArray(string5, ';', false);
            if (stringArray6 != null && stringArray5 != null && stringArray5.length == 1 && stringArray6.length > 1) {
                object3 = stringArray5[0];
                stringArray5 = new String[stringArray6.length];
                for (int i = 0; i < stringArray5.length; ++i) {
                    stringArray5[i] = object3;
                }
            }
            if (stringArray6 == null || stringArray6.length != stringArray5.length) {
                string3 = string3 + "&files=0&message=An invalid remote filespec was supplied";
                string3 = string3 + "&Subject=Unable to send files";
                string3 = string3 + "&text=";
                string3 = stringArray6 == null ? string3 + "An invalid (blank) filespec was supplied" : string3 + "The number of entries in the remote and local filespecs must be the same.  Remote entries: " + stringArray6.length + "Local entries: " + stringArray5.length;
                string3 = string3 + "&Fileset=" + string11 + "&FilesetCRC=" + string12;
                TFormulaEvaluator.getNotificationClient();
                TNotification_ClientSide.sendNotification(this.ReplyTo, NOTIFICATION_RECEIVEDFILES, string3, string, 15, "", "");
                MainWin.appendToLog("TNotification", "processNotificationRequestFiles", Thread.currentThread(), null, 3, "Invalid remote filespec: " + string5);
                return false;
            }
        }
        object3 = charutil.getSubStringArray(string9, '|', false);
        String[] stringArray7 = new String[]{};
        long[] lArray = new long[]{};
        long[] lArray2 = new long[]{};
        boolean[] blArray = new boolean[]{};
        if (object3 != null && ((String[])object3).length > 0) {
            stringArray7 = new String[((String[])object3).length];
            lArray = new long[((String[])object3).length];
            lArray2 = new long[((String[])object3).length];
            blArray = new boolean[((String[])object3).length];
            for (int i = 0; i < ((String[])object3).length; ++i) {
                stringArray3 = charutil.getSubStringArray(object3[i], '^', false);
                if (stringArray3 == null || stringArray3.length < 3) continue;
                stringArray7[i] = charutil.replaceChar(stringArray3[0], '/', '\\');
                lArray[i] = charutil.lval(stringArray3[1]);
                lArray2[i] = charutil.lval(stringArray3[2]);
                blArray[i] = stringArray3.length > 3 ? charutil.boolval(stringArray3[3]) : false;
            }
        }
        Date date = new Date(0L);
        if (string10.length() > 0 && string10 != "0") {
            date = dateutil.parseDate(string10, "MM-dd-yyyy");
        }
        stringArray3 = new ArrayList();
        for (int i = 0; i < stringArray5.length; ++i) {
            charSequence = stringArray6 == null ? stringArray5[i] : stringArray6[i];
            String string13 = dosutil.listMatchingFiles((String)charSequence, 1, bl4, false, n3, string6);
            stringArray2 = charutil.getSubStringArray(string13, '|', false);
            stringBuilder.append("<br>Adding Filespec: " + (String)charSequence + "<br>");
            stringBuilder.append("<table><tr><th align='left'>Filename</th><th align='left'>Time</th><th align='left'>Size</th><th align='left'>Action</th></tr>");
            if (stringArray2 != null && stringArray2.length > 0) {
                for (n = 0; n < stringArray2.length; ++n) {
                    String string14;
                    object2 = new File(stringArray2[n]);
                    stringBuilder.append("<tr><td>" + stringArray2[n] + "</td>");
                    object = stringArray = charutil.replaceChar(stringArray2[n], '/', '\\');
                    if (stringArray6 != null) {
                        String[] stringArray8 = dosutil.splitPath(stringArray6[i]);
                        String[] stringArray9 = dosutil.splitPath(stringArray5[i]);
                        String[] stringArray10 = dosutil.splitPath(stringArray2[n]);
                        if (stringArray8[1] != null) {
                            stringArray8[1] = charutil.replaceChar(stringArray8[1], '/', '\\');
                        }
                        if (stringArray9[1] != null) {
                            stringArray9[1] = charutil.replaceChar(stringArray9[1], '/', '\\');
                        }
                        if (stringArray10[1] != null) {
                            stringArray10[1] = charutil.replaceChar(stringArray10[1], '/', '\\');
                        }
                        stringArray = stringArray9[0] == null ? "" : stringArray9[0];
                        String string15 = string14 = stringArray9[1] == null ? "" : stringArray9[1];
                        if (stringArray10[1] != null) {
                            if (stringArray8[1] != null && stringArray9[1] != null) {
                                if (!stringArray8[1].equalsIgnoreCase(stringArray9[1])) {
                                    String string16 = TPasswordService.generateSalt(16);
                                    string14 = charutil.replaceAllSubstrings(stringArray10[1], stringArray8[1], string16);
                                    string14 = charutil.replaceAllSubstrings(string14, string16, stringArray9[1]);
                                } else {
                                    string14 = stringArray10[1];
                                }
                            } else {
                                string14 = string14 + charutil.replaceAllSubstrings(stringArray10[1], string14, "");
                            }
                        }
                        stringArray = (String)stringArray + string14;
                        if (stringArray10[2] != null) {
                            stringArray = (String)stringArray + stringArray10[2];
                        }
                        if (stringArray10[3] != null) {
                            stringArray = (String)stringArray + stringArray10[3];
                        }
                    }
                    stringBuilder.append("<td>" + dateutil.formatDate(new Date(((File)object2).lastModified()), "MM-dd-yyyy HH:mm:ss") + "</td>");
                    stringBuilder.append("<td> " + Long.toString(((File)object2).length()) + " bytes</td>");
                    int n4 = -1;
                    boolean bl8 = true;
                    boolean bl9 = false;
                    string14 = "";
                    for (int j = 0; object3 != null && n4 < 0 && j < ((String[])object3).length; ++j) {
                        long l;
                        if (stringArray7[j] == null || !stringArray7[j].equalsIgnoreCase((String)stringArray)) continue;
                        bl9 = true;
                        if (blArray[j]) {
                            stringBuilder.append("<td>File is read-only</td>");
                            bl8 = false;
                        } else if (!bl5) {
                            stringBuilder.append("<td>File already exists</td>");
                            bl8 = false;
                        } else if (bl6) {
                            l = new File(stringArray2[n]).lastModified();
                            if (Math.floor(l / 1000L) <= Math.floor(lArray2[j] / 1000L)) {
                                stringBuilder.append("<td>Timestamp is equal or earlier</td>");
                                bl8 = false;
                            } else {
                                Date date2 = new Date(l);
                                Date date3 = new Date(lArray2[j]);
                                string14 = "t1=" + dateutil.formatDate(date2, "MM-dd-yyyy HH:mm:ss:SSS") + " t2=" + dateutil.formatDate(date3, "MM-dd-yyyy HH:mm:ss:SSS") + " Local=" + (String)stringArray + " Existing=" + stringArray7[j];
                            }
                        } else {
                            l = dosutil.getChecksum(stringArray2[n]);
                            if (l == lArray[j]) {
                                stringBuilder.append("<td>None: Content is identical</td>");
                                bl8 = false;
                            }
                        }
                        n4 = j;
                    }
                    if (bl8 && stringArray3.contains(stringArray2[n])) {
                        stringBuilder.append("<td>Duplicated in filespec</td>");
                        bl8 = false;
                    }
                    if (bl8 && ((File)object2).lastModified() < date.getTime()) {
                        stringBuilder.append("<td>None: Timestamp is earlier than " + dateutil.formatDate(date, "MM-dd-yyyy") + "</td>");
                        bl8 = false;
                    }
                    if (bl8) {
                        if (stringBuilder2.length() > 0) {
                            stringBuilder2.append("\n");
                        }
                        stringBuilder2.append(stringArray2[n] + "|" + (String)stringArray + "|" + Long.toString(((File)object2).lastModified()));
                        if (string14.length() == 0) {
                            stringBuilder.append("<td>Send</td>");
                        } else {
                            stringBuilder.append("<td>" + string14 + "</td>");
                        }
                        stringArray3.add(stringArray2[n]);
                    }
                    stringBuilder.append("</tr>");
                }
            }
            stringBuilder.append("</table>");
        }
        String string17 = Application.getTokenValue("Aspect_BackOffice_PollPasswd");
        if (bl3 || bl || this.ReplyTo.equals(Application.getTokenValue("AspectServerHashID"))) {
            string17 = "";
            string3 = string3 + "&encryption=false";
        } else {
            string3 = string3 + "&encryption=true";
        }
        charSequence = new StringBuilder("&Text=");
        ((StringBuilder)charSequence).append("<h2>Options</h2>");
        ((StringBuilder)charSequence).append("Remote Filespec: " + string4 + "<br>");
        ((StringBuilder)charSequence).append("Local Filespec: " + string5 + "<br>");
        if (bl4) {
            if (n3 == 0) {
                ((StringBuilder)charSequence).append(" Recurse all directories<br>");
            } else {
                ((StringBuilder)charSequence).append(" Recurse up to " + n3 + " directories<br>");
            }
        } else {
            ((StringBuilder)charSequence).append(" No recursion<br>");
        }
        ((StringBuilder)charSequence).append("Exclude: " + string6 + "<br>");
        ((StringBuilder)charSequence).append("Exclude: files modified prior to " + string10 + " [" + dateutil.formatDate(date, "MM-dd-yyyy") + "]<br>");
        ((StringBuilder)charSequence).append("Replace existing files: " + bl5 + "<br>");
        if (bl6) {
            ((StringBuilder)charSequence).append("Method: Compare timestamps<br>");
        } else {
            ((StringBuilder)charSequence).append("Method: Compare content<br>");
        }
        if (string17.length() == 0) {
            ((StringBuilder)charSequence).append("Encryption: no");
        } else {
            ((StringBuilder)charSequence).append("Encryption: yes");
        }
        int n5 = stringArray3.size();
        if (n5 > 0) {
            stringArray2 = new String[n5];
            for (n = 0; n < n5; ++n) {
                stringArray2[n] = (String)stringArray3.get(n);
            }
            String string18 = "synch_" + dateutil.formatDate(new Date(), "yyyyMMdd_HHmmss") + "_" + TPasswordService.generateSalt(4);
            object2 = Application.getTemporaryFiles() + string18 + ".$$$";
            ziputil.addFileToZip((String)object2, stringArray2, true, "");
            stringArray = ziputil.getZipContents((String)object2, false);
            if (stringArray == null) {
                MainWin.appendToLog("TNotification", "processNotificationRequestFiles", Thread.currentThread(), null, 4, "Got null content when verifying zip file");
            } else {
                MainWin.appendToLog("TNotification", "processNotificationRequestFiles", Thread.currentThread(), null, 3, "Confirm number of entries in zip file = " + stringArray.length);
            }
            object = Application.getTemporaryFiles() + string18 + "_encrypted.$$$";
            dosutil.copyFile((String)object2, (String)object, 0, false, "", string17, "");
            long l = dosutil.getChecksum((String)object2);
            long l2 = dosutil.getChecksum((String)object);
            MainWin.appendToLog("TNotification", "processNotificationRequestFiles", Thread.currentThread(), null, 3, "Process request files encrypted with pass=" + string17 + " crc1=" + l + " crc2=" + l2);
            dosutil.deleteFile((String)object2);
            File file = new File((String)object);
            stringBuilder.append("Zipped " + Integer.toString(n5) + " files.  (" + file.length() + " bytes)<br>");
            string3 = string3 + "&files=" + Integer.toString(n5) + "&message=Sent " + Integer.toString(n5) + " files";
            string3 = string3 + "&Manifest=" + stringBuilder2.toString();
            string3 = string3 + "&Fileset=" + string11 + "&FilesetCRC=" + string12;
            ((StringBuilder)charSequence).append("<h2>Log</h2>");
            ((StringBuilder)charSequence).append((CharSequence)stringBuilder);
            string3 = string3 + charSequence;
            if (file.length() >= (long)TNotificationServer.iMaxAttachmentSize) {
                string3 = "&Subject=Cound not send files because size exceeds " + Integer.toString(TNotificationServer.iMaxAttachmentSize) + " bytes&" + string3;
                string3 = string3 + "&Fileset=" + string11 + "&FilesetCRC=" + string12;
                TFormulaEvaluator.getNotificationClient();
                TNotification_ClientSide.sendNotification(this.ReplyTo, NOTIFICATION_TEXT, string3, string, 60, "", "");
            } else {
                string3 = "Subject=Sent " + Integer.toString(n5) + " Files&" + string3;
                string3 = string3 + "&Fileset=" + string11 + "&FilesetCRC=" + string12;
                TFormulaEvaluator.getNotificationClient();
                TNotification_ClientSide.sendNotification(this.ReplyTo, NOTIFICATION_RECEIVEDFILES, string3, string, 60, (String)object, string18 + "_encrypt.$$$");
            }
        } else {
            stringBuilder.append("No files to send");
            ((StringBuilder)charSequence).append("No files to send");
            string3 = string3 + "&files=0&message=No files to send";
            string3 = string3 + "&Subject=No files to send";
            string3 = string3 + charSequence + "<br>Log<br><hr>" + stringBuilder.toString() + "<br><hr>";
            string3 = string3 + "&Fileset=" + string11 + "&FilesetCRC=" + string12;
            TFormulaEvaluator.getNotificationClient();
            TNotification_ClientSide.sendNotification(this.ReplyTo, NOTIFICATION_RECEIVEDFILES, string3, string, 60, "", "");
        }
        MainWin.appendToLog("TNotification", "processNotificationRequestFiles", Thread.currentThread(), null, 3, "Process request files complete.  Sending " + n5 + " files");
        return true;
    }

    public boolean processNotificationReceivedFiles() {
        Object object;
        int n;
        int n2;
        String[] stringArray;
        CharSequence charSequence;
        String string = this.Data;
        if (this.ExternalFilename.length() > 0) {
            string = TAsciiInput.getContent(this.ExternalFilename);
        }
        String string2 = this.ParentID;
        String string3 = charutil.getParamValue(string, "LocalFilespec", '&');
        String string4 = charutil.getParamValue(string, "RemoteFilespec", '&').trim();
        boolean bl = charutil.boolval(charutil.getParamValue(string, "recurse", '&'));
        int n3 = charutil.ival(charutil.getParamValue(string, "DirLevel", '&'));
        String string5 = charutil.getParamValue(string, "ExcludeFilespec", '&').trim();
        boolean bl2 = charutil.boolval(charutil.getParamValue(string, "replace", '&'));
        boolean bl3 = charutil.boolval(charutil.getParamValue(string, "TimestampOnly", '&'));
        String string6 = charutil.getParamValue(string, "TaskSchedulerID", '&');
        String string7 = charutil.getParamValue(string, "TaskName", '&');
        String string8 = charutil.getParamValue(string, "ExistingFiles", '&');
        String string9 = this.AttachedFilename;
        int n4 = charutil.ival(charutil.getParamValue(string, "Files", '&'));
        String string10 = charutil.getParamValue(string, "Manifest", '&');
        boolean bl4 = charutil.boolval(charutil.getParamValue(string, "encryption", '&'));
        String string11 = charutil.getParamValue(string, "Fileset", '&');
        String string12 = charutil.getParamValue(string, "FilesetCRC", '&');
        System.out.println("processNotificationReceivedFiles Fileset=" + string11 + " CRC=" + string12);
        string = "";
        TAspectDriver tAspectDriver = null;
        int n5 = -1;
        if (string11.trim().length() > 0) {
            tAspectDriver = new TAspectDriver("Aspect_File_Set_Synch", 1, true, false, "");
            n5 = tAspectDriver.getMatchingRecordAbsolute("(HashID=\"" + this.ReplyTo + "\") and (File_Set_Name=\"" + string11 + "\")", 0);
            if (n5 < 0) {
                charSequence = "Unable to locate synch task for HashID=" + this.ReplyTo + " Fileset=" + string11;
                MainWin.appendToLog("TNotification", "processNotificationReceivedFiles", Thread.currentThread(), null, 4, (String)charSequence);
                tAspectDriver.dispose();
                tAspectDriver = null;
            } else {
                tAspectDriver.putFieldAbsolute("Time_Last_Synchronized", n5, (Object)new Date());
            }
        }
        charSequence = new StringBuilder("");
        MainWin.appendToLog("TNotification", "processNotificationReceivedFiles", Thread.currentThread(), null, 3, "Processing received files");
        if (n4 == 0) {
            string = string + "text=Acknowledge no files received&Fileset=" + string11 + "&FilesetCRC=" + string12 + "&FilesetResult=Ok: No files received";
            TFormulaEvaluator.getNotificationClient();
            TNotification_ClientSide.sendNotification(this.ReplyTo, NOTIFICATION_ACKNOWLEDGEFILES, string, string2, 15, "", "");
            MainWin.appendToLog("TNotification", "processNotificationReceivedFiles", Thread.currentThread(), null, 3, "Acknowledge no files received");
            if (tAspectDriver != null) {
                tAspectDriver.putFieldAbsolute("Last_Synchronizer_Result", n5, (Object)"Ok: Acknowledge no files received");
                tAspectDriver.putFieldAbsolute("Last_Synchronized_CRC", n5, (Object)string12);
                tAspectDriver.dispose();
                new TFormulaEvaluator().getFormulaValue("updateTaskScheduler(\"Aspect_File_Set_Synch\")");
            }
            return false;
        }
        if (this.AttachedFilename.trim().length() == 0) {
            string = string + "text=No attachment received&Fileset=" + string11 + "&FilesetCRC=" + string12 + "&FilesetResult=Error: No attachment received";
            TFormulaEvaluator.getNotificationClient();
            TNotification_ClientSide.sendNotification(this.ReplyTo, NOTIFICATION_ACKNOWLEDGEFILES, string, string2, 15, "", "");
            MainWin.appendToLog("TNotification", "processNotificationReceivedFiles", Thread.currentThread(), null, 4, "No attachment received");
            if (tAspectDriver != null) {
                tAspectDriver.putFieldAbsolute("Last_Synchronizer_Result", n5, (Object)"Error: No attachment received");
                tAspectDriver.dispose();
                new TFormulaEvaluator().getFormulaValue("updateTaskScheduler(\"Aspect_File_Set_Synch\")");
            }
            return false;
        }
        String string13 = "synch_" + dateutil.formatDate(new Date(), "yyyyMMdd_HHmmss") + "_" + TPasswordService.generateSalt(4);
        String string14 = Application.getTemporaryFiles() + string13 + ".zip";
        String string15 = Application.getTokenValue("Aspect_BackOffice_PollPasswd");
        if (!bl4 || Application.getTokenValue("AspectServerHashID").equals(Application.getTokenValue("AspectHashID"))) {
            string15 = "";
        }
        dosutil.copyFile(this.AttachedFilename, string14, 0, false, string15, "", "");
        long l = dosutil.getChecksum(string14);
        long l2 = dosutil.getChecksum(this.AttachedFilename);
        MainWin.appendToLog("TNotification", "processNotificationRequestFiles", Thread.currentThread(), null, 3, "Process request files unencrypted with pass=" + string15 + " crc1=" + l + " crc2=" + l2);
        String[] stringArray2 = ziputil.getZipContents(string14, false);
        if (string10.length() == 0) {
            string = string + "text=No manifest received&Fileset=" + string11 + "&FilesetCRC=" + string12 + "&FilesetResult=Error: No manifest received";
            TFormulaEvaluator.getNotificationClient();
            TNotification_ClientSide.sendNotification(this.ReplyTo, NOTIFICATION_ACKNOWLEDGEFILES, string, string2, 15, "", "");
            MainWin.appendToLog("TNotification", "processNotificationReceivedFiles", Thread.currentThread(), null, 4, "No manifest received");
            if (tAspectDriver != null) {
                tAspectDriver.putFieldAbsolute("Last_Synchronizer_Result", n5, (Object)"Error: No manifest received");
                tAspectDriver.dispose();
                new TFormulaEvaluator().getFormulaValue("updateTaskScheduler(\"Aspect_File_Set_Synch\")");
            }
            return false;
        }
        String[] stringArray3 = charutil.getSubStringArray(string10, '\n', true);
        if (stringArray3.length != stringArray2.length) {
            string = string + "text=Manifest contains " + Integer.toString(stringArray3.length) + " entries but zip contains " + Integer.toString(stringArray2.length) + "&Fileset=" + string11 + "&FilesetCRC=" + string12 + "&FilesetResult=Error: Manifest does not match zip contents";
            TFormulaEvaluator.getNotificationClient();
            TNotification_ClientSide.sendNotification(this.ReplyTo, NOTIFICATION_ACKNOWLEDGEFILES, string, string2, 15, "", "");
            MainWin.appendToLog("TNotification", "processNotificationReceivedFiles", Thread.currentThread(), null, 4, "Manifest does not match zip contents: " + string10);
            if (tAspectDriver != null) {
                tAspectDriver.putFieldAbsolute("Last_Synchronizer_Result", n5, (Object)"Error: Manifest does not match zip contents");
                tAspectDriver.dispose();
                new TFormulaEvaluator().getFormulaValue("updateTaskScheduler(\"Aspect_File_Set_Synch\")");
            }
            return false;
        }
        String[] stringArray4 = new String[stringArray2.length];
        long[] lArray = new long[stringArray2.length];
        long[] lArray2 = new long[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray = charutil.getSubStringArray(stringArray2[i], '\n', true);
            if (stringArray == null || stringArray.length != 3) continue;
            stringArray4[i] = stringArray[0];
            lArray[i] = charutil.lval(stringArray[1]);
            lArray2[i] = charutil.lval(stringArray[2]);
        }
        String[] stringArray5 = new String[stringArray3.length];
        stringArray = new String[stringArray3.length];
        long[] lArray3 = new long[stringArray3.length];
        for (n2 = 0; n2 < stringArray3.length; ++n2) {
            n = stringArray3[n2].indexOf("|");
            if (n > 0) {
                object = charutil.getSubStringArray(stringArray3[n2], '|', true);
                if (object == null || ((String[])object).length < 3) {
                    string = string + "text=Error in manifest1: Line " + Integer.toString(n2) + " value: " + stringArray3[n2] + "&Fileset=" + string11 + "&FilesetCRC=" + string12 + "&FilesetResult=Error: Error in manifest";
                    TFormulaEvaluator.getNotificationClient();
                    TNotification_ClientSide.sendNotification(this.ReplyTo, NOTIFICATION_ACKNOWLEDGEFILES, string, string2, 15, "", "");
                    MainWin.appendToLog("TNotification", "processNotificationReceivedFiles", Thread.currentThread(), null, 4, "Error in manifest1: " + string10);
                    if (tAspectDriver != null) {
                        tAspectDriver.putFieldAbsolute("Last_Synchronizer_Result", n5, (Object)"Error: Error in manifest");
                        tAspectDriver.dispose();
                        new TFormulaEvaluator().getFormulaValue("updateTaskScheduler(\"Aspect_File_Set_Synch\")");
                    }
                    return false;
                }
            } else {
                string = string + "text=Error in manifest2: Line " + Integer.toString(n2) + " value: " + stringArray3[n2] + "&Fileset=" + string11 + "&FilesetCRC=" + string12 + "&FilesetResult=Error: Error in manifest";
                TFormulaEvaluator.getNotificationClient();
                TNotification_ClientSide.sendNotification(this.ReplyTo, NOTIFICATION_ACKNOWLEDGEFILES, string, string2, 15, "", "");
                MainWin.appendToLog("TNotification", "processNotificationReceivedFiles", Thread.currentThread(), null, 4, "Error in manifest2: " + string10);
                if (tAspectDriver != null) {
                    tAspectDriver.putFieldAbsolute("Last_Synchronizer_Result", n5, (Object)"Error: Error in manifest");
                    tAspectDriver.dispose();
                    new TFormulaEvaluator().getFormulaValue("updateTaskScheduler(\"Aspect_File_Set_Synch\")");
                }
                return false;
            }
            stringArray5[n2] = object[0];
            stringArray[n2] = object[1];
            lArray3[n2] = charutil.lval((String)object[2]);
        }
        System.out.println("Zip Filename\tRemote Filename\tLocal Filename");
        for (n2 = 0; n2 < stringArray3.length; ++n2) {
            System.out.println(stringArray4[n2] + "\t" + stringArray5[n2] + "\t" + stringArray[n2]);
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            n = -1;
            for (int i = 0; n < 0 && i < stringArray5.length; ++i) {
                if (!stringArray5[i].equalsIgnoreCase(stringArray4[n2])) continue;
                n = i;
            }
            if (n >= 0) {
                String string16;
                object = new File(stringArray[n]);
                if (bl2 || !((File)object).exists()) {
                    string16 = "Extracting " + stringArray4[n2] + " to " + stringArray[n] + " timestamp=" + dateutil.formatDate(new Date(lArray3[n]), "MM-dd-yyyy HH:mm:ss") + "<br>";
                    ((StringBuilder)charSequence).append(string16);
                    MainWin.appendToLog("TNotification", "processNotificationReceivedFiles", Thread.currentThread(), null, 3, string16);
                    dosutil.copyFile(string14 + "/" + stringArray4[n2], stringArray[n], 0, false, "", "", "");
                    object = new File(stringArray[n]);
                    ((File)object).setLastModified(lArray3[n]);
                    continue;
                }
                string16 = "Skipping " + stringArray4[n2] + " because the file already exists<br>";
                ((StringBuilder)charSequence).append(string16);
                MainWin.appendToLog("TNotification", "processNotificationReceivedFiles", Thread.currentThread(), null, 3, string16);
                continue;
            }
            object = "Skipping " + stringArray4[n2] + " because cannot locate filename in the manifest<br>";
            ((StringBuilder)charSequence).append((String)object);
            MainWin.appendToLog("TNotification", "processNotificationReceivedFiles", Thread.currentThread(), null, 3, (String)object);
        }
        dosutil.deleteFile(string14);
        if (tAspectDriver != null) {
            tAspectDriver.putFieldAbsolute("Last_Synchronizer_Result", n5, (Object)"Ok");
            tAspectDriver.putFieldAbsolute("Last_Synchronized_CRC", n5, (Object)string12);
            tAspectDriver.dispose();
            new TFormulaEvaluator().getFormulaValue("updateTaskScheduler(\"Aspect_File_Set_Synch\")");
        }
        string = string + "&subject=Acknowledge file transfer&Fileset=" + string11 + "&FilesetCRC=" + string12 + "&FilesetResult=Ok: Acknowledge file transfer";
        string = string + "&text=";
        string = string + "Remote Filespec: " + string4 + "<br>";
        string = string + "Local Filespec: " + string3 + "<br>";
        string = string + "<br><b>Log</b><br>" + charSequence;
        TFormulaEvaluator.getNotificationClient();
        TNotification_ClientSide.sendNotification(this.ReplyTo, NOTIFICATION_ACKNOWLEDGEFILES, string, string2, 15, "", "");
        MainWin.appendToLog("TNotification", "processNotificationReceivedFiles", Thread.currentThread(), null, 3, "Receive files complete.  Received " + stringArray2.length + " files");
        return true;
    }

    public boolean processNotificationAcknowledgeFiles() {
        String string = this.Data;
        String string2 = charutil.getParamValue(string, "Fileset", '&');
        if (string2.trim().length() > 0) {
            String string3 = charutil.getParamValue(string, "FilesetCRC", '&');
            String string4 = charutil.getParamValue(string, "FilesetResult", '&');
            System.out.println("processNotificationAcknowledgeFiles Fileset=" + string2 + " CRC=" + string3 + " Result=" + string4);
            String string5 = "CustomerID=" + this.ReplyTo + "&Fileset=" + string2 + "&CRC=" + string3 + "&FilesetResult=" + string4;
            String string6 = "execAgent(\"K4Ui6j3Y1rwlvukPkOqn25Em\",\"Acknowledge File Set Listener Result\",\"" + string5 + "\",\"\",false)";
            new TFormulaEvaluator().getFormulaValue(string6);
        }
        return true;
    }

    public static boolean isLoginException(String string, String string2, String string3, String string4, String[] stringArray) {
        String string5;
        String string6;
        boolean bl = false;
        bl = bl || string.equalsIgnoreCase("M2HDPGX49Sct3l6etItu5n1J") && string2.equalsIgnoreCase("Support Home 2015");
        bl = bl || string.equalsIgnoreCase("h0BE4ziTlLytqKxtWLMy5CVY") && string2.equalsIgnoreCase("BackOffice Home 2015");
        bl = bl || string.equalsIgnoreCase("K4Ui6j3Y1rwlvukPkOqn25Em") && string2.equalsIgnoreCase("Registration 2017") && string3.equalsIgnoreCase("771930");
        bl = bl || string.equalsIgnoreCase("K4Ui6j3Y1rwlvukPkOqn25Em") && string2.equalsIgnoreCase("Registration 2017") && string3.equalsIgnoreCase("510954");
        bl = bl || string.equalsIgnoreCase("K4Ui6j3Y1rwlvukPkOqn25Em") && string2.equalsIgnoreCase("Registration 2017") && string3.equalsIgnoreCase("760502");
        bl = bl || string.equalsIgnoreCase("K4Ui6j3Y1rwlvukPkOqn25Em") && string2.equalsIgnoreCase("Registration 2017") && string3.equalsIgnoreCase("498428");
        bl = bl || string.equalsIgnoreCase("K4Ui6j3Y1rwlvukPkOqn25Em") && string2.equalsIgnoreCase("Registration 2017") && string3.equalsIgnoreCase("432137");
        bl = bl || string.equalsIgnoreCase("K4Ui6j3Y1rwlvukPkOqn25Em") && string2.equalsIgnoreCase("Registration 2017") && string3.equalsIgnoreCase("670903");
        bl = bl || string.equalsIgnoreCase("M2HDPGX49Sct3l6etItu5n1J") && string2.equalsIgnoreCase("Content Elements") && string3.equalsIgnoreCase("932435");
        bl = bl || string.equalsIgnoreCase("M2HDPGX49Sct3l6etItu5n1J") && string2.equalsIgnoreCase("Content Elements") && string3.equalsIgnoreCase("281281");
        bl = bl || string.equalsIgnoreCase("M2HDPGX49Sct3l6etItu5n1J") && string2.equalsIgnoreCase("Content Elements") && string3.equalsIgnoreCase("sensor_list");
        bl = bl || string.equalsIgnoreCase("M2HDPGX49Sct3l6etItu5n1J") && string2.equalsIgnoreCase("Content Elements") && string3.equalsIgnoreCase("action_list");
        bl = bl || string4.equalsIgnoreCase("gCE0fPW7");
        bl = bl || string4.equalsIgnoreCase("3m1ZUQlv");
        bl = bl || string.equalsIgnoreCase("K4Ui6j3Y1rwlvukPkOqn25Em") && string2.equalsIgnoreCase("User Interface Setup");
        bl = bl || string.equalsIgnoreCase("K4Ui6j3Y1rwlvukPkOqn25Em") && string2.equalsIgnoreCase("Login");
        bl = bl || string4.equalsIgnoreCase("r63bIXdW");
        boolean bl2 = bl = bl || string.equalsIgnoreCase("K4Ui6j3Y1rwlvukPkOqn25Em") && string2.equalsIgnoreCase("Support Tasks");
        if (!bl && string.equalsIgnoreCase("K4Ui6j3Y1rwlvukPkOqn25Em") && string2.equalsIgnoreCase("Notification Queries") && (string6 = charutil.getParamValue(stringArray, "query").trim()).equalsIgnoreCase("getHtmlSelectOptions") && (string5 = charutil.getParamValue(stringArray, "CollectionID").trim()).equalsIgnoreCase("Aspect_Support_Task_Detail_Names_by_ID")) {
            bl = true;
        }
        if (!bl && string.equalsIgnoreCase("K4Ui6j3Y1rwlvukPkOqn25Em") && string2.equalsIgnoreCase("Notification Queries") && ((string6 = charutil.getParamValue(stringArray, "CollectionID").trim()).equalsIgnoreCase("Aspect_Support_Question_by_ID") || string6.equalsIgnoreCase("Aspect_Support_Video_Filename_by_ID"))) {
            bl = true;
        }
        if (!bl && string.equalsIgnoreCase("K4Ui6j3Y1rwlvukPkOqn25Em") && string2.equalsIgnoreCase("Notification Queries")) {
            string6 = charutil.getParamValue(stringArray, "query").trim();
            string5 = charutil.getParamValue(stringArray, "SensorName").trim();
            if (string6.equalsIgnoreCase("getAgentSensorValue") && string5.equalsIgnoreCase("getSupportTaskInfo")) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean processNotificationGetWidget() {
        Object object;
        String string;
        String string2 = this.ID;
        if (this.ParentID.length() > 0) {
            string2 = this.ParentID;
        }
        boolean bl = false;
        if (this.EncryptedPassword.equals(TNotification.encryptPassword())) {
            bl = true;
        } else if (this.EncryptedPassword.equals(Application.getTokenValue("AspectSupportNotificationPass"))) {
            bl = true;
        }
        String[] stringArray = charutil.getSubStringArray(this.Data, '&', false);
        String string3 = charutil.getParamValue(stringArray, "DocumentID");
        String string4 = charutil.getParamValue(stringArray, "Widget");
        String string5 = charutil.getParamValue(stringArray, "ContainerItemID");
        String string6 = charutil.getParamValue(stringArray, "Query");
        String string7 = charutil.getParamValue(stringArray, "ViewID");
        if (string4.equalsIgnoreCase("LogIn")) {
            bl = true;
        } else if (string4.equalsIgnoreCase("LogIn - Mobile")) {
            bl = true;
        }
        if (!bl) {
            bl = TNotification.isLoginException(string3, string4, string5, string7, stringArray);
        }
        if (MainWin.isRunningOnServer()) {
            if (string5.equalsIgnoreCase("invmaint_getInvMaster")) {
                bl = true;
            } else if (string5.equalsIgnoreCase("invmaint_setup")) {
                bl = true;
            } else if (string6.equalsIgnoreCase("recordAgentStatus")) {
                bl = true;
            } else if (string4.equalsIgnoreCase("Computers In Company")) {
                bl = true;
            }
            if (bl) {
                // empty if block
            }
        }
        if (!bl && TNotification.encryptPassword().equals(Application.getTokenValue("AspectSupportNotificationPass"))) {
            string = charutil.getParamValue(stringArray, "ActionName");
            if (string3.equalsIgnoreCase("K4Ui6j3Y1rwlvukPkOqn25Em") && string4.equalsIgnoreCase("Process File Set Listener Notification")) {
                bl = true;
            }
        }
        if (!bl) {
            string = "Invalid password for " + string3 + ":" + string4 + ":" + string5 + ":" + string7;
            MainWin.appendToLog("TNotification", "processNotificationGetWidget", Thread.currentThread(), null, 3, "TNotification: processNotificationGetWidget " + string);
            if (this.ReplyTo.length() > 0) {
                TFormulaEvaluator.getNotificationClient();
                TNotification_ClientSide.sendNotification(this.ReplyTo, 4, string, string2, 5, "", "");
            }
            return false;
        }
        if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotificationGetWidget", Thread.currentThread(), null, 3, "TNotification: processNotificationGetWidget Pass=" + this.EncryptedPassword);
        }
        string = this.Data;
        String string8 = charutil.getParamValue(string, "remoteIP", '&');
        String string9 = charutil.getParamValue(string, "user-agent", '&');
        string = string + "&ParentID=" + string2 + "&Recipient=" + Application.getTokenValue("AspectHashID");
        string = string + "&NotificationReplyTo=" + this.From;
        if (string8.trim().length() > 0) {
            object = new TCacheServerInfo(string8);
            string = string + "&SourceServerID=" + ((TCacheServerInfo)object).getServerID();
            string = string + "&SourceServer=" + ((TCacheServerInfo)object).getServer();
            string = string + "&SourceServerProtocol=" + ((TCacheServerInfo)object).getServerProtocol();
            string = string + "&SourceServerHost=" + ((TCacheServerInfo)object).getServerHost();
            string = string + "&SourceServerHostName=" + ((TCacheServerInfo)object).getServerHostName();
            string = string + "&SourceServerPort=" + ((TCacheServerInfo)object).getServerPort();
        }
        object = Application.getHomeDir() + "temporary_files/" + TPasswordService.generateSalt(16) + ".$$$";
        string = string + "&AttachFilename=" + (String)object;
        if (this.Type == NOTIFICATION_PROXY_WIDGET) {
            string = string + "&isProxyRequest=true";
        }
        if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotificationGetWidget", Thread.currentThread(), null, 3, "\tNotification: Processing widget request.  Args=" + string);
        }
        String string10 = "";
        try {
            string10 = TFormulaEvaluator.getCache().getCachedContent(0, Application.getTokenValue("AspectHashID"), string, true, string8, string9);
        }
        catch (Exception exception) {
            MainWin.appendToLog("TNotification", "processNotificationGetWidget", Thread.currentThread(), null, 4, "\tNotification: Error in processNotificationGetWidget: " + exception.toString());
            System.out.println("Args=" + string);
        }
        if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotificationGetWidget", Thread.currentThread(), null, 3, "\tNotification: Processing widget request complete.  Args=" + string);
        }
        if (this.ReplyTo.length() > 0) {
            if (dosutil.fileExists((String)object)) {
                String string11 = charutil.getParamValue(this.Data, "FileDescription", '&');
                if (string11.trim().length() == 0) {
                    string11 = "No description of file given";
                }
                if (DebugNotifications) {
                    MainWin.appendToLog("TNotification", "processNotificationGetWidget", Thread.currentThread(), null, 3, "\tNotification: Sending response to widget request with attachment.  ParentID=" + string2);
                }
                TFormulaEvaluator.getNotificationClient();
                TNotification_ClientSide.sendNotification(this.ReplyTo, 4, string10, string2, 5, (String)object, string11);
            } else {
                if (DebugNotifications) {
                    MainWin.appendToLog("TNotification", "processNotificationGetWidget", Thread.currentThread(), null, 3, "\tNotification: Sending response to widget request.  ParentID=" + string2);
                }
                TFormulaEvaluator.getNotificationClient();
                TNotification_ClientSide.sendNotification(this.ReplyTo, 4, string10, string2, 5, "", "");
            }
        } else if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotificationGetWidget", Thread.currentThread(), null, 3, "\tTNotification: Processed widget request but no ReplyTo specified in notification.");
        }
        return true;
    }

    public boolean processNotificationScript() {
        String string = charutil.getParamValue(this.Data, "ScriptID", '&');
        boolean bl = false;
        if (this.EncryptedPassword.equals(TNotification.encryptPassword())) {
            bl = true;
        } else if (this.EncryptedPassword.equals(Application.getTokenValue("AspectSupportNotificationPass"))) {
            bl = true;
        }
        if (!bl) {
            String string2 = "Cannot process script [" + string + "] because an invalid password was given.  Encrypted password: " + this.EncryptedPassword;
            if (this.ReplyTo.length() > 0) {
                TFormulaEvaluator.getNotificationClient();
                TNotification_ClientSide.sendNotification(this.ReplyTo, 4, string2, 5);
            }
            return false;
        }
        if (string.trim().length() == 0) {
            String string3 = "Could not process notification because a scriptID was not found.";
            if (this.ReplyTo.length() > 0) {
                TFormulaEvaluator.getNotificationClient();
                TNotification_ClientSide.sendNotification(this.ReplyTo, 4, string3, 5);
            }
            return false;
        }
        MainWin.appendToLog("TNotification", "processNotification", Thread.currentThread(), null, 3, "\tTNotification: Executing Script: " + string);
        String string4 = "NotificationReplyTo=" + this.From;
        string4 = string4 + "&ParentID=" + this.ID;
        String[] stringArray = charutil.getSubStringArray(this.Data, '&', false);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].toUpperCase().startsWith("ScriptID=") || stringArray[i].toUpperCase().startsWith("ScriptWait=")) continue;
                string4 = string4 + "&" + stringArray[i];
            }
            TExecScript tExecScript = new TExecScript(string, null, new TFormulaEvaluator());
            tExecScript.setParameters(string4);
            if (!charutil.boolval(charutil.getParamValue(this.Data, "ScriptWait", '&'))) {
                tExecScript.start();
                return true;
            }
            tExecScript.executeScript();
            String string5 = "";
            if (tExecScript.getScriptResult() == null) {
                string5 = "The script did not return a result.";
            } else {
                string5 = (String)tExecScript.getScriptResult();
                if (string5.toUpperCase().indexOf("__WIDGETID__") >= 0) {
                    string5 = "<div ID='__WidgetID__'>" + string5 + "</div>";
                    string5 = charutil.replaceAllSubstrings(string5, "__WidgetID__", "w" + TPasswordService.generateSalt(24));
                }
            }
            if (this.ReplyTo.length() > 0) {
                TFormulaEvaluator.getNotificationClient();
                TNotification_ClientSide.sendNotification(this.ReplyTo, 4, string5, this.ID, 15, "", "");
            }
            return true;
        }
        return false;
    }

    public boolean processNotificationExecTask() {
        String string = charutil.getParamValue(this.Data, "DriverID", '&');
        String string2 = charutil.getParamValue(this.Data, "TaskName", '&');
        if (string.length() == 0) {
            string = "TaskScheduler";
        }
        TTaskScheduler tTaskScheduler = TFormulaEvaluator.getTaskScheduler(string);
        String string3 = "";
        if (tTaskScheduler != null) {
            MainWin.appendToLog("TNotification", "processNotificationExecTask", Thread.currentThread(), null, 3, "Executing task for notification: " + string2);
            string3 = objectutil.convertToString(tTaskScheduler.execTask(string2));
        } else {
            string3 = "Error processing notification.  Task scheduler named " + string + " does not exist";
            MainWin.appendToLog("TNotification", "processNotificationExecTask", Thread.currentThread(), null, 3, string3);
        }
        String string4 = "Text=" + string3;
        TFormulaEvaluator.getNotificationClient();
        TNotification_ClientSide.sendNotification(this.ReplyTo, NOTIFICATION_TEXT, string4, this.ID, 15, "", "");
        return true;
    }

    public boolean processNotificationRequestDriverData() {
        int n;
        Object object;
        int n2;
        String[] stringArray;
        Object object2;
        boolean bl = false;
        if (this.EncryptedPassword.equals(TNotification.encryptPassword())) {
            bl = true;
        } else if (this.EncryptedPassword.equals(Application.getTokenValue("AspectSupportNotificationPass"))) {
            bl = true;
        }
        if (!bl) {
            MainWin.appendToLog("TNotification", "processNotificationRequestDriverData", Thread.currentThread(), null, 3, "\tTNotification: Received invalid password in request for driver data");
            String string = "Cannot process request for driver data because an invalid password was given.  Encrypted password: " + this.EncryptedPassword;
            if (this.ReplyTo.length() > 0) {
                TFormulaEvaluator.getNotificationClient();
                TNotification_ClientSide.sendNotification(this.ReplyTo, 4, string, 15);
            }
            return false;
        }
        if (this.ReplyTo.length() == 0) {
            MainWin.appendToLog("TNotification", "processNotificationRequestDriverData", Thread.currentThread(), null, 3, "\tTNotification: No ReplyTo in request for driver data");
            return false;
        }
        String[] stringArray2 = charutil.getSubStringArray(this.Data, '\n', true);
        if (stringArray2 == null || stringArray2.length < 6) {
            MainWin.appendToLog("TNotification", "processNotificationRequestDriverData", Thread.currentThread(), null, 3, "\tTNotification: Missing arguments in request for driver data");
            if (stringArray2 == null) {
                System.out.println("arData is null");
            } else {
                for (int i = 0; i < stringArray2.length; ++i) {
                    System.out.println("\tarData[" + i + "] = " + stringArray2[i]);
                }
            }
            return false;
        }
        String string = stringArray2[0];
        String string2 = stringArray2[1];
        String string3 = stringArray2[2];
        String string4 = stringArray2[3];
        String string5 = stringArray2[4];
        String string6 = stringArray2[5];
        if (string6.trim().length() == 0) {
            string6 = "true";
        }
        if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotificationRequestDriverData", Thread.currentThread(), null, 3, "\tTNotification: Process request for driver data:  DriverID=" + string2 + " KeyExpression=" + string3 + " Params=" + string4);
            MainWin.appendToLog("TNotification", "processNotificationRequestDriverData", Thread.currentThread(), null, 3, "\tTNotification: Process request for driver data:  Fields=" + string5);
        }
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        for (int i = 6; i < stringArray2.length; ++i) {
            int n3 = stringArray2[i].indexOf(94);
            if (n3 <= 0) continue;
            object2 = stringArray2[i].substring(0, n3);
            stringArray = stringArray2[i].substring(n3 + 1);
            hashtable.put(((String)object2).toUpperCase(), stringArray);
        }
        TAppDriversObject tAppDriversObject = TNotification.Application.AppDrivers.getAppDriversObject(string2);
        if (tAppDriversObject == null) {
            MainWin.appendToLog("TNotification", "processNotificationRequestDriverData", Thread.currentThread(), null, 4, "\tTNotification: Process request for driver data: Invalid driver ID: " + string2);
            TFormulaEvaluator.getNotificationClient();
            TNotification_ClientSide.sendNotification(this.ReplyTo, 4, "Error - Invalid driver ID: " + string2, this.ID, 15, "", "");
            return false;
        }
        TAspectDriver.executeDriverPreActions(tAppDriversObject);
        TAspectDriver tAspectDriver = new TAspectDriver(Application, tAppDriversObject, 1, true, string4);
        tAspectDriver.setActiveFilter(string6, true);
        if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotificationRequestDriverData", Thread.currentThread(), null, 3, "\tTNotification: Process request for driver data: Records in driver = " + tAspectDriver.getRecordCount() + " Filter=" + string6 + " Absolute count: " + tAspectDriver.getAbsoluteRecordCount());
        }
        object2 = new ArrayList();
        if (string5.trim().length() > 0) {
            stringArray = charutil.getSubStringArray(string5, '^', true);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                TDriverStructRecord tDriverStructRecord = tAspectDriver.DriverStruct.getField(stringArray[n2]);
                if (tDriverStructRecord == null) continue;
                ((ArrayList)object2).add(tDriverStructRecord);
            }
        } else {
            for (int i = 0; i < tAspectDriver.DriverStruct.FieldColl.size(); ++i) {
                ((ArrayList)object2).add(tAspectDriver.DriverStruct.FieldColl.get(i));
            }
        }
        String[] stringArray3 = new String[((ArrayList)object2).size()];
        for (n2 = 0; n2 < ((ArrayList)object2).size(); ++n2) {
            stringArray3[n2] = ((TDriverStructRecord)((ArrayList)object2).get((int)n2)).ID;
        }
        n2 = 0;
        int n4 = 0;
        TDataCollection tDataCollection = new TDataCollection(string3);
        for (int i = 0; i < tAspectDriver.getRecordCount(); ++i) {
            object = tAspectDriver.getKeyValue(string3, i).toUpperCase();
            if (((String)object).trim().length() > 0) {
                int n5;
                int n6 = tAspectDriver.getCheckSum(i, stringArray3);
                n = 1;
                if (hashtable.containsKey(object)) {
                    n5 = charutil.ival((String)hashtable.get(object));
                    if (n6 == n5) {
                        n = 0;
                        ++n4;
                    }
                    hashtable.remove(object);
                }
                if (n == 0) continue;
                for (n5 = 0; n5 < ((ArrayList)object2).size(); ++n5) {
                    TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)((ArrayList)object2).get(n5);
                    Object object3 = tAspectDriver.getField(tDriverStructRecord, i);
                    tDataCollection.addField((String)object, tDriverStructRecord.ID, tDriverStructRecord.FieldType, object3);
                }
                ++n2;
                continue;
            }
            MainWin.appendToLog("TNotification", "processNotificationRequestDriverData", Thread.currentThread(), null, 4, "\tTNotification: Blank key value in driver " + string2);
        }
        if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotificationRequestDriverData", Thread.currentThread(), null, 3, "\tTNotification: Added " + n2 + " records to driver request");
            MainWin.appendToLog("TNotification", "processNotificationRequestDriverData", Thread.currentThread(), null, 3, "\tTNotification: Skipped " + n4 + " records with matching checksums");
            MainWin.appendToLog("TNotification", "processNotificationRequestDriverData", Thread.currentThread(), null, 3, "\tTNotification: There are " + hashtable.size() + " records to be deleted");
        }
        if (hashtable.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            object = new ArrayList();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (n = 0; n < tAspectDriver.DriverStruct.FieldColl.size(); ++n) {
                TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)tAspectDriver.DriverStruct.FieldColl.get(n);
                if (tDriverStructRecord.DefaultOnDelete.trim().length() <= 0) continue;
                arrayList.add(tDriverStructRecord.ID);
                ((ArrayList)object).add(tDriverStructRecord.DefaultOnDelete);
                arrayList2.add(new Integer(tDriverStructRecord.FieldType));
            }
            if (arrayList.size() > 0) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string7 = (String)enumeration.nextElement();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        tDataCollection.addField(string7, (String)arrayList.get(i), (Integer)arrayList2.get(i), (String)((ArrayList)object).get(i));
                    }
                    if (!DebugNotifications) continue;
                    MainWin.appendToLog("TNotification", "processNotificationRequestDriverData", Thread.currentThread(), null, 3, "\tTNotification: Added fields for deleted record with key " + string7);
                }
            } else {
                MainWin.appendToLog("TNotification", "processNotificationRequestDriverData", Thread.currentThread(), null, 4, "\tTNotification: No fields found with a DefaultOnDelete value.");
            }
        }
        tAspectDriver.dispose();
        String string8 = tDataCollection.toString();
        if (TCacheObj.DebugCache) {
            MainWin.appendToLog("TNotification", "processNotificationRequestDriverData", Thread.currentThread(), null, 10, "TNotification_ClientSize.processNotificationRequestDriverData sending driver data");
            if (Application.getDevelopmentMode() == 0) {
                object = Application.getHomeDir() + "cachedata\\cachedriver_driverdata_" + dateutil.formatDate(new Date(), "MMddyyyy_HHmmss") + ".txt";
                MainWin.appendToLog("TNotification", "processNotificationRequestDriverData", Thread.currentThread(), null, 10, "TNotification_ClientSize.processNotificationRequestDriverData driver data written to " + (String)object);
                TAsciiOutput.writeContent((String)object, string8);
            }
        }
        TFormulaEvaluator.getNotificationClient();
        TNotification_ClientSide.sendNotification(this.ReplyTo, 4, string8, this.ID, 15, "", "");
        return true;
    }

    public boolean processNotificationUpdateDriverData() {
        TAppDriversObject tAppDriversObject;
        if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotificationUpdateDriverData", Thread.currentThread(), null, 3, "TNotification: Received notification containing updated driver data");
        }
        Application.setTokenValue("tmLastPutDriverDataRemote", Long.toString(new Date().getTime()));
        System.out.println("FEval settoken: tmLastPutDriverDataRemote Value:" + new Date().getTime());
        boolean bl = false;
        if (this.EncryptedPassword.equals(TNotification.encryptPassword())) {
            bl = true;
        } else if (this.EncryptedPassword.equals(Application.getTokenValue("AspectSupportNotificationPass"))) {
            bl = true;
        }
        if (!bl) {
            MainWin.appendToLog("TNotification", "processNotificationUpdateDriverData", Thread.currentThread(), null, 3, "\tTNotification: Received invalid password in request for driver data");
            String string = "1.0\n-1\nInvalid password in update driver data notification";
            if (this.ReplyTo.length() > 0) {
                TFormulaEvaluator.getNotificationClient();
                TNotification_ClientSide.sendNotification(this.ReplyTo, 4, string, 10);
            }
            return false;
        }
        String[] stringArray = charutil.getSubStringArray(this.Data, '\n', true);
        if (stringArray == null || stringArray.length < 6) {
            MainWin.appendToLog("TNotification", "processNotificationUpdateDriverData", Thread.currentThread(), null, 3, "\tTNotification: Missing arguments in request to put driver data");
            String string = "1.0\n-1\nInvalid format in update driver data notification";
            if (this.ReplyTo.length() > 0) {
                TFormulaEvaluator.getNotificationClient();
                TNotification_ClientSide.sendNotification(this.ReplyTo, 4, string, 10);
            }
            return false;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotificationUpdateDriverData", Thread.currentThread(), null, 3, "TNotification: DriverInfo DriverID=" + string2 + " Params=" + string3);
        }
        if ((tAppDriversObject = TNotification.Application.AppDrivers.getAppDriversObject(string2)) == null) {
            MainWin.appendToLog("TNotification", "processNotificationUpdateDriverData", Thread.currentThread(), null, 3, "TNotification: Invalid driver ID in update driver data: " + string2);
            String string4 = "1.0\n-1\nInvalid driver in update driver data notification: " + string2;
            if (this.ReplyTo.length() > 0) {
                TFormulaEvaluator.getNotificationClient();
                TNotification_ClientSide.sendNotification(this.ReplyTo, 4, string4, 10);
            }
            return false;
        }
        TAspectDriver tAspectDriver = new TAspectDriver(Application, tAppDriversObject, 1, true, string3);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 3; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append("\n");
        }
        TDataCollection tDataCollection = new TDataCollection(tAspectDriver.DriverStruct, stringBuilder.toString());
        if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotificationUpdateDriverData", Thread.currentThread(), null, 3, "TNotification: Data collection contains " + tDataCollection.getRecordCount() + " records");
        }
        tDataCollection.writeToDriver(tAspectDriver, true);
        tAspectDriver.dispose();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("1.0\n");
        stringBuilder2.append("Ok\n");
        if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotificationUpdateDriverData", Thread.currentThread(), null, 3, "TNotification: Sending response to driver data update notification");
        }
        TFormulaEvaluator.getNotificationClient();
        TNotification_ClientSide.sendNotification(this.ReplyTo, 4, stringBuilder2.toString(), this.ID, 15, "", "");
        return true;
    }

    public boolean processNotificationProcessItem() {
        if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotificationProcessItem", Thread.currentThread(), null, 3, "TNotification: processNotificationProcessItem Pass=" + this.EncryptedPassword);
        }
        String string = this.ID;
        if (this.ParentID.length() > 0) {
            string = this.ParentID;
        }
        String string2 = this.Data;
        string2 = string2 + "&isProxyRequest=true";
        String string3 = charutil.getParamValue(string2, "remoteIP", '&');
        String string4 = charutil.getParamValue(string2, "user-agent", '&');
        if (DebugNotifications) {
            MainWin.appendToLog("TNotification", "processNotificationProcessItem", Thread.currentThread(), null, 3, "\tTNotification: Processing container item.  Args=" + string2);
        }
        String string5 = TFormulaEvaluator.getCache().getCachedContent(1, Application.getTokenValue("AspectHashID"), string2, true, string3, string4);
        if (this.ReplyTo.length() > 0) {
            TFormulaEvaluator.getNotificationClient();
            TNotification_ClientSide.sendNotification(this.ReplyTo, 4, string5, string, 5, "", "");
        }
        return true;
    }
}

