/*
 * Decompiled with CFR 0.152.
 */
package utility;

import aspect.Aspect;
import aspect.TMainWin;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.dosutil;

public class imageutil {
    private static Hashtable hashImages = null;
    private static Hashtable hashJarredImages = null;
    private static Hashtable hashErrImages = null;

    public static ImageIcon getIcon(Object object, String string, String string2) {
        ImageIcon imageIcon = null;
        StringBuilder stringBuilder = new StringBuilder();
        URL uRL = object.getClass().getResource(string);
        if (uRL == null && dosutil.findFile(stringBuilder, TMainWin.Application, string)) {
            try {
                uRL = new URL(stringBuilder.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL, string2);
        }
        if (imageIcon == null) {
            Aspect.MainWin.appendToLog("dosutil", "getIcon", Thread.currentThread(), null, 4, "Cannot locate icon named: " + string);
        }
        return imageIcon;
    }

    public static BufferedImage createResizedCopy(Image image, int n, int n2, boolean bl) {
        int n3 = bl ? 1 : 2;
        int n4 = n;
        int n5 = n2;
        if (n < 0) {
            n4 = (int)Math.floor((double)n5 / (double)image.getHeight(null) * (double)image.getWidth(null));
        } else if (n2 < 0) {
            n5 = (int)Math.floor((double)n4 / (double)image.getWidth(null) * (double)image.getHeight(null));
        }
        if (n4 == 0) {
            n4 = image.getWidth(null);
        }
        if (n5 == 0) {
            n5 = image.getHeight(null);
        }
        BufferedImage bufferedImage = new BufferedImage(n4, n5, n3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (bl) {
            graphics2D.setComposite(AlphaComposite.Src);
        }
        graphics2D.drawImage(image, 0, 0, n4, n5, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Image getScaledImage(Class clazz, String string, int n, int n2) {
        URL uRL = null;
        Image image = null;
        ImageIcon imageIcon = null;
        BufferedImage bufferedImage = null;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n;
        int n4 = n2;
        if (string.length() == 0) {
            return null;
        }
        if (hashErrImages != null && hashErrImages.containsKey(string)) {
            return null;
        }
        if (hashImages != null && hashImages.containsKey(string)) {
            image = (Image)hashImages.get(string);
        }
        if (image == null) {
            uRL = ClassLoader.getSystemClassLoader().getClass().getResource(string);
            if (uRL == null) {
                stringBuilder.setLength(0);
                stringBuilder.append(string);
                uRL = Aspect.class.getResource(stringBuilder.toString());
            }
            if (uRL == null) {
                if (string.toUpperCase().indexOf(".JAR") > 0 || string.toUpperCase().indexOf(".ZIP") > 0) {
                    if (hashJarredImages != null && hashJarredImages.containsKey(string)) {
                        image = (Image)hashJarredImages.get(string);
                    }
                    if (image == null) {
                        TAsciiInput tAsciiInput = new TAsciiInput(string, '\u0000');
                        byte[] byArray = tAsciiInput.get_entire_file();
                        if (byArray != null) {
                            image = Toolkit.getDefaultToolkit().createImage(byArray);
                            if (hashJarredImages == null) {
                                hashJarredImages = new Hashtable();
                            }
                            hashJarredImages.put(string, image);
                        }
                        tAsciiInput.dispose();
                    }
                } else {
                    if (dosutil.findFile(stringBuilder, TMainWin.Application, string)) {
                        try {
                            uRL = new URL(dosutil.formatURL(stringBuilder.toString()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (uRL == null) {
                        dosutil.formatURL(stringBuilder, new StringBuilder(string));
                        try {
                            uRL = new URL(stringBuilder.toString());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        Object object = uRL.getContent();
                    }
                    catch (Exception exception) {
                        if (Aspect.MainWin != null) {
                            Aspect.MainWin.appendToLog("dosutil", "getIcon", Thread.currentThread(), exception, 4, "Error loading image2: " + uRL);
                        }
                        if (hashErrImages == null) {
                            hashErrImages = new Hashtable();
                        }
                        hashErrImages.put(string, string);
                        uRL = null;
                    }
                }
            }
        }
        if (image == null && uRL != null) {
            image = uRL.getPath().toUpperCase().endsWith(".GIF") ? Toolkit.getDefaultToolkit().getImage(uRL) : Toolkit.getDefaultToolkit().createImage(uRL);
        }
        if (image != null) {
            imageIcon = new ImageIcon(image);
            int n5 = imageIcon.getIconWidth();
            int n6 = imageIcon.getIconHeight();
            if (n < 0 && n2 < 0) {
                return image;
            }
            if (n == n5 && n2 == n6) {
                return image;
            }
            if (n < 0) {
                double d = charutil.divby(n2, n6);
                n3 = (int)((double)image.getWidth(null) * d);
            } else if (n2 < 0) {
                double d = charutil.divby(n, n5);
                n4 = (int)((double)image.getHeight(null) * d);
            }
            bufferedImage = imageutil.createResizedCopy(image, n3, n4, true);
        }
        return bufferedImage;
    }

    public static BufferedImage rotate(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if (n == 180) {
            AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, -1.0);
            affineTransform.translate(-bufferedImage.getWidth(null), -bufferedImage.getHeight(null));
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
            bufferedImage = affineTransformOp.filter(bufferedImage, null);
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n3, n2, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        double d = (double)(n3 - n2) / 2.0;
        double d2 = (double)(n2 - n3) / 2.0;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d, d2);
        affineTransform.rotate(Math.toRadians(n), (double)n2 / 2.0, (double)n3 / 2.0);
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        graphics2D.dispose();
        return bufferedImage2;
    }
}

