/*
 * Decompiled with CFR 0.152.
 */
package utility.ftp;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Vector;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import resources.TApplication;
import utility.charutil;
import utility.dosutil;

public class TFtpClient
extends FTPClient {
    private static TMainWin MainWin = Aspect.MainWin;
    private static boolean Debug = false;
    private static TApplication Application = null;
    String HostName = null;
    String UserName = null;
    String Password = null;
    int TimezoneOffset = 0;
    boolean Passive = true;
    boolean Connected = false;
    int HostPort = -1;

    public TFtpClient() {
        if (MainWin != null) {
            Debug = TMainWin.Application.getTokenValueAsBool("TFtpClient");
            Application = TMainWin.Application;
        }
    }

    public TFtpClient(String string, String string2, String string3, boolean bl, int n) {
        if (MainWin != null) {
            Debug = TMainWin.Application.getTokenValueAsBool("TFtpClient");
            Application = TMainWin.Application;
        }
        this.HostName = string;
        this.UserName = string2;
        this.Password = string3;
        this.Passive = bl;
        this.TimezoneOffset = n;
        try {
            System.out.println("connecting to " + this.HostName + " user:" + this.UserName + " Pass:" + this.Password);
            this.connect(this.HostName, this.UserName, this.Password);
            if (this.Connected) {
                if (this.Passive) {
                    this.setPassiveMode(true);
                } else {
                    this.setPassiveMode(false);
                }
                this.setDataTimeout(180000);
                MainWin.appendToLog("TFtpClient", "init", Thread.currentThread(), null, 3, "Connected to " + this.HostName);
            } else {
                MainWin.appendToLog("TFtpClient", "init", Thread.currentThread(), null, 4, "Error logging onto " + this.HostName);
                Application.setTokenValue("$FtpTransferStatus", "Could not connect to " + this.HostName);
            }
        }
        catch (Exception exception) {
            if (MainWin == null) {
                System.out.println("Error: TFtpClient1: " + exception.toString());
            }
            MainWin.appendToLog("TFtpClient", "init", Thread.currentThread(), exception, 4, "Error logging onto " + this.HostName);
            Application.setTokenValue("$FtpTransferStatus", "Could not connect to " + this.HostName);
        }
    }

    public TFtpClient(String string, String string2, String string3, boolean bl, int n, int n2) {
        if (MainWin != null) {
            Debug = TMainWin.Application.getTokenValueAsBool("TFtpClient");
            Application = TMainWin.Application;
        }
        this.HostName = string;
        this.UserName = string2;
        this.Password = string3;
        this.Passive = bl;
        this.TimezoneOffset = n;
        this.HostPort = n2;
        try {
            this.connect(this.HostName, this.UserName, this.Password);
            if (this.Connected) {
                if (this.Passive) {
                    this.setPassiveMode(true);
                } else {
                    this.setPassiveMode(false);
                }
                this.setDataTimeout(180000);
                MainWin.appendToLog("TFtpClient", "init", Thread.currentThread(), null, 3, "Connected to " + this.HostName);
            } else {
                MainWin.appendToLog("TFtpClient", "init", Thread.currentThread(), null, 4, "Error logging onto " + this.HostName);
                Application.setTokenValue("$FtpTransferStatus", "Could not connect to " + this.HostName);
            }
        }
        catch (Exception exception) {
            MainWin.appendToLog("TFtpClient", "init", Thread.currentThread(), exception, 4, "Error logging onto " + this.HostName);
            Application.setTokenValue("$FtpTransferStatus", "Could not connect to " + this.HostName);
        }
    }

    public void dispose() {
        if (this.Connected) {
            try {
                this.logout();
            }
            catch (Exception exception) {
                MainWin.appendToLog("", "", Thread.currentThread(), exception, 4, "Error logging off ftp host.");
                Application.setTokenValue("$FtpTransferStatus", "Error logging off ftp host.");
            }
            this.disconnect();
            this.Connected = false;
        }
    }

    public boolean isConnected() {
        return this.Connected;
    }

    public String connect(String string, String string2, String string3) throws IOException, UnknownHostException, FTPConnectionClosedException {
        String string4 = "";
        boolean bl = false;
        if (this.HostPort < 0) {
            MainWin.appendToLog("TFtpClient", "connect", Thread.currentThread(), null, 3, "Connecting to: " + string + " on default port");
            Application.setTokenValue("$FtpTransferStatus", "Connecting to ftp host: " + string + " on default port");
            this.connect(string);
        } else {
            MainWin.appendToLog("TFtpClient", "connect", Thread.currentThread(), null, 3, "Connecting to: " + string + " on port " + this.HostPort);
            Application.setTokenValue("$FtpTransferStatus", "Connecting to ftp host: " + string + " on port " + this.HostPort);
            this.connect(string, this.HostPort);
        }
        int n = this.getReplyCode();
        if (FTPReply.isPositiveCompletion((int)n)) {
            bl = this.login(string2, string3);
        }
        if (bl) {
            this.Connected = true;
            string4 = "ok";
            MainWin.appendToLog("TFtpClient", "connect", Thread.currentThread(), null, 3, "Connected to " + string);
            Application.setTokenValue("$FtpTransferStatus", "Connected to " + string);
        } else {
            this.disconnect();
            string4 = "Could not connect to " + string;
            MainWin.appendToLog("TFtpClient", "connect", Thread.currentThread(), null, 3, string4);
            Application.setTokenValue("$FtpTransferStatus", string4);
        }
        return string4;
    }

    public void disconnect() {
        try {
            super.disconnect();
        }
        catch (Exception exception) {
            MainWin.appendToLog("TFtpClient", "disconnect", Thread.currentThread(), exception, 3, "Error disconnecting from FTP host.");
            Application.setTokenValue("$FtpTransferStatus", "Error disconnecting from FTP host.");
        }
        this.Connected = false;
    }

    public void setPassiveMode(boolean bl) {
        if (bl) {
            this.enterLocalPassiveMode();
        } else {
            this.enterLocalActiveMode();
        }
    }

    public boolean ascii() throws IOException {
        return this.setFileType(0);
    }

    public boolean binary() throws IOException {
        return this.setFileType(2);
    }

    public boolean downloadFile(String string, String string2) throws IOException, FTPConnectionClosedException {
        this.setBufferSize(0x100000);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        boolean bl = this.retrieveFile(string, fileOutputStream);
        fileOutputStream.close();
        return bl;
    }

    public boolean uploadFile(String string, String string2) throws IOException, FTPConnectionClosedException {
        FileInputStream fileInputStream = new FileInputStream(string);
        boolean bl = this.storeFile(string2, fileInputStream);
        fileInputStream.close();
        return bl;
    }

    public Vector listFileNames() throws IOException, FTPConnectionClosedException {
        FTPFile[] fTPFileArray = this.listFiles();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < fTPFileArray.length; ++i) {
            if (fTPFileArray[i].isDirectory()) continue;
            vector.addElement(fTPFileArray[i].getName());
        }
        return vector;
    }

    public String listFileNamesString() throws IOException, FTPConnectionClosedException {
        return this.vectorToString(this.listFileNames(), "\n");
    }

    public Vector listSubdirNames() throws IOException, FTPConnectionClosedException {
        FTPFile[] fTPFileArray = this.listFiles();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < fTPFileArray.length; ++i) {
            if (!fTPFileArray[i].isDirectory()) continue;
            vector.addElement(fTPFileArray[i].getName());
        }
        return vector;
    }

    public String listSubdirNamesString() throws IOException, FTPConnectionClosedException {
        return this.vectorToString(this.listSubdirNames(), "\n");
    }

    private String vectorToString(Vector vector, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        for (int i = 0; i < vector.size(); ++i) {
            stringBuilder.append(string2).append((String)vector.elementAt(i));
            string2 = string;
        }
        return stringBuilder.toString();
    }

    private void outputMessage(String string) {
        MainWin.appendToLog("TFtpClient", "transferFile", Thread.currentThread(), null, 3, string);
        Application.setTokenValue("$FtpTransferStatus", string);
    }

    public String transferFile(String string, String string2, boolean bl, int n) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        File file = null;
        File file2 = null;
        boolean bl2 = true;
        file = new File(string);
        if (!this.Connected) {
            string5 = "No connection";
        } else if (n == 0 && !file.exists()) {
            string5 = "Cannot find " + string;
        } else if (file.isDirectory()) {
            string5 = string + " is a directory, not a file.";
        }
        if (string5.length() > 0) {
            this.outputMessage(string5);
            return string5;
        }
        try {
            String[] stringArray = dosutil.splitPath(string2);
            if (stringArray[1] == null) {
                stringArray[1] = "/";
            }
            if (!(string3 = charutil.replaceChar(stringArray[1], '\\', '/')).startsWith("/")) {
                string3 = "/" + string3;
            }
            String[] stringArray2 = dosutil.splitPath(string);
            string4 = stringArray2[0] + stringArray2[1];
            file2 = new File(string4);
            if (n == 0) {
                MainWin.appendToLog("TFtpClient", "transferFile", Thread.currentThread(), null, 3, "Changing ftp directory to " + string3);
                Application.setTokenValue("$FtpTransferStatus", string5);
                if (!this.changeWorkingDirectory(string3) && !this.makeDirectory(string3)) {
                    string5 = "Unable to create directory named " + string3;
                    MainWin.appendToLog("TFtpClient", "transferFile", Thread.currentThread(), null, 3, string5);
                    Application.setTokenValue("$FtpTransferStatus", string5);
                }
                if (this.changeWorkingDirectory(string3)) {
                    string7 = stringArray[2];
                    if (stringArray[3] != null) {
                        string7 = string7 + stringArray[3];
                    }
                    this.outputMessage("Sending file: " + string + " as " + string7);
                    if (bl) {
                        this.binary();
                    }
                    this.setPassiveMode(this.Passive);
                    this.uploadFile(string, string7);
                    this.outputMessage("Finished sending " + string);
                    string5 = "ok";
                } else {
                    string5 = "Invalid directory: " + string3;
                    this.outputMessage(string5);
                }
            } else {
                boolean bl3 = false;
                if (file2.exists()) {
                    if (!file2.isDirectory()) {
                        string5 = "Invalid local directory: " + string4;
                        this.outputMessage(string5);
                        bl3 = true;
                    }
                } else if (!file2.mkdir()) {
                    string5 = "Unable to create local directory" + string4;
                    this.outputMessage(string5);
                    bl3 = true;
                }
                if (!bl3) {
                    this.outputMessage("Changing directory to: " + string3);
                    if (this.changeWorkingDirectory(string3)) {
                        string6 = stringArray[2] + stringArray[3];
                        this.outputMessage("Receiving file: " + string2 + " as " + string);
                        if (bl) {
                            this.binary();
                        }
                        if (this.downloadFile(stringArray[2] + stringArray[3], string)) {
                            this.outputMessage("Downloading " + string + " Complete.");
                            string5 = "ok";
                        } else {
                            string5 = "FTP download failed for " + string2;
                            MainWin.appendToLog("TFtpClient", "transferFile", Thread.currentThread(), null, 3, string5);
                            Application.setTokenValue("$FtpTransferStatus", string5);
                        }
                    } else {
                        string5 = "Invalid directory: " + string3;
                        this.outputMessage(string5);
                    }
                }
            }
        }
        catch (Exception exception) {
            string5 = exception.toString();
            this.outputMessage(string5);
        }
        return string5;
    }

    public String[] doCommandAsStrings(String string, String string2) {
        return null;
    }

    public static String transferFile(String string, String string2, String string3, boolean bl, String string4, String string5, int n) {
        TFtpClient tFtpClient = new TFtpClient(string, string2, string3, true, 0);
        tFtpClient.setPassiveMode(bl);
        String string6 = tFtpClient.transferFile(string4, string5, true, n);
        tFtpClient.dispose();
        return string6;
    }

    public static String transferFile(String string, String string2, String string3, int n) {
        Object[] objectArray = new String[1];
        Object[] objectArray2 = new String[1];
        int[] nArray = new int[1];
        objectArray[0] = string2;
        objectArray2[0] = string3;
        String[] stringArray = TFtpClient.transferFiles(string, objectArray, objectArray2, n);
        return stringArray[0];
    }

    public static String[] transferFiles(String string, Object[] objectArray, Object[] objectArray2, int n) {
        int n2;
        String[] stringArray = new String[objectArray.length];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray[n2] = "";
        }
        if (objectArray == null || objectArray.length == 0) {
            MainWin.appendToLog("TFtpClient", "transferFiles", Thread.currentThread(), null, 3, "No local file names given.");
            Application.setTokenValue("$FtpTransferStatus", "No local file names given.");
            return stringArray;
        }
        if (objectArray2 == null || objectArray2.length == 0) {
            MainWin.appendToLog("TFtpClient", "transferFiles", Thread.currentThread(), null, 3, "No ftp file names given.");
            Application.setTokenValue("$FtpTransferStatus", "No ftp file names given.");
            return stringArray;
        }
        if (objectArray2.length != objectArray.length) {
            MainWin.appendToLog("TFtpClient", "transferFiles", Thread.currentThread(), null, 3, "The number of local file names does not match the number of ftp file names.");
            Application.setTokenValue("$FtpTransferStatus", "The number of local file names does not match the number of ftp file names.");
            return stringArray;
        }
        TAspectDriver tAspectDriver = new TAspectDriver("FTPAccounts", 0, false, true, "");
        if (!tAspectDriver.isValid()) {
            MainWin.appendToLog("TAbstractDriver", "ftpSendFile", Thread.currentThread(), null, 4, "Count not open list of FTP accounts.");
            Application.setTokenValue("$FtpTransferStatus", "Count not open list of FTP accounts.");
            return stringArray;
        }
        int n3 = tAspectDriver.getMatchingRecord("FTPName=\"" + string + '\"');
        if (n3 < 0) {
            MainWin.appendToLog("TAbstractDriver", "ftpSendFile", Thread.currentThread(), null, 4, "Could not locate Ftp account information for " + string);
            Application.setTokenValue("$FtpTransferStatus", "Could not locate Ftp account information for " + string);
            return stringArray;
        }
        String string2 = (String)tAspectDriver.getField("FTPHost", n3);
        String string3 = (String)tAspectDriver.getField("FTPUserName", n3);
        String string4 = (String)tAspectDriver.getField("FTPPassword", n3);
        int n4 = (Integer)tAspectDriver.getField("FTPTimeZoneOffset", n3);
        boolean bl = (Boolean)tAspectDriver.getField("FTPPassive", n3);
        tAspectDriver.dispose();
        TFtpClient tFtpClient = new TFtpClient(string2, string3, string4, bl, n4);
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (Debug) {
                MainWin.appendToLog("TAbstractDriver", "ftpSendFile", Thread.currentThread(), null, 3, "calling transferFile for " + (String)objectArray[n2]);
            }
            stringArray[n2] = tFtpClient.transferFile((String)objectArray[n2], (String)objectArray2[n2], true, n);
        }
        tFtpClient.dispose();
        return stringArray;
    }

    public static String[] transferFiles(String string, String string2, String string3, boolean bl, Object[] objectArray, Object[] objectArray2, int n) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        if (objectArray == null || objectArray.length == 0) {
            MainWin.appendToLog("TFtpClient", "transferFiles", Thread.currentThread(), null, 3, "No local file names given.");
            Application.setTokenValue("$FtpTransferStatus", "No local file names given.");
            return stringArray;
        }
        if (objectArray2 == null || objectArray2.length == 0) {
            MainWin.appendToLog("TFtpClient", "transferFiles", Thread.currentThread(), null, 3, "No ftp file names given.");
            Application.setTokenValue("$FtpTransferStatus", "No ftp file names given.");
            return stringArray;
        }
        if (objectArray2.length != objectArray.length) {
            MainWin.appendToLog("TFtpClient", "transferFiles", Thread.currentThread(), null, 3, "The number of local file names does not match the number of ftp file names.");
            Application.setTokenValue("$FtpTransferStatus", "The number of local file names does not match the number of ftp file names.");
            return stringArray;
        }
        TFtpClient tFtpClient = new TFtpClient(string, string2, string3, bl, 0);
        for (int i = 0; i < objectArray.length; ++i) {
            if (Debug) {
                MainWin.appendToLog("TAbstractDriver", "ftpSendFile", Thread.currentThread(), null, 3, "calling transferFile for " + (String)objectArray[i]);
            }
            stringArray[i] = tFtpClient.transferFile((String)objectArray[i], (String)objectArray2[i], true, n);
        }
        tFtpClient.dispose();
        return stringArray;
    }

    public static String getFileNames(String string, String string2, String string3, boolean bl, String string4) {
        String string5 = "";
        TFtpClient tFtpClient = new TFtpClient(string, string2, string3, bl, 0);
        if (tFtpClient == null) {
            System.out.println("Error: getFilenames: FtpClient is null");
        }
        try {
            if (tFtpClient.changeWorkingDirectory(string4)) {
                string5 = tFtpClient.listFileNamesString();
            } else {
                string5 = "Error: Unable to set working directory: " + string4;
                MainWin.appendToLog("TFtpClient", "getFileNames", Thread.currentThread(), null, 3, string5);
            }
        }
        catch (Exception exception) {
            if (MainWin == null) {
                System.out.println("Error: getFileNames: " + exception.toString());
            }
            string5 = "Error getting directory listing for " + string4;
            MainWin.appendToLog("TFtpClient", "getFileNames", Thread.currentThread(), exception, 3, string5);
        }
        tFtpClient.dispose();
        return string5;
    }
}

