/*
 * Decompiled with CFR 0.152.
 */
package utility.firecracker;

import aspect.Aspect;
import aspect.TMainWin;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import utility.firecracker.X10Command;

public class FireCracker {
    private static TMainWin MainWin = Aspect.MainWin;
    private static boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugFirecracker");
    private static int ms_cyclesPerTenth = FireCracker.calibrate();
    private SerialPort m_port;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openPort(String string) throws PortInUseException, NoSuchPortException {
        FireCracker fireCracker = this;
        synchronized (fireCracker) {
            if (this.m_port != null) {
                this.closePort();
            }
            this.m_port = FireCracker.getCommPort(string);
            this.sendWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePort() {
        FireCracker fireCracker = this;
        synchronized (fireCracker) {
            this.m_port.close();
            this.m_port = null;
        }
    }

    public void sendCommand(X10Command x10Command) {
        this.sendBits("11010101 10101010 " + x10Command.getBits() + " " + "10101101");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBits(String string) {
        FireCracker fireCracker = this;
        synchronized (fireCracker) {
            int n;
            while (string.length() > 0) {
                n = string.charAt(0);
                if (n == 49) {
                    this.sendOne();
                    this.sendWait();
                } else if (n == 48) {
                    this.sendZero();
                    this.sendWait();
                }
                string = string.substring(1);
            }
            for (n = 0; n < 100; ++n) {
                FireCracker.waitForBitDelay();
            }
        }
    }

    private void sendOne() {
        FireCracker.waitForBitDelay();
        this.m_port.setRTS(true);
        this.m_port.setDTR(false);
    }

    private void sendZero() {
        FireCracker.waitForBitDelay();
        this.m_port.setDTR(true);
        this.m_port.setRTS(false);
    }

    private void sendWait() {
        FireCracker.waitForBitDelay();
        this.m_port.setRTS(true);
        this.m_port.setDTR(true);
    }

    private static void waitForBitDelay() {
        for (int i = 10 * ms_cyclesPerTenth; i >= 0; --i) {
        }
    }

    private static SerialPort getCommPort(String string) throws PortInUseException, NoSuchPortException {
        CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string);
        CommPort commPort = commPortIdentifier.open("SEntrySentry", 2000);
        return (SerialPort)commPort;
    }

    private static int calibrate() {
        int n = 1000;
        while (true) {
            long l = System.currentTimeMillis();
            for (int i = 0; i < n; ++i) {
            }
            long l2 = System.currentTimeMillis() - l;
            if (l2 > 100L) {
                int n2 = (int)((long)n / l2);
                return n2 / 10;
            }
            n *= 10;
        }
    }

    public static String x10SendCommand(String string, char c, int n, String string2) {
        String string3 = "ok";
        try {
            FireCracker fireCracker = new FireCracker();
            fireCracker.openPort(string.toUpperCase());
            X10Command x10Command = null;
            if (Debug) {
                String string4 = "Firecracker AHouseCode=" + c + " AUnit=" + n + " ACommand=" + string2;
                MainWin.appendToLog("TDriverMerge", "merge", Thread.currentThread(), null, 10, string4);
            }
            if (string2.equalsIgnoreCase("ON")) {
                x10Command = X10Command.makeOnCommand(c, n);
            } else if (string2.equalsIgnoreCase("OFF")) {
                x10Command = X10Command.makeOffCommand(c, n);
            } else if (string2.equalsIgnoreCase("BRIGHT")) {
                x10Command = X10Command.makeBrightCommand(c);
            } else if (string2.equalsIgnoreCase("DIM")) {
                x10Command = X10Command.makeDimCommand(c);
            } else {
                string3 = "Unrecognized x10 command: " + string2;
            }
            if (x10Command != null) {
                fireCracker.sendCommand(x10Command);
            }
            fireCracker.closePort();
        }
        catch (PortInUseException portInUseException) {
            string3 = "Error executing x10 command.  Specified port in use by application: " + portInUseException.currentOwner;
        }
        catch (NoSuchPortException noSuchPortException) {
            string3 = "Error executing x10 command.  Port not recognized: " + string;
        }
        return string3;
    }
}

