/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;
import utility.charutil;

public class dateutil {
    static final String[] arDatePatterns = new String[]{"M-d-yy", "MM-dd-yyyy", "MMddyy", "MMddyyyy", "yyyy-MM-dd"};
    static final String[] arTimePatterns = new String[]{"hh:mm aa", "HHmm", "HH:mm", "HH:mm:ss"};
    private static String sLastErr = "";
    static Date dtTest = null;

    public static SimpleDateFormat getDateTimeFormat(int n) {
        SimpleDateFormat simpleDateFormat;
        switch (n) {
            case 0: {
                simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(2);
                break;
            }
            case 1: {
                simpleDateFormat = (SimpleDateFormat)DateFormat.getTimeInstance(3);
                break;
            }
            case 2: {
                simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 3);
                break;
            }
            case 3: {
                simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 3);
                break;
            }
            default: {
                simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 3);
            }
        }
        return simpleDateFormat;
    }

    public static String formatDate(Date date, String string) {
        String string2 = "MM-dd-yy";
        DateFormat dateFormat = DateFormat.getInstance();
        if (string != null && string.length() > 0) {
            string2 = string;
        }
        if (dateFormat instanceof SimpleDateFormat) {
            ((SimpleDateFormat)dateFormat).applyPattern(string2);
        }
        return dateFormat.format(date);
    }

    public static String formatDate(Date date) {
        return dateutil.formatDate(date, "MM-dd-yyyy");
    }

    public static String formatDate(long l) {
        return dateutil.formatDate(new Date(l), "MM-dd-yyyy");
    }

    public static String formatDate(Calendar calendar, String string) {
        return dateutil.formatDate(calendar.getTime(), string);
    }

    public static synchronized Date parseDateString(String[] stringArray, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        Date date = null;
        boolean bl = false;
        if (string.trim().length() == 0) {
            return new Date();
        }
        if (string.trim().equalsIgnoreCase("0")) {
            return new Date(0L);
        }
        for (int i = 0; date == null && i < stringArray.length; ++i) {
            try {
                if (stringArray[i].trim().length() <= 0) continue;
                simpleDateFormat.applyPattern(stringArray[i]);
                date = simpleDateFormat.parse(string);
                if (!bl) continue;
                System.out.println(date + " using pattern " + stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (date == null) {
            String string2 = "Error: Cannot parse date: " + string;
            if (!string2.equalsIgnoreCase(sLastErr)) {
                sLastErr = string2;
            }
            date = new Date();
        }
        return date;
    }

    public static boolean isValidDate(String string, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        if (string2.length() > 0) {
            try {
                simpleDateFormat.applyPattern(string2);
                Date date = simpleDateFormat.parse(string);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        String string3 = charutil.replaceChar(string, '/', '-');
        Date date = null;
        for (int i = 0; date == null && i < arDatePatterns.length; ++i) {
            try {
                if (arDatePatterns[i].trim().length() <= 0) continue;
                simpleDateFormat.applyPattern(arDatePatterns[i]);
                date = simpleDateFormat.parse(string3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return date != null;
    }

    public static boolean isValidTime(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        Date date = null;
        for (int i = 0; date == null && i < arTimePatterns.length; ++i) {
            try {
                if (arTimePatterns[i].trim().length() <= 0) continue;
                simpleDateFormat.applyPattern(arTimePatterns[i]);
                date = simpleDateFormat.parse(string);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return date != null;
    }

    public static Date parseDate(String string) {
        String string2 = charutil.replaceChar(string, '/', '-');
        if (string2.trim().length() == 0) {
            return new Date(0L);
        }
        if (string2.length() < 5) {
            System.out.println("Error: Invalid date string in parseDate: " + string);
            return new Date(0L);
        }
        if (string2.length() == 7 && (string2.charAt(4) == '-' || string2.charAt(4) == '/')) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
            simpleDateFormat.applyPattern("yyyy-MM");
            try {
                Date date = simpleDateFormat.parse(string2);
                return date;
            }
            catch (Exception exception) {
                System.out.println("Error parsing date: " + string2);
                System.out.println(exception.toString());
                return new Date(0L);
            }
        }
        if (string2.length() > 10 && string2.charAt(10) == 'T') {
            string2 = charutil.replaceChar(string2, 'T', ' ');
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
            simpleDateFormat.applyPattern("yyyy-MM-dd HH:mm");
            try {
                Date date = simpleDateFormat.parse(string2);
                return date;
            }
            catch (Exception exception) {
                System.out.println("Error parsing date: " + string2);
                System.out.println(exception.toString());
                return new Date(0L);
            }
        }
        int n = string2.indexOf(45);
        if (n == 4) {
            string2 = string2.substring(5) + "-" + string2.substring(0, 4);
        }
        return dateutil.parseDateString(arDatePatterns, string2);
    }

    public static Date parseTime(String string) {
        return dateutil.parseDateString(arTimePatterns, string);
    }

    public static Date parseDateTime(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        if (string.length() > 10 && string.charAt(4) == '-' && string.charAt(10) == 'T') {
            String string2 = charutil.replaceChar(string, 'T', ' ');
            string2 = charutil.replaceChar(string2, '/', '-');
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat();
            simpleDateFormat2.applyPattern("yyyy-MM-dd HH:mm");
            try {
                Date date = simpleDateFormat2.parse(string2);
                return date;
            }
            catch (Exception exception) {
                System.out.println("Error parsing date: " + string2);
                System.out.println(exception.toString());
                return new Date(0L);
            }
        }
        if (string.length() > 10 && string.charAt(4) == '-' && string.charAt(10) == ' ') {
            String string3 = charutil.replaceChar(string, '/', '-');
            SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat();
            simpleDateFormat3.applyPattern("yyyy-MM-dd HH:mm");
            try {
                Date date = simpleDateFormat3.parse(string);
                return date;
            }
            catch (Exception exception) {
                System.out.println("Error parsing date: " + string);
                System.out.println(exception.toString());
                return new Date(0L);
            }
        }
        Date date = new Date();
        StringBuilder stringBuilder = new StringBuilder();
        charutil.replace_char(stringBuilder, new StringBuilder(string.trim()), '/', '-');
        int n = stringBuilder.indexOf("-");
        int n2 = stringBuilder.indexOf(":");
        int n3 = stringBuilder.indexOf(" ");
        simpleDateFormat.applyPattern("EEE MMM dd HH:mm:ss z yyyy");
        try {
            date = simpleDateFormat.parse(stringBuilder.toString());
            return date;
        }
        catch (Exception exception) {
            if (stringBuilder.length() >= 8 && stringBuilder.indexOf("-") < 0 && charutil.ival(stringBuilder.substring(0, 2)) > 12) {
                if (n2 < 0 && n3 < 0) {
                    try {
                        simpleDateFormat.applyPattern("yyyyMMdd");
                        date = simpleDateFormat.parse(stringBuilder.toString());
                    }
                    catch (Exception exception2) {
                        date.setTime(0L);
                    }
                    return date;
                }
                try {
                    simpleDateFormat.applyPattern("yyyyMMdd HHmmss");
                    date = simpleDateFormat.parse(stringBuilder.toString());
                }
                catch (Exception exception3) {
                    date.setTime(0L);
                }
                if (date.getTime() == 0L) {
                    try {
                        simpleDateFormat.applyPattern("yyyyMMdd HHmm");
                        date = simpleDateFormat.parse(stringBuilder.toString());
                    }
                    catch (Exception exception4) {
                        date.setTime(0L);
                    }
                }
                return date;
            }
            if (stringBuilder.length() >= 10 && stringBuilder.charAt(4) == '-' && stringBuilder.charAt(7) == '-') {
                if (n2 < 0) {
                    try {
                        simpleDateFormat.applyPattern("yyyy-MM-dd");
                        date = simpleDateFormat.parse(stringBuilder.toString());
                    }
                    catch (Exception exception5) {
                        date.setTime(0L);
                    }
                    return date;
                }
                try {
                    simpleDateFormat.applyPattern("yyyy-MM-dd HH:mm:ss");
                    date = simpleDateFormat.parse(stringBuilder.toString());
                }
                catch (Exception exception6) {
                    date.setTime(0L);
                }
                return date;
            }
            if (n >= 0 && n2 < 0) {
                return dateutil.parseDate(string);
            }
            if (n < 0 && n2 >= 0) {
                return dateutil.parseTime(string);
            }
            String[] stringArray = new String[arDatePatterns.length * arTimePatterns.length];
            n = 0;
            for (int i = 0; i < arDatePatterns.length; ++i) {
                for (int j = 0; j < arTimePatterns.length; ++j) {
                    stringArray[n] = arDatePatterns[i] + " " + arTimePatterns[j];
                    ++n;
                }
            }
            return dateutil.parseDateString(stringArray, stringBuilder.toString());
        }
    }

    public static Date parseDate(String string, String string2) {
        String string3 = string2;
        String string4 = charutil.replaceChar(string, '/', '-');
        if (string4.length() > 4 && string4.charAt(4) == '-') {
            if (string2.equalsIgnoreCase("mm-dd-yyyy")) {
                string3 = "yyyy-mm-dd";
            } else if (string2.equalsIgnoreCase("mm/dd/yyyy")) {
                string3 = "yyyy/mm/dd";
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
        try {
            Date date = simpleDateFormat.parse(string);
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Date parseDate(String string, SimpleDateFormat simpleDateFormat) {
        try {
            Date date = simpleDateFormat.parse(string);
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int compDate(Date date, Date date2) {
        long l;
        long l2 = date.getTime();
        if (l2 < (l = date2.getTime())) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        return 0;
    }

    public static String makeAspectDate(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(2) + 1;
        int n2 = gregorianCalendar.get(5);
        int n3 = gregorianCalendar.get(1);
        StringBuilder stringBuilder = new StringBuilder(Integer.toString(n));
        if (stringBuilder.length() == 1) {
            stringBuilder.insert(0, '0');
        }
        stringBuilder.append('-');
        StringBuilder stringBuilder2 = new StringBuilder(Integer.toString(n2));
        if (stringBuilder2.length() == 1) {
            stringBuilder2.insert(0, '0');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append('-');
        while (n3 >= 100) {
            n3 -= 100;
        }
        stringBuilder2 = new StringBuilder(Integer.toString(n3));
        if (stringBuilder2.length() == 1) {
            stringBuilder2.insert(0, '0');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        return stringBuilder.toString();
    }

    public static GregorianCalendar adjustTime(GregorianCalendar gregorianCalendar, int n) {
        Date date = gregorianCalendar.getTime();
        date.setTime(date.getTime() + (long)n);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date);
        return gregorianCalendar2;
    }

    public static Date roundTime(Date date, String string, String string2) {
        String string3 = "SECOND|MINUTE|HOUR";
        String string4 = "UP|DOWN|NEAR";
        long l = 0L;
        long l2 = date.getTime();
        int n = string3.indexOf(string.toUpperCase());
        if (n < 0) {
            System.out.println("Unrecognized param in roundTime: " + string);
            return date;
        }
        switch (n) {
            case 0: {
                l = 1000L;
                break;
            }
            case 7: {
                l = 60000L;
                break;
            }
            case 14: {
                l = 3600000L;
            }
        }
        long l3 = l2 % l;
        n = string4.indexOf(string2.toUpperCase());
        if (n < 0) {
            System.out.println("Unrecognized method in roundTime: " + string2);
            return date;
        }
        switch (n) {
            case 0: {
                if (l3 <= 0L) break;
                l2 = ((long)Math.floor(l2 / l) + 1L) * l;
                break;
            }
            case 3: {
                if (l3 <= 0L) break;
                l2 = (long)Math.floor(l2 / l) * l;
                break;
            }
            case 8: {
                l2 = (long)Math.floor((l2 + l / 2L) / l) * l;
            }
        }
        return new Date(l2);
    }

    public static String formatElapsedTime(int n, String string, boolean bl) {
        int n2 = n;
        String string2 = string.toUpperCase();
        int[] nArray = new int[]{86400000, 3600000, 60000, 1000};
        String[] stringArray = new String[]{"day", "hour", "minute", "second"};
        String[] stringArray2 = new String[]{"day", "hour", "min", "sec"};
        char[] cArray = new char[]{'D', 'H', 'M', 'S'};
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).applyPattern("0");
        }
        String string3 = "";
        int n3 = -1;
        for (int i = 0; i < 4; ++i) {
            boolean bl2 = string2.indexOf(cArray[i]) >= 0;
            boolean bl3 = bl2 = bl2 || n2 > 0 && n3 == 0;
            if (!bl2 || (n3 = n2 / nArray[i]) <= 0) continue;
            boolean bl4 = false;
            for (int j = i + 1; j < 4; ++j) {
                if (string2.indexOf(cArray[j]) < 0) continue;
                bl4 = true;
            }
            string3 = bl4 || i == 3 ? string3 + Integer.toString(n3) + " " : string3 + numberFormat.format(Math.round((double)n2 / (double)nArray[i])) + " ";
            if (bl) {
                string3 = string3 + stringArray2[i];
            } else {
                string3 = string3 + stringArray[i];
                if (n3 > 1) {
                    string3 = string3 + "s";
                }
            }
            string3 = string3 + " ";
            n2 = Math.max(0, n2 - n3 * nArray[i]);
        }
        return string3;
    }

    public static Date getCurrentBusinessDay(String string) {
        String[] stringArray;
        Date date = new Date();
        if (dtTest != null) {
            date = dtTest;
        }
        if ((stringArray = charutil.getSubStringArray(string, ':', false)) == null || stringArray.length < 2) {
            return null;
        }
        int n = charutil.ival(stringArray[0]) * 60 + charutil.ival(stringArray[1]);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n2 = gregorianCalendar.get(11) * 60 + gregorianCalendar.get(12);
        if (n < 720) {
            if (n2 < n) {
                gregorianCalendar.add(5, -1);
            }
        } else if (n2 >= n) {
            gregorianCalendar.add(5, 1);
        }
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTime();
    }

    public static Date getLastBusinessDay(String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(dateutil.getCurrentBusinessDay(string));
        gregorianCalendar.add(5, -1);
        return gregorianCalendar.getTime();
    }

    public static Date getCurrentWeekStart(String string, int n) {
        Date date = dateutil.getCurrentBusinessDay(string);
        if (date == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        while (gregorianCalendar.get(7) - 1 != n) {
            gregorianCalendar.add(5, -1);
        }
        return gregorianCalendar.getTime();
    }

    public static Date getCurrentWeekEnd(String string, int n) {
        Date date = dateutil.getCurrentWeekStart(string, n);
        if (date == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.add(5, 6);
        return gregorianCalendar.getTime();
    }

    public static Date getLastWeekStart(String string, int n) {
        Date date = dateutil.getCurrentBusinessDay(string);
        if (date == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        while (gregorianCalendar.get(7) - 1 != n) {
            gregorianCalendar.add(5, -1);
        }
        gregorianCalendar.add(5, -1);
        while (gregorianCalendar.get(7) - 1 != n) {
            gregorianCalendar.add(5, -1);
        }
        return gregorianCalendar.getTime();
    }

    public static Date getLastWeekEnd(String string, int n) {
        Date date = dateutil.getLastWeekStart(string, n);
        if (date == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.add(5, 6);
        return gregorianCalendar.getTime();
    }

    public static Date incrementMonth(Date date, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.add(2, n);
        return gregorianCalendar.getTime();
    }

    public static Date getWeekEnd(int n, Date date, int n2) {
        if (n2 < 1 || n2 > 7) {
            System.out.println("Error: Invalid DayOfWeek in getWeekEnd: " + n2);
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        while (gregorianCalendar.get(7) != n2) {
            gregorianCalendar.add(5, 1);
        }
        gregorianCalendar.add(5, 7 * n);
        return gregorianCalendar.getTime();
    }

    public static Date getWeekStart(int n, Date date, int n2) {
        if (n2 < 1 || n2 > 7) {
            System.out.println("Error: Invalid DayOfWeek in getWeekEnd: " + n2);
            return null;
        }
        Date date2 = dateutil.getWeekEnd(n, date, n2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date2);
        gregorianCalendar.add(5, -6);
        return gregorianCalendar.getTime();
    }

    public static Date getMonthEnd(int n, Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(5, 1);
        if (n != 0) {
            gregorianCalendar.add(2, n);
        }
        gregorianCalendar.set(5, gregorianCalendar.getActualMaximum(5));
        return gregorianCalendar.getTime();
    }

    public static Date getMonthStart(int n, Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(5, 1);
        if (n != 0) {
            gregorianCalendar.add(2, n);
        }
        return gregorianCalendar.getTime();
    }

    public static Date getQuarterStart(int n, Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        gregorianCalendar.set(5, 1);
        while (gregorianCalendar.get(2) != 0 && gregorianCalendar.get(2) != 3 && gregorianCalendar.get(2) != 6 && gregorianCalendar.get(2) != 9) {
            gregorianCalendar.add(2, -1);
        }
        if (n != 0) {
            gregorianCalendar.add(2, 3 * n);
        }
        return gregorianCalendar.getTime();
    }

    public static Date getQuarterEnd(int n, Date date) {
        Date date2 = dateutil.getQuarterStart(0, date);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date2);
        gregorianCalendar.add(2, 3);
        gregorianCalendar.add(5, -1);
        if (n != 0) {
            gregorianCalendar.add(2, 3 * n);
        }
        return gregorianCalendar.getTime();
    }

    public static Date getYearStart(int n, Date date, int n2, int n3) {
        if (n2 < 0 || n2 > 7) {
            System.out.println("Error: Invalid DayOfWeek in getWeekEnd: " + n2);
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(2, 0);
        gregorianCalendar.set(5, 1);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        if (n != 0) {
            gregorianCalendar.add(1, n);
        }
        if (n2 >= 1) {
            for (int i = 0; i < 10 && gregorianCalendar.get(7) != n2; ++i) {
                System.out.println("getYearStart DAY_OF_WEEK=" + gregorianCalendar.get(7) + " DayOfWeek=" + n2);
                if (n3 == 1) {
                    gregorianCalendar.add(5, 1);
                    continue;
                }
                gregorianCalendar.add(5, -1);
            }
        }
        return gregorianCalendar.getTime();
    }

    public static Date getYearEnd(int n, Date date, int n2, int n3) {
        if (n2 < 0 || n2 > 7) {
            System.out.println("Error: Invalid DayOfWeek in getWeekEnd: " + n2);
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(2, 11);
        gregorianCalendar.set(5, 31);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        if (n != 0) {
            gregorianCalendar.add(1, n);
        }
        if (n2 >= 1) {
            for (int i = 0; i < 10 && gregorianCalendar.get(7) != n2; ++i) {
                System.out.println("getYearStart DAY_OF_WEEK=" + gregorianCalendar.get(7) + " DayOfWeek=" + n2);
                if (n3 == 1) {
                    gregorianCalendar.add(5, 1);
                    continue;
                }
                gregorianCalendar.add(5, -1);
            }
        }
        return gregorianCalendar.getTime();
    }

    public static Date getLastOccurrenceOfDay(Date date, String string) {
        int n = 0;
        if (string.toUpperCase().startsWith("SUN")) {
            n = 1;
        } else if (string.toUpperCase().startsWith("MON")) {
            n = 2;
        } else if (string.toUpperCase().startsWith("TUE")) {
            n = 3;
        } else if (string.toUpperCase().startsWith("WED")) {
            n = 4;
        } else if (string.toUpperCase().startsWith("THU")) {
            n = 5;
        } else if (string.toUpperCase().startsWith("FRI")) {
            n = 6;
        } else if (string.toUpperCase().startsWith("SAT")) {
            n = 7;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        while (gregorianCalendar.get(7) != n) {
            gregorianCalendar.add(5, -1);
        }
        return gregorianCalendar.getTime();
    }

    public static Date date(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTime();
    }

    public static boolean InDaylightSavings(Date date) {
        Properties properties = System.getProperties();
        TimeZone timeZone = TimeZone.getTimeZone(properties.getProperty("user.timezone"));
        return timeZone.inDaylightTime(date);
    }

    public static int getGMTOffset(Date date) {
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getOffset(date.getTime()) / 1000 / 60 / 60;
        return n;
    }
}

