/*
 * Decompiled with CFR 0.152.
 */
package utility.aws;

import aspect.Aspect;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.List;
import utility.TFile;

public class s3 {
    public static AWSCredentials getCredentials() {
        AWSCredentials aWSCredentials = null;
        try {
            aWSCredentials = new ProfileCredentialsProvider().getCredentials();
        }
        catch (Exception exception) {
            if (Aspect.MainWin == null) {
                System.out.println(exception.toString());
            } else {
                Aspect.MainWin.appendToLog("s3", "getCredentials", Thread.currentThread(), exception, 4, "Cannot load the credentials from the credential profiles file");
            }
            return null;
        }
        return aWSCredentials;
    }

    public static AmazonS3 getS3Instance() {
        AmazonS3Client amazonS3Client = null;
        try {
            AWSCredentials aWSCredentials = s3.getCredentials();
            amazonS3Client = new AmazonS3Client(aWSCredentials);
        }
        catch (Exception exception) {
            if (Aspect.MainWin == null) {
                System.out.println(exception.toString());
            } else {
                Aspect.MainWin.appendToLog("aws", "getS3Instance", Thread.currentThread(), exception, 4, "Error in getS3Instance");
            }
            return null;
        }
        return amazonS3Client;
    }

    public static String[] listBuckets() {
        System.setProperty("com.amazonaws.sdk.disableCertChecking", "true");
        AmazonS3 amazonS3 = s3.getS3Instance();
        if (amazonS3 == null) {
            return null;
        }
        try {
            List list = amazonS3.listBuckets();
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = ((Bucket)list.get(i)).getName();
            }
            return stringArray;
        }
        catch (Exception exception) {
            if (Aspect.MainWin == null) {
                System.out.println(exception.toString());
            } else {
                Aspect.MainWin.appendToLog("aws", "listBuckets", Thread.currentThread(), exception, 4, "Error in listBuckets");
            }
            return null;
        }
    }

    public static String[] listKeys(String string) {
        System.setProperty("com.amazonaws.sdk.disableCertChecking", "true");
        AmazonS3 amazonS3 = s3.getS3Instance();
        if (amazonS3 == null) {
            return null;
        }
        try {
            System.out.println("A: " + string);
            ObjectListing objectListing = amazonS3.listObjects(string);
            System.out.println("B");
            List list = objectListing.getObjectSummaries();
            System.out.println("C");
            String[] stringArray = new String[list.size()];
            System.out.println("D");
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = ((S3ObjectSummary)list.get(i)).getKey();
            }
            System.out.println("E");
            return stringArray;
        }
        catch (Exception exception) {
            if (Aspect.MainWin == null) {
                System.out.println(exception.toString());
            } else {
                Aspect.MainWin.appendToLog("aws", "listKeys", Thread.currentThread(), exception, 4, "Error in listBuckets");
            }
            return null;
        }
    }

    public static String[] listKeys(String string, String string2) {
        System.setProperty("com.amazonaws.sdk.disableCertChecking", "true");
        AmazonS3 amazonS3 = s3.getS3Instance();
        if (amazonS3 == null) {
            return null;
        }
        try {
            String string3 = string2;
            if (!string3.endsWith("/")) {
                string3 = string3 + "/";
            }
            System.out.println("A: " + string + " Prefix=" + string3);
            ObjectListing objectListing = amazonS3.listObjects(string, string3);
            System.out.println("B");
            List list = objectListing.getObjectSummaries();
            System.out.println("list size=" + list.size());
            String[] stringArray = new String[list.size()];
            System.out.println("D");
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = ((S3ObjectSummary)list.get(i)).getKey();
                String string4 = ((S3ObjectSummary)list.get(i)).getBucketName();
                String string5 = ((S3ObjectSummary)list.get(i)).toString();
                System.out.println("key[" + i + "]=" + stringArray[i] + " Bucket=" + string4 + " toString=" + string5);
            }
            System.out.println("E");
            return stringArray;
        }
        catch (Exception exception) {
            if (Aspect.MainWin == null) {
                System.out.println(exception.toString());
            } else {
                Aspect.MainWin.appendToLog("aws", "listKeys", Thread.currentThread(), exception, 4, "Error in listBuckets");
            }
            return null;
        }
    }

    public static S3Object getObject(String string, String string2) {
        System.setProperty("com.amazonaws.sdk.disableCertChecking", "true");
        AmazonS3 amazonS3 = s3.getS3Instance();
        if (amazonS3 == null) {
            return null;
        }
        S3Object s3Object = null;
        try {
            s3Object = amazonS3.getObject(new GetObjectRequest(string, string2));
        }
        catch (Exception exception) {
            if (Aspect.MainWin == null) {
                System.out.println(exception.toString());
            }
            Aspect.MainWin.appendToLog("aws", "getObject", Thread.currentThread(), exception, 4, "Error in getObject");
        }
        return s3Object;
    }

    public static Date getLastModified(S3Object s3Object) {
        try {
            return s3Object.getObjectMetadata().getLastModified();
        }
        catch (Exception exception) {
            if (Aspect.MainWin == null) {
                System.out.println(exception.toString());
            } else {
                Aspect.MainWin.appendToLog("s3", "getLastModified", Thread.currentThread(), exception, 4, "Error in getLastModified");
            }
            return new Date(0L);
        }
    }

    public static long getLength(S3Object s3Object) {
        try {
            return s3Object.getObjectMetadata().getContentLength();
        }
        catch (Exception exception) {
            if (Aspect.MainWin == null) {
                System.out.println(exception.toString());
            } else {
                Aspect.MainWin.appendToLog("s3", "getLength", Thread.currentThread(), exception, 4, "Error in getLength");
            }
            return 0L;
        }
    }

    public static boolean downloadObject(S3Object s3Object, String string) {
        System.setProperty("com.amazonaws.sdk.disableCertChecking", "true");
        S3ObjectInputStream s3ObjectInputStream = null;
        try {
            s3ObjectInputStream = s3Object.getObjectContent();
            TFile tFile = new TFile(string);
            tFile.validatePathToFile(true);
            if (tFile.exists()) {
                tFile.delete();
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rwd");
            int n = 0;
            int n2 = 0;
            byte[] byArray = new byte[2048];
            do {
                if ((n2 = s3ObjectInputStream.read(byArray, 0, byArray.length)) < 0) continue;
                randomAccessFile.write(byArray, 0, n2);
                n += n2;
            } while (n2 > 0);
            randomAccessFile.close();
            s3ObjectInputStream.close();
            if (Aspect.MainWin == null) {
                System.out.println("Downloaded " + s3Object.getBucketName() + "/" + s3Object.getKey() + " to " + string);
            } else {
                Aspect.MainWin.appendToLog("s3", "downloadObject", Thread.currentThread(), null, 3, "Downloaded " + s3Object.getBucketName() + "/" + s3Object.getKey() + " to " + string);
            }
        }
        catch (Exception exception) {
            if (Aspect.MainWin == null) {
                System.out.println(exception.toString());
            } else {
                Aspect.MainWin.appendToLog("s3", "downloadObject", Thread.currentThread(), exception, 4, "Error downloading " + s3Object.getBucketName() + "/" + s3Object.getKey());
            }
            try {
                if (s3ObjectInputStream != null) {
                    s3ObjectInputStream.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return false;
        }
        return true;
    }
}

