/*
 * Decompiled with CFR 0.152.
 */
package utility;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import pub.exec;
import resources.TApplication;
import utility.asciifiles.TAsciiInput;
import utility.asciifiles.TAsciiOutput;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.notifications.TNotification_ClientSide;
import utility.security.TPasswordService;

public class TService {
    private static TMainWin MainWin = Aspect.MainWin;
    private static TApplication Application = TMainWin.Application;
    public static String[] arAspectLaunchFiles = new String[]{"AspectLaunch.jar"};
    public static String[] arAspect7BetaFiles = new String[]{"Aspect7Beta.jar"};
    public static String[] arAspect7Files = new String[]{"Aspect7.jar"};

    public static String getJavaHome() {
        return System.getProperty("java.home");
    }

    public static byte[] readInputStream(InputStream inputStream) {
        try {
            byte[] byArray = new byte[65536];
            byte[] byArray2 = null;
            int n = 0;
            int n2 = 0;
            do {
                if ((n = inputStream.read(byArray)) < 0) continue;
                byArray2 = byArray2 == null ? (byArray2 = new byte[n]) : (byte[])charutil.arrayGrow(byArray2, byArray2.length + n);
                System.arraycopy(byArray, 0, byArray2, n2, n);
                n2 += n;
            } while (n >= 0);
            return byArray2;
        }
        catch (Exception exception) {
            System.out.println("readInputStream: " + exception.toString());
            return null;
        }
    }

    public static byte[] getURL(String string) {
        try {
            URL uRL = new URL(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            byte[] byArray = TService.readInputStream(bufferedInputStream);
            bufferedInputStream.close();
            return byArray;
        }
        catch (Exception exception) {
            System.out.println("getURL: " + exception.toString());
            return null;
        }
    }

    public static byte[] getFile(String string) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.read(byArray);
            randomAccessFile.close();
            return byArray;
        }
        catch (Exception exception) {
            System.out.println("getFile: " + exception.toString());
            return null;
        }
    }

    public static byte[] getJarEntry(String string, String string2) {
        try {
            URL uRL = new URL("jar:file:/" + string + "!/" + charutil.replaceChar(string2, '\\', '/'));
            InputStream inputStream = uRL.openStream();
            if (inputStream == null) {
                System.out.println("getJarEntry: Cannot get inputstream: " + string2 + " in jar " + string);
                return null;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = TService.readInputStream(bufferedInputStream);
            bufferedInputStream.close();
            return byArray;
        }
        catch (Exception exception) {
            System.out.println("getJarEntry: " + exception.toString());
            return null;
        }
    }

    public static boolean writeFile(String string, byte[] byArray) {
        return TService.writeFile(string, byArray, false);
    }

    public static boolean writeFile(String string, byte[] byArray, boolean bl) {
        try {
            File file;
            String string2;
            String[] stringArray = dosutil.splitPath(string);
            String string3 = string2 = stringArray[0] != null ? stringArray[0] : "\\";
            if (stringArray[1] != null) {
                string2 = string2 + stringArray[1];
            }
            if (!(file = new File(charutil.replaceChar(dosutil.removeTrailingSlash(string2), '\\', '/'))).exists()) {
                file.mkdirs();
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            if (bl) {
                randomAccessFile.seek(randomAccessFile.length());
            } else {
                randomAccessFile.setLength(0L);
            }
            randomAccessFile.write(byArray);
            randomAccessFile.close();
            return true;
        }
        catch (Exception exception) {
            System.out.println("writeFile: " + exception.toString());
            return false;
        }
    }

    public static String byteToString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append((char)byArray[i]);
        }
        return stringBuilder.toString();
    }

    public static byte[] stringToByte(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    public static boolean copyResource(String string, String string2) {
        if (string.toUpperCase().startsWith("HTTP")) {
            byte[] byArray = TService.getURL(string);
            if (byArray != null) {
                return TService.writeFile(string2, byArray);
            }
        } else {
            int n = string.toUpperCase().indexOf(".ZIP");
            if (n < 0) {
                n = string.toUpperCase().indexOf(".JAR");
            }
            if (n > 0) {
                String string3;
                String string4 = string.substring(0, n + 4);
                byte[] byArray = TService.getJarEntry(string4, string3 = string.substring(n + 5));
                if (byArray != null) {
                    return TService.writeFile(string2, byArray);
                }
            } else {
                byte[] byArray = TService.getFile(string);
                if (byArray != null) {
                    return TService.writeFile(string2, byArray);
                }
            }
        }
        return false;
    }

    public static boolean validateFileSet(String string, String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + stringArray[i];
            if (dosutil.fileExists(string2)) {
                if (dosutil.fileSize(string2) == 0) {
                    bl = false;
                }
                MainWin.appendToLog("TService", "validateFileSet", Thread.currentThread(), null, 3, "Validate: " + string2 + "," + dosutil.fileSize(string2) + "," + dateutil.formatDate(dosutil.fileModified(string2), "MM-dd-yyyy HH:mm:ss"));
                continue;
            }
            MainWin.appendToLog("TService", "validateFileSet", Thread.currentThread(), null, 3, "Validate: " + string2 + " not found");
            bl = false;
        }
        return bl;
    }

    public static boolean updateFiles(String string, String[] stringArray, String string2, String string3) {
        boolean bl = TService.validateFileSet(string, stringArray);
        if (!bl) {
            byte[] byArray = TService.getURL(string2);
            if (byArray == null && string3.length() > 0) {
                byArray = TService.getURL(string3);
            }
            if (byArray != null && byArray.length > 0) {
                String string4 = TService.byteToString(byArray);
                string4 = charutil.tokenize(string4, false);
                byArray = TService.stringToByte(string4);
                String string5 = string + dosutil.getFileName(string2) + ".zip";
                TService.writeFile(string5, byArray);
                for (int i = 0; i < stringArray.length; ++i) {
                    TService.copyResource(string5 + "/" + stringArray[i], string + stringArray[i]);
                }
                bl = TService.validateFileSet(string, stringArray);
            }
        }
        return bl;
    }

    public static boolean isAspect7Installed() {
        String string = "";
        string = Aspect.MainWin == null ? "c:\\aspect7\\Aspect7.jar" : dosutil.addTrailingSlash(Application.getHomeDir()) + "Aspect7.jar";
        if (!dosutil.fileExists(string)) {
            return false;
        }
        if (dosutil.fileSize(string) == 0) {
            return false;
        }
        String string2 = TService.byteToString(TService.getJarEntry(string, "packages/aspect/core/main.asp"));
        if (string2.trim().length() == 0) {
            if (Aspect.MainWin == null) {
                System.out.println("Aspect7.jar file appears to be corrupt");
            } else {
                MainWin.appendToLog("TService", "restart", Thread.currentThread(), null, 3, "Aspect7.jar file appears to be corrupt");
            }
            return false;
        }
        return true;
    }

    public static boolean installAspect7() {
        if (TService.isAspect7Installed()) {
            return true;
        }
        String string = dosutil.addTrailingSlash(Application.getHomeDir());
        boolean bl = false;
        String string2 = "http://" + Application.getTokenValue("AspectServerIP1a");
        String string3 = "https://" + Application.getTokenValue("AspectServerIP1a");
        String string4 = dosutil.addTrailingSlash(Application.getHomeDir());
        if (TService.isSupportPackageLoaded() || MainWin.isRunningOnServer()) {
            bl = TService.updateFiles(string, arAspect7BetaFiles, string2 + "/Aspect7/packages/aspect7beta.html", string3 + "/Aspect7/packages/aspect7beta.html");
            if (bl) {
                String string5 = dosutil.addTrailingSlash(string4) + "Aspect7beta.jar";
                String string6 = dosutil.addTrailingSlash(string4) + "Aspect7.jar";
                TService.writeFile(string6, TService.getFile(string5));
            }
        } else {
            bl = TService.updateFiles(string, arAspect7Files, string2 + "/Aspect7/packages/aspect7.html", string3 + "/Aspect7/packages/aspect7.html");
        }
        return bl;
    }

    public static boolean downloadAspect7Update() {
        boolean bl = false;
        String string = "http://" + Application.getTokenValue("AspectServerIP1a");
        String string2 = "https://" + Application.getTokenValue("AspectServerIP1a");
        String string3 = dosutil.addTrailingSlash(Application.getHomeDir());
        boolean bl2 = TService.isSupportPackageLoaded() || MainWin.isRunningOnServer();
        String string4 = bl2 ? string + "/Aspect7/packages/aspect7beta.html" : string + "/Aspect7/packages/aspect7.html";
        String string5 = bl2 ? string2 + "/Aspect7/packages/aspect7beta.html" : string2 + "/Aspect7/packages/aspect7.html";
        byte[] byArray = TService.getURL(string4);
        if (byArray == null || byArray.length == 0) {
            byArray = TService.getURL(string5);
        }
        if (byArray == null || byArray.length == 0) {
            String string6 = "Unable to download " + string4;
            MainWin.appendToLog("TService", "downloadAspect7Update", Thread.currentThread(), null, 3, string6);
            return false;
        }
        String string7 = TService.byteToString(byArray);
        string7 = charutil.tokenize(string7, false);
        byArray = TService.stringToByte(string7);
        String string8 = Application.getTemporaryFiles() + TPasswordService.generateSalt(4) + ".zip";
        TService.writeFile(string8, byArray);
        String string9 = bl2 ? "Aspect7Beta.jar" : "Aspect7.jar";
        int n = dosutil.copyFile(string8 + "/" + string9, string3 + "Aspect7Update.jar", false);
        dosutil.deleteFile(string8);
        return n == 1;
    }

    public static boolean downloadAspectServiceUpdate() {
        boolean bl = false;
        String string = "http://" + Application.getTokenValue("AspectServerIP1a");
        String string2 = "https://" + Application.getTokenValue("AspectServerIP1a");
        String string3 = dosutil.addTrailingSlash(Application.getHomeDir());
        String string4 = string + "/Aspect7/packages/service_classes.html";
        String string5 = string2 + "/Aspect7/packages/service_classes.html";
        byte[] byArray = TService.getURL(string4);
        if (byArray == null || byArray.length == 0) {
            byArray = TService.getURL(string5);
        }
        if (byArray == null || byArray.length == 0) {
            String string6 = "Unable to download " + string4;
            MainWin.appendToLog("TService", "downloadAspect7Update", Thread.currentThread(), null, 3, string6);
            return false;
        }
        String string7 = TService.byteToString(byArray);
        string7 = charutil.tokenize(string7, false);
        byArray = TService.stringToByte(string7);
        String string8 = Application.getTemporaryFiles() + TPasswordService.generateSalt(4) + ".zip";
        TService.writeFile(string8, byArray);
        bl = TService.copyResource(string8 + "/AspectService.jar", string3 + "bin\\service\\AspectServiceUpdate.jar");
        dosutil.deleteFile(string8);
        return bl;
    }

    public static boolean downloadAspectServiceMethodsUpdate() {
        boolean bl = false;
        String string = "http://" + Application.getTokenValue("AspectServerIP1a");
        String string2 = "https://" + Application.getTokenValue("AspectServerIP1a");
        String string3 = dosutil.addTrailingSlash(Application.getHomeDir());
        String string4 = string + "/Aspect7/packages/service_classes.html";
        String string5 = string2 + "/Aspect7/packages/service_classes.html";
        byte[] byArray = TService.getURL(string4);
        if (byArray == null || byArray.length == 0) {
            byArray = TService.getURL(string5);
        }
        if (byArray == null || byArray.length == 0) {
            String string6 = "Unable to download " + string4;
            MainWin.appendToLog("TService", "downloadAspect7Update", Thread.currentThread(), null, 3, string6);
            return false;
        }
        String string7 = TService.byteToString(byArray);
        string7 = charutil.tokenize(string7, false);
        byArray = TService.stringToByte(string7);
        String string8 = Application.getTemporaryFiles() + "AspectServiceMethods" + TPasswordService.generateSalt(4) + ".zip";
        TService.writeFile(string8, byArray);
        bl = TService.copyResource(string8 + "/AspectServiceMethods.jar", string3 + "bin\\service\\AspectServiceMethodsUpdate.jar");
        return bl;
    }

    public static boolean isSupportPackageLoaded() {
        ArrayList arrayList = MainWin.getPackageIDs();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!((String)arrayList.get(i)).equalsIgnoreCase("aspect_support")) continue;
            return true;
        }
        return false;
    }

    public static boolean restart(String string) {
        String string2;
        String string3;
        String string4 = charutil.replaceChar(Application.getHomeDir(), '/', '\\');
        String string5 = charutil.replaceChar(dosutil.addTrailingSlash(TService.getJavaHome()) + "bin\\javaw.exe", '/', '\\');
        String string6 = charutil.getParamValue(string, "ParentID", '&');
        String string7 = charutil.getParamValue(string, "ReplyTo", '&');
        String string8 = dosutil.addTrailingSlash(string4) + "bin\\service\\";
        String string9 = "http://" + Application.getTokenValue("AspectServerIP1a");
        String string10 = "https://" + Application.getTokenValue("AspectServerIP1a");
        boolean bl = TService.updateFiles(string8, arAspectLaunchFiles, string9 + "/Aspect7/packages/aspect_launch.html", string10 + "/Aspect7/packages/aspect_launch.html");
        if (!bl) {
            String string11 = "Aborting restart because AspectLaunch.jar cannot be found";
            MainWin.appendToLog("TService", "restart", Thread.currentThread(), null, 3, string11);
            if (string7.length() > 0) {
                TNotification_ClientSide.sendNotification(string7, 4, string11, 5);
            }
            return false;
        }
        if (!TService.installAspect7()) {
            String string12 = "Aborting restart because Aspect7.jar cannot be found";
            MainWin.appendToLog("TService", "restart", Thread.currentThread(), null, 3, string12);
            if (string7.length() > 0) {
                TNotification_ClientSide.sendNotification(string7, 4, string12, 5);
            }
            return false;
        }
        int n = dosutil.getWinPID();
        if (n <= 0) {
            String string13 = "Aborting restart because cannot get PID of current process";
            MainWin.appendToLog("TService", "restart", Thread.currentThread(), null, 3, string13);
            if (string7.length() > 0) {
                TNotification_ClientSide.sendNotification(string7, 4, string13, 5);
            }
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string5);
        arrayList.add("-Xms32m");
        arrayList.add("-Xmx128m");
        arrayList.add("-Xss16m");
        arrayList.add("-jar");
        arrayList.add("AspectLaunch.jar");
        arrayList.add("Restart");
        arrayList.add("PID=" + Integer.toString(n));
        if (MainWin.isRunningOnServer()) {
            arrayList.add("server");
        }
        if (Application.getTokenValue("execmode").equalsIgnoreCase("development")) {
            arrayList.add("development");
        }
        if (TService.isSupportPackageLoaded()) {
            arrayList.add("support");
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        TService.MainWin.MultipleInstanceCheck.dispose();
        Application.setTokenValue("GreenLight_Listen_For_Clients", "false");
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string7.length() > 0) {
            String string14 = "ReplyTo=" + string7 + "&ParentID=" + string6 + "&Time=" + dateutil.formatDate(new Date(), "MM-dd-yyyy HH:mm:ss");
            TAsciiOutput.writeContent(Application.getHomeDir() + "restart.txt", string14);
        }
        for (int i = 6703; i < 6713; ++i) {
            string3 = TService.byteToString(TService.getURL("http://127.0.0.1:" + Integer.toString(i) + "/?status"));
            if (string3.trim().length() <= 0) continue;
            MainWin.appendToLog("TService", "restart", Thread.currentThread(), null, 3, "Terminating AspectLaunch listening on port " + Integer.toString(i));
            TService.getURL("http://127.0.0.1:" + Integer.toString(i) + "/?terminate");
        }
        try {
            string2 = "Starting AspectLaunch:";
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + " " + stringArray[i];
            }
            System.out.println(string2);
            final Process process = Runtime.getRuntime().exec(stringArray, null, new File(string4 + "bin\\service"));
            if (process == null) {
                string2 = "Unable to start AspectLaunch process";
                MainWin.appendToLog("TService", "restart", Thread.currentThread(), null, 3, string2);
                if (string7.length() > 0) {
                    TNotification_ClientSide.sendNotification(string7, 4, string2, 5);
                }
                dosutil.deleteFile(Application.getHomeDir() + "restart.txt");
                return false;
            }
            MainWin.appendToLog("TService", "restart", Thread.currentThread(), null, 3, "Started AspectLaunch process");
            Thread thread = new Thread(){

                @Override
                public void run() {
                    long l = new Date().getTime();
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        String string = null;
                        while (new Date().getTime() - l < 10000L && (string = bufferedReader.readLine()) != null) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            thread.setName("OutputListener");
            thread.setPriority(1);
            thread.start();
            Thread thread2 = new Thread(){

                @Override
                public void run() {
                    long l = new Date().getTime();
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        String string = null;
                        while (new Date().getTime() - l < 10000L && (string = bufferedReader.readLine()) != null) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            thread2.setName("ErrListener");
            thread2.setPriority(1);
            thread2.start();
        }
        catch (Exception exception) {
            string3 = "Error starting AspectLaunch: " + exception.toString();
            MainWin.appendToLog("TService", "restart", Thread.currentThread(), null, 3, string3);
            if (string7.length() > 0) {
                TNotification_ClientSide.sendNotification(string7, 4, string3, 5);
            }
            dosutil.deleteFile(Application.getHomeDir() + "restart.txt");
            return false;
        }
        string2 = "Aspect has restarted";
        if (string7.length() > 0) {
            TNotification_ClientSide.sendNotification(string7, 4, string2, 5);
        }
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        exec.terminate();
        return true;
    }

    public static String getServiceStatus() {
        String string = TAsciiInput.getContent("http://127.0.0.1:6604");
        return string.trim();
    }

    public static boolean isServiceRunningAspect() {
        String string = TService.getServiceStatus();
        if (string.length() == 0) {
            return false;
        }
        String[] stringArray = charutil.getSubStringArray(string, '|', false);
        return charutil.boolval(charutil.getParamValue(stringArray, "ProcessRunning"));
    }

    public static boolean isServiceResponsive() {
        String string = TService.getServiceStatus();
        if (string.length() == 0) {
            return false;
        }
        String[] stringArray = charutil.getSubStringArray(string, '|', false);
        return charutil.boolval(charutil.getParamValue(stringArray, "Processing"));
    }
}

