/*
 * Decompiled with CFR 0.152.
 */
package utility;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import resources.TApplication;
import utility.TFile;
import utility.charutil;
import utility.http.THttpRequest;
import utility.http.THttpResponse;
import utility.netutil;
import utility.notifications.TNotification;
import utility.security.TPasswordService;
import utility.ziputil;

public class TScriptSocket {
    private TMainWin MainWin = Aspect.MainWin;
    private TApplication Application = TMainWin.Application;
    public String ID = TPasswordService.generateSalt(4);
    public static Date dtLastOpenDirectSocket = null;
    public static long tLastOpenDirectSocketSuccess = 0L;
    public static int[] arConntectAttempts = new int[24];
    public Socket socket = null;
    public DataOutputStream socketOutputStream = null;
    public DataInputStream socketInputStream = null;
    public THttpRequest HttpRequest = null;
    public THttpResponse HttpResponse = null;
    public StringBuilder strErrorMsg = new StringBuilder();
    public long tmLastWrite = new Date().getTime();
    public long tmLastRead = new Date().getTime();
    public long tmOpened = new Date().getTime();
    public long cGetResponse = 0L;
    public long cSendResponse = 0L;
    public long cSendRequest = 0L;
    public boolean bInWriteToFile = false;
    public String WriteToFileName = "";
    public int WriteToFileLen = 0;
    public int WriteToFileBytesReceived = 0;
    public boolean bInSendFile = false;
    public boolean bServicing = false;
    public long tmLastNotificationSentFromServer = new Date().getTime() - 1800000L;
    public static long countOpenDirectSocket = 0L;
    public long tmLastService = 0L;
    boolean DisposeOnClose = true;

    public TScriptSocket() {
    }

    public TScriptSocket(Socket socket) {
        this.socket = socket;
        try {
            this.socket.setTcpNoDelay(true);
            this.socket.setReceiveBufferSize(32768);
            this.socket.setSendBufferSize(32768);
            this.socket.setTrafficClass(24);
            this.socket.setSoTimeout(120000);
            this.socketOutputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.socketInputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.HttpRequest = new THttpRequest(this.socket);
            this.HttpResponse = new THttpResponse(this.socket);
        }
        catch (Exception exception) {
            if (this.MainWin != null) {
                this.MainWin.appendToLog("TFormulaEvaluator", "TScriptSocket.init()", Thread.currentThread(), exception, 4, "Error initializing socket: " + exception.toString());
            } else {
                System.out.println("Error initializing socket: " + exception.toString());
            }
            exception.printStackTrace();
        }
    }

    public void dispose() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                this.MainWin.appendToLog("TFormulaEvaluator", "dispose", Thread.currentThread(), exception, 4, "Error closing socket: " + exception.toString());
            }
        }
    }

    public String getIPAddress() {
        if (this.socket == null) {
            return "";
        }
        return this.socket.getInetAddress().getHostAddress();
    }

    public static void updateConnectionAttempts() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date());
        int n = gregorianCalendar.get(11);
        for (int i = 0; i < 24; ++i) {
            if (i == n) {
                int n2 = i;
                arConntectAttempts[n2] = arConntectAttempts[n2] + 1;
                continue;
            }
            TScriptSocket.arConntectAttempts[i] = 0;
        }
    }

    public static int getConnectionAttempts() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date());
        int n = gregorianCalendar.get(11);
        if (n >= 0 && n < 24) {
            return arConntectAttempts[n];
        }
        return 0;
    }

    public Socket openDirectSocketAlt() {
        String string = TMainWin.Application.getTokenValue("AspectServerIP2");
        String[] stringArray = charutil.getSubStringArray(string, ':', true);
        if (this.MainWin.isRunningOnServer()) {
            stringArray[0] = TMainWin.Application.getTokenValue("AspectServerIP1a");
        }
        this.MainWin.appendToLog("TScriptSocket", "openDirectSocket", Thread.currentThread(), null, 3, "Notification Client: Opening direct socket alternate: " + stringArray[0] + ".  Attempts this hour: " + TScriptSocket.getConnectionAttempts());
        try {
            InetAddress inetAddress = InetAddress.getByName(stringArray[0]);
            System.out.println("openDirectSocketAlt addr=" + inetAddress);
            this.socket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, charutil.ival(stringArray[1]));
            this.socket.setSoTimeout(60000);
            this.socket.connect(inetSocketAddress, 60000);
            System.out.println("openDirectSocketAlt socket connected");
            this.socket.setKeepAlive(true);
            this.socket.setTcpNoDelay(true);
            this.socket.setReceiveBufferSize(32768);
            this.socket.setSendBufferSize(32768);
            this.socket.setTrafficClass(24);
            this.socketOutputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.socketInputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.HttpRequest = new THttpRequest(this.socket);
            this.HttpResponse = new THttpResponse(this.socket);
            String string2 = "Network=GreenLight&ID=socketConnect&HashId=" + TMainWin.Application.getAspectHashID() + "&pw=" + TNotification.encryptPassword();
            System.out.println("openDirectSocketAlt args=" + string2);
            this.setRequestArguments(string2);
            this.setRequestMethod(1);
            this.setRequestURI("/");
            this.setRequestHttpVersion("HTTP/1.1");
            this.setRequestHeaderValue("user-agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.0.10) Gecko/2009042316 Firefox/3.0.10");
            this.setRequestHeaderValue("accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
            this.setRequestHeaderValue("accept-encoding", "gzip");
            this.setRequestHeaderValue("CONNECTION", "keep-alive");
            this.setRequestHeaderValue("KEEP-ALIVE", "300");
            this.setRequestHeaderValue("ACCEPT-LANGUAGE", "en-us,en;q=0.5");
            this.setRequestHeaderValue("ACCEPT-CHARSET", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
            this.sendRequest();
            this.getResponse();
            int n = this.getResponseCode();
            String string3 = "";
            if (n != 0 && n != 200 && (n < 300 || n > 399)) {
                this.MainWin.appendToLog("TScriptSocket", "openDirectSocket", Thread.currentThread(), null, 4, "Error in openDirectSocketAlt1.  Http response code " + n);
            } else {
                tLastOpenDirectSocketSuccess = new Date().getTime();
            }
            if (this.getResponseHeaderValue("content-encoding").equalsIgnoreCase("gzip")) {
                string3 = ziputil.gunzipString(this.getResponseContentBytes());
                this.MainWin.appendToLog("TScriptSocket", "applyFunction", Thread.currentThread(), null, 3, "\tNotification Client: Direct socket alt result1: [" + string3 + "] intResponseCode=" + n);
            } else {
                string3 = this.getResponseContent();
                this.MainWin.appendToLog("TScriptSocket", "applyFunction", Thread.currentThread(), null, 3, "\tNotification Client: Direct socket alt result2: [" + string3 + "] intResponseCode=" + n);
            }
            return this.socket;
        }
        catch (UnknownHostException unknownHostException) {
            this.MainWin.appendToLog("TScriptSocket", "applyFunction", Thread.currentThread(), null, 4, "Error in openDirectSocketAlt2: " + unknownHostException.toString());
        }
        catch (IOException iOException) {
            this.MainWin.appendToLog("TScriptSocket", "applyFunction", Thread.currentThread(), null, 4, "Error in openDirectSocketAlt3: " + iOException.toString());
        }
        return null;
    }

    public Socket openDirectSocket() {
        ++countOpenDirectSocket;
        dtLastOpenDirectSocket = new Date();
        TScriptSocket.updateConnectionAttempts();
        String string = TMainWin.Application.getTokenValue("AspectServerIP1");
        if (Aspect.getArg("-local") != null) {
            if (TMainWin.Application.getDevelopmentMode() == 0) {
                System.out.println("************* openDirectSocket: Using local connection for direct connect **************");
                string = netutil.getLocalIP() + ":4447";
            }
        }
        String[] stringArray = charutil.getSubStringArray(string, ':', true);
        if (this.MainWin.isRunningOnServer()) {
            stringArray[0] = TMainWin.Application.getTokenValue("AspectServerIP1a");
        }
        this.MainWin.appendToLog("TScriptSocket", "openDirectSocket", Thread.currentThread(), null, 3, "Notification Client: Opening direct socket: " + stringArray[0] + ":" + stringArray[1] + ".  Attempts this hour: " + TScriptSocket.getConnectionAttempts());
        if (this.socket != null) {
            try {
                this.socketOutputStream.close();
                this.socketInputStream.close();
                this.socket.close();
                this.socket = null;
            }
            catch (Exception exception) {
                System.out.println("Error closing socket: " + exception);
            }
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(stringArray[0]);
            SSLSocketFactory sSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            this.socket = (SSLSocket)sSLSocketFactory.createSocket(inetAddress, charutil.ival(stringArray[1]));
            this.socket.setSoTimeout(60000);
            ((SSLSocket)this.socket).startHandshake();
            this.socket.setKeepAlive(true);
            this.socket.setTcpNoDelay(true);
            this.socket.setReceiveBufferSize(32768);
            this.socket.setSendBufferSize(32768);
            this.socket.setTrafficClass(24);
            this.socketOutputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.socketInputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.HttpRequest = new THttpRequest(this.socket);
            this.HttpResponse = new THttpResponse(this.socket);
            String string2 = "Network=GreenLight&ID=socketConnect&HashId=" + TMainWin.Application.getAspectHashID() + "&pw=" + TNotification.encryptPassword();
            this.setRequestArguments(string2);
            this.setRequestMethod(1);
            this.setRequestURI("/");
            this.setRequestHttpVersion("HTTP/1.1");
            this.setRequestHeaderValue("user-agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.0.10) Gecko/2009042316 Firefox/3.0.10");
            this.setRequestHeaderValue("accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
            this.setRequestHeaderValue("accept-encoding", "gzip");
            this.setRequestHeaderValue("CONNECTION", "keep-alive");
            this.setRequestHeaderValue("KEEP-ALIVE", "300");
            this.setRequestHeaderValue("ACCEPT-LANGUAGE", "en-us,en;q=0.5");
            this.setRequestHeaderValue("ACCEPT-CHARSET", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
            this.sendRequest();
            this.getResponse();
            int n = this.getResponseCode();
            if (n == 0) {
                this.MainWin.appendToLog("TScriptSocket", "openDirectSocket", Thread.currentThread(), null, 4, "Error in openDirectSocket. intResponseCode=" + n);
                this.socket = this.openDirectSocketAlt();
                return this.socket;
            }
            String string3 = "";
            if (n != 0 && n != 200 && (n < 300 || n > 399)) {
                this.MainWin.appendToLog("TScriptSocket", "openDirectSocket", Thread.currentThread(), null, 4, "Error in openDirectSocket1.  Http response code " + n);
            } else {
                tLastOpenDirectSocketSuccess = new Date().getTime();
            }
            if (this.getResponseHeaderValue("content-encoding").equalsIgnoreCase("gzip")) {
                string3 = ziputil.gunzipString(this.getResponseContentBytes());
                this.MainWin.appendToLog("TScriptSocket", "applyFunction", Thread.currentThread(), null, 3, "\tNotification Client: Direct socket result1: [" + string3 + "] intResponseCode=" + n);
            } else {
                string3 = this.getResponseContent();
                this.MainWin.appendToLog("TScriptSocket", "applyFunction", Thread.currentThread(), null, 3, "\tNotification Client: Direct socket result2: [" + string3 + "] intResponseCode=" + n);
            }
            return (SSLSocket)this.socket;
        }
        catch (UnknownHostException unknownHostException) {
            this.MainWin.appendToLog("TScriptSocket", "applyFunction", Thread.currentThread(), null, 4, "Error in openDirectSocket2: " + unknownHostException.toString());
        }
        catch (IOException iOException) {
            this.MainWin.appendToLog("TScriptSocket", "applyFunction", Thread.currentThread(), null, 4, "Error in openDirectSocket3: " + iOException.toString());
            this.socket = this.openDirectSocketAlt();
            return this.socket;
        }
        return null;
    }

    public boolean isClosed() {
        if (this.socket == null) {
            return true;
        }
        return this.socket.isClosed();
    }

    public void setDisposeOnClose(boolean bl) {
        this.DisposeOnClose = bl;
    }

    public String getRemoteIP() {
        SocketAddress socketAddress = this.socket.getRemoteSocketAddress();
        String string = "";
        if (socketAddress instanceof InetSocketAddress) {
            string = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
        }
        return string;
    }

    public int getRemotePort() {
        return this.socket.getPort();
    }

    public void setLastMessage(String string) {
        this.strErrorMsg.setLength(0);
        this.strErrorMsg.append(string);
    }

    public String getLastMessage() {
        return this.strErrorMsg.toString();
    }

    public boolean setTimeout(int n) {
        try {
            this.socket.setSoTimeout(n);
            this.setLastMessage("Ok");
            return true;
        }
        catch (Exception exception) {
            this.setLastMessage(exception.toString());
            return false;
        }
    }

    public void getRequest() {
        String string = this.HttpRequest.receive();
        this.setLastMessage(string);
    }

    public String getRequestHeaderValue(String string) {
        return this.HttpRequest.getHeaderValue(string);
    }

    public String getRequestURI() {
        return this.HttpRequest.getURI();
    }

    public String getRequestContent() {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = this.HttpRequest.getContent();
        if (byArray == null) {
            return "";
        }
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append((char)byArray[i]);
        }
        return stringBuilder.toString();
    }

    public int getRequestContentLength() {
        return this.HttpRequest.getContentLength();
    }

    public String getRequestArgumentValue(String string) {
        if (this.HttpRequest == null) {
            return null;
        }
        return this.HttpRequest.getArgumentValue(string);
    }

    public String getRequestArguments() {
        return this.HttpRequest.getArguments();
    }

    public String getRequestHeaders() {
        return this.HttpRequest.getHeaders();
    }

    public String getResponse() {
        ++this.cGetResponse;
        return this.HttpResponse.receive();
    }

    public int getResponseCode() {
        return this.HttpResponse.getResponseCode();
    }

    public String getResponseCodeText() {
        return this.HttpResponse.getResponseCodeText();
    }

    public byte[] getResponseContentBytes() {
        return this.HttpResponse.getContent();
    }

    public String getResponseContent() {
        byte[] byArray = this.HttpResponse.getContent();
        if (byArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append((char)byArray[i]);
        }
        return stringBuilder.toString();
    }

    public int getResponseContentLength() {
        return this.HttpResponse.getContentLength();
    }

    public String getResponseHeaderValue(String string) {
        return this.HttpResponse.getHeaderValue(string);
    }

    public String getResponseHeaders() {
        return this.HttpResponse.getHeaders();
    }

    public String sendRequest() {
        ++this.cSendRequest;
        return this.HttpRequest.send();
    }

    public String sendResponse() {
        ++this.cSendResponse;
        return this.HttpResponse.send();
    }

    public String setRequestArgValue(String string, String string2) {
        this.HttpRequest.setArgumentValue(string, string2);
        return "ok";
    }

    public String setRequestArgs(String string) {
        this.HttpRequest.setArguments(string);
        return "ok";
    }

    public String setRequestMethod(int n) {
        this.HttpRequest.setMethod(n);
        return "ok";
    }

    public String setRequestMethod(String string) {
        if (string.equalsIgnoreCase("GET")) {
            this.HttpRequest.setMethod(1);
        } else if (string.equalsIgnoreCase("POST")) {
            this.HttpRequest.setMethod(2);
        } else if (string.equalsIgnoreCase("HEAD")) {
            this.HttpRequest.setMethod(3);
        } else {
            return "Invalid request method";
        }
        return "ok";
    }

    public String setRequestURI(String string) {
        this.HttpRequest.setURI(string);
        return "ok";
    }

    public String setRequestHttpVersion(String string) {
        this.HttpRequest.setHttpVersion(string);
        return "ok";
    }

    public String setRequestHeaders(String string) {
        this.HttpRequest.setHeaders(string);
        return "ok";
    }

    public String setRequestHeaderValue(String string, String string2) {
        this.HttpRequest.setHeaderValue(string, string2);
        return "ok";
    }

    public void setRequestArguments(String string) {
        this.HttpRequest.setArguments(string);
    }

    public String setRequestContent(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        this.HttpRequest.setContent(byArray);
        return "ok";
    }

    public void setResponseHttpVersion(String string) {
        this.HttpResponse.setHttpVersion(string);
    }

    public void setResponseCode(String string) {
        this.HttpResponse.setResponseCode(charutil.ival(string));
    }

    public void setResponseCodeText(String string) {
        this.HttpResponse.setResponseCodeText(string);
    }

    public void setResponseContent(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        this.HttpResponse.setContent(byArray);
    }

    public void setResponseHeaderValue(String string, String string2) {
        this.HttpResponse.setHeaderValue(string, string2);
    }

    public synchronized void flush() {
        try {
            this.socketOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized boolean writeInt(int n, boolean bl) {
        try {
            this.socketOutputStream.writeInt(n);
            if (bl) {
                this.socketOutputStream.flush();
            }
            this.setLastMessage("Ok");
            this.tmLastWrite = new Date().getTime();
            return true;
        }
        catch (Exception exception) {
            this.setLastMessage(exception.toString());
            return false;
        }
    }

    public synchronized int readInt() {
        try {
            int n = this.socketInputStream.readInt();
            this.setLastMessage("Ok");
            this.tmLastRead = new Date().getTime();
            return n;
        }
        catch (Exception exception) {
            this.MainWin.appendToLog("TFormulaEvaluator", "TScriptSocket.readInt", Thread.currentThread(), exception, 4, "Error in socket.readInt(): " + exception.toString());
            this.setLastMessage(exception.toString());
            return 0;
        }
    }

    public synchronized boolean writeZipString(String string, boolean bl) {
        return this.writeZipString(string, bl, false);
    }

    public synchronized boolean writeZipString(String string, boolean bl, boolean bl2) {
        if (TNotification.DebugNotifications) {
            this.MainWin.appendToLog("TScriptSocket", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: TScriptSocket writeZipString started");
        }
        byte[] byArray = ziputil.gzipString(string);
        int n = byArray.length;
        if (TNotification.DebugNotifications) {
            this.MainWin.appendToLog("TScriptSocket", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: TScriptSocket len=" + n);
        }
        if (bl2) {
            String string2 = "";
            try {
                string2 = ziputil.gunzipString(byArray);
            }
            catch (Exception exception) {
                System.out.println("TScriptSocket.writeZipString: error unzipping string for confirmation");
                System.out.println("String=" + string);
            }
            if (!string2.equals(string)) {
                System.out.println("TScriptSocket.writeZipString ERROR in zip operation");
            }
            System.out.println("TScriptSocket writeZipString zip content confirmed.  Writing " + n + " bytes");
        }
        try {
            int n2 = this.socket.getSendBufferSize();
            if (n > n2) {
                this.socket.setSendBufferSize(Math.min(n + 4, 524288));
                n2 = this.socket.getSendBufferSize();
            }
            if (TNotification.DebugNotifications) {
                this.MainWin.appendToLog("TScriptSocket", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: TScriptSocket calling writeInt");
            }
            if (this.writeInt(n, false)) {
                if (TNotification.DebugNotifications) {
                    this.MainWin.appendToLog("TScriptSocket", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: TScriptSocket writing buffer started");
                }
                int n3 = 0;
                if (n > 0) {
                    do {
                        int n4 = Math.min(n - n3, n2 - 4);
                        this.socketOutputStream.write(byArray, n3, n4);
                        n3 += n4;
                        try {
                            Thread.yield();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!TNotification.DebugNotifications) continue;
                        this.MainWin.appendToLog("TScriptSocket", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: TScriptSocket writing buffer BufStart=" + n3);
                    } while (n3 < n);
                }
                if (TNotification.DebugNotifications) {
                    this.MainWin.appendToLog("TScriptSocket", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: TScriptSocket writing buffer complete");
                }
                if (bl) {
                    if (TNotification.DebugNotifications) {
                        this.MainWin.appendToLog("TScriptSocket", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: TScriptSocket flushing buffer");
                    }
                    this.socketOutputStream.flush();
                    this.socketOutputStream.flush();
                }
                this.setLastMessage("Ok");
                this.tmLastWrite = new Date().getTime();
                if (TNotification.DebugNotifications) {
                    this.MainWin.appendToLog("TScriptSocket", "sendNotifications", Thread.currentThread(), null, 3, "Notification Client: TScriptSocket complete");
                }
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println("Error in writeZipString: " + exception.toString());
            this.setLastMessage(exception.toString());
            return false;
        }
    }

    public synchronized String readZipString(boolean bl) {
        int n = -1;
        long l = new Date().getTime();
        if (bl) {
            this.MainWin.appendToLog("TFormulaEvaluator", "applyFunction", Thread.currentThread(), null, 3, "readZipString waiting for len");
        }
        while (n < 0 && new Date().getTime() - l < 120000L) {
            try {
                n = this.socketInputStream.readInt();
                Thread.yield();
                if (!(Math.random() < 0.1)) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {}
        }
        if (bl) {
            this.MainWin.appendToLog("TFormulaEvaluator", "applyFunction", Thread.currentThread(), null, 3, "readZipString got len=" + n);
        }
        if (n < 0) {
            this.MainWin.appendToLog("TFormulaEvaluator", "applyFunction", Thread.currentThread(), null, 4, "Error: Timeout in readZipString()");
            this.setLastMessage("Error: Timeout in readZipString()");
            return "";
        }
        if (n > 0x1400000) {
            this.MainWin.appendToLog("TFormulaEvaluator", "applyFunction", Thread.currentThread(), null, 4, "Error: Len is invalid in readZipString().  Len=" + n);
            this.setLastMessage("Error: Len is invalid in readZipString()");
            byte[] byArray = new byte[1024];
            int n2 = 0;
            do {
                try {
                    n2 = this.socketInputStream.read(byArray, 0, byArray.length - 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (n2 > 0);
            return "";
        }
        try {
            int n3 = this.socket.getReceiveBufferSize();
            byte[] byArray = new byte[n];
            int n4 = 0;
            long l2 = new Date().getTime();
            do {
                int n5 = Math.min(n - n4, n3);
                int n6 = this.socketInputStream.read(byArray, n4, n5);
                n4 += n5;
                long l3 = new Date().getTime();
                if (l3 - l2 > 3000L) {
                    System.out.println("TScriptSocket waiting in readZipString Bytes read: " + n4 + " of " + n);
                    l2 = l3;
                }
                Thread.yield();
                if (!(Math.random() < 0.1)) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (n4 < n);
            this.setLastMessage("Ok");
            this.tmLastRead = new Date().getTime();
            if (bl) {
                this.MainWin.appendToLog("TFormulaEvaluator", "applyFunction", Thread.currentThread(), null, 3, "readZipString got " + n4 + " bytes.  Unzipping string");
            }
            String string = ziputil.gunzipString(byArray);
            if (bl) {
                this.MainWin.appendToLog("TFormulaEvaluator", "applyFunction", Thread.currentThread(), null, 3, "readZipString len of unzipped string=" + string.length());
            }
            return string;
        }
        catch (Exception exception) {
            this.MainWin.appendToLog("TFormulaEvaluator", "applyFunction", Thread.currentThread(), exception, 4, "Error in readZipString: " + exception.toString());
            this.setLastMessage(exception.toString());
            return "";
        }
    }

    public synchronized boolean writeString(String string, boolean bl) {
        try {
            int n;
            int n2 = string.length();
            byte[] byArray = new byte[n2];
            for (n = 0; n < n2; ++n) {
                byArray[n] = (byte)string.charAt(n);
            }
            n = this.socket.getSendBufferSize();
            if (n2 > n) {
                this.socket.setSendBufferSize(Math.min(n2, 524288));
                n = this.socket.getSendBufferSize();
            }
            if (n2 > 0) {
                int n3 = 0;
                do {
                    int n4 = Math.min(n2 - n3, n - 4);
                    this.socketOutputStream.write(byArray, n3, n4);
                    n3 += n4;
                    try {
                        Thread.yield();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                } while (n3 < n2);
            }
            if (bl) {
                this.socketOutputStream.flush();
            }
        }
        catch (Exception exception) {
            System.out.println("TFormulaEvaluator.socket writeString: " + exception.toString());
            this.setLastMessage(exception.toString());
            return false;
        }
        this.tmLastWrite = new Date().getTime();
        this.setLastMessage("Ok");
        return true;
    }

    public synchronized String readString(int n) {
        byte[] byArray = new byte[n];
        try {
            int n2;
            int n3 = this.socket.getReceiveBufferSize();
            int n4 = 0;
            do {
                int n5 = Math.min(n - n4, n3);
                n2 = this.socketInputStream.read(byArray, n4, n5);
                n4 += n2;
                try {
                    Thread.yield();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(Math.random() < 0.1)) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (n4 < n);
            StringBuilder stringBuilder = new StringBuilder();
            for (n2 = 0; n2 < n4; ++n2) {
                stringBuilder.append((char)byArray[n2]);
            }
            String string = stringBuilder.toString();
            this.setLastMessage("Ok");
            this.tmLastRead = new Date().getTime();
            return string;
        }
        catch (Exception exception) {
            this.MainWin.appendToLog("TFormulaEvaluator", "applyFunction", Thread.currentThread(), exception, 4, "Error in readString: " + exception.toString());
            this.setLastMessage(exception.toString());
            return "";
        }
    }

    public synchronized String sendFile(String string) {
        this.bInSendFile = true;
        TFile tFile = new TFile(string);
        if (!tFile.exists()) {
            return "File not found";
        }
        long l = tFile.getContentLength();
        try {
            int n;
            this.socket.setSoTimeout(120000);
            byte[] byArray = new byte[Short.MAX_VALUE];
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rwd");
            int n2 = 0;
            long l2 = new Date().getTime();
            do {
                long l3;
                if ((n = randomAccessFile.read(byArray)) > 0) {
                    this.socketOutputStream.write(byArray, 0, n);
                    this.socketOutputStream.flush();
                    n2 += n;
                }
                if ((l3 = new Date().getTime()) - l2 > 3000L) {
                    System.out.println("TScriptSocket waiting in sendFile: " + string + " Sent " + n2 + " of " + randomAccessFile.length());
                    l2 = l3;
                }
                Thread.yield();
                if (!(Math.random() < 0.1)) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (n >= 0);
            randomAccessFile.close();
            this.setLastMessage("Ok");
        }
        catch (Exception exception) {
            this.MainWin.appendToLog("TFormulaEvaluator", "applyFunction", Thread.currentThread(), exception, 4, "Error in socketSendFile: " + exception.toString());
            this.setLastMessage(exception.toString());
            this.bInSendFile = false;
            return exception.toString();
        }
        this.bInSendFile = false;
        return "ok";
    }

    public synchronized long writeToFile(String string, int n) {
        this.bInWriteToFile = true;
        this.WriteToFileBytesReceived = 0;
        this.WriteToFileName = string;
        this.WriteToFileLen = n;
        try {
            byte[] byArray = new byte[8192];
            int n2 = this.socket.getReceiveBufferSize();
            TFile tFile = new TFile(string);
            tFile.validatePathToFile(true);
            if (tFile.exists()) {
                tFile.delete();
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rwd");
            int n3 = this.socket.getSoTimeout();
            if (n3 < 0 || n3 > 120000) {
                this.socket.setSoTimeout(120000);
            }
            int n4 = 0;
            do {
                int n5 = Math.min(n - n4, byArray.length);
                int n6 = this.socketInputStream.read(byArray, 0, n5);
                this.WriteToFileBytesReceived = n4 += n6;
                if (n6 >= 0) {
                    randomAccessFile.write(byArray, 0, n6);
                }
                try {
                    Thread.yield();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (n4 < n);
            randomAccessFile.close();
            this.setLastMessage("Ok");
            this.bInWriteToFile = false;
            return n4;
        }
        catch (Exception exception) {
            this.MainWin.appendToLog("TFormulaEvaluator", "applyFunction", Thread.currentThread(), exception, 4, "Error in writeToFile: " + exception.toString());
            this.setLastMessage(exception.toString());
            this.bInWriteToFile = false;
            return -1L;
        }
    }

    public synchronized String readLine() {
        byte[] byArray = new byte[8192];
        int n = 0;
        try {
            byte by;
            do {
                if ((by = this.socketInputStream.readByte()) == 10 || by == 13) continue;
                byArray[n] = by;
                if (++n != byArray.length) continue;
                byArray = (byte[])charutil.arrayGrow(byArray, 8192);
            } while (by != 10 && this.socketInputStream.available() > 0);
            this.setLastMessage("Ok");
            this.tmLastRead = new Date().getTime();
            return new String(byArray);
        }
        catch (Exception exception) {
            this.setLastMessage(exception.toString());
            return "";
        }
    }
}

