/*
 * Decompiled with CFR 0.152.
 */
package utility;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import utility.charutil;
import utility.objectutil;

public class TGoogleChart {
    private static TMainWin MainWin = Aspect.MainWin;
    private static boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTChart");
    TDriverStructRecord[] arDSRecDataLabel = null;
    TDriverStructRecord[] arDSRecDataValue = null;
    String[] arFilter = null;
    TAspectDriver AspectDriver = null;
    String AChartTitle = "Chart Title";
    String AFilename = "";
    String AChartType = "bar";
    String ACategoryAxisLabel = "Domain Axis Label";
    String AValueAxisLabel = "Value Axis Label";
    int AWidth = 640;
    int AHeight = 480;
    String TitleFontName = "";
    int TitleFontSize = 0;
    String TitleFontStyle = "";
    boolean bContainsSubtotals = false;

    public TGoogleChart(TAspectDriver tAspectDriver, String string, String string2, String string3, String string4) {
        int n;
        String[] stringArray = charutil.getSubStringArray(string, '|', true);
        String[] stringArray2 = charutil.getSubStringArray(string2, '|', true);
        String[] stringArray3 = charutil.getSubStringArray(string3, '|', true);
        String[] stringArray4 = charutil.getSubStringArray(string4, '&', true);
        this.AspectDriver = tAspectDriver;
        this.AChartTitle = charutil.getParamValue(stringArray4, "ChartTitle");
        this.AFilename = charutil.getParamValue(stringArray4, "Filename");
        this.AChartType = charutil.getParamValue(stringArray4, "ChartType");
        this.ACategoryAxisLabel = charutil.getParamValue(stringArray4, "DomainAxisLabel");
        this.AValueAxisLabel = charutil.getParamValue(stringArray4, "ValueAxisLabel");
        this.AWidth = charutil.ival(charutil.getParamValue(stringArray4, "Width"));
        this.AHeight = charutil.ival(charutil.getParamValue(stringArray4, "Height"));
        this.TitleFontName = charutil.getParamValue(stringArray4, "TitleFontName");
        this.TitleFontSize = charutil.ival(charutil.getParamValue(stringArray4, "TitleFontSize"));
        this.TitleFontStyle = charutil.getParamValue(stringArray4, "TitleFontStyle");
        if (this.TitleFontName.length() == 0) {
            this.TitleFontName = "arial";
        }
        if (this.TitleFontSize == 0) {
            this.TitleFontSize = 12;
        }
        if (this.TitleFontStyle.length() == 0) {
            this.TitleFontStyle = "bold";
        }
        if (this.AWidth == 0) {
            this.AWidth = 640;
        }
        if (this.AHeight == 0) {
            this.AHeight = 480;
        }
        this.arDSRecDataLabel = new TDriverStructRecord[stringArray.length];
        this.arDSRecDataValue = new TDriverStructRecord[stringArray2.length];
        for (n = 0; n < stringArray.length; ++n) {
            this.arDSRecDataLabel[n] = tAspectDriver.getDriverStructRecord(stringArray[n]);
            if (this.arDSRecDataLabel[n] != null) continue;
            MainWin.appendToLog("TChart", "init", Thread.currentThread(), null, 4, "TChart cannot locate field with ID of " + stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            this.arDSRecDataValue[n] = tAspectDriver.getDriverStructRecord(stringArray2[n]);
            if (this.arDSRecDataValue[n] != null) continue;
            MainWin.appendToLog("TChart", "init", Thread.currentThread(), null, 4, "TChart cannot locate field with ID of " + stringArray2[n]);
        }
        this.bContainsSubtotals = false;
        n = this.AspectDriver.getRecordCount();
        for (int i = 0; !this.bContainsSubtotals && i < n; ++i) {
            this.bContainsSubtotals = this.AspectDriver.isSubtotal(i);
        }
    }

    public String getData() {
        String string = "";
        string = this.AChartType.equalsIgnoreCase("bar") ? this.createLineChart() : (this.AChartType.equalsIgnoreCase("column") ? this.createLineChart() : (this.AChartType.equalsIgnoreCase("line") ? this.createLineChart() : (this.AChartType.equalsIgnoreCase("line2") ? this.createLineChart() : (this.AChartType.equalsIgnoreCase("pie") ? this.createLineChart() : (this.AChartType.equalsIgnoreCase("scatter") ? this.createLineChart() : this.createLineChart())))));
        return string;
    }

    public String createLineChart() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        if (this.arDSRecDataLabel[0] == null) {
            return "";
        }
        if (this.arDSRecDataLabel[0].Description == null) {
            return "";
        }
        string = string + charutil.replaceChar(this.arDSRecDataLabel[0].Description, '\\', ' ');
        string = charutil.replaceAllSubstrings(string, "<br>", " ");
        for (n = 0; n < this.arDSRecDataValue.length; ++n) {
            if (string.length() > 0) {
                string = string + "^";
            }
            String string2 = charutil.replaceChar(this.arDSRecDataValue[n].Description, '\\', ' ');
            string2 = charutil.replaceAllSubstrings(string2, "<br>", " ");
            string = string + string2;
        }
        stringBuilder.append(string);
        n = this.AspectDriver.getRecordCount();
        for (int i = 0; i < n; ++i) {
            int n2 = this.AspectDriver.getAbsoluteDiskIndex(i);
            if (this.AspectDriver.isGrandTotalAbsolute(n2) || this.AspectDriver.isDetail(n2) && this.bContainsSubtotals) continue;
            boolean bl = true;
            if (this.arFilter != null && this.arFilter.length >= 1 && this.arFilter[0].length() > 0) {
                bl = this.AspectDriver.isInFilter(i, this.arFilter[0]);
            }
            if (!bl) continue;
            Object object = this.AspectDriver.getFieldForHtml(this.arDSRecDataLabel[0], i, true);
            string = objectutil.convertFieldTypeToString(this.arDSRecDataLabel[0].FieldType, object);
            for (int j = 0; j < this.arDSRecDataValue.length; ++j) {
                object = this.AspectDriver.getField(this.arDSRecDataValue[j], i);
                double d = objectutil.convertToNumber(object);
                string = string + "^" + charutil.formatNumber(d, "#.####");
            }
            stringBuilder.append("|" + string);
        }
        return stringBuilder.toString();
    }
}

