/*
 * Decompiled with CFR 0.152.
 */
package utility;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.File;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import utility.charutil;
import utility.objectutil;

public class TChart {
    private static TMainWin MainWin = Aspect.MainWin;
    private static boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTChart");
    TDriverStructRecord[] arDSRecDataLabel = null;
    TDriverStructRecord[] arDSRecDataValue = null;
    String[] arFilter = null;
    JFreeChart chart = null;
    TAspectDriver AspectDriver = null;
    String AChartTitle = "Chart Title";
    String AFilename = "";
    String AChartType = "bar";
    String ACategoryAxisLabel = "Domain Axis Label";
    String AValueAxisLabel = "Value Axis Label";
    int AWidth = 640;
    int AHeight = 480;
    String TitleFontName = "";
    int TitleFontSize = 0;
    String TitleFontStyle = "";
    String DomainAxisDataLabelOrientation = "standard";
    boolean DomainAxisDataLabelsVisible = true;
    GradientPaint[] arGradientPaint;
    Paint ChartBackground = null;
    Paint PlotBackground = null;
    boolean bContainsSubtotals = false;

    public TChart(TAspectDriver tAspectDriver, String[] stringArray, String[] stringArray2, String[] stringArray3, String string) {
        int n;
        String string2;
        String[] stringArray4 = charutil.getSubStringArray(string, '&', true);
        this.AspectDriver = tAspectDriver;
        this.arFilter = stringArray3;
        this.AChartTitle = charutil.getParamValue(stringArray4, "ChartTitle");
        this.AFilename = charutil.getParamValue(stringArray4, "Filename");
        this.AChartType = charutil.getParamValue(stringArray4, "ChartType");
        this.ACategoryAxisLabel = charutil.getParamValue(stringArray4, "DomainAxisLabel");
        this.AValueAxisLabel = charutil.getParamValue(stringArray4, "ValueAxisLabel");
        this.AWidth = charutil.ival(charutil.getParamValue(stringArray4, "Width"));
        this.AHeight = charutil.ival(charutil.getParamValue(stringArray4, "Height"));
        this.TitleFontName = charutil.getParamValue(stringArray4, "TitleFontName");
        this.TitleFontSize = charutil.ival(charutil.getParamValue(stringArray4, "TitleFontSize"));
        this.TitleFontStyle = charutil.getParamValue(stringArray4, "TitleFontStyle");
        if (this.TitleFontName.length() == 0) {
            this.TitleFontName = "arial";
        }
        if (this.TitleFontSize == 0) {
            this.TitleFontSize = 12;
        }
        if (this.TitleFontStyle.length() == 0) {
            this.TitleFontStyle = "bold";
        }
        if ((string2 = charutil.getParamValue(stringArray4, "ChartBackground")).length() == 6) {
            try {
                this.ChartBackground = new Color(Integer.parseInt(string2.substring(0, 2), 16), Integer.parseInt(string2.substring(2, 4), 16), Integer.parseInt(string2.substring(4, 6), 16));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string2 = charutil.getParamValue(stringArray4, "PlotBackground")).length() == 6) {
            try {
                this.PlotBackground = new Color(Integer.parseInt(string2.substring(0, 2), 16), Integer.parseInt(string2.substring(2, 4), 16), Integer.parseInt(string2.substring(4, 6), 16));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.arGradientPaint = new GradientPaint[20];
        for (n = 0; n < 20; ++n) {
            this.arGradientPaint[n] = null;
            string2 = charutil.getParamValue(stringArray4, "Gradient" + Integer.toString(n + 1));
            if (string2.length() <= 0) continue;
            String[] stringArray5 = charutil.getSubStringArray(string2, '|', true);
            String string3 = stringArray5[0];
            String string4 = stringArray5[0];
            if (stringArray5.length > 1) {
                string4 = stringArray5[1];
            }
            if (string3.length() != 6 || string4.length() != 6) continue;
            try {
                Color color = new Color(Integer.parseInt(string3.substring(0, 2), 16), Integer.parseInt(string3.substring(2, 4), 16), Integer.parseInt(string3.substring(4, 6), 16));
                Color color2 = new Color(Integer.parseInt(string4.substring(0, 2), 16), Integer.parseInt(string4.substring(2, 4), 16), Integer.parseInt(string4.substring(4, 6), 16));
                this.arGradientPaint[n] = new GradientPaint(0.0f, 0.0f, color, 0.0f, 0.0f, color2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.AWidth == 0) {
            this.AWidth = 640;
        }
        if (this.AHeight == 0) {
            this.AHeight = 480;
        }
        this.DomainAxisDataLabelOrientation = charutil.getParamValue(stringArray4, "DomainAxisDataLabelOrientation");
        if (this.DomainAxisDataLabelOrientation.length() == 0) {
            this.DomainAxisDataLabelOrientation = "standard";
        }
        if ((string2 = charutil.getParamValue(stringArray4, "DomainAxisDataLabelsVisible")).length() > 0) {
            this.DomainAxisDataLabelsVisible = charutil.boolval(string2);
        }
        this.arDSRecDataLabel = new TDriverStructRecord[stringArray.length];
        this.arDSRecDataValue = new TDriverStructRecord[stringArray2.length];
        for (n = 0; n < stringArray.length; ++n) {
            this.arDSRecDataLabel[n] = tAspectDriver.getDriverStructRecord(stringArray[n]);
            if (this.arDSRecDataLabel[n] != null) continue;
            MainWin.appendToLog("TChart", "init", Thread.currentThread(), null, 4, "TChart cannot locate field with ID of " + stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            this.arDSRecDataValue[n] = tAspectDriver.getDriverStructRecord(stringArray2[n]);
            if (this.arDSRecDataValue[n] != null) continue;
            MainWin.appendToLog("TChart", "init", Thread.currentThread(), null, 4, "TChart cannot locate field with ID of " + stringArray2[n]);
        }
        this.bContainsSubtotals = false;
        n = this.AspectDriver.getRecordCount();
        for (int i = 0; !this.bContainsSubtotals && i < n; ++i) {
            this.bContainsSubtotals = this.AspectDriver.isSubtotal(i);
        }
    }

    public String createChart() {
        String string = "ok";
        if (this.AChartType.equalsIgnoreCase("pie")) {
            string = this.createPieChart();
        } else if (this.AChartType.equalsIgnoreCase("bar")) {
            string = this.createBarChart();
        } else if (this.AChartType.equalsIgnoreCase("line")) {
            string = this.createLineChart();
        } else if (this.AChartType.equalsIgnoreCase("scatter")) {
            string = this.createScatterChart();
        }
        return string;
    }

    public String createPieChart() {
        String string = "ok";
        int n = this.AspectDriver.getRecordCount();
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        for (int i = 0; i < n; ++i) {
            int n2 = this.AspectDriver.getAbsoluteDiskIndex(i);
            if (this.AspectDriver.isGrandTotalAbsolute(n2) || this.AspectDriver.isDetail(n2) && this.bContainsSubtotals) continue;
            Object object = this.AspectDriver.getFieldForHtml(this.arDSRecDataLabel[0], i);
            String string2 = objectutil.convertFieldTypeToString(this.arDSRecDataLabel[0].FieldType, object);
            object = this.AspectDriver.getField(this.arDSRecDataValue[0], i);
            double d = objectutil.convertToNumber(object);
            defaultPieDataset.setValue((Comparable)((Object)string2), (Number)new Double(d));
        }
        this.chart = ChartFactory.createPieChart((String)this.AChartTitle, (PieDataset)defaultPieDataset, (boolean)false, (boolean)true, (boolean)false);
        TextTitle textTitle = this.chart.getTitle();
        Font font = textTitle.getFont();
        int n3 = 1;
        if (this.TitleFontStyle.equalsIgnoreCase("italic")) {
            n3 = 2;
        } else if (this.TitleFontStyle.equalsIgnoreCase("plain")) {
            n3 = 0;
        }
        textTitle.setFont(new Font(this.TitleFontName, n3, this.TitleFontSize));
        if (this.ChartBackground != null) {
            this.chart.setBackgroundPaint(this.ChartBackground);
        }
        this.writeChartToFile();
        string = this.encodeChart();
        return string;
    }

    public String createBarChart() {
        int n;
        String string = "ok";
        double d = 0.0;
        double d2 = 0.0;
        int n2 = this.AspectDriver.getRecordCount();
        boolean bl = true;
        boolean bl2 = true;
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < this.arDSRecDataValue.length; ++i) {
            for (int j = 0; j < n2; ++j) {
                n = this.AspectDriver.getAbsoluteDiskIndex(j);
                if (this.AspectDriver.isGrandTotalAbsolute(n) || this.AspectDriver.isDetail(n) && this.bContainsSubtotals || !this.AspectDriver.isInFilter(j, this.arFilter[i])) continue;
                Object object = this.AspectDriver.getFieldForHtml(this.arDSRecDataLabel[i], j);
                String string2 = objectutil.convertFieldTypeToString(this.arDSRecDataLabel[i].FieldType, object);
                object = this.AspectDriver.getField(this.arDSRecDataValue[i], j);
                double d3 = objectutil.convertToNumber(object);
                String string3 = charutil.replaceChar(this.arDSRecDataValue[i].Description, '\\', ' ');
                defaultCategoryDataset.addValue((Number)new Double(d3), (Comparable)((Object)string3), (Comparable)((Object)string2));
                if (bl || d3 < d) {
                    d = d3;
                }
                if (bl2 || d3 > d2) {
                    d2 = d3;
                }
                bl = false;
                bl2 = false;
            }
        }
        this.chart = ChartFactory.createBarChart((String)this.AChartTitle, (String)this.ACategoryAxisLabel, (String)this.AValueAxisLabel, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        TextTitle textTitle = this.chart.getTitle();
        Font font = textTitle.getFont();
        n = 1;
        if (this.TitleFontStyle.equalsIgnoreCase("italic")) {
            n = 2;
        } else if (this.TitleFontStyle.equalsIgnoreCase("plain")) {
            n = 0;
        }
        textTitle.setFont(new Font(this.TitleFontName, n, this.TitleFontSize));
        CategoryPlot categoryPlot = this.chart.getCategoryPlot();
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setLowerBound(d - (d2 - d) * 0.1);
        numberAxis.setUpperBound(d2 + (d2 - d) * 0.1);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        if (!this.DomainAxisDataLabelOrientation.equalsIgnoreCase("standard")) {
            if (this.DomainAxisDataLabelOrientation.equalsIgnoreCase("down_45")) {
                categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
            } else if (this.DomainAxisDataLabelOrientation.equalsIgnoreCase("down_90")) {
                categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
            } else if (this.DomainAxisDataLabelOrientation.equalsIgnoreCase("up_45")) {
                categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
            } else if (this.DomainAxisDataLabelOrientation.equalsIgnoreCase("up_90")) {
                categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            }
        }
        categoryAxis.setTickLabelsVisible(this.DomainAxisDataLabelsVisible);
        if (this.PlotBackground != null) {
            categoryPlot.setBackgroundPaint(this.PlotBackground);
        }
        if (this.ChartBackground != null) {
            this.chart.setBackgroundPaint(this.ChartBackground);
        }
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        for (int i = 0; i < 20; ++i) {
            if (this.arGradientPaint[i] == null) continue;
            barRenderer.setSeriesPaint(i, (Paint)this.arGradientPaint[i]);
        }
        this.writeChartToFile();
        string = this.encodeChart();
        return string;
    }

    public String createLineChart() {
        int n;
        String string = "ok";
        double d = 0.0;
        double d2 = 0.0;
        int n2 = this.AspectDriver.getRecordCount();
        boolean bl = true;
        boolean bl2 = true;
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        int n3 = 0;
        for (int i = 0; i < this.arDSRecDataValue.length; ++i) {
            n3 = Math.max(n3, n2);
            for (int j = 0; j < n2; ++j) {
                n = this.AspectDriver.getAbsoluteDiskIndex(j);
                if (this.AspectDriver.isGrandTotalAbsolute(n) || this.AspectDriver.isDetail(n) && this.bContainsSubtotals || !this.AspectDriver.isInFilter(j, this.arFilter[i])) continue;
                Object object = this.AspectDriver.getFieldForHtml(this.arDSRecDataLabel[i], j);
                String string2 = objectutil.convertFieldTypeToString(this.arDSRecDataLabel[i].FieldType, object);
                object = this.AspectDriver.getField(this.arDSRecDataValue[i], j);
                double d3 = objectutil.convertToNumber(object);
                String string3 = charutil.replaceChar(this.arDSRecDataValue[i].Description, '\\', ' ');
                defaultCategoryDataset.addValue((Number)new Double(d3), (Comparable)((Object)string3), (Comparable)((Object)string2));
                if (bl || d3 < d) {
                    d = d3;
                }
                if (bl2 || d3 > d2) {
                    d2 = d3;
                }
                bl = false;
                bl2 = false;
            }
        }
        this.chart = ChartFactory.createLineChart((String)this.AChartTitle, (String)this.ACategoryAxisLabel, (String)this.AValueAxisLabel, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        TextTitle textTitle = this.chart.getTitle();
        Font font = textTitle.getFont();
        n = 1;
        if (this.TitleFontStyle.equalsIgnoreCase("italic")) {
            n = 2;
        } else if (this.TitleFontStyle.equalsIgnoreCase("plain")) {
            n = 0;
        }
        textTitle.setFont(new Font(this.TitleFontName, n, this.TitleFontSize));
        CategoryPlot categoryPlot = this.chart.getCategoryPlot();
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setLowerBound(d - (d2 - d) * 0.1);
        numberAxis.setUpperBound(d2 + (d2 - d) * 0.1);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        if (!this.DomainAxisDataLabelOrientation.equalsIgnoreCase("standard")) {
            if (this.DomainAxisDataLabelOrientation.equalsIgnoreCase("down_45")) {
                categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
            } else if (this.DomainAxisDataLabelOrientation.equalsIgnoreCase("down_90")) {
                categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
            } else if (this.DomainAxisDataLabelOrientation.equalsIgnoreCase("up_45")) {
                categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
            } else if (this.DomainAxisDataLabelOrientation.equalsIgnoreCase("up_90")) {
                categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            }
        }
        categoryAxis.setTickLabelsVisible(this.DomainAxisDataLabelsVisible);
        if (n3 > 50) {
            categoryAxis.setTickLabelsVisible(false);
        }
        if (this.PlotBackground != null) {
            categoryPlot.setBackgroundPaint(this.PlotBackground);
        }
        if (this.ChartBackground != null) {
            this.chart.setBackgroundPaint(this.ChartBackground);
        }
        LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        for (int i = 0; i < 20; ++i) {
            if (this.arGradientPaint[i] == null) continue;
            lineAndShapeRenderer.setSeriesPaint(i, (Paint)this.arGradientPaint[i]);
        }
        this.writeChartToFile();
        string = this.encodeChart();
        return string;
    }

    public String createScatterChart() {
        int n;
        Object object;
        String string = "ok";
        int n2 = this.AspectDriver.getRecordCount();
        String string2 = charutil.replaceChar(this.arDSRecDataValue[0].Description, '\\', ' ');
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        for (int i = 1; i < this.arDSRecDataValue.length; ++i) {
            String string3 = charutil.replaceChar(this.arDSRecDataValue[i].Description, '\\', ' ');
            object = new XYSeries((Comparable)((Object)string3));
            for (n = 0; n < n2; ++n) {
                int n3 = this.AspectDriver.getAbsoluteDiskIndex(n);
                if (this.AspectDriver.isGrandTotalAbsolute(n3) || this.AspectDriver.isDetail(n3) && this.bContainsSubtotals || !this.AspectDriver.isInFilter(n, this.arFilter[i])) continue;
                Object object2 = this.AspectDriver.getField(this.arDSRecDataValue[0], n);
                double d = objectutil.convertToNumber(object2);
                object2 = this.AspectDriver.getField(this.arDSRecDataValue[i], n);
                double d2 = objectutil.convertToNumber(object2);
                object.add(d, d2);
            }
            xYSeriesCollection.addSeries(object);
        }
        this.chart = ChartFactory.createScatterPlot((String)this.AChartTitle, (String)string2, (String)this.AValueAxisLabel, (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        TextTitle textTitle = this.chart.getTitle();
        object = textTitle.getFont();
        n = 1;
        if (this.TitleFontStyle.equalsIgnoreCase("italic")) {
            n = 2;
        } else if (this.TitleFontStyle.equalsIgnoreCase("plain")) {
            n = 0;
        }
        textTitle.setFont(new Font(this.TitleFontName, n, this.TitleFontSize));
        XYPlot xYPlot = this.chart.getXYPlot();
        if (this.PlotBackground != null) {
            xYPlot.setBackgroundPaint(this.PlotBackground);
        }
        if (this.ChartBackground != null) {
            this.chart.setBackgroundPaint(this.ChartBackground);
        }
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYPlot.getRenderer();
        for (int i = 0; i < 20; ++i) {
            if (this.arGradientPaint[i] != null) {
                xYLineAndShapeRenderer.setSeriesPaint(i, (Paint)this.arGradientPaint[i]);
            }
            xYLineAndShapeRenderer.setSeriesShape(i, (Shape)new Rectangle(3, 3));
        }
        this.writeChartToFile();
        string = this.encodeChart();
        return string;
    }

    public void writeChartToFile() {
        if (this.AFilename.length() == 0) {
            return;
        }
        try {
            if (this.AFilename.toUpperCase().indexOf(".JPG") >= 0) {
                ChartUtilities.saveChartAsJPEG((File)new File(this.AFilename), (JFreeChart)this.chart, (int)this.AWidth, (int)this.AHeight);
            } else if (this.AFilename.toUpperCase().indexOf(".PNG") >= 0) {
                ChartUtilities.saveChartAsPNG((File)new File(this.AFilename), (JFreeChart)this.chart, (int)this.AWidth, (int)this.AHeight);
            }
        }
        catch (Exception exception) {
            MainWin.appendToLog("TChart", "encodeChart", Thread.currentThread(), exception, 4, "Error saving chart image");
        }
    }

    public String encodeChart() {
        try {
            BufferedImage bufferedImage = this.chart.createBufferedImage(this.AWidth, this.AHeight);
            byte[] byArray = ChartUtilities.encodeAsPNG((BufferedImage)bufferedImage);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < byArray.length; ++i) {
                stringBuilder.append((char)byArray[i]);
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            MainWin.appendToLog("TChart", "encodeChart", Thread.currentThread(), exception, 4, "Error encoding chart");
            return "";
        }
    }
}

