/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.toolbar;

import aspect.TMainWin;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.MatteBorder;
import resources.TActionObject;
import resources.TAppToolbarObject;
import resources.TApplication;
import scrollwin.toolbar.TScrollToolbar;
import scrollwin.toolbar.TScrollToolbarControlInterface;
import utility.objectutil;

public class TScrollToolbarTextBox
extends JTextField
implements TScrollToolbarControlInterface {
    private TApplication Application = TMainWin.Application;
    private TAppToolbarObject AppToolbarObject;

    public TScrollToolbarTextBox(TScrollToolbar tScrollToolbar, TAppToolbarObject tAppToolbarObject, TActionObject tActionObject) {
        this.AppToolbarObject = tAppToolbarObject;
        this.setText(this.Application.getTokenValue(this.AppToolbarObject.AssociatedToken));
        Dimension dimension = this.AppToolbarObject.Width != 0 && this.AppToolbarObject.Height != 0 ? new Dimension(this.AppToolbarObject.Width, this.AppToolbarObject.Height) : new Dimension(200, 20);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        if (!this.AppToolbarObject.FontName.equalsIgnoreCase("default") || this.AppToolbarObject.FontSize != 0 || this.AppToolbarObject.FontStyle != 0) {
            objectutil.setFont(this, this.AppToolbarObject.FontName, this.AppToolbarObject.FontSize, this.AppToolbarObject.FontStyle);
            this.setForeground(new Color(this.AppToolbarObject.FontColor));
        }
        if (this.AppToolbarObject.LeftMargin > 0) {
            MatteBorder matteBorder = BorderFactory.createMatteBorder(0, this.AppToolbarObject.LeftMargin, 0, 0, tScrollToolbar.getBackground());
            this.setBorder(BorderFactory.createCompoundBorder(matteBorder, this.getBorder()));
        }
        this.setAction(tActionObject);
        this.addActionListener(tScrollToolbar.getToolbarListener());
        this.addFocusListener(tScrollToolbar.getToolbarListener());
    }

    @Override
    public boolean isTokenControl() {
        return false;
    }

    @Override
    public void update(String string, String string2) {
        this.setText(string2);
    }

    @Override
    public String getTokenID() {
        return this.AppToolbarObject.AssociatedToken;
    }

    @Override
    public String getControlValue() {
        return this.getText();
    }

    @Override
    public TAppToolbarObject getAppToolbarObject() {
        return this.AppToolbarObject;
    }
}

