/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.table;

import drivers.aspect.TAspectDriver;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import resources.TAppTablesObject;
import scrollwin.table.TScrollTable;
import scrollwin.table.TScrollTableModel;
import utility.charutil;
import utility.objectutil;

public class TScrollTableHeaderRenderer
extends JList
implements TableCellRenderer {
    private TableHeaderListRenderer renderer;
    private TScrollTable ScrollTable;
    private TScrollTableModel ScrollTableModel;
    private TableColumnModel ColumnModel;
    private TAspectDriver AspectDriver;
    private TAppTablesObject AppTablesObj;
    private Color ColorHeaderBackground;
    private Color ColorHeaderForeground;

    public TScrollTableHeaderRenderer(JTable jTable) {
        this.ScrollTable = (TScrollTable)jTable;
        this.ScrollTableModel = (TScrollTableModel)jTable.getModel();
        this.ColumnModel = this.ScrollTable.getTableHeader().getColumnModel();
        this.AspectDriver = this.ScrollTableModel.AspectDriver;
        this.AppTablesObj = this.AspectDriver.AspectDriverFilter.ActiveAppTablesObj;
        this.ColorHeaderBackground = new Color(this.AppTablesObj.TableHeaderBackground);
        this.ColorHeaderForeground = new Color(this.AppTablesObj.TableHeaderForeground);
        this.setForeground(this.ColorHeaderForeground);
        this.setBackground(this.ColorHeaderBackground);
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.renderer = new TableHeaderListRenderer();
        this.renderer.setForeground(this.ColorHeaderForeground);
        this.renderer.setBackground(this.ColorHeaderBackground);
        objectutil.setFont(this, this.AppTablesObj.TableHeaderFontName, this.AppTablesObj.TableHeaderFontSize, this.AppTablesObj.TableHeaderFontStyle);
        this.setCellRenderer(this.renderer);
    }

    @Override
    public synchronized void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.renderer != null) {
            this.renderer.setOpaque(bl);
        }
    }

    protected synchronized Icon getHeaderRendererIcon(int n, int n2) {
        int n3 = this.AspectDriver.getSortDirection(n);
        if (n3 != 0) {
            return new Arrow(n3 == -1, n2, 1);
        }
        return null;
    }

    @Override
    public synchronized Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        int n3;
        JLabel[] jLabelArray = new JLabel[this.ScrollTableModel.LinesInHeader];
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = 0;
        boolean bl3 = false;
        String string = this.AspectDriver.getFieldNotes(n2);
        if (string.trim().length() == 0) {
            string = (String)object;
        }
        this.setToolTipText(charutil.wrapAsHtml(string));
        Class clazz = this.ScrollTableModel.getColumnClass(n2);
        if (clazz != null && clazz.getName().equals("java.lang.String")) {
            this.renderer.setHorizontalAlignment(2);
        } else {
            this.renderer.setHorizontalAlignment(0);
        }
        StringBuilder stringBuilder2 = object == null ? new StringBuilder("") : new StringBuilder(object.toString());
        String[] stringArray = charutil.getSubStringArray(stringBuilder2, '\n', true);
        if (stringArray == null) {
            stringArray = new String[]{"Unlabelled"};
        }
        for (n3 = 0; n3 < this.ScrollTableModel.LinesInHeader - stringArray.length; ++n3) {
            jLabelArray[n3] = new JLabel(" ");
        }
        n4 = this.ScrollTableModel.LinesInHeader - stringArray.length;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            jLabelArray[n4] = stringArray[n3].length() == 0 ? new JLabel(" ") : new JLabel(stringArray[n3]);
            jLabelArray[n4].setOpaque(this.isOpaque());
            ++n4;
        }
        if (n2 >= 0) {
            int n5 = jTable.convertColumnIndexToModel(n2);
            jLabelArray[this.ScrollTableModel.LinesInHeader - 1].setIcon(this.getHeaderRendererIcon(n5, jLabelArray[this.ScrollTableModel.LinesInHeader - 1].getFont().getSize()));
        }
        this.setListData(jLabelArray);
        return this;
    }

    private class Arrow
    implements Icon {
        private boolean descending;
        private int size;
        private int priority;

        public Arrow(boolean bl, int n, int n2) {
            this.descending = bl;
            this.size = n;
            this.priority = n2;
        }

        @Override
        public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component == null ? Color.GRAY : component.getBackground();
            int n3 = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int n4 = this.descending ? n3 : -n3;
            n2 = n2 + 5 * this.size / 6 + (this.descending ? -n4 : 0);
            int n5 = this.descending ? 1 : -1;
            graphics.translate(n, n2);
            graphics.setColor(color.darker());
            graphics.drawLine(n3 / 2, n4, 0, 0);
            graphics.drawLine(n3 / 2, n4 + n5, 0, n5);
            graphics.setColor(color.brighter());
            graphics.drawLine(n3 / 2, n4, n3, 0);
            graphics.drawLine(n3 / 2, n4 + n5, n3, n5);
            if (this.descending) {
                graphics.setColor(color.darker().darker());
            } else {
                graphics.setColor(color.brighter().brighter());
            }
            graphics.drawLine(n3, 0, 0, 0);
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }

        @Override
        public synchronized int getIconWidth() {
            return this.size;
        }

        @Override
        public synchronized int getIconHeight() {
            return this.size;
        }
    }

    class TableHeaderListRenderer
    extends JLabel
    implements ListCellRenderer {
        TableHeaderListRenderer() {
        }

        public synchronized Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)object;
            if (jLabel != null) {
                this.setText(jLabel.getText());
                this.setIcon(jLabel.getIcon());
                this.setHorizontalTextPosition(2);
                this.setFont(jList.getFont());
            } else {
                this.setText(" ");
            }
            this.setOpaque(TScrollTableHeaderRenderer.this.isOpaque());
            return this;
        }
    }
}

