/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.filtertree;

import aspect.Aspect;
import aspect.TMainWin;
import controls.TProgressBar;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import resources.TAppTablesObject;
import scrollwin.filtertree.TScrollFilterTreeNode;
import scrollwin.filtertree.TScrollFilterTreeNodeListenerInterface;
import utility.objectutil;

public class TScrollFilterTree
extends JTree {
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTScrollFilterTree");
    public TAspectDriver AspectDriver = null;
    private TAppTablesObject AppTablesObj;
    private DefaultTreeModel Model;
    public TScrollFilterTreeNode TopNode;
    private TTreeCellEditor treeCellEditor;
    private TTreeCellRenderer treeCellRenderer;
    private Color ColorTreeBackground;
    private Color ColorTreeForeground;
    private Color ColorTreeSelectedBackground;
    private Color ColorTreeSelectedForeground;
    private Font TreeRootFont = null;
    private Font TreeFont = null;
    public boolean InitializingTree = false;
    public boolean CheckboxesEnabled = true;
    private TFilterTreeBuilder CurrentBuilder = null;
    public static int cFilterTreeBuilderInstance = 0;
    private TScrollFilterTreeNodeListenerInterface TreeNodeListener;

    public TScrollFilterTree(TScrollFilterTreeNode tScrollFilterTreeNode, TScrollFilterTreeNodeListenerInterface tScrollFilterTreeNodeListenerInterface, TAspectDriver tAspectDriver) {
        super(tScrollFilterTreeNode);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.Model = (DefaultTreeModel)this.getModel();
        this.TopNode = tScrollFilterTreeNode;
        this.AspectDriver = tAspectDriver;
        this.AppTablesObj = this.AspectDriver.AspectDriverFilter.ActiveAppTablesObj;
        this.TreeNodeListener = tScrollFilterTreeNodeListenerInterface;
        this.ColorTreeBackground = new Color(this.AppTablesObj.TreeBackground);
        this.ColorTreeForeground = new Color(this.AppTablesObj.TreeForeground);
        this.ColorTreeSelectedBackground = new Color(this.AppTablesObj.TreeSelectedBackground);
        this.ColorTreeSelectedForeground = new Color(this.AppTablesObj.TreeSelectedForeground);
        this.TreeFont = objectutil.makeFont(this.AppTablesObj.TreeFontName, this.AppTablesObj.TreeFontStyle, this.AppTablesObj.TreeFontSize);
        this.TreeRootFont = objectutil.makeFont(this.AppTablesObj.TreeFontName, 3, this.TreeFont.getSize() + 1);
        this.getSelectionModel().setSelectionMode(1);
        this.addMouseListener(new NodeSelectionListener(this));
        this.initializeTree();
    }

    public void setCheckboxes(boolean bl) {
        this.CheckboxesEnabled = bl;
    }

    public void initializeTree() {
        this.InitializingTree = true;
        if (this.CurrentBuilder != null && this.CurrentBuilder.isAlive()) {
            this.CurrentBuilder.Terminate = true;
            while (this.CurrentBuilder.isAlive()) {
                Thread.yield();
                if (!(Math.random() < 0.1)) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
        }
        this.CurrentBuilder = new TFilterTreeBuilder();
        this.AspectDriver.clearBuffer();
        this.CurrentBuilder.run();
        this.InitializingTree = false;
    }

    @Override
    public void paint(Graphics graphics) {
        if (cFilterTreeBuilderInstance > 0) {
            return;
        }
        super.paint(graphics);
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    public void expandSelectedPaths(TScrollFilterTreeNode tScrollFilterTreeNode) {
        TScrollFilterTreeNode tScrollFilterTreeNode2 = null;
        Enumeration<TreeNode> enumeration = tScrollFilterTreeNode.children();
        while (enumeration.hasMoreElements()) {
            tScrollFilterTreeNode2 = (TScrollFilterTreeNode)enumeration.nextElement();
            if (tScrollFilterTreeNode.equals(this.TopNode)) {
                if (tScrollFilterTreeNode2.isSelected()) continue;
                this.expandSelectedPaths(tScrollFilterTreeNode2);
                continue;
            }
            if (tScrollFilterTreeNode2.isSelected()) {
                Object[] objectArray = tScrollFilterTreeNode2.getPath();
                TreePath treePath = new TreePath(objectArray);
                this.expandPath(treePath.getParentPath());
                continue;
            }
            this.expandSelectedPaths(tScrollFilterTreeNode2);
        }
    }

    public String formatDescription(TDriverStructRecord tDriverStructRecord, Object object) {
        if (object == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        String string = "";
        switch (tDriverStructRecord.FieldType) {
            case 10: {
                if (tDriverStructRecord.FormatPattern.length() > 0) {
                    simpleDateFormat.applyPattern(tDriverStructRecord.FormatPattern);
                } else {
                    simpleDateFormat.applyPattern("MM-dd-yyyy");
                }
                string = simpleDateFormat.format((Date)object);
                break;
            }
            case 18: {
                if (tDriverStructRecord.FormatPattern.length() > 0) {
                    simpleDateFormat.applyPattern(tDriverStructRecord.FormatPattern);
                } else {
                    simpleDateFormat.applyPattern("HH:mm:ss");
                }
                string = simpleDateFormat.format((Date)object);
                break;
            }
            case 13: 
            case 21: {
                if (tDriverStructRecord.FormatPattern.length() > 0) {
                    simpleDateFormat.applyPattern(tDriverStructRecord.FormatPattern);
                } else {
                    simpleDateFormat.applyPattern("MM-dd-yyyy HH:mm:ss");
                }
                string = simpleDateFormat.format((Date)object);
                break;
            }
            default: {
                string = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
            }
        }
        return string;
    }

    public boolean isInTree(TScrollFilterTreeNode tScrollFilterTreeNode, int n) {
        boolean bl = false;
        if (tScrollFilterTreeNode != this.TopNode && tScrollFilterTreeNode.CheckBox.isSelected()) {
            if (tScrollFilterTreeNode.Record < 0) {
                bl = true;
            } else {
                Object object = this.AspectDriver.getFieldAbsoluteWithLookup(tScrollFilterTreeNode.DSRec, n);
                String string = this.formatDescription(tScrollFilterTreeNode.DSRec, object);
                if (tScrollFilterTreeNode.Description.equalsIgnoreCase(string)) {
                    bl = true;
                }
            }
        } else {
            Object object;
            String string;
            if (tScrollFilterTreeNode == this.TopNode) {
                bl = true;
                for (int i = 0; bl && i < tScrollFilterTreeNode.getChildCount(); ++i) {
                    TScrollFilterTreeNode tScrollFilterTreeNode2 = (TScrollFilterTreeNode)tScrollFilterTreeNode.getChildAt(i);
                    if (this.isInTree(tScrollFilterTreeNode2, n)) continue;
                    bl = false;
                }
            } else {
                for (int i = 0; !bl && i < tScrollFilterTreeNode.getChildCount(); ++i) {
                    TScrollFilterTreeNode tScrollFilterTreeNode3 = (TScrollFilterTreeNode)tScrollFilterTreeNode.getChildAt(i);
                    bl = this.isInTree(tScrollFilterTreeNode3, n);
                }
            }
            if (bl && tScrollFilterTreeNode.Record >= 0 && !tScrollFilterTreeNode.Description.equalsIgnoreCase(string = this.formatDescription(tScrollFilterTreeNode.DSRec, object = this.AspectDriver.getFieldAbsoluteWithLookup(tScrollFilterTreeNode.DSRec, n)))) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public TreeCellEditor getCellEditor() {
        if (this.treeCellEditor == null) {
            this.treeCellEditor = new TTreeCellEditor();
        }
        return this.treeCellEditor;
    }

    @Override
    public TreeCellRenderer getCellRenderer() {
        if (this.treeCellRenderer == null) {
            this.treeCellRenderer = new TTreeCellRenderer();
        }
        this.treeCellRenderer.setOpaque(this.isOpaque());
        return this.treeCellRenderer;
    }

    class TFilterTreeBuilder
    extends Thread {
        TScrollFilterTreeNode NewTopNode;
        boolean Terminate;

        public TFilterTreeBuilder() {
            super("TFilterTreeBuilder");
            this.Terminate = false;
            this.setPriority(1);
            ++cFilterTreeBuilderInstance;
        }

        public void addNodesFromPreviousTree(TScrollFilterTreeNode tScrollFilterTreeNode, TScrollFilterTreeNode tScrollFilterTreeNode2) {
            TScrollFilterTreeNode tScrollFilterTreeNode3 = null;
            TScrollFilterTreeNode tScrollFilterTreeNode4 = null;
            TScrollFilterTreeNode tScrollFilterTreeNode5 = null;
            Enumeration<TreeNode> enumeration = tScrollFilterTreeNode2.children();
            while (!this.Terminate && enumeration.hasMoreElements()) {
                tScrollFilterTreeNode3 = (TScrollFilterTreeNode)enumeration.nextElement();
                if (tScrollFilterTreeNode3.isSelected()) {
                    TreeNode[] treeNodeArray = tScrollFilterTreeNode3.getPath();
                    tScrollFilterTreeNode4 = tScrollFilterTreeNode;
                    for (int i = 1; i < treeNodeArray.length; ++i) {
                        Enumeration<TreeNode> enumeration2 = tScrollFilterTreeNode4.children();
                        boolean bl = false;
                        while (!bl && enumeration2.hasMoreElements()) {
                            tScrollFilterTreeNode5 = (TScrollFilterTreeNode)enumeration2.nextElement();
                            if (!tScrollFilterTreeNode5.Description.equalsIgnoreCase(((TScrollFilterTreeNode)treeNodeArray[i]).Description)) continue;
                            bl = true;
                            tScrollFilterTreeNode5.CheckBox.setSelected(((TScrollFilterTreeNode)treeNodeArray[i]).isSelected());
                        }
                        if (!bl) {
                            tScrollFilterTreeNode5 = new TScrollFilterTreeNode((TScrollFilterTreeNode)treeNodeArray[i]);
                            tScrollFilterTreeNode4.add(tScrollFilterTreeNode5);
                        }
                        tScrollFilterTreeNode4 = tScrollFilterTreeNode5;
                    }
                    continue;
                }
                this.addNodesFromPreviousTree(tScrollFilterTreeNode, tScrollFilterTreeNode3);
            }
        }

        public void addChildNodes(ArrayList arrayList, String string) {
            TScrollFilterTreeNode tScrollFilterTreeNode;
            int n;
            TScrollFilterTreeNode tScrollFilterTreeNode2 = null;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<TDriverStructRecord> arrayList3 = new ArrayList<TDriverStructRecord>();
            Hashtable<TScrollFilterTreeNode, TScrollFilterTreeNode> hashtable = new Hashtable<TScrollFilterTreeNode, TScrollFilterTreeNode>();
            ArrayList<TScrollFilterTreeNode> arrayList4 = new ArrayList<TScrollFilterTreeNode>();
            ArrayList<String> arrayList5 = new ArrayList<String>();
            StringBuilder stringBuilder = new StringBuilder();
            if (TScrollFilterTree.this.Debug) {
                System.out.println("adding child nodes for childID = " + string);
                System.out.println("Parents are: ");
                for (n = 0; n < arrayList.size(); ++n) {
                    tScrollFilterTreeNode = (TScrollFilterTreeNode)arrayList.get(n);
                    System.out.println("\t" + tScrollFilterTreeNode.Description);
                }
                System.out.println();
            }
            TDriverStructRecord tDriverStructRecord = TScrollFilterTree.this.AspectDriver.getDriverStructRecord(string);
            int n2 = TScrollFilterTree.this.AspectDriver.getAbsoluteRecordCount();
            for (int i = 0; !this.Terminate && i < n2; ++i) {
                String string2;
                String string3;
                Object object;
                if (TScrollFilterTree.this.AspectDriver.isAbsoluteIndexDeleted(i) || !TScrollFilterTree.this.AspectDriver.isInFilterAbsolute(i, TScrollFilterTree.this.AspectDriver.AspectDriverFilter.ActiveFilter) || (object = TScrollFilterTree.this.AspectDriver.getFieldAbsoluteWithLookup(tDriverStructRecord, i)) == null || (string3 = TScrollFilterTree.this.formatDescription(tDriverStructRecord, object)).length() <= 0) continue;
                if (TScrollFilterTree.this.Debug) {
                    System.out.println("Adding child = " + string3);
                }
                arrayList3.clear();
                tScrollFilterTreeNode = (TScrollFilterTreeNode)arrayList.get(0);
                TreeNode[] treeNodeArray = tScrollFilterTreeNode.getPath();
                for (n = 2; n < treeNodeArray.length; ++n) {
                    arrayList3.add(((TScrollFilterTreeNode)treeNodeArray[n]).DSRec);
                }
                arrayList5.clear();
                stringBuilder.setLength(0);
                for (n = 0; n < arrayList3.size(); ++n) {
                    TDriverStructRecord tDriverStructRecord2 = (TDriverStructRecord)arrayList3.get(n);
                    Object object2 = TScrollFilterTree.this.AspectDriver.getFieldAbsoluteWithLookup(tDriverStructRecord2, i);
                    if (object2 != null) {
                        string2 = TScrollFilterTree.this.formatDescription(tDriverStructRecord2, object2);
                        arrayList5.add(string2);
                        stringBuilder.append(string2);
                        continue;
                    }
                    arrayList5.add("");
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    tScrollFilterTreeNode = (TScrollFilterTreeNode)arrayList.get(n);
                    treeNodeArray = tScrollFilterTreeNode.getPath();
                    boolean bl = true;
                    for (int j = 2; j < treeNodeArray.length; ++j) {
                        string2 = ((TScrollFilterTreeNode)treeNodeArray[j]).Description;
                        String string4 = (String)arrayList5.get(j - 2);
                        if (string2.equalsIgnoreCase(string4)) continue;
                        bl = false;
                    }
                    if (!bl) continue;
                    tScrollFilterTreeNode2 = new TScrollFilterTreeNode(TScrollFilterTree.this.AspectDriver.getDriverID(), string3, tDriverStructRecord, i, object, false, stringBuilder.toString());
                    hashtable.put(tScrollFilterTreeNode2, tScrollFilterTreeNode);
                    int n3 = Collections.binarySearch(arrayList4, tScrollFilterTreeNode2);
                    if (n3 >= 0) continue;
                    arrayList4.add(Math.abs(n3 + 1), tScrollFilterTreeNode2);
                }
                arrayList2.add(string3);
            }
            if (arrayList4.size() > 0) {
                for (n = 0; !this.Terminate && n < arrayList4.size(); ++n) {
                    tScrollFilterTreeNode2 = (TScrollFilterTreeNode)arrayList4.get(n);
                    tScrollFilterTreeNode2.addListener(TScrollFilterTree.this.TreeNodeListener);
                    tScrollFilterTreeNode = (TScrollFilterTreeNode)hashtable.get(tScrollFilterTreeNode2);
                    tScrollFilterTreeNode.add(tScrollFilterTreeNode2);
                }
                if (tDriverStructRecord.ChildNode.length() > 0) {
                    this.addChildNodes(arrayList4, tDriverStructRecord.ChildNode);
                }
            }
            if (TScrollFilterTree.this.Debug) {
                System.out.println("Add child nodes for " + string + " Complete.");
            }
        }

        @Override
        public void run() {
            int n;
            int n2;
            TProgressBar tProgressBar = null;
            TScrollFilterTreeNode tScrollFilterTreeNode = null;
            TScrollFilterTreeNode tScrollFilterTreeNode2 = null;
            TScrollFilterTreeNode tScrollFilterTreeNode3 = TScrollFilterTree.this.TopNode;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            ArrayList arrayList = new ArrayList();
            ArrayList<TScrollFilterTreeNode> arrayList2 = new ArrayList<TScrollFilterTreeNode>();
            ArrayList<TScrollFilterTreeNode> arrayList3 = new ArrayList<TScrollFilterTreeNode>();
            if (TScrollFilterTree.this.Debug) {
                TScrollFilterTree.this.MainWin.appendToLog("TScrollFilterTree", "initializeTree", Thread.currentThread(), null, 10, "Initializing filter tree for " + TScrollFilterTree.this.AspectDriver.AppDriverObj.Description);
            }
            this.NewTopNode = new TScrollFilterTreeNode(TScrollFilterTree.this.TopNode.Description, true);
            for (n2 = 0; n2 < TScrollFilterTree.this.AspectDriver.DriverStruct.FieldColl.size(); ++n2) {
                TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)TScrollFilterTree.this.AspectDriver.DriverStruct.FieldColl.get(n2);
                if (!tDriverStructRecord.IsRootNode) continue;
                if (TScrollFilterTree.this.Debug) {
                    System.out.println("Adding root: " + tDriverStructRecord.FullID);
                }
                if ((n = Collections.binarySearch(arrayList2, tScrollFilterTreeNode = new TScrollFilterTreeNode(TScrollFilterTree.this.AspectDriver.getDriverID(), tDriverStructRecord.Description, tDriverStructRecord, true))) >= 0) continue;
                arrayList2.add(Math.abs(n + 1), tScrollFilterTreeNode);
            }
            int n3 = TScrollFilterTree.this.AspectDriver.getAbsoluteRecordCount();
            for (n2 = 0; !this.Terminate && n2 < arrayList2.size(); ++n2) {
                int n4;
                tScrollFilterTreeNode = (TScrollFilterTreeNode)arrayList2.get(n2);
                hashtable.clear();
                arrayList3.clear();
                for (n4 = 0; !this.Terminate && n4 < n3; ++n4) {
                    String string;
                    Object object;
                    if (!TScrollFilterTree.this.AspectDriver.isAbsoluteIndexDeleted(n4) && TScrollFilterTree.this.AspectDriver.isInFilterAbsolute(n4, TScrollFilterTree.this.AspectDriver.AspectDriverFilter.ActiveFilter) && (object = TScrollFilterTree.this.AspectDriver.getFieldAbsoluteWithLookup(tScrollFilterTreeNode.DSRec, n4)) != null && (string = TScrollFilterTree.this.formatDescription(tScrollFilterTreeNode.DSRec, object)).length() > 0 && !hashtable.containsKey(string)) {
                        if (TScrollFilterTree.this.Debug) {
                            System.out.println("Adding child to " + tScrollFilterTreeNode.DSRec.FullID + ": " + objectutil.convertToString(object));
                        }
                        if ((n = Collections.binarySearch(arrayList3, tScrollFilterTreeNode2 = new TScrollFilterTreeNode(TScrollFilterTree.this.AspectDriver.getDriverID(), string, tScrollFilterTreeNode.DSRec, n4, object, false, ""))) < 0) {
                            arrayList3.add(Math.abs(n + 1), tScrollFilterTreeNode2);
                        }
                        hashtable.put(string, object);
                    }
                    Thread.yield();
                    if (tProgressBar == null) continue;
                    tProgressBar.increment();
                }
                if (this.Terminate || arrayList3.size() <= 0) continue;
                tScrollFilterTreeNode.addListener(TScrollFilterTree.this.TreeNodeListener);
                this.NewTopNode.add(tScrollFilterTreeNode);
                for (n4 = 0; !this.Terminate && n4 < arrayList3.size(); ++n4) {
                    tScrollFilterTreeNode2 = (TScrollFilterTreeNode)arrayList3.get(n4);
                    tScrollFilterTreeNode2.addListener(TScrollFilterTree.this.TreeNodeListener);
                    tScrollFilterTreeNode.add(tScrollFilterTreeNode2);
                }
                if (tScrollFilterTreeNode.DSRec.ChildNode.length() <= 0) continue;
                this.addChildNodes(arrayList3, tScrollFilterTreeNode.DSRec.ChildNode);
            }
            arrayList2.clear();
            hashtable.clear();
            arrayList3.clear();
            if (tProgressBar != null) {
                tProgressBar.dispose();
            }
            if (!this.Terminate) {
                Enumeration<TreeNode> enumeration = TScrollFilterTree.this.TopNode.children();
                while (enumeration.hasMoreElements()) {
                    tScrollFilterTreeNode = (TScrollFilterTreeNode)enumeration.nextElement();
                    if (tScrollFilterTreeNode.isSelected()) continue;
                    this.addNodesFromPreviousTree(this.NewTopNode, tScrollFilterTreeNode);
                }
            }
            if (!this.Terminate) {
                TScrollFilterTree.this.TopNode = this.NewTopNode;
                TScrollFilterTree.this.Model.setRoot(TScrollFilterTree.this.TopNode);
                TScrollFilterTree.this.Model.reload();
                tScrollFilterTreeNode3.dispose();
            } else {
                this.NewTopNode.dispose();
            }
            if (!this.Terminate) {
                TScrollFilterTree.this.expandSelectedPaths(TScrollFilterTree.this.TopNode);
                if (TScrollFilterTree.this.TopNode.getChildCount() == 1) {
                    TScrollFilterTree.this.expandRow(1);
                }
                --cFilterTreeBuilderInstance;
            }
            --cFilterTreeBuilderInstance;
            if (TScrollFilterTree.this.Debug) {
                System.out.println("TScrollFilterTree.run() Complete");
            }
        }
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree tree;

        NodeSelectionListener(JTree jTree) {
            this.tree = jTree;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            boolean bl;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = this.tree.getRowForLocation(n, n2);
            TreePath treePath = this.tree.getPathForRow(n3);
            boolean bl2 = bl = mouseEvent.getButton() == 1;
            if (treePath != null) {
                boolean bl3;
                TScrollFilterTreeNode tScrollFilterTreeNode = (TScrollFilterTreeNode)treePath.getLastPathComponent();
                boolean bl4 = bl3 = !tScrollFilterTreeNode.CheckBox.isSelected();
                if (TScrollFilterTree.this.CheckboxesEnabled) {
                    TScrollFilterTreeNode tScrollFilterTreeNode2;
                    if (bl3 && bl && !tScrollFilterTreeNode.equals(TScrollFilterTree.this.TopNode)) {
                        tScrollFilterTreeNode.selectAllChildren(false);
                        tScrollFilterTreeNode2 = (TScrollFilterTreeNode)tScrollFilterTreeNode.getParent();
                        if (tScrollFilterTreeNode2 != null && !tScrollFilterTreeNode2.equals(TScrollFilterTree.this.TopNode)) {
                            tScrollFilterTreeNode.selectAllSiblings(false);
                        }
                    }
                    tScrollFilterTreeNode.CheckBox.setSelected(bl3);
                    ((DefaultTreeModel)this.tree.getModel()).nodeChanged(tScrollFilterTreeNode);
                    if (bl3) {
                        if (tScrollFilterTreeNode != TScrollFilterTree.this.TopNode) {
                            tScrollFilterTreeNode.selectAllParents(false);
                            tScrollFilterTreeNode.selectAllChildren(false);
                        }
                    } else {
                        for (int i = 0; i < TScrollFilterTree.this.TopNode.getChildCount(); ++i) {
                            tScrollFilterTreeNode2 = (TScrollFilterTreeNode)TScrollFilterTree.this.TopNode.getChildAt(i);
                            if (tScrollFilterTreeNode2.hasSelectedElement()) continue;
                            tScrollFilterTreeNode2.CheckBox.setSelected(true);
                        }
                    }
                    TScrollFilterTree.this.updateUI();
                    TScrollFilterTree.this.fireValueChanged(new TreeSelectionEvent((Object)TScrollFilterTree.this, treePath, false, null, null));
                } else if (bl && !tScrollFilterTreeNode.equals(TScrollFilterTree.this.TopNode) && tScrollFilterTreeNode.isLeaf()) {
                    tScrollFilterTreeNode.CheckBox.setSelected(!tScrollFilterTreeNode.CheckBox.isSelected());
                    ((DefaultTreeModel)this.tree.getModel()).nodeChanged(tScrollFilterTreeNode);
                }
            }
        }
    }

    public class TTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            TScrollFilterTreeNode tScrollFilterTreeNode = (TScrollFilterTreeNode)object;
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            defaultTreeCellRenderer.setOpaque(TScrollFilterTree.this.isOpaque());
            tScrollFilterTreeNode.CheckBox.setOpaque(TScrollFilterTree.this.isOpaque());
            if (n == 0 || !TScrollFilterTree.this.CheckboxesEnabled) {
                if (TScrollFilterTree.this.TreeRootFont == null) {
                    Font font = tScrollFilterTreeNode.CheckBox.getFont();
                    TScrollFilterTree.this.TreeRootFont = new Font(font.getName(), 1, font.getSize() + 1);
                }
                if (bl) {
                    if (this.isOpaque()) {
                        defaultTreeCellRenderer.setBackground(TScrollFilterTree.this.ColorTreeForeground);
                        defaultTreeCellRenderer.setBackgroundSelectionColor(TScrollFilterTree.this.ColorTreeForeground);
                        defaultTreeCellRenderer.setBackgroundNonSelectionColor(TScrollFilterTree.this.ColorTreeForeground);
                    }
                    defaultTreeCellRenderer.setForeground(TScrollFilterTree.this.ColorTreeBackground);
                    defaultTreeCellRenderer.setTextNonSelectionColor(TScrollFilterTree.this.ColorTreeBackground);
                    defaultTreeCellRenderer.setTextSelectionColor(TScrollFilterTree.this.ColorTreeBackground);
                } else {
                    if (this.isOpaque()) {
                        defaultTreeCellRenderer.setBackground(TScrollFilterTree.this.ColorTreeBackground);
                        defaultTreeCellRenderer.setBackgroundSelectionColor(TScrollFilterTree.this.ColorTreeBackground);
                        defaultTreeCellRenderer.setBackgroundNonSelectionColor(TScrollFilterTree.this.ColorTreeBackground);
                    }
                    defaultTreeCellRenderer.setForeground(TScrollFilterTree.this.ColorTreeForeground);
                    defaultTreeCellRenderer.setTextNonSelectionColor(TScrollFilterTree.this.ColorTreeForeground);
                    defaultTreeCellRenderer.setTextSelectionColor(TScrollFilterTree.this.ColorTreeForeground);
                }
                if (n == 0) {
                    defaultTreeCellRenderer.setFont(TScrollFilterTree.this.TreeRootFont);
                } else if (TScrollFilterTree.this.TreeFont != null) {
                    defaultTreeCellRenderer.setFont(TScrollFilterTree.this.TreeFont);
                }
                return defaultTreeCellRenderer;
            }
            if (this.isOpaque()) {
                tScrollFilterTreeNode.CheckBox.setBackground(TScrollFilterTree.this.ColorTreeBackground);
            }
            tScrollFilterTreeNode.CheckBox.setForeground(TScrollFilterTree.this.ColorTreeForeground);
            if (TScrollFilterTree.this.TreeFont != null) {
                tScrollFilterTreeNode.CheckBox.setFont(TScrollFilterTree.this.TreeFont);
            }
            return tScrollFilterTreeNode.CheckBox;
        }
    }

    public class TTreeCellEditor
    extends DefaultTreeCellEditor
    implements TreeCellEditor {
        public TTreeCellEditor() {
            super(TScrollFilterTree.this, (DefaultTreeCellRenderer)TScrollFilterTree.this.getCellRenderer());
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            return super.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
        }
    }
}

