/*
 * Decompiled with CFR 0.152.
 */
package scrollwin.dialogpanel;

import drivers.aspect.TAspectDriver;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import resources.TAppTablesObject;
import scrollwin.filtertree.TScrollFilterTree;
import scrollwin.subtotaltree.TScrollSubtotalTree;
import scrollwin.table.TScrollTable;
import scrollwin.table.TScrollTablePanel;

public class TDialogTablePanel
extends JPanel {
    public TScrollTablePanel TablePanel = null;
    public TScrollTable Table = null;
    public TAspectDriver AspectDriver = null;
    public TScrollFilterTree FilterTree = null;
    public TScrollSubtotalTree SubtotalTree = null;
    private JSplitPane SplitPane = null;
    private JSplitPane TreePane = null;
    private JScrollPane SubtotalScrollPane = null;
    private JScrollPane FilterScrollPane = null;

    public TDialogTablePanel() {
        this.setLayout(new BoxLayout(this, 2));
    }

    public void dispose() {
        this.Table.shutDownTable();
    }

    public void setTablePanel(TScrollTablePanel tScrollTablePanel) {
        if (this.AspectDriver != null) {
            this.AspectDriver.dispose();
        }
        this.removeAll();
        this.addTablePanel(tScrollTablePanel);
    }

    public void addTablePanel(TScrollTablePanel tScrollTablePanel) {
        this.TablePanel = tScrollTablePanel;
        this.Table = this.TablePanel.Table;
        this.AspectDriver = this.Table.AspectDriver;
        this.add(this.TablePanel);
        this.add(Box.createGlue());
        if (this.AspectDriver.DriverStruct.HasTreeNodes || this.AspectDriver.DriverStruct.HasSubtotals) {
            TAppTablesObject tAppTablesObject = this.AspectDriver.getAppTablesObject();
            if (tAppTablesObject == null) {
                this.AspectDriver.loadDisplay("");
                tAppTablesObject = this.AspectDriver.getAppTablesObject();
            }
            this.SplitPane = new JSplitPane();
            this.SplitPane.setOneTouchExpandable(true);
            this.SplitPane.setDividerSize(7);
            this.add((Component)this.SplitPane, "Center");
            this.SplitPane.setRightComponent(this.TablePanel);
            if (this.AspectDriver.DriverStruct.HasTreeNodes) {
                this.FilterTree = this.Table.initializeFilterTree();
                this.FilterTree.setBackground(new Color(tAppTablesObject.TreeBackground));
                this.FilterTree.expandRow(0);
                this.AspectDriver.setScrollFilterTree(this.FilterTree);
                this.FilterScrollPane = new JScrollPane(this.FilterTree);
                this.FilterScrollPane.setBackground(new Color(tAppTablesObject.TreeBackground));
            }
            if (this.AspectDriver.DriverStruct.HasSubtotals) {
                this.SubtotalTree = this.Table.initializeSubtotalTree();
                this.SubtotalTree.setBackground(new Color(tAppTablesObject.TreeBackground));
                this.SubtotalTree.expandRow(0);
                this.AspectDriver.setScrollSubtotalTree(this.SubtotalTree);
                this.SubtotalScrollPane = new JScrollPane(this.SubtotalTree);
                this.SubtotalScrollPane.setBackground(new Color(tAppTablesObject.TreeBackground));
            }
            if (this.FilterTree != null && this.SubtotalTree != null) {
                this.TreePane = new JSplitPane(0, true);
                this.TreePane.setResizeWeight(0.5);
                this.TreePane.setOneTouchExpandable(true);
                this.TreePane.setDividerSize(7);
                this.SplitPane.setLeftComponent(this.TreePane);
                this.TreePane.setTopComponent(this.FilterScrollPane);
                this.TreePane.setBottomComponent(this.SubtotalScrollPane);
            } else if (this.FilterTree != null) {
                this.SplitPane.setLeftComponent(this.FilterScrollPane);
            } else if (this.SubtotalTree != null) {
                this.SplitPane.setLeftComponent(this.SubtotalScrollPane);
            }
        } else {
            this.add((Component)this.TablePanel, "Center");
        }
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.TablePanel != null) {
            this.TablePanel.setOpaque(bl);
        }
        if (this.SplitPane != null) {
            this.SplitPane.setOpaque(bl);
        }
        if (this.TreePane != null) {
            this.TreePane.setOpaque(bl);
        }
        if (this.FilterScrollPane != null) {
            this.FilterScrollPane.setOpaque(bl);
            this.FilterScrollPane.getViewport().setOpaque(bl);
        }
        if (this.SubtotalScrollPane != null) {
            this.SubtotalScrollPane.setOpaque(bl);
            this.SubtotalScrollPane.getViewport().setOpaque(bl);
        }
        if (this.FilterTree != null) {
            this.FilterTree.setOpaque(bl);
        }
        if (this.SubtotalTree != null) {
            this.SubtotalTree.setOpaque(bl);
        }
    }
}

