/*
 * Decompiled with CFR 0.152.
 */
package scrollwin;

import aspect.Aspect;
import aspect.TMainWin;
import controls.TCheckBox;
import controls.TComboBox;
import controls.TTextField;
import drivers.aspect.TDisplaysFile;
import scrollwin.dialogpanel.TDialogTablePanel;
import scrollwin.dialogpanel.TScrollDialogPanel;
import scrollwin.dialogpanel.TScrollDialogPanelAbstractListener;
import scrollwin.dialogpanel.TScrollDialogPanelControl;
import scrollwin.dialogpanel.TScrollDialogPanelEvent;
import scrollwin.dialogpanel.TScrollDialogPanelListenerInterface;
import scrollwin.table.TScrollTablePanel;

public class TScrollDisplayDialog
extends TScrollDialogPanelAbstractListener
implements TScrollDialogPanelListenerInterface {
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTScrollDisplayDialog");
    private boolean InItemStateChange = false;
    private StringBuilder LastDisplayName = new StringBuilder();
    private boolean ProcessingEvent = false;

    public static String getDisplayNameSelection(TScrollDialogPanel tScrollDialogPanel) {
        TScrollDialogPanelControl tScrollDialogPanelControl = null;
        tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("$ScrollWinDisplayName");
        if (tScrollDialogPanelControl != null) {
            TComboBox tComboBox = (TComboBox)tScrollDialogPanelControl.ControlObj;
            return (String)tComboBox.getSelectedItem();
        }
        return null;
    }

    public void repaintTables(TScrollDialogPanel tScrollDialogPanel) {
        TScrollTablePanel tScrollTablePanel;
        TScrollDialogPanelControl tScrollDialogPanelControl;
        if (this.Debug) {
            this.MainWin.appendToLog("TScrollDisplayDialog", "repaintTables", Thread.currentThread(), null, 10, "repaint tables");
        }
        if ((tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("Displays_ListBoxColumns")) != null) {
            tScrollTablePanel = ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).TablePanel;
            tScrollTablePanel.AspectDriver.clearBuffer();
            tScrollTablePanel.AspectDriver.initializeFilteredList();
            tScrollTablePanel.Table.repaint();
        }
        if ((tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("Displays_ListBoxRows")) != null) {
            tScrollTablePanel = ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).TablePanel;
            tScrollTablePanel.AspectDriver.clearBuffer();
            tScrollTablePanel.AspectDriver.initializeFilteredList();
            tScrollTablePanel.Table.repaint();
        }
        if ((tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("Displays_ListBoxSubtotals")) != null) {
            tScrollTablePanel = ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).TablePanel;
            tScrollTablePanel.AspectDriver.clearBuffer();
            tScrollTablePanel.AspectDriver.initializeFilteredList();
            tScrollTablePanel.Table.repaint();
        }
    }

    public static TDisplaysFile getDisplaysFile(TScrollDialogPanel tScrollDialogPanel) {
        TDisplaysFile tDisplaysFile = null;
        TScrollDialogPanelControl tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("Displays_ListBoxColumns");
        if (tScrollDialogPanelControl != null) {
            TScrollTablePanel tScrollTablePanel = ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).TablePanel;
            tDisplaysFile = (TDisplaysFile)tScrollTablePanel.AspectDriver.F;
        }
        return tDisplaysFile;
    }

    public void loadDisplay(TScrollDialogPanel tScrollDialogPanel) {
        TScrollDialogPanelControl tScrollDialogPanelControl = null;
        String string = TScrollDisplayDialog.getDisplayNameSelection(tScrollDialogPanel);
        if (this.Debug) {
            this.MainWin.appendToLog("TScrollDisplayDialog", "loadDisplay", Thread.currentThread(), null, 10, "TScrollDisplayDialog:loadDisplay: " + string);
        }
        if (string != null && (tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("Displays_ListBoxColumns")) != null) {
            TScrollTablePanel tScrollTablePanel = ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).TablePanel;
            TDisplaysFile tDisplaysFile = (TDisplaysFile)tScrollTablePanel.AspectDriver.F;
            tDisplaysFile.updateTempFileFromBinary(string, false);
            tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("Displays_ListBoxSubtotals");
            tScrollTablePanel = ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).TablePanel;
            tScrollTablePanel.Table.getTableModel().fireTableStructureChanged();
            tScrollTablePanel.Table.InitializeEditors = true;
            this.repaintTables(tScrollDialogPanel);
        }
    }

    public void setAutoResizeSelected(TScrollDialogPanel tScrollDialogPanel, boolean bl) {
        TScrollDialogPanelControl tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("$ScrollWinDisplayAutoResize");
        if (tScrollDialogPanelControl != null) {
            ((TCheckBox)tScrollDialogPanelControl.ControlObj).setSelected(bl);
        }
    }

    public boolean isAutoResizeSelected(TScrollDialogPanel tScrollDialogPanel) {
        boolean bl = true;
        TScrollDialogPanelControl tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("$ScrollWinDisplayAutoResize");
        if (tScrollDialogPanelControl != null) {
            bl = ((TCheckBox)tScrollDialogPanelControl.ControlObj).isChecked();
        }
        return bl;
    }

    public void setAdvancedFilter(TScrollDialogPanel tScrollDialogPanel, String string) {
        TScrollDialogPanelControl tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("$ScrollWinDisplayAdvancedFilter");
        if (tScrollDialogPanelControl != null) {
            ((TTextField)tScrollDialogPanelControl.ControlObj).setText(string);
        }
    }

    public String getAdvancedFilter(TScrollDialogPanel tScrollDialogPanel) {
        String string = "";
        TScrollDialogPanelControl tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("$ScrollWinDisplayAdvancedFilter");
        if (tScrollDialogPanelControl != null) {
            string = ((TTextField)tScrollDialogPanelControl.ControlObj).getText();
        }
        return string.trim();
    }

    public void saveDisplayAs(TScrollDialogPanel tScrollDialogPanel) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = TScrollDisplayDialog.getDisplayNameSelection(tScrollDialogPanel);
        TMainWin.Application.setTokenValue("$SaveDisplayAs", string);
        TMainWin.Application.getTokenValue(stringBuilder, "Driver_Displays_SaveAs");
        TMainWin.executeDialog(stringBuilder.toString());
        TMainWin.Application.getTokenValue(stringBuilder, "$SaveDisplayAs");
        if (stringBuilder.length() > 0) {
            String string2 = stringBuilder.toString();
            boolean bl = this.isAutoResizeSelected(tScrollDialogPanel);
            String string3 = this.getAdvancedFilter(tScrollDialogPanel);
            if (!string2.equalsIgnoreCase(string)) {
                TDisplaysFile tDisplaysFile = TScrollDisplayDialog.getDisplaysFile(tScrollDialogPanel);
                tDisplaysFile.recordTempFileToBinary(string2, false, bl, string3);
                TScrollDialogPanelControl tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("$ScrollWinDisplayName");
                int n = ((TComboBox)tScrollDialogPanelControl.ControlObj).ComboBoxColl.getArrayIndexOfKey(string2);
                int n2 = 0;
                while (n2 >= 0) {
                    if ((n2 = tScrollDialogPanel.getControlWithId("$ScrollWinDisplayName", n2)) < 0) continue;
                    tScrollDialogPanelControl = (TScrollDialogPanelControl)tScrollDialogPanel.arControls.get(n2);
                    if (n < 0) {
                        ((TComboBox)tScrollDialogPanelControl.ControlObj).addItem(string2);
                        ((TComboBox)tScrollDialogPanelControl.ControlObj).ComboBoxColl.add(string2, string2);
                    }
                    ((TComboBox)tScrollDialogPanelControl.ControlObj).setSelectedItem(string2);
                    ++n2;
                }
                this.loadDisplay(tScrollDialogPanel);
            }
        }
    }

    public void saveDisplay(TScrollDialogPanel tScrollDialogPanel) {
        boolean bl = false;
        String string = TScrollDisplayDialog.getDisplayNameSelection(tScrollDialogPanel);
        bl = this.isAutoResizeSelected(tScrollDialogPanel);
        String string2 = this.getAdvancedFilter(tScrollDialogPanel);
        TScrollDialogPanelControl tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("Displays_ListBoxColumns");
        if (tScrollDialogPanelControl != null) {
            TScrollTablePanel tScrollTablePanel = ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).TablePanel;
            TDisplaysFile tDisplaysFile = (TDisplaysFile)tScrollTablePanel.AspectDriver.F;
            tDisplaysFile.recordTempFileToBinary(string.toString(), true, bl, string2);
        }
    }

    public void deleteDisplay(TScrollDialogPanel tScrollDialogPanel) {
        TScrollDialogPanelControl tScrollDialogPanelControl;
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        int n = Aspect.MainWin.showConfirmDialog(null, "Delete this display?", "Confirm...", 0);
        if (n != 0) {
            return;
        }
        String string2 = TScrollDisplayDialog.getDisplayNameSelection(tScrollDialogPanel);
        if (string2 != null && (tScrollDialogPanelControl = tScrollDialogPanel.getControlWithId("Displays_ListBoxColumns")) != null) {
            int n2;
            TScrollTablePanel tScrollTablePanel = ((TDialogTablePanel)tScrollDialogPanelControl.ControlObj).TablePanel;
            TDisplaysFile tDisplaysFile = (TDisplaysFile)tScrollTablePanel.AspectDriver.F;
            if (tDisplaysFile.deleteDisplay(string2) && (n2 = tScrollDialogPanel.getControlWithId("$ScrollWinDisplayName", 0)) >= 0) {
                tScrollDialogPanelControl = (TScrollDialogPanelControl)tScrollDialogPanel.arControls.get(n2);
                int n3 = ((TComboBox)tScrollDialogPanelControl.ControlObj).ComboBoxColl.getArrayIndexOfKey(string2);
                int n4 = n3 - 1;
                if (n3 >= 0) {
                    n2 = 0;
                    while (n2 >= 0) {
                        if ((n2 = tScrollDialogPanel.getControlWithId("$ScrollWinDisplayName", n2)) < 0) continue;
                        tScrollDialogPanelControl = (TScrollDialogPanelControl)tScrollDialogPanel.arControls.get(n2);
                        ((TComboBox)tScrollDialogPanelControl.ControlObj).removeItemAt(n3);
                        ((TComboBox)tScrollDialogPanelControl.ControlObj).ComboBoxColl.remove(n3);
                        if (n4 >= 0) {
                            ((TComboBox)tScrollDialogPanelControl.ControlObj).setSelectedIndex(n4);
                            string = (String)((TComboBox)tScrollDialogPanelControl.ControlObj).getSelectedItem();
                        } else {
                            string = "Default Display";
                            ((TComboBox)tScrollDialogPanelControl.ControlObj).addItem(string);
                            ((TComboBox)tScrollDialogPanelControl.ControlObj).ComboBoxColl.add(string, string);
                        }
                        ++n2;
                    }
                }
                tDisplaysFile.updateTempFileFromBinary(string, false);
                if (n4 < 0) {
                    boolean bl = this.isAutoResizeSelected(tScrollDialogPanel);
                    String string3 = this.getAdvancedFilter(tScrollDialogPanel);
                    tDisplaysFile.recordTempFileToBinary(string, true, bl, string3);
                }
                this.loadDisplay(tScrollDialogPanel);
            }
        }
    }

    public void ok(TScrollDialogPanel tScrollDialogPanel) {
        this.saveDisplay(tScrollDialogPanel);
    }

    public void updateTokenValues(TScrollDialogPanel tScrollDialogPanel) {
        TDisplaysFile tDisplaysFile = TScrollDisplayDialog.getDisplaysFile(tScrollDialogPanel);
        this.setAdvancedFilter(tScrollDialogPanel, tDisplaysFile.getAdvancedFilter());
        this.setAutoResizeSelected(tScrollDialogPanel, tDisplaysFile.getAutoResize());
    }

    @Override
    public void beginTransferValues(TScrollDialogPanel tScrollDialogPanel, int n) {
    }

    @Override
    public void endTransferValues(TScrollDialogPanel tScrollDialogPanel, int n) {
        if (n == 0) {
            this.updateTokenValues(tScrollDialogPanel);
        }
    }

    @Override
    public void scrollDialogPanelEventOccurred(TScrollDialogPanelEvent tScrollDialogPanelEvent) {
        this.ProcessingEvent = true;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        TDisplaysFile tDisplaysFile = TScrollDisplayDialog.getDisplaysFile(tScrollDialogPanelEvent.getScrollDialogPanel());
        TScrollDialogPanelControl tScrollDialogPanelControl = tScrollDialogPanelEvent.getScrollDialogPanelControl();
        String string = tScrollDialogPanelEvent.getScrollDialogPanelControlID();
        String string2 = TScrollDisplayDialog.getDisplayNameSelection(tScrollDialogPanelEvent.getScrollDialogPanel());
        if (tScrollDialogPanelEvent.getEventType() == 0) {
            bl = true;
        }
        if (tScrollDialogPanelEvent.getEventType() == 1) {
            if (this.ProcessingEvent) {
                return;
            }
            this.repaintTables(tScrollDialogPanelEvent.getScrollDialogPanel());
        }
        if (bl && string.equalsIgnoreCase("IDOK")) {
            this.saveDisplay(tScrollDialogPanelEvent.getScrollDialogPanel());
        } else if (bl && string.equalsIgnoreCase("Displays_Save")) {
            this.saveDisplay(tScrollDialogPanelEvent.getScrollDialogPanel());
        } else if (bl && string.equalsIgnoreCase("Displays_SaveAs")) {
            this.saveDisplayAs(tScrollDialogPanelEvent.getScrollDialogPanel());
        } else if (bl && string.equalsIgnoreCase("Displays_Restore")) {
            if (string2 != null) {
                tDisplaysFile.updateTempFileFromBinary(string2, true);
                this.repaintTables(tScrollDialogPanelEvent.getScrollDialogPanel());
            }
        } else if (bl && string.equalsIgnoreCase("Displays_Delete")) {
            String string3 = TScrollDisplayDialog.getDisplayNameSelection(tScrollDialogPanelEvent.getScrollDialogPanel());
            if (string3 != null) {
                this.deleteDisplay(tScrollDialogPanelEvent.getScrollDialogPanel());
            }
        } else if (string.equalsIgnoreCase("$ScrollWinDisplayName")) {
            if (string2 != null && !string2.equalsIgnoreCase(this.LastDisplayName.toString())) {
                this.loadDisplay(tScrollDialogPanelEvent.getScrollDialogPanel());
                this.updateTokenValues(tScrollDialogPanelEvent.getScrollDialogPanel());
                this.LastDisplayName.setLength(0);
                this.LastDisplayName.append(string2);
            }
        } else if (bl && string.equalsIgnoreCase("Displays_ResetFilters")) {
            tDisplaysFile.resetFilters();
            this.repaintTables(tScrollDialogPanelEvent.getScrollDialogPanel());
        } else if (bl && string.equalsIgnoreCase("Displays_ResetSubtotals")) {
            tDisplaysFile.resetSubtotals();
            this.repaintTables(tScrollDialogPanelEvent.getScrollDialogPanel());
        } else if (bl && string.equalsIgnoreCase("Displays_SelectAll")) {
            tDisplaysFile.selectAll(true);
            this.repaintTables(tScrollDialogPanelEvent.getScrollDialogPanel());
        } else if (bl && string.equalsIgnoreCase("Displays_SelectNone")) {
            tDisplaysFile.selectAll(false);
            this.repaintTables(tScrollDialogPanelEvent.getScrollDialogPanel());
        } else if (bl && string.equalsIgnoreCase("Displays_MoveUp")) {
            TScrollDialogPanelControl tScrollDialogPanelControl2 = tScrollDialogPanelEvent.getScrollDialogPanel().getControlWithId("Displays_ListBoxColumns");
            if (tScrollDialogPanelControl2 != null) {
                TScrollTablePanel tScrollTablePanel = ((TDialogTablePanel)tScrollDialogPanelControl2.ControlObj).TablePanel;
                tScrollTablePanel.Table.moveSelectionUp();
                this.repaintTables(tScrollDialogPanelEvent.getScrollDialogPanel());
            }
        } else if (bl && string.equalsIgnoreCase("Displays_MoveDown")) {
            TScrollDialogPanelControl tScrollDialogPanelControl3 = tScrollDialogPanelEvent.getScrollDialogPanel().getControlWithId("Displays_ListBoxColumns");
            if (tScrollDialogPanelControl3 != null) {
                TScrollTablePanel tScrollTablePanel = ((TDialogTablePanel)tScrollDialogPanelControl3.ControlObj).TablePanel;
                tScrollTablePanel.Table.moveSelectionDown();
                this.repaintTables(tScrollDialogPanelEvent.getScrollDialogPanel());
            }
        } else if (bl && string.equalsIgnoreCase("Displays_MoveVisibleToTop")) {
            tDisplaysFile.moveSelectedToTop();
            this.repaintTables(tScrollDialogPanelEvent.getScrollDialogPanel());
        }
        this.ProcessingEvent = false;
    }

    public static Object canClose(TScrollDialogPanel tScrollDialogPanel, TScrollDialogPanelControl tScrollDialogPanelControl) {
        return new Boolean(true);
    }
}

