/*
 * Decompiled with CFR 0.152.
 */
package scrollwin;

import aspect.Aspect;
import aspect.TMainWin;
import controls.TButton;
import controls.TDialog;
import controls.TFrame;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TEditDialogsDriver;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.SwingUtilities;
import resources.TAppActionObject;
import resources.TAppDriversObject;
import resources.TApplication;
import scripts.TExecScript;
import scrollwin.dialogpanel.TScrollDialogPanel;
import scrollwin.dialogpanel.TScrollDialogPanelEvent;
import scrollwin.dialogpanel.TScrollDialogPanelListenerInterface;
import utility.charutil;

public class TScrollDialog
extends TDialog
implements TScrollDialogPanelListenerInterface {
    private TMainWin MainWin = Aspect.MainWin;
    private TFrame ParentFrame;
    private TApplication Application;
    private TAspectDriver AspectDriver = null;
    private String DialogID;
    private TAppDriversObject AppDriversObject = null;
    public TScrollDialogPanel ScrollDialogPanel = null;
    private boolean IsPreview = false;
    private boolean IsExecuting = false;
    private static Stack stackCurrentDialog = new Stack();

    public TScrollDialog(TFrame tFrame, String string, TApplication tApplication, TAspectDriver tAspectDriver, String string2, TAppDriversObject tAppDriversObject, int n) {
        super(tFrame, string, true);
        this.getRootPane().setOpaque(true);
        this.ParentFrame = tFrame;
        this.Application = tApplication;
        this.AspectDriver = tAspectDriver;
        this.DialogID = string2;
        this.AppDriversObject = tAppDriversObject;
        this.setDefaultCloseOperation(n);
        this.ScrollDialogPanel = new TScrollDialogPanel(this.Application, this.AspectDriver, this.DialogID);
    }

    public TScrollDialog(TFrame tFrame, String string, TApplication tApplication, TEditDialogsDriver tEditDialogsDriver, String string2) {
        super(tFrame, string, true);
        this.getRootPane().setOpaque(true);
        this.IsPreview = true;
        this.ParentFrame = tFrame;
        this.Application = tApplication;
        this.AspectDriver = null;
        this.DialogID = string2;
        this.setDefaultCloseOperation(2);
        this.ScrollDialogPanel = new TScrollDialogPanel(this.Application, tEditDialogsDriver, string2);
    }

    @Override
    public void dispose() {
        this.ScrollDialogPanel.dispose();
        if (!TMainWin.IsClosing) {
            super.dispose();
        }
        System.gc();
    }

    public static TScrollDialog getCurrentDialog() {
        if (stackCurrentDialog.size() == 0) {
            return null;
        }
        return (TScrollDialog)stackCurrentDialog.peek();
    }

    public int getRecordNumber() {
        return this.ScrollDialogPanel.getRecordNumber();
    }

    public void setResourceElements(ArrayList arrayList) {
        this.ScrollDialogPanel.setResourceElements(arrayList);
    }

    public void createGui() {
        TButton tButton;
        this.ScrollDialogPanel.createPanel();
        this.setContentPane(this.ScrollDialogPanel);
        this.setTitle(this.ScrollDialogPanel.getTitleStr());
        this.ScrollDialogPanel.addScrollDialogPanelListener(this);
        if (this.AppDriversObject != null && this.AppDriversObject.DialogListener.length() > 0) {
            this.ScrollDialogPanel.addScrollDialogPanelListener(this.AppDriversObject.DialogListener.toString());
        }
        if ((tButton = this.ScrollDialogPanel.getDefaultButton()) != null) {
            this.getRootPane().setDefaultButton(tButton);
        }
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public TScrollDialogPanel getScrollDialogPanel() {
        return this.ScrollDialogPanel;
    }

    public String getReturnValue() {
        return this.ScrollDialogPanel.getReturnValue();
    }

    public void transferValues(int n, int n2) {
        this.ScrollDialogPanel.transferValues(n, n2);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void execute() {
        this.IsExecuting = true;
        stackCurrentDialog.push(this);
        super.setVisible(true);
        stackCurrentDialog.pop();
    }

    @Override
    public void enterPressed() {
        this.ScrollDialogPanel.Ok();
        this.ok();
    }

    @Override
    public void escPressed() {
        this.ScrollDialogPanel.Cancel();
        this.cancel();
    }

    @Override
    public void ok() {
        this.setVisible(false);
    }

    @Override
    public void cancel() {
        this.setVisible(false);
    }

    @Override
    public void close(String string) {
        final String string2 = this.ScrollDialogPanel.getReturnValue();
        if (string2.indexOf(46) < 0) {
            this.setVisible(false);
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string;
                        String[] stringArray;
                        if (string2.toUpperCase().startsWith("ACTION.")) {
                            String string2 = string2.substring(7);
                            TAppActionObject tAppActionObject = ((TScrollDialog)TScrollDialog.this).Application.AppAction.getAppActionObject(string2);
                            if (tAppActionObject != null) {
                                Aspect.MainWin.executeActionObject(tAppActionObject.ActionObject, null);
                            } else {
                                TScrollDialog.this.MainWin.appendToLog("TDesktopPane", "close", Thread.currentThread(), null, 3, "Unable to locate an action with the ID of '" + string2 + "'");
                            }
                        } else if (string2.toUpperCase().startsWith("SCRIPT.")) {
                            String string3 = string2.substring(7);
                            Aspect.MainWin.executeScript(string3);
                        } else if (string2.toUpperCase().startsWith("VIEW.")) {
                            String string4 = string2.substring(5);
                            TExecScript tExecScript = new TExecScript("Aspect_Common_selectView", null, null);
                            String[] stringArray2 = new String[]{"THtmlViewer", "", "Description=" + string4};
                            tExecScript.setParameters(stringArray2);
                            tExecScript.start();
                        } else if (string2.toUpperCase().startsWith("DIALOG.")) {
                            String string5 = string2.substring(7);
                            String[] stringArray3 = charutil.getSubStringArray(string5, '?', true);
                            if (stringArray3 != null && stringArray3.length > 0) {
                                String string6 = stringArray3[0];
                                int n = 0;
                                if (stringArray3.length > 1) {
                                    n = charutil.ival(stringArray3[1]);
                                }
                                TMainWin.executeDialog(string6, n);
                            }
                        } else if (string2.toUpperCase().startsWith("DRIVERCMD.") && (stringArray = charutil.getSubStringArray(string = string2.substring(10), ',', true)) != null) {
                            if (stringArray.length == 1) {
                                Aspect.MainWin.executeDriverCommand(stringArray[0], "");
                            } else {
                                Aspect.MainWin.executeDriverCommand(stringArray[0], stringArray[1]);
                            }
                        }
                    }
                });
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    @Override
    public void beginTransferValues(TScrollDialogPanel tScrollDialogPanel, int n) {
    }

    @Override
    public void endTransferValues(TScrollDialogPanel tScrollDialogPanel, int n) {
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.ScrollDialogPanel.getDefaultFocus() != null) {
            this.ScrollDialogPanel.getDefaultFocus().requestFocus();
        }
    }

    @Override
    public void scrollDialogPanelEventOccurred(TScrollDialogPanelEvent tScrollDialogPanelEvent) {
    }

    @Override
    public void nextRecord() {
    }

    @Override
    public void previousRecord() {
    }

    @Override
    public void firstRecord() {
    }

    @Override
    public void lastRecord() {
    }

    @Override
    public void gotoRecord(int n) {
    }
}

