/*
 * Decompiled with CFR 0.152.
 */
package scripts;

import aspect.Aspect;
import aspect.TMainWin;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import resources.TAppScriptsObject;
import scripts.TExecScriptCommand;
import scripts.TExecScriptDriver;
import utility.TFormulaEvaluator;
import utility.charutil;

public class TExecScriptCommandSet {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTExecScript");
    private boolean ContainsInitializer = false;
    private String ScriptID = "";
    TExecScriptDriver ExecScriptDriver;
    ArrayList arCommandSet = new ArrayList();
    int CmdIndex = -1;

    public TExecScriptCommandSet(String string, TExecScriptDriver tExecScriptDriver, ArrayList arrayList) {
        this.ScriptID = string;
        this.ExecScriptDriver = tExecScriptDriver;
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            TExecScriptCommand tExecScriptCommand;
            Object object;
            TAppScriptsObject tAppScriptsObject = (TAppScriptsObject)arrayList.get(i);
            if (tAppScriptsObject.Command.length() <= 0) continue;
            if (tAppScriptsObject.Command.trim().endsWith("++")) {
                object = tAppScriptsObject.Command.trim().substring(0, tAppScriptsObject.Command.length() - 2);
                object = (String)object + "=" + (String)object + "+1";
                tExecScriptCommand = new TExecScriptCommand(n, (String)object);
                this.arCommandSet.add(tExecScriptCommand);
                ++n;
                continue;
            }
            if (tAppScriptsObject.Command.trim().endsWith("--")) {
                object = tAppScriptsObject.Command.trim().substring(0, tAppScriptsObject.Command.length() - 2);
                object = (String)object + "=" + (String)object + "-1";
                tExecScriptCommand = new TExecScriptCommand(n, (String)object);
                this.arCommandSet.add(tExecScriptCommand);
                ++n;
                continue;
            }
            if (tAppScriptsObject.Command.trim().toUpperCase().startsWith("RETURN(")) {
                object = tAppScriptsObject.Command.trim().substring(7);
                object = ((String)object).substring(0, ((String)object).length() - 1);
                tExecScriptCommand = new TExecScriptCommand(n, "scriptSetResult(" + (String)object + ")");
                this.arCommandSet.add(tExecScriptCommand);
                tExecScriptCommand = new TExecScriptCommand(++n, "exit");
                this.arCommandSet.add(tExecScriptCommand);
                ++n;
                continue;
            }
            object = new TExecScriptCommand(n, tAppScriptsObject.Command);
            this.arCommandSet.add(object);
            ++n;
            if (!((TExecScriptCommand)object).isScriptInitializer()) continue;
            this.ContainsInitializer = true;
        }
    }

    public void dispose() {
        this.arCommandSet.clear();
    }

    public void errorMsg(TExecScriptCommand tExecScriptCommand, String string) {
        MainWin.appendToLog(this.getClass().getName(), "errorMsg", Thread.currentThread(), null, 4, "Error in script: " + string + " ID:" + this.ScriptID);
        if (tExecScriptCommand != null) {
            MainWin.appendToLog(this.getClass().getName(), "errorMsg", Thread.currentThread(), null, 4, "\twhile executing: " + tExecScriptCommand.getCommand());
        }
    }

    public boolean getContainsInitializer() {
        return this.ContainsInitializer;
    }

    public TExecScriptCommand getCommand(int n) {
        if (n >= 0 && n < this.arCommandSet.size()) {
            return (TExecScriptCommand)this.arCommandSet.get(n);
        }
        return null;
    }

    public int nextElse(int n) {
        int n2 = 1;
        boolean bl = false;
        for (int i = n + 1; i < this.arCommandSet.size(); ++i) {
            TExecScriptCommand tExecScriptCommand = this.getCommand(i);
            if (tExecScriptCommand.getCommandType() == 2) {
                ++n2;
                continue;
            }
            if (tExecScriptCommand.getCommandType() == 5) {
                if (--n2 != 0) continue;
                return -1;
            }
            if (tExecScriptCommand.getCommandType() != 3 && tExecScriptCommand.getCommandType() != 4 || n2 != 1) continue;
            return i;
        }
        return -1;
    }

    public int nextEndIf(int n) {
        int n2 = 0;
        boolean bl = false;
        for (int i = n + 1; i < this.arCommandSet.size(); ++i) {
            TExecScriptCommand tExecScriptCommand = this.getCommand(i);
            if (tExecScriptCommand.getCommandType() == 2) {
                ++n2;
                continue;
            }
            if (tExecScriptCommand.getCommandType() != 5) continue;
            if (n2 > 0) {
                --n2;
                continue;
            }
            return i;
        }
        this.errorMsg(this.getCommand(n), "If without endif(1) in script " + this.ScriptID + " " + this.getCommand(n).getCommand());
        return -1;
    }

    public int endOfWhileLoop(int n) {
        int n2 = 0;
        boolean bl = false;
        for (int i = n + 1; i < this.arCommandSet.size(); ++i) {
            TExecScriptCommand tExecScriptCommand = this.getCommand(i);
            if (tExecScriptCommand.getCommandType() == 6) {
                ++n2;
                continue;
            }
            if (tExecScriptCommand.getCommandType() != 7) continue;
            if (n2 > 0) {
                --n2;
                continue;
            }
            return i;
        }
        this.errorMsg(this.getCommand(n), "While without EndWhile");
        return -1;
    }

    public int startOfWhileLoop(int n) {
        int n2 = 0;
        boolean bl = false;
        for (int i = n - 1; i >= 0; --i) {
            TExecScriptCommand tExecScriptCommand = this.getCommand(i);
            if (tExecScriptCommand.getCommandType() == 7) {
                ++n2;
                continue;
            }
            if (tExecScriptCommand.getCommandType() != 6) continue;
            if (n2 > 0) {
                --n2;
                continue;
            }
            return i;
        }
        this.errorMsg(this.getCommand(n), "Loop without do");
        return -1;
    }

    public int previousDo(int n) {
        int n2 = 0;
        boolean bl = false;
        for (int i = n - 1; i >= 0; --i) {
            TExecScriptCommand tExecScriptCommand = this.getCommand(i);
            if (tExecScriptCommand.getCommandType() == 9) {
                ++n2;
                continue;
            }
            if (tExecScriptCommand.getCommandType() != 8) continue;
            if (n2 > 0) {
                --n2;
                continue;
            }
            return i;
        }
        this.errorMsg(this.getCommand(n), "Loop without do");
        return -1;
    }

    public TExecScriptCommand gotoNextLine() {
        ++this.CmdIndex;
        if (this.CmdIndex >= this.arCommandSet.size()) {
            return null;
        }
        TExecScriptCommand tExecScriptCommand = this.getCommand(this.CmdIndex);
        if (tExecScriptCommand.isExit()) {
            return null;
        }
        if (tExecScriptCommand.isElse() || tExecScriptCommand.isElseIf()) {
            int n = this.nextEndIf(this.CmdIndex);
            if (n >= 0) {
                this.CmdIndex = n;
                return this.getCommand(n);
            }
            this.errorMsg(tExecScriptCommand, "If without endif in script(2) " + this.ScriptID + " Command:" + this.getCommand(this.CmdIndex).getCommand());
            return null;
        }
        if (tExecScriptCommand.isAssignment()) {
            return tExecScriptCommand;
        }
        return tExecScriptCommand;
    }

    public TExecScriptCommand nextCommand() {
        if (this.arCommandSet.size() == 0) {
            return null;
        }
        if (this.CmdIndex < 0) {
            this.CmdIndex = 0;
            return this.getCommand(this.CmdIndex);
        }
        TExecScriptCommand tExecScriptCommand = this.getCommand(this.CmdIndex);
        if (tExecScriptCommand.isAssignment()) {
            return this.gotoNextLine();
        }
        if (tExecScriptCommand.isDo()) {
            return this.gotoNextLine();
        }
        if (tExecScriptCommand.isLoop()) {
            Object object = this.ExecScriptDriver.FormulaEvaluator.getFormulaValue(tExecScriptCommand.getExpression(), 0, 0);
            TFormulaEvaluator cfr_ignored_0 = this.ExecScriptDriver.FormulaEvaluator;
            boolean bl = TFormulaEvaluator.convertToBoolean(object);
            if (bl) {
                int n = this.previousDo(this.CmdIndex);
                if (n >= 0) {
                    this.CmdIndex = n;
                    return this.getCommand(this.CmdIndex);
                }
                this.errorMsg(this.getCommand(this.CmdIndex), "Loop without do.");
                return null;
            }
            return this.gotoNextLine();
        }
        if (tExecScriptCommand.isWhile()) {
            if (this.Debug) {
                // empty if block
            }
            Object object = this.ExecScriptDriver.FormulaEvaluator.getFormulaValue(tExecScriptCommand.getExpression(), 0, 0);
            TFormulaEvaluator cfr_ignored_1 = this.ExecScriptDriver.FormulaEvaluator;
            boolean bl = TFormulaEvaluator.convertToBoolean(object);
            if (this.Debug) {
                MainWin.appendToLog("TExecScriptCommandSet", "nextCommand", Thread.currentThread(), null, 10, "[script] Evaluating [while]: " + tExecScriptCommand.getExpression() + " Result: " + bl);
            }
            if (bl) {
                return this.gotoNextLine();
            }
            int n = this.endOfWhileLoop(this.CmdIndex);
            if (n >= 0) {
                this.CmdIndex = n;
                return this.gotoNextLine();
            }
            this.errorMsg(this.getCommand(this.CmdIndex), "While without EndWhile.");
            return null;
        }
        if (tExecScriptCommand.isEndWhile()) {
            int n = this.startOfWhileLoop(this.CmdIndex);
            if (n >= 0) {
                this.CmdIndex = n;
                return this.getCommand(this.CmdIndex);
            }
            this.errorMsg(this.getCommand(this.CmdIndex), "Endwhile without while.");
            return null;
        }
        if (tExecScriptCommand.isElse()) {
            return this.gotoNextLine();
        }
        if (tExecScriptCommand.isElseIf()) {
            if (this.Debug) {
                // empty if block
            }
            Object object = this.ExecScriptDriver.FormulaEvaluator.getFormulaValue(tExecScriptCommand.getExpression(), 0, 0);
            TFormulaEvaluator cfr_ignored_2 = this.ExecScriptDriver.FormulaEvaluator;
            boolean bl = TFormulaEvaluator.convertToBoolean(object);
            if (this.Debug) {
                MainWin.appendToLog("TExecScriptCommandSet", "nextCommand", Thread.currentThread(), null, 10, "[script] Evaluating [elseif]: " + tExecScriptCommand.getExpression() + " Result: " + bl);
            }
            if (bl) {
                return this.gotoNextLine();
            }
            int n = this.nextElse(this.CmdIndex);
            if (n >= 0) {
                this.CmdIndex = n;
                return this.getCommand(this.CmdIndex);
            }
            n = this.nextEndIf(this.CmdIndex);
            if (n >= 0) {
                this.CmdIndex = n;
                return this.getCommand(n);
            }
            this.errorMsg(this.getCommand(this.CmdIndex), "If without endif(3) in script " + this.ScriptID);
        } else {
            if (tExecScriptCommand.isEndIf()) {
                return this.gotoNextLine();
            }
            if (tExecScriptCommand.isIf()) {
                if (this.Debug) {
                    // empty if block
                }
                Object object = this.ExecScriptDriver.FormulaEvaluator.getFormulaValue(tExecScriptCommand.getExpression(), 0, 0);
                TFormulaEvaluator cfr_ignored_3 = this.ExecScriptDriver.FormulaEvaluator;
                boolean bl = TFormulaEvaluator.convertToBoolean(object);
                if (this.Debug) {
                    MainWin.appendToLog("TExecScriptCommandSet", "nextCommand", Thread.currentThread(), null, 10, "[script] Evaluating [if]: " + tExecScriptCommand.getExpression() + " Result: " + bl);
                }
                if (bl) {
                    ++this.CmdIndex;
                    if (this.CmdIndex >= this.arCommandSet.size()) {
                        return null;
                    }
                    return this.getCommand(this.CmdIndex);
                }
                int n = this.nextElse(this.CmdIndex);
                if (n >= 0) {
                    this.CmdIndex = n;
                    return this.getCommand(this.CmdIndex);
                }
                n = this.nextEndIf(this.CmdIndex);
                if (n >= 0) {
                    this.CmdIndex = n;
                    return this.getCommand(n);
                }
                this.errorMsg(this.getCommand(this.CmdIndex), "If without endif(4) in script " + this.ScriptID + " " + tExecScriptCommand.getCommand());
                this.outputForDebugging(7);
            }
        }
        return null;
    }

    public String getProfileCommand() {
        for (int i = 0; i < this.arCommandSet.size(); ++i) {
            if (!this.getCommand(i).getCommand().toUpperCase().startsWith("PROFILE(")) continue;
            return this.getCommand(i).getCommand();
        }
        return "";
    }

    public void updateProfile(TExecScriptCommand tExecScriptCommand, Date date, Date date2) {
        tExecScriptCommand.updateProfile(date, date2);
    }

    public void outputProfile(String string) {
        long l = 0L;
        for (int i = 0; i < this.arCommandSet.size(); ++i) {
            l += this.getCommand(i).getExecTime();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.arCommandSet.size(); ++i) {
            TExecScriptCommand tExecScriptCommand = this.getCommand(i);
            stringBuilder.append(Integer.toString(i) + ",");
            String string2 = tExecScriptCommand.getCommand();
            string2 = charutil.replaceAllSubstrings(string2, "\"", "&#34;");
            string2 = charutil.replaceAllSubstrings(string2, ",", "&#44; ");
            string2 = charutil.replaceAllSubstrings(string2, "<", "&lt;");
            string2 = charutil.replaceAllSubstrings(string2, ">", "&gt;");
            string2 = charutil.replaceAllSubstrings(string2, "|", "&#166; ");
            string2 = charutil.replaceAllSubstrings(string2, "~", "&#126; ");
            stringBuilder.append(string2 + ",");
            stringBuilder.append(Integer.toString(tExecScriptCommand.getExecCount()) + ",");
            stringBuilder.append(Long.toString(tExecScriptCommand.getExecTime()) + ",");
            stringBuilder.append(Long.toString(l) + "\r\n");
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rwd");
            randomAccessFile.setLength(0L);
            randomAccessFile.writeBytes(stringBuilder.toString());
            randomAccessFile.close();
        }
        catch (Exception exception) {
            MainWin.appendToLog(this.getClass().getName(), "errorMsg", Thread.currentThread(), exception, 4, "Error writing profile");
            new Throwable().printStackTrace();
        }
    }

    public void outputForDebugging(int n) {
        int n2 = Math.min(n, this.arCommandSet.size());
        for (int i = 0; i < n2; ++i) {
            System.out.println("\t" + this.getCommand(i).getCommand());
        }
    }
}

