/*
 * Decompiled with CFR 0.152.
 */
package scripts;

import agent.TAgentProfiler;
import agent.TAgentProfilerObj;
import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStruct;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import performance.TPerformanceScriptMark;
import resources.TAppDriversObject;
import resources.TAppScriptsObject;
import resources.TApplication;
import scripts.TExecScriptCommand;
import scripts.TExecScriptCommandSet;
import scripts.TExecScriptDriver;
import scrollwin.table.TScrollTable;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.dateutil;
import utility.objectutil;
import utility.taskscheduler.TTaskScheduler;

public class TExecScript
extends Thread {
    private static TMainWin MainWin = Aspect.MainWin;
    public boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTExecScript");
    private TApplication Application = TMainWin.Application;
    private static ArrayList arRunningScripts = new ArrayList();
    private ArrayList arScriptCommands;
    private ArrayList arListeners = null;
    private Socket socket = null;
    private String SocketName = "";
    private String ScriptID = "";
    private String ScriptName = "Undefined";
    private TFormulaEvaluator AltFormulaEvaluator = null;
    private static String ExecScriptDriverID = "ExecScriptDriver";
    private TExecScriptDriver ExecScriptDriver;
    private boolean Terminate = false;
    private int Suspend = 0;
    private Object ScriptResult = null;
    private Date tmStart = new Date();
    public String TaskSchedulerID = null;
    public String TaskSchedulerTaskName = null;
    private int TaskResult = 0;
    private String TaskMessage = null;
    public boolean TaskManual = false;
    private long TaskInstance = 0L;
    private String[] arParams = null;
    private String SocketParams = "";
    public TExecScriptCommandSet CommandSet = null;
    private boolean IsInitialized = false;
    private boolean IsFinished = false;
    private boolean IsStarted = false;
    private static boolean IsSuspending = false;
    private static long cInstance = 0L;
    private long ScriptInstance = 0L;
    private static boolean bInitProfiler = true;
    private static RandomAccessFile fProfile = null;
    private int ProfileThreadCount = Thread.activeCount();
    private int ProfileScriptCount = arRunningScripts.size();
    private static StringBuilder sProfileWriteBuffer = new StringBuilder();
    private TScrollTable ScrollTable = null;
    private Hashtable hScriptDriverValues = null;
    TExecScriptCommand ExecScriptCommand = null;
    String DebugStatus = "Not initialized";

    public TExecScript(String string, TScrollTable tScrollTable, TFormulaEvaluator tFormulaEvaluator) {
        super("TExecScript-" + string);
        String[] stringArray;
        this.setPriority(1);
        if (bInitProfiler) {
            stringArray = MainWin.getPackageIDs();
            for (int i = 0; i < stringArray.size(); ++i) {
                if (!((String)stringArray.get(i)).equalsIgnoreCase("Aspect_Support_Server")) continue;
                try {
                    fProfile = new RandomAccessFile(TMainWin.Application.getHomeDir() + "script_profiler.dta", "rwd");
                    fProfile.setLength(0L);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Error initializing script profiler file: " + exception.toString());
                }
            }
            bInitProfiler = false;
        }
        this.ScrollTable = tScrollTable;
        this.ScriptID = string;
        if (this.ScriptID.indexOf(47) >= 0) {
            this.ScriptID = "";
            stringArray = charutil.getSubStringArray(string, '/', true);
            if (stringArray != null && stringArray.length > 0) {
                this.ScriptID = stringArray[0];
                if (stringArray.length > 1 && stringArray[1].length() > 0) {
                    stringArray[1] = stringArray[1].substring(1);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 1; i < stringArray.length; ++i) {
                        stringBuilder.append(stringArray[i]);
                        if (i >= stringArray.length - 1) continue;
                        stringBuilder.append("/");
                    }
                    this.setParameters(charutil.getSubStringArray(stringBuilder.toString(), '&', true));
                }
            }
        }
        this.arScriptCommands = this.Application.AppScripts.getResourceElements(this.ScriptID);
        if (this.arScriptCommands.size() == 0) {
            MainWin.appendToLog("TExecScript", "init", Thread.currentThread(), null, 4, "The script with the ID '" + string + "' is either undefined or contains no commands.");
            new Throwable().printStackTrace();
        }
        this.ScriptInstance = ++cInstance;
        if (this.arScriptCommands.size() > 0) {
            this.ScriptName = ((TAppScriptsObject)this.arScriptCommands.get((int)0)).ScriptName;
        }
        this.AltFormulaEvaluator = tFormulaEvaluator;
        TExecScript.addToRunningScripts(this);
    }

    public static long getNewScriptInstance() {
        return ++cInstance;
    }

    public void setScheduledTask(String string, String string2, boolean bl, long l) {
        this.TaskSchedulerID = string;
        this.TaskSchedulerTaskName = string2;
        this.TaskManual = bl;
        this.TaskInstance = l;
    }

    public static synchronized void addToRunningScripts(TExecScript tExecScript) {
        arRunningScripts.add(tExecScript);
    }

    public static synchronized void removeFromHashedScripts(TExecScript tExecScript) {
        if (arRunningScripts.contains(tExecScript)) {
            arRunningScripts.remove(tExecScript);
        }
    }

    public static synchronized int terminateScript(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < arRunningScripts.size()) {
            TExecScript tExecScript = (TExecScript)arRunningScripts.get(n2);
            if (string == null || tExecScript.ScriptID.equalsIgnoreCase(string)) {
                tExecScript.terminate();
                arRunningScripts.remove(tExecScript);
                ++n;
                continue;
            }
            ++n2;
        }
        return n;
    }

    public static synchronized int suspendScript(String string, boolean bl, long l) {
        if (IsSuspending) {
            return -1;
        }
        IsSuspending = true;
        int n = 0;
        int n2 = arRunningScripts.size();
        for (int i = 0; i < n2; ++i) {
            TExecScript tExecScript = (TExecScript)arRunningScripts.get(i);
            if (string != null && !tExecScript.ScriptID.equalsIgnoreCase(string) || l != 0L && tExecScript.ScriptInstance == l) continue;
            if (bl) {
                ++tExecScript.Suspend;
            } else {
                --tExecScript.Suspend;
                if (tExecScript.Suspend < 0) {
                    tExecScript.Suspend = 0;
                }
            }
            ++n;
        }
        IsSuspending = false;
        return n;
    }

    public static boolean isTerminated(String string) {
        int n = arRunningScripts.size();
        for (int i = 0; i < n; ++i) {
            TExecScript tExecScript = (TExecScript)arRunningScripts.get(i);
            if (!tExecScript.ScriptID.equalsIgnoreCase(string)) continue;
            return tExecScript.Terminate;
        }
        return false;
    }

    public static synchronized boolean isSuspended(long l) {
        int n = arRunningScripts.size();
        for (int i = 0; i < n; ++i) {
            TExecScript tExecScript = (TExecScript)arRunningScripts.get(i);
            if (tExecScript.ScriptInstance != l) continue;
            return tExecScript.Suspend > 0;
        }
        return false;
    }

    public static boolean setInitialized(long l) {
        int n = arRunningScripts.size();
        for (int i = 0; i < n; ++i) {
            TExecScript tExecScript = (TExecScript)arRunningScripts.get(i);
            if (tExecScript.ScriptInstance != l) continue;
            tExecScript.IsInitialized = true;
            if (true) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public boolean isInitialized() {
        return this.IsInitialized;
    }

    public boolean isFinished() {
        return this.IsFinished;
    }

    public boolean isStarted() {
        return this.IsStarted;
    }

    public static synchronized void removeTerminatedScripts() {
        int n = 0;
        while (n < arRunningScripts.size()) {
            TExecScript tExecScript = (TExecScript)arRunningScripts.get(n);
            if (tExecScript.isStarted() && !tExecScript.isAlive() && !tExecScript.isFinished()) {
                try {
                    arRunningScripts.remove(tExecScript);
                }
                catch (Exception exception) {
                    System.out.println("caught exception while removing terminated script");
                }
                MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 4, "Error: Removed terminated script: " + tExecScript.ScriptID);
                continue;
            }
            ++n;
        }
    }

    public static synchronized int countScripts(String string) {
        TExecScript.removeTerminatedScripts();
        int n = 0;
        for (int i = 0; i < arRunningScripts.size(); ++i) {
            TExecScript tExecScript = (TExecScript)arRunningScripts.get(i);
            if (string == null || tExecScript.ScriptID.equalsIgnoreCase(string)) {
                ++n;
                continue;
            }
            if (string.length() <= 6 || tExecScript.ScriptID.length() <= 6 || !string.startsWith("%") || !tExecScript.ScriptID.startsWith("%") || string.charAt(5) != '_' || tExecScript.ScriptID.charAt(5) != '_' || !tExecScript.ScriptID.substring(6).equalsIgnoreCase(string.substring(6))) continue;
            ++n;
        }
        return n;
    }

    public static int countScripts() {
        TExecScript.removeTerminatedScripts();
        return arRunningScripts.size();
    }

    public static synchronized int countScripts(String string, String string2) {
        TExecScript.removeTerminatedScripts();
        int n = 0;
        for (int i = 0; i < arRunningScripts.size(); ++i) {
            Object object;
            TFormulaEvaluator tFormulaEvaluator;
            boolean bl;
            TExecScript tExecScript = (TExecScript)arRunningScripts.get(i);
            boolean bl2 = bl = string == null || tExecScript.ScriptID.equalsIgnoreCase(string);
            if (!bl && string.length() > 6 && tExecScript.ScriptID.length() > 6 && string.startsWith("%") && tExecScript.ScriptID.startsWith("%") && string.charAt(5) == '_' && tExecScript.ScriptID.charAt(5) == '_' && tExecScript.ScriptID.substring(6).equalsIgnoreCase(string.substring(6))) {
                bl = true;
            }
            if (!bl || tExecScript.Terminate || tExecScript.ExecScriptDriver == null || (tFormulaEvaluator = tExecScript.ExecScriptDriver.getFormulaEvaluator()) == null || !((object = tFormulaEvaluator.getFormulaValue(string2, -1, -1)) instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
            ++n;
        }
        return n;
    }

    public static String getRunningScriptIDs() {
        TExecScript.removeTerminatedScripts();
        StringBuilder stringBuilder = new StringBuilder();
        int n = arRunningScripts.size();
        for (int i = 0; i < n; ++i) {
            TExecScript tExecScript;
            String string;
            String[] stringArray;
            if (i >= arRunningScripts.size() || (stringArray = charutil.getSubStringArray(string = (tExecScript = (TExecScript)arRunningScripts.get(i)).getName(), '&', true)) == null || stringArray.length <= 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append(stringArray[0]);
        }
        return stringBuilder.toString();
    }

    public static String getRunningScripts(boolean bl) {
        TExecScript.removeTerminatedScripts();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        for (int i = 0; i < arRunningScripts.size(); ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            TExecScript tExecScript = (TExecScript)arRunningScripts.get(i);
            stringBuilder2.setLength(0);
            String string = charutil.removeChar(tExecScript.getName(), '\t');
            if (string.toUpperCase().startsWith("GREENLIGHT_PROCESSCONTAINERHTML")) {
                string = string.substring(0, Math.min(string.length(), 512)) + "...";
                string = charutil.removeChar(string, '\"');
            }
            if (bl) {
                if (string.toUpperCase().indexOf("GREENLIGHT_CLIENT_LISTENER_START") < 0) {
                    if (tExecScript.Suspend > 0) {
                        stringBuilder2.append("Suspend\t");
                    } else {
                        stringBuilder2.append("Active\t");
                    }
                    stringBuilder2.append(dateutil.formatDate(tExecScript.getTimeStart(), "MM-dd-yyyy HH:mm:ss:SSS") + "&nbsp;-&nbsp;" + Long.toString(new Date().getTime() - tExecScript.getTimeStart().getTime()) + "ms\t");
                    if (string.equalsIgnoreCase("GreenLight_Client_Listener_Socket")) {
                        string = string + " Instance: " + Long.toString(tExecScript.ScriptInstance);
                        try {
                            String string2 = (String)tExecScript.ExecScriptDriver.FormulaEvaluator.getFormulaValue("strClientContent", 0, 0);
                            if (!string2.equals("strClientContent")) {
                                string = string + " " + string2;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    stringBuilder2.append(string + "\t");
                    charutil.replaceAllSubstrings(stringBuilder2, stringBuilder2, "\n", "");
                }
            } else {
                stringBuilder2.append(string + "\t");
                stringBuilder2.append(Long.toString(tExecScript.ScriptInstance) + "\t");
                if (tExecScript.Suspend > 0) {
                    stringBuilder2.append("Suspended-" + Integer.toString(tExecScript.Suspend) + "\t");
                } else {
                    stringBuilder2.append("Active\t");
                }
                charutil.replaceAllSubstrings(stringBuilder2, stringBuilder2, "\n", "");
                stringBuilder2.append(new Date().getTime() - tExecScript.getTimeStart().getTime() + "\t");
                stringBuilder2.append(Long.toString(tExecScript.getTimeStart().getTime()));
            }
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "<", "&lt;");
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, ">", "&gt;");
        return stringBuilder.toString();
    }

    public Date getTimeStart() {
        return this.tmStart;
    }

    public static TExecScript getScript(long l) {
        for (int i = 0; i < arRunningScripts.size(); ++i) {
            TExecScript tExecScript = (TExecScript)arRunningScripts.get(i);
            if (tExecScript.ScriptInstance != l) continue;
            return tExecScript;
        }
        return null;
    }

    public static String[] getCurrentCommand(long l) {
        String[] stringArray = new String[]{"null", "Script not found"};
        TExecScript tExecScript = TExecScript.getScript(l);
        if (tExecScript == null) {
            return stringArray;
        }
        stringArray[0] = tExecScript.ExecScriptCommand == null ? "null" : tExecScript.ExecScriptCommand.strCommand;
        stringArray[1] = tExecScript.DebugStatus;
        return stringArray;
    }

    public static boolean scriptYield(long l) {
        for (int i = 0; i < arRunningScripts.size(); ++i) {
            TExecScript tExecScript = (TExecScript)arRunningScripts.get(i);
            if (tExecScript.ScriptInstance != l) continue;
            for (int j = 0; j < 100; ++j) {
                tExecScript.yield();
            }
            return true;
        }
        return false;
    }

    public static boolean scriptSleep(long l, long l2) {
        for (int i = 0; i < arRunningScripts.size(); ++i) {
            TExecScript tExecScript = (TExecScript)arRunningScripts.get(i);
            if (tExecScript.ScriptInstance != l) continue;
            try {
                TExecScript.sleep(l2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public void setSocket(Socket socket, String string) {
        this.socket = socket;
        this.SocketName = string;
    }

    public static void setScriptResult(long l, Object object) {
        TExecScript tExecScript = TExecScript.getScript(l);
        if (tExecScript != null) {
            tExecScript.ScriptResult = object;
        }
    }

    public static void setSocketParams(long l, String string) {
        TExecScript tExecScript = TExecScript.getScript(l);
        if (tExecScript != null) {
            tExecScript.SocketParams = string;
        }
    }

    public static void setTaskResult(long l, int n, String string) {
        TExecScript tExecScript = TExecScript.getScript(l);
        if (tExecScript != null) {
            tExecScript.TaskResult = n;
            tExecScript.TaskMessage = string;
        } else {
            MainWin.appendToLog("TExecScript", "setTaskResult", Thread.currentThread(), null, 4, "Error in setTaskResult.  Cannot locate script to record result: " + string);
        }
    }

    public Object getScriptResult() {
        return this.ScriptResult;
    }

    public void executeScript() {
        this.start();
        while (this.isAlive() && !this.IsFinished) {
            TExecScript.yield();
            if (!(Math.random() < 0.1)) continue;
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
    }

    public void terminate() {
        this.Terminate = true;
    }

    public void setThreadName() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(this.ScriptID);
        String string = "";
        if (this.arParams != null) {
            for (n = 0; n < this.arParams.length; ++n) {
                stringBuilder.append("&" + this.arParams[n]);
            }
        }
        if (stringBuilder.toString().trim().equalsIgnoreCase(this.ScriptID) && stringBuilder.length() < 7 && this.arScriptCommands != null && this.arScriptCommands.size() > 0) {
            n = 0;
            for (int i = 0; stringBuilder.length() < 128 && i < this.arScriptCommands.size(); ++i) {
                String string2 = ((TAppScriptsObject)this.arScriptCommands.get((int)i)).Command.trim();
                if (string2.length() <= 0) continue;
                stringBuilder.append(" //" + string2 + "//");
            }
        }
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "&", "//amp//");
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "//amp//", "&amp;");
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "<", "&lt;");
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "\"", "&#34;");
        charutil.replaceAllSubstrings(stringBuilder, stringBuilder, "'", "&#39;");
        if (stringBuilder.length() > 128) {
            stringBuilder.setLength(128);
            stringBuilder.append("...");
        }
        this.setName(stringBuilder.toString());
    }

    public void setParameters(String[] stringArray) {
        this.arParams = stringArray;
        this.setThreadName();
    }

    public void setParameters(String string) {
        if (this.arParams == null) {
            this.arParams = new String[1];
        }
        this.arParams[0] = string;
        this.setThreadName();
    }

    public String getParamString() {
        if (this.arParams == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.arParams.length; ++i) {
            stringBuilder.append("&" + this.arParams[i]);
        }
        stringBuilder.deleteCharAt(0);
        return stringBuilder.toString();
    }

    public void setScriptDriverValues(Hashtable hashtable) {
        this.hScriptDriverValues = hashtable;
    }

    public Hashtable getScriptDriverValues() {
        return this.hScriptDriverValues;
    }

    public void setDebug(boolean bl) {
        this.Debug = bl;
    }

    @Override
    public void run() {
        Object object;
        CharSequence charSequence;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        TAppDriversObject tAppDriversObject;
        this.IsStarted = true;
        this.DebugStatus = "Status-1";
        Object object7 = null;
        String string = null;
        this.setThreadName();
        String string2 = this.ScriptID;
        if (string2.length() > 6 && string2.charAt(5) == '_') {
            string2 = string2.substring(6);
        }
        TPerformanceScriptMark tPerformanceScriptMark = new TPerformanceScriptMark(string2, this.getParamString());
        TFormulaEvaluator.Performance.addMark(tPerformanceScriptMark);
        if (this.Debug) {
            MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 3, "Executing script: '" + this.ScriptName + "'");
            MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 10, "Lines in script: " + this.arScriptCommands.size());
            for (int i = 0; i < this.arScriptCommands.size(); ++i) {
                TAppScriptsObject tAppScriptsObject = (TAppScriptsObject)this.arScriptCommands.get(i);
                MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 10, Integer.toString(i) + "] " + tAppScriptsObject.Command);
            }
        }
        if ((tAppDriversObject = this.Application.AppDrivers.getAppDriversObject(ExecScriptDriverID)) == null) {
            MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 4, "Cannot locate script driver with ID of " + ExecScriptDriverID);
            return;
        }
        this.ExecScriptDriver = new TExecScriptDriver(this.Application, tAppDriversObject, 1, false);
        if (this.hScriptDriverValues != null) {
            object6 = this.hScriptDriverValues.keys();
            while (object6.hasMoreElements()) {
                String string3 = (String)object6.nextElement();
                object5 = this.hScriptDriverValues.get(string3);
                this.ExecScriptDriver.putField(string3, 0, object5);
            }
        }
        this.DebugStatus = "Status-2";
        object6 = new StringBuilder();
        if (this.arParams != null) {
            for (int i = 0; i < this.arParams.length; ++i) {
                this.ExecScriptDriver.putField("Arg" + (i + 1), 0, (Object)this.arParams[i]);
                if (((StringBuilder)object6).length() > 0) {
                    ((StringBuilder)object6).append("&");
                }
                ((StringBuilder)object6).append(this.arParams[i]);
            }
            this.ExecScriptDriver.putField("Args", 0, (Object)((StringBuilder)object6).toString());
        }
        this.DebugStatus = "Status-3";
        if (this.ScrollTable != null) {
            this.ExecScriptDriver.getFormulaEvaluator().addAdditionalScriptDriver("$ActiveDriver", this.ScrollTable.AspectDriver);
        }
        this.DebugStatus = "Status-4";
        this.ExecScriptDriver.getFormulaEvaluator().setScriptID(this.ScriptID, this.ScriptInstance);
        this.DebugStatus = "Status-5";
        this.ExecScriptDriver.setAspectDriver(new TAspectDriver(this.Application, this.ExecScriptDriver.getAppDriversObject(), this.ExecScriptDriver, false, false));
        this.DebugStatus = "Status-6";
        if (this.AltFormulaEvaluator != null) {
            this.ExecScriptDriver.getFormulaEvaluator().setAltFormulaEvaluator(this.AltFormulaEvaluator);
        }
        this.DebugStatus = "Status-7";
        if (this.socket != null) {
            this.ExecScriptDriver.getFormulaEvaluator().addSocket(this.socket, this.SocketName);
        }
        this.DebugStatus = "Status-8";
        this.CommandSet = new TExecScriptCommandSet(this.ScriptID, this.ExecScriptDriver, this.arScriptCommands);
        boolean bl = false;
        object5 = this.CommandSet.getProfileCommand();
        if (((String)object5).length() > 0 && (object4 = this.ExecScriptDriver.getFormulaEvaluator().getFormulaValue((String)object5, -1, -1)) instanceof Boolean) {
            bl = (Boolean)object4;
        }
        this.DebugStatus = "Status-9";
        if (!this.CommandSet.getContainsInitializer()) {
            this.IsInitialized = true;
        }
        this.DebugStatus = "Status-10";
        object4 = this.getParamString();
        String string4 = this.ExecScriptDriver.getFormulaEvaluator().getScriptIDForLog();
        MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 15, string4, "", "", 0, false, string4, (int)this.ScriptInstance, 0, (String)object4, 0);
        Date date = new Date();
        long l = 0L;
        boolean bl2 = false;
        TAgentProfiler tAgentProfiler = TFormulaEvaluator.getAgentProfiler();
        TAgentProfilerObj tAgentProfilerObj = null;
        int n = 0;
        try {
            this.ExecScriptCommand = this.CommandSet.nextCommand();
            while (!this.Terminate && this.ExecScriptCommand != null) {
                this.DebugStatus = "Status-Loop " + Integer.toString(n++);
                if (this.ExecScriptCommand.getCommand().indexOf("::node,") >= 0) {
                    tAgentProfilerObj = tAgentProfiler.nodeExecuted(this.ExecScriptCommand.getCommand(), tAgentProfilerObj);
                    this.ExecScriptCommand = this.CommandSet.nextCommand();
                    continue;
                }
                while (this.Suspend > 0 && !this.Terminate) {
                    try {
                        Thread.sleep(1000L);
                        if (!this.Debug) continue;
                        MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 10, "[script] Suspended");
                    }
                    catch (Exception exception) {}
                }
                if (this.Terminate) continue;
                object3 = new Date();
                if (this.ExecScriptCommand.isAssignment()) {
                    string = this.ExecScriptCommand.getVariableName();
                    String string5 = this.ExecScriptCommand.getExpression();
                    if (this.Debug) {
                        // empty if block
                    }
                    if (this.Debug) {
                        MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 10, "[script] Executing: " + this.ExecScriptCommand.getCommand());
                    }
                    try {
                        object7 = this.ExecScriptDriver.FormulaEvaluator.getFormulaValue(string5, 0, 0);
                        if (string5.toUpperCase().indexOf("SCRIPTEXEC") >= 0 || bl2) {
                            l += new Date().getTime() - ((Date)object3).getTime();
                            bl2 = false;
                        } else if (string.equalsIgnoreCase("sGreenlightIndirect") && objectutil.convertToString(object7).toUpperCase().indexOf("SCRIPTEXEC") >= 0) {
                            bl2 = true;
                        }
                    }
                    catch (Exception exception) {
                        MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 10, "Error in script command: " + this.ExecScriptCommand.getCommand());
                        return;
                    }
                    if (this.Debug) {
                        MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 10, "[script] Result: " + object7);
                        if (object7 == null) {
                            MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 10, "[script] Null returned in " + string5);
                        }
                    }
                    if (this.ExecScriptCommand.getCommandType() == 0 && object7 != null) {
                        this.ExecScriptDriver.putField(string, 0, object7);
                        if (this.Debug) {
                            MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 10, "[script] Recorded: " + object7 + " in " + string);
                        }
                    }
                } else if (this.Debug) {
                    MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 10, "[script] Flow control: " + this.ExecScriptCommand.getCommand());
                }
                Thread.yield();
                if (bl) {
                    TExecScriptCommand tExecScriptCommand = this.ExecScriptCommand;
                    this.ExecScriptCommand = this.CommandSet.nextCommand();
                    this.CommandSet.updateProfile(tExecScriptCommand, (Date)object3, new Date());
                } else {
                    this.ExecScriptCommand = this.CommandSet.nextCommand();
                }
                if (!this.Debug) continue;
                if (this.ExecScriptCommand == null) {
                    MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 10, "[script] No more commands.");
                    continue;
                }
                MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 10, "[script] Got next command: " + this.ExecScriptCommand.getCommand());
            }
        }
        catch (Exception exception) {
            MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), exception, 10, "Exception in script " + this.ScriptID);
        }
        this.DebugStatus = "Status-11";
        if (this.Debug) {
            MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 10, "[script] All commands executed.");
        }
        object3 = object4;
        if (this.SocketParams.length() > 0) {
            object3 = (String)object3 + "&" + this.SocketParams;
        }
        int n2 = (int)(new Date().getTime() - date.getTime());
        MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 16, string4, "", "", 0, false, string4, (int)this.ScriptInstance, n2, (String)object3, (int)l);
        if (bl) {
            object5 = this.ScriptID.charAt(5) == '_' ? this.ScriptID.substring(6) : this.ScriptID;
            object2 = TMainWin.Application.getTemporaryFiles();
            if (((String)object5).equalsIgnoreCase("GreenLight_Client_Listener_Socket")) {
                charSequence = objectutil.convertToString(this.ExecScriptDriver.getField("strClientID", 0));
                object = objectutil.convertToString(this.ExecScriptDriver.getField("strClientContent", 0));
                String string6 = charutil.getParamValue((String)object, "Widget", '&');
                String string7 = charutil.getParamValue((String)object, "ContainerItemID", '&');
                if (((String)charSequence).length() > 0) {
                    charSequence = "_" + (String)charSequence;
                }
                if (string6.length() > 0) {
                    string6 = "_" + string6;
                }
                if (string7.length() > 0) {
                    string7 = "_" + string7;
                }
                String string8 = "cmdprofile_" + (String)object5 + (String)charSequence + string6 + string7 + ".$$$";
                string8 = charutil.replaceAllSubstrings(string8, "/", "_");
                string8 = charutil.replaceAllSubstrings(string8, "\\", "_");
                object2 = (String)object2 + string8;
            } else {
                if (((String)object5).toUpperCase().indexOf(":ACTION=") >= 0) {
                    object5 = charutil.getParamValue((String)object5, "Action", ':');
                }
                if (((String)object5).toUpperCase().indexOf(":SENSOR=") >= 0) {
                    object5 = charutil.getParamValue((String)object5, "Sensor", ':');
                }
                object2 = (String)object2 + "cmdprofile_" + (String)object5 + ".$$$";
            }
            object2 = charutil.removeChar((String)object2, '\r');
            object2 = charutil.removeChar((String)object2, '\n');
            object2 = charutil.replaceAllSubstrings((String)object2, "  ", " ");
            object2 = charutil.replaceAllSubstrings((String)object2, " ", "_");
            object2 = charutil.replaceAllSubstrings((String)object2, "\t", "_");
            object2 = charutil.replaceAllSubstrings((String)object2, "\"", "");
            object2 = charutil.replaceAllSubstrings((String)object2, "'", "");
            this.CommandSet.outputProfile((String)object2);
        }
        if (fProfile != null) {
            this.DebugStatus = "Status-12";
            object2 = new char[277];
            System.arraycopy(dateutil.formatDate(this.tmStart, "HHmmss").toCharArray(), 0, object2, 0, 6);
            System.arraycopy(this.ScriptID.toCharArray(), 0, object2, 6, Math.min(128, this.ScriptID.length()));
            charSequence = new StringBuilder();
            if (this.ScriptID.equalsIgnoreCase("GreenLight_Client_Listener_Socket")) {
                object = this.ExecScriptDriver.getField("strClientID", 0);
                if (object == null) {
                    object = this.ExecScriptDriver.getField("strClientContent", 0);
                }
                ((StringBuilder)charSequence).append((String)object);
            }
            if (this.ScriptID.equalsIgnoreCase("GreenLight_getxmlHttpRequest")) {
                ((StringBuilder)charSequence).append(this.ExecScriptDriver.getField("strUrl", 0));
            }
            if (this.ScriptID.equalsIgnoreCase("Aspect_Common_getCachedWidget")) {
                ((StringBuilder)charSequence).append(this.ExecScriptDriver.getField("strName", 0));
            }
            if (this.ScriptID.equalsIgnoreCase("GreenLight_processContainerHtml")) {
                ((StringBuilder)charSequence).append((String)this.ExecScriptDriver.getField("strContent", 0));
            }
            if (this.ScriptID.equalsIgnoreCase("Library_getDocumentContent")) {
                ((StringBuilder)charSequence).append((String)this.ExecScriptDriver.getField("strID", 0));
            }
            if (this.ScriptID.equalsIgnoreCase("Aspect_Common_getContainerWidgetItem")) {
                ((StringBuilder)charSequence).append((String)this.ExecScriptDriver.getField("strWidget", 0));
                ((StringBuilder)charSequence).append(" - " + (String)this.ExecScriptDriver.getField("strItemID", 0));
                ((StringBuilder)charSequence).append(" - Text=" + Boolean.toString((Boolean)this.ExecScriptDriver.getField("bText", 0)));
            }
            if (this.ScriptID.indexOf(46) >= 0) {
                for (int i = 0; i < 5 && i < this.arScriptCommands.size(); ++i) {
                    ((StringBuilder)charSequence).append(((TAppScriptsObject)this.arScriptCommands.get((int)i)).Command + " ");
                }
            }
            if (((StringBuilder)charSequence).toString().trim().length() == 0) {
                ((StringBuilder)charSequence).append(charutil.replaceAllSubstrings(this.getName(), this.ScriptID, ""));
            }
            System.arraycopy(((StringBuilder)charSequence).toString().toCharArray(), 0, object2, 134, Math.min(128, ((StringBuilder)charSequence).length()));
            object = Long.toString(new Date().getTime() - this.tmStart.getTime()).toCharArray();
            System.arraycopy(object, 0, object2, 262, Math.min(6, ((String[])object).length));
            object = Long.toString(this.ProfileScriptCount).toCharArray();
            System.arraycopy(object, 0, object2, 268, Math.min(3, ((String[])object).length));
            object = Integer.toString(this.ProfileThreadCount).toCharArray();
            System.arraycopy(object, 0, object2, 271, Math.min(3, ((String[])object).length));
            object = Integer.toString(TFormulaEvaluator.getQueuedSocketCount()).toCharArray();
            System.arraycopy(object, 0, object2, 274, Math.min(3, ((String[])object).length));
            block18: for (int i = 0; i < ((Object)object2).length; ++i) {
                switch (object2[i]) {
                    case 123: {
                        object2[i] = 91;
                        continue block18;
                    }
                    case 125: {
                        object2[i] = 91;
                        continue block18;
                    }
                    case 60: {
                        object2[i] = 91;
                        continue block18;
                    }
                    case 62: {
                        object2[i] = 91;
                    }
                }
            }
            this.writeToProfileFile(new String((char[])object2));
            this.DebugStatus = "Status-13";
        }
        this.DebugStatus = "Status-14";
        this.CommandSet.dispose();
        this.DebugStatus = "Status-15";
        this.hScriptDriverValues = new Hashtable();
        object2 = this.ExecScriptDriver.getDriverStruct();
        for (int i = 0; i < ((TDriverStruct)object2).getFieldCount(); ++i) {
            object5 = ((TDriverStruct)object2).getFieldID(i);
            object = this.ExecScriptDriver.getField((String)object5, 0);
            if (object == null) continue;
            this.hScriptDriverValues.put(object5, object);
        }
        if (this.ScriptID.equalsIgnoreCase("GreenLight_Client_Listener_Socket")) {
            tPerformanceScriptMark.Params = objectutil.convertToString(this.ExecScriptDriver.getField("strClientContent", 0));
            tPerformanceScriptMark.SocketRequestNetwork = charutil.getParamValue(tPerformanceScriptMark.Params, "Network", '&');
            tPerformanceScriptMark.SocketRequestID = charutil.getParamValue(tPerformanceScriptMark.Params, "ID", '&');
            tPerformanceScriptMark.SocketIPAddress = objectutil.convertToString(this.ExecScriptDriver.getField("strIPAddress", 0));
        }
        if (((String)(object5 = tPerformanceScriptMark.Params.toUpperCase())).length() > 0 && (((String)object5).indexOf("RANDOM") >= 0 || ((String)object5).indexOf("USER-AGENT") >= 0)) {
            StringBuilder stringBuilder = new StringBuilder();
            object = charutil.getSubStringArray(tPerformanceScriptMark.Params, '&', true);
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (object[i].toUpperCase().indexOf("RANDOM") >= 0 || object[i].toUpperCase().indexOf("USER-AGENT") >= 0) continue;
                stringBuilder.append("&" + object[i]);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(0);
            }
            tPerformanceScriptMark.Params = stringBuilder.toString();
        }
        tPerformanceScriptMark.Params = charutil.replaceAllSubstrings(tPerformanceScriptMark.Params, "\r", "<br>");
        this.ExecScriptDriver.dispose();
        this.DebugStatus = "Status-16";
        TExecScript.removeFromHashedScripts(this);
        this.arScriptCommands.clear();
        this.DebugStatus = "Status-17";
        if (this.TaskSchedulerID != null) {
            TTaskScheduler tTaskScheduler = TTaskScheduler.getTaskScheduler(this.TaskSchedulerID);
            if (tTaskScheduler != null) {
                if (this.TaskMessage == null) {
                    this.TaskMessage = objectutil.convertToString(this.ScriptResult);
                }
                tTaskScheduler.recordResult(this.TaskSchedulerTaskName, this.TaskResult, this.TaskMessage, objectutil.convertToString(this.ScriptResult));
            }
            object5 = this.TaskMessage.trim().length() == 0 ? "Script did not return a message: " + this.ScriptID : this.TaskMessage;
            MainWin.appendToLog("TExecScript", "run", Thread.currentThread(), null, 3, (String)object5, this.TaskSchedulerID, this.TaskSchedulerTaskName, this.TaskResult, this.TaskManual, 0L, this.TaskInstance);
        }
        this.DebugStatus = "Status-18";
        this.IsFinished = true;
        tPerformanceScriptMark.destroy();
    }

    public static void resetProfiler() {
        if (fProfile != null) {
            try {
                fProfile.setLength(0L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void writeToProfileFile(String string) {
        sProfileWriteBuffer.append(string);
        if (sProfileWriteBuffer.length() > 32768) {
            try {
                fProfile.writeBytes(sProfileWriteBuffer.toString());
                sProfileWriteBuffer.setLength(0);
            }
            catch (Exception exception) {
                System.out.println("Error writing to script profiler: " + exception.toString());
            }
        }
    }
}

