/*
 * Decompiled with CFR 0.152.
 */
package resources;

import aspect.TMainWin;
import collections.TComboBoxColl;
import drivers.aspect.TDriverStruct;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import resources.TAppAction;
import resources.TAppBaseObject;
import resources.TAppCollections;
import resources.TAppDialogs;
import resources.TAppDisplays;
import resources.TAppDriverCmd;
import resources.TAppDriverStruct;
import resources.TAppDrivers;
import resources.TAppFilters;
import resources.TAppFunction;
import resources.TAppMain;
import resources.TAppMenu;
import resources.TAppReports;
import resources.TAppScripts;
import resources.TAppTables;
import resources.TAppToken;
import resources.TAppTokenObject;
import resources.TAppToolbar;
import resources.TApplicationListenerEvent;
import resources.TApplicationListenerInterface;
import scripts.TExecScript;
import utility.charutil;
import utility.dosutil;

public class TApplication {
    private static final String[] arResourceStructureIDs = new String[]{"{Structure_Main}", "Aspect_Core_Actions", "{Structure_Menu}", "Aspect_Core_Tokens", "Aspect_Core_Structures", "Aspect_Core_Drivers", "Aspect_Core_Collections", "{Structure_Binary_Displays}", "{Structure_Filters}", "Aspect_Core_Dialogs", "Scripts", "Aspect_Core_Toolbars", "{Structure_Functions}", "Aspect_Core_Tables", "Structure_DriverCmd", "Aspect_Core_Reports"};
    private static final String[] arResourceDriverIDs = new String[]{"Driver_Main", "Driver_Actions", "Driver_Menus", "Driver_Tokens", "Driver_File_Structures", "Driver_Drivers", "Driver_Collections", "Driver_Displays", "Driver_Filters", "Driver_Dialogs", "Driver_Scripts", "Driver_Toolbars", "Driver_Functions", "Driver_Tables", "Driver_DriverCmd", "Driver_Reports"};
    private static final String[] arResourceDescriptions = new String[]{"Main", "Actions", "Menu", "Tokens", "Structures", "Drivers", "Collections", "Displays", "Filters", "Dialogs", "Scripts", "Toolbars", "Functions", "Tables", "Driver Commands", "Reports"};
    public String ExecDirectory = "";
    public String AspectCoreUrl = "";
    public String HomeDirectory = "";
    public int ExecutionMode = 0;
    public String[] CommandLineArgs;
    public TMainWin MainWin = null;
    public TAppMain AppMain = null;
    public TAppAction AppAction = null;
    public TAppMenu AppMenu = null;
    public TAppToken AppToken = null;
    public TAppDriverStruct AppDriverStruct = null;
    public TAppDrivers AppDrivers = null;
    public TAppCollections AppCollections = null;
    public TAppDialogs AppDialogs = null;
    public TAppToolbar AppToolbar = null;
    public TAppFunction AppFunction = null;
    public TAppDisplays AppDisplays = null;
    public TAppFilters AppFilters = null;
    public TAppTables AppTables = null;
    public TAppReports AppReports = null;
    public TAppDriverCmd AppDriverCmd = null;
    public TAppScripts AppScripts = null;
    public boolean IsValid = true;
    private ArrayList arListeners = null;
    public static String tokenAspectHashID = "";
    public static String tokenTemporaryFiles = "";
    public static String tokenHomeDir = "";
    public long ResourcesLastUpdated = new Date().getTime();

    public TApplication(TMainWin tMainWin) {
        this.MainWin = tMainWin;
        this.CommandLineArgs = null;
    }

    public TApplication(TMainWin tMainWin, String[] stringArray) {
        this.MainWin = tMainWin;
        this.CommandLineArgs = stringArray;
    }

    public void disposeResources() {
        if (this.AppMain != null) {
            this.AppMain.dispose();
        }
        this.AppMain = null;
        if (this.AppAction != null) {
            this.AppAction.dispose();
        }
        this.AppAction = null;
        if (this.AppMenu != null) {
            this.AppMenu.dispose();
        }
        this.AppMenu = null;
        if (this.AppToken != null) {
            this.AppToken.dispose();
        }
        this.AppToken = null;
        if (this.AppDriverStruct != null) {
            this.AppDriverStruct.dispose();
        }
        this.AppDriverStruct = null;
        if (this.AppDrivers != null) {
            this.AppDrivers.dispose();
        }
        this.AppDrivers = null;
        if (this.AppCollections != null) {
            this.AppCollections.dispose();
        }
        this.AppCollections = null;
        if (this.AppDialogs != null) {
            this.AppDialogs.dispose();
        }
        this.AppDialogs = null;
        if (this.AppScripts != null) {
            this.AppScripts.dispose();
        }
        this.AppScripts = null;
        if (this.AppToolbar != null) {
            this.AppToolbar.dispose();
        }
        this.AppToolbar = null;
        if (this.AppFunction != null) {
            this.AppFunction.dispose();
        }
        this.AppFunction = null;
        if (this.AppDisplays != null) {
            this.AppDisplays.dispose();
        }
        this.AppDisplays = null;
        if (this.AppFilters != null) {
            this.AppFilters.dispose();
        }
        this.AppFilters = null;
        if (this.AppTables != null) {
            this.AppTables.dispose();
        }
        this.AppTables = null;
        if (this.AppReports != null) {
            this.AppReports.dispose();
        }
        this.AppReports = null;
        if (this.AppDriverCmd != null) {
            this.AppDriverCmd.dispose();
        }
        this.AppDriverCmd = null;
    }

    public String getResourceDriverID(int n) {
        if (n < 0 || n > 15) {
            return null;
        }
        return arResourceDriverIDs[n];
    }

    public TDriverStruct getResourceStructure(int n) {
        if (n < 0 || n > 15) {
            return null;
        }
        String string = this.parse_tokens(arResourceStructureIDs[n]);
        return new TDriverStruct(this, string);
    }

    public void setHomeDirectory(String string) {
        this.HomeDirectory = string;
    }

    public String getHomeDirectory() {
        return this.HomeDirectory;
    }

    public void setExecutionMode(int n) {
        this.ExecutionMode = n;
    }

    public int getDevelopmentMode() {
        return this.ExecutionMode;
    }

    public void removeResource(String string, int n) {
        ArrayList arrayList = null;
        switch (n) {
            case 0: {
                arrayList = this.AppMain.ResourceColl;
                break;
            }
            case 1: {
                arrayList = this.AppAction.ResourceColl;
                break;
            }
            case 2: {
                arrayList = this.AppMenu.ResourceColl;
                break;
            }
            case 3: {
                arrayList = this.AppToken.ResourceColl;
                break;
            }
            case 4: {
                arrayList = this.AppDriverStruct.ResourceColl;
                break;
            }
            case 5: {
                arrayList = this.AppDrivers.ResourceColl;
                break;
            }
            case 6: {
                arrayList = this.AppCollections.ResourceColl;
                break;
            }
            case 7: {
                arrayList = this.AppDisplays.ResourceColl;
                break;
            }
            case 8: {
                arrayList = this.AppFilters.ResourceColl;
                break;
            }
            case 9: {
                arrayList = this.AppDialogs.ResourceColl;
                break;
            }
            case 13: {
                arrayList = this.AppTables.ResourceColl;
                break;
            }
            case 15: {
                arrayList = this.AppReports.ResourceColl;
                break;
            }
            case 10: {
                arrayList = this.AppScripts.ResourceColl;
                break;
            }
            case 11: {
                arrayList = this.AppToolbar.ResourceColl;
                break;
            }
            case 12: {
                arrayList = this.AppFunction.ResourceColl;
                break;
            }
            case 14: {
                arrayList = this.AppDriverCmd.ResourceColl;
            }
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            TAppBaseObject tAppBaseObject = (TAppBaseObject)arrayList.get(n2);
            if (tAppBaseObject.PackageID.equalsIgnoreCase(string)) {
                arrayList.remove(n2);
                continue;
            }
            ++n2;
        }
    }

    public int reloadResource(int n, String string) {
        TComboBoxColl tComboBoxColl = this.AppCollections.getCollection("Package_ID_by_Location", null, null, false, "", "");
        String string2 = dosutil.getFileName(string) + dosutil.getFileExt(string);
        String string3 = string.substring(0, string.length() - string2.length());
        String string4 = (String)tComboBoxColl.getValueOfKey(string3);
        if (string4 == null) {
            this.MainWin.appendToLog("TApplication", "reloadResource", Thread.currentThread(), null, 4, "Cannot locate package ID for resource " + string);
            new Throwable().printStackTrace();
            return 0;
        }
        this.removeResource(string4, n);
        switch (n) {
            case 0: {
                this.AppMain.addResource(string4, string);
                break;
            }
            case 1: {
                this.AppAction.addResource(string4, string);
                break;
            }
            case 2: {
                this.AppMenu.addResource(string4, string);
                break;
            }
            case 3: {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                int n2 = 0;
                while (true) {
                    if (n2 >= TMainWin.Application.AppToken.ResourceColl.size()) break;
                    TAppTokenObject tAppTokenObject = (TAppTokenObject)TMainWin.Application.AppToken.ResourceColl.get(n2);
                    if (tAppTokenObject.Persist) {
                        hashtable.put(tAppTokenObject.TokenID, tAppTokenObject.Value.toString());
                    }
                    ++n2;
                }
                this.AppToken.addResource(string4, string);
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    TMainWin.Application.setTokenValue(string2, (String)hashtable.get(string2));
                }
                break;
            }
            case 4: {
                this.AppDriverStruct.addResource(string4, string);
                TDriverStruct.clearHashedStructures();
                break;
            }
            case 5: {
                this.AppDrivers.addResource(string4, string);
                break;
            }
            case 6: {
                this.AppCollections.addResource(string4, string);
                break;
            }
            case 7: {
                this.AppDisplays.addResource(string4, string);
                break;
            }
            case 8: {
                this.AppFilters.addResource(string4, string);
                break;
            }
            case 9: {
                this.AppDialogs.addResource(string4, string);
                break;
            }
            case 13: {
                this.AppTables.addResource(string4, string);
                break;
            }
            case 15: {
                this.AppReports.addResource(string4, string);
                break;
            }
            case 10: {
                this.AppScripts.addResource(string4, string);
                break;
            }
            case 11: {
                this.AppToolbar.addResource(string4, string);
                break;
            }
            case 12: {
                this.AppFunction.addResource(string4, string);
                break;
            }
            case 14: {
                this.AppDriverCmd.addResource(string4, string);
            }
        }
        return 1;
    }

    public int addResource(String string, int n, String string2) {
        switch (n) {
            case 0: {
                if (this.AppMain == null) {
                    this.AppMain = new TAppMain(this);
                }
                this.AppMain.addResource(string, string2);
                break;
            }
            case 1: {
                if (this.AppAction == null) {
                    this.AppAction = new TAppAction(this);
                }
                this.AppAction.addResource(string, string2);
                break;
            }
            case 2: {
                if (this.AppMenu == null) {
                    this.AppMenu = new TAppMenu(this);
                }
                this.AppMenu.addResource(string, string2);
                break;
            }
            case 3: {
                if (this.AppToken == null) {
                    this.AppToken = new TAppToken(this);
                }
                this.AppToken.addResource(string, string2);
                break;
            }
            case 4: {
                if (this.AppDriverStruct == null) {
                    this.AppDriverStruct = new TAppDriverStruct(this);
                }
                this.AppDriverStruct.addResource(string, string2);
                break;
            }
            case 5: {
                if (this.AppDrivers == null) {
                    this.AppDrivers = new TAppDrivers(this);
                }
                this.AppDrivers.addResource(string, string2);
                break;
            }
            case 6: {
                if (this.AppCollections == null) {
                    this.AppCollections = new TAppCollections(this);
                }
                this.AppCollections.addResource(string, string2);
                break;
            }
            case 7: {
                if (this.AppDisplays == null) {
                    this.AppDisplays = new TAppDisplays(this);
                }
                this.AppDisplays.addResource(string, string2);
                break;
            }
            case 8: {
                if (this.AppFilters == null) {
                    this.AppFilters = new TAppFilters(this);
                }
                this.AppFilters.addResource(string, string2);
                break;
            }
            case 9: {
                if (this.AppDialogs == null) {
                    this.AppDialogs = new TAppDialogs(this);
                }
                this.AppDialogs.addResource(string, string2);
                break;
            }
            case 13: {
                if (this.AppTables == null) {
                    this.AppTables = new TAppTables(this);
                }
                this.AppTables.addResource(string, string2);
                break;
            }
            case 15: {
                if (this.AppReports == null) {
                    this.AppReports = new TAppReports(this);
                }
                this.AppReports.addResource(string, string2);
                break;
            }
            case 10: {
                if (this.AppScripts == null) {
                    this.AppScripts = new TAppScripts(this);
                }
                this.AppScripts.addResource(string, string2);
                break;
            }
            case 11: {
                if (this.AppToolbar == null) {
                    this.AppToolbar = new TAppToolbar(this);
                }
                this.AppToolbar.addResource(string, string2);
                break;
            }
            case 12: {
                if (this.AppFunction == null) {
                    this.AppFunction = new TAppFunction(this);
                }
                this.AppFunction.addResource(string, string2);
                break;
            }
            case 14: {
                if (this.AppDriverCmd == null) {
                    this.AppDriverCmd = new TAppDriverCmd(this);
                }
                this.AppDriverCmd.addResource(string, string2);
            }
        }
        this.ResourcesLastUpdated = new Date().getTime();
        return 1;
    }

    public boolean isValid() {
        return this.IsValid;
    }

    public void addListener(TApplicationListenerInterface tApplicationListenerInterface) {
        if (this.arListeners == null) {
            this.arListeners = new ArrayList();
        }
        this.arListeners.add(tApplicationListenerInterface);
    }

    public void removeListener(TApplicationListenerInterface tApplicationListenerInterface) {
        if (this.arListeners != null) {
            for (int i = 0; i < this.arListeners.size(); ++i) {
                if (!((TApplicationListenerInterface)this.arListeners.get(i)).equals(tApplicationListenerInterface)) continue;
                this.arListeners.remove(tApplicationListenerInterface);
            }
        }
    }

    public void notifyListeners(TApplicationListenerEvent tApplicationListenerEvent) {
        if (this.arListeners != null) {
            for (int i = 0; i < this.arListeners.size(); ++i) {
                ((TApplicationListenerInterface)this.arListeners.get(i)).notifyApplicationEvent(tApplicationListenerEvent);
            }
        }
        String string = "TokenChanged_" + tApplicationListenerEvent.getTokenID();
        if (this.AppScripts != null && this.AppScripts.isResourceDefined(string)) {
            TExecScript tExecScript = new TExecScript(string, null, null);
            tExecScript.start();
        }
    }

    public void setElementText(String string, String string2) {
        TApplicationListenerEvent tApplicationListenerEvent = new TApplicationListenerEvent(1, string, string2);
        this.notifyListeners(tApplicationListenerEvent);
    }

    public String getElementText(String string) {
        TApplicationListenerEvent tApplicationListenerEvent = new TApplicationListenerEvent(2, string, "");
        Object object = null;
        if (this.arListeners != null) {
            for (int i = 0; i < this.arListeners.size() && object == null; ++i) {
                object = ((TApplicationListenerInterface)this.arListeners.get(i)).notifyApplicationEvent(tApplicationListenerEvent);
            }
        }
        if (object != null && object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public void updateLocalDisplays() {
        if (this.AppDisplays != null) {
            this.AppDisplays.updateLocalDisplays();
        }
    }

    public Iterator getIterator(int n) {
        Iterator iterator = null;
        switch (n) {
            case 0: {
                iterator = this.AppMain.ResourceColl.iterator();
                break;
            }
            case 1: {
                iterator = this.AppAction.ResourceColl.iterator();
                break;
            }
            case 2: {
                iterator = this.AppMenu.ResourceColl.iterator();
                break;
            }
            case 3: {
                iterator = this.AppToken.ResourceColl.iterator();
                break;
            }
            case 4: {
                iterator = this.AppDriverStruct.ResourceColl.iterator();
                break;
            }
            case 5: {
                iterator = this.AppDrivers.ResourceColl.iterator();
                break;
            }
            case 6: {
                iterator = this.AppCollections.ResourceColl.iterator();
                break;
            }
            case 7: {
                iterator = this.AppDisplays.ResourceColl.iterator();
                break;
            }
            case 8: {
                iterator = this.AppFilters.ResourceColl.iterator();
                break;
            }
            case 9: {
                iterator = this.AppDialogs.ResourceColl.iterator();
                break;
            }
            case 13: {
                iterator = this.AppTables.ResourceColl.iterator();
                break;
            }
            case 15: {
                iterator = this.AppReports.ResourceColl.iterator();
                break;
            }
            case 10: {
                iterator = this.AppScripts.ResourceColl.iterator();
                break;
            }
            case 11: {
                iterator = this.AppToolbar.ResourceColl.iterator();
                break;
            }
            case 12: {
                iterator = this.AppFunction.ResourceColl.iterator();
                break;
            }
            case 14: {
                iterator = this.AppDriverCmd.ResourceColl.iterator();
                break;
            }
            default: {
                System.out.println("Invalid iterator requested");
            }
        }
        return iterator;
    }

    public ArrayList getResourceElements(int n, String string) {
        ArrayList arrayList = null;
        switch (n) {
            case 0: {
                arrayList = this.AppMain.getResourceElements(string);
                break;
            }
            case 1: {
                arrayList = this.AppAction.getResourceElements(string);
                break;
            }
            case 2: {
                arrayList = this.AppMenu.getResourceElements(string);
                break;
            }
            case 3: {
                arrayList = this.AppToken.getResourceElements(string);
                break;
            }
            case 4: {
                arrayList = this.AppDriverStruct.getResourceElements(string);
                break;
            }
            case 5: {
                arrayList = this.AppDrivers.getResourceElements(string);
                break;
            }
            case 6: {
                arrayList = this.AppCollections.getResourceElements(string);
                break;
            }
            case 7: {
                arrayList = this.AppDisplays.getResourceElements(string);
                break;
            }
            case 9: {
                arrayList = this.AppDialogs.getResourceElements(string);
                break;
            }
            case 13: {
                arrayList = this.AppTables.getResourceElements(string);
                break;
            }
            case 15: {
                arrayList = this.AppReports.getResourceElements(string);
                break;
            }
            case 10: {
                arrayList = this.AppScripts.getResourceElements(string);
                break;
            }
            case 11: {
                arrayList = this.AppToolbar.getResourceElements(string);
                break;
            }
            case 12: {
                arrayList = this.AppFunction.getResourceElements(string);
                break;
            }
            case 14: {
                arrayList = this.AppDriverCmd.getResourceElements(string);
            }
        }
        return arrayList;
    }

    public String getDefinedTokens() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        for (TAppBaseObject tAppBaseObject : this.AppMain.ResourceColl) {
            string = charutil.removeChar(tAppBaseObject.Value.toString(), '\n');
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(tAppBaseObject.TokenID + "=" + string);
        }
        for (TAppBaseObject tAppBaseObject : this.AppToken.ResourceColl) {
            string = charutil.removeChar(((TAppTokenObject)tAppBaseObject).Value.toString(), '\n');
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(((TAppTokenObject)tAppBaseObject).TokenID + "=" + string);
        }
        return stringBuilder.toString();
    }

    public synchronized int getTokenValue(StringBuilder stringBuilder, String string) {
        int n = 0;
        if (string.equalsIgnoreCase("PACKAGEURL_ASPECT_SOFTWARE_NET_CORE") || string.equalsIgnoreCase("PACKAGEURL_ASPECT_SOFTWARE_NET_COMMON")) {
            String string2 = this.AspectCoreUrl;
            if (string2.toUpperCase().startsWith("FILE:")) {
                string2 = string2.substring(5);
            }
            stringBuilder.setLength(0);
            stringBuilder.append(string2);
            return 1;
        }
        if (string.equalsIgnoreCase("execdir")) {
            stringBuilder.setLength(0);
            stringBuilder.append(this.ExecDirectory);
            return 1;
        }
        if (this.AppMain != null && (n = this.AppMain.getTokenValue(stringBuilder, string)) == 0 && this.AppToken != null) {
            n = this.AppToken.getTokenValue(stringBuilder, string);
        }
        return n;
    }

    public synchronized int getTokenValue(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        return this.getTokenValue(stringBuilder, stringBuilder2.toString());
    }

    public synchronized String getTokenValue(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.getTokenValue(stringBuilder, string);
        return stringBuilder.toString();
    }

    public synchronized boolean getTokenValueAsBool(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.getTokenValue(stringBuilder, string);
        if (stringBuilder.length() == 0) {
            return false;
        }
        return charutil.boolval(stringBuilder);
    }

    public synchronized int getTokenValueAsInt(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.getTokenValue(stringBuilder, string);
        if (stringBuilder.length() == 0) {
            return 0;
        }
        return charutil.ival(stringBuilder);
    }

    public synchronized void setTokenValue(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        this.setTokenValue(stringBuilder.toString(), stringBuilder2.toString());
    }

    public synchronized void setTokenValue(String string, String string2) {
        String string3 = string2.trim();
        int n = 0;
        boolean bl = false;
        if (this.AppMain != null) {
            if (string3.length() > 1 && string3.charAt(0) == '{') {
                StringBuilder stringBuilder = new StringBuilder(string3);
                stringBuilder.deleteCharAt(0);
                if (stringBuilder.charAt(stringBuilder.length() - 1) == '}') {
                    stringBuilder.setLength(stringBuilder.length() - 1);
                }
                string3 = stringBuilder.toString();
            }
            if (!string.startsWith("$Collection")) {
                n = this.AppMain.setTokenValue(string, string3, false);
            }
            if (n == 0 && this.AppToken != null) {
                this.AppToken.setTokenValue(string, string3, true);
            } else {
                this.AppMain.setTokenValue(string, string3, true);
            }
        }
        this.notifyListeners(new TApplicationListenerEvent(0, string, string3));
    }

    public synchronized String parse_tokens(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        boolean bl = false;
        if (stringBuilder2.indexOf("{") < 0) {
            String string = stringBuilder2.toString();
            stringBuilder.setLength(0);
            stringBuilder.append(string);
            return stringBuilder.toString();
        }
        if (bl) {
            System.out.println("TApplication.parse_tokens: " + stringBuilder2);
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        StringBuilder stringBuilder4 = new StringBuilder();
        StringBuilder stringBuilder5 = new StringBuilder(stringBuilder2.toString());
        while (charutil.get_token_string(stringBuilder4, stringBuilder5, 0) >= 0) {
            this.getTokenValue(stringBuilder3, charutil.remove_braces(stringBuilder4, "{}"));
            charutil.replace_sub_string(stringBuilder5, stringBuilder5, stringBuilder4, stringBuilder3);
            if (!bl) continue;
            System.out.println("  = " + stringBuilder5);
        }
        stringBuilder.setLength(0);
        stringBuilder.append((CharSequence)stringBuilder5);
        return stringBuilder.toString();
    }

    public synchronized String parse_tokens(StringBuilder stringBuilder, String string) {
        return this.parse_tokens(stringBuilder, new StringBuilder(string));
    }

    public synchronized String parse_tokens(String string) {
        if (string == null) {
            return "";
        }
        if (string.indexOf(123) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.parse_tokens(stringBuilder, string);
        return stringBuilder.toString();
    }

    public synchronized String preserveUserTokens(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        charutil.replace_sub_string(stringBuilder, stringBuilder, "{execdir}", "@_execdir}");
        charutil.replace_sub_string(stringBuilder, stringBuilder, "{workingdir}", "@_workingdir}");
        charutil.replace_sub_string(stringBuilder, stringBuilder, "{homedir}", "@_homedir}");
        charutil.replace_sub_string(stringBuilder, stringBuilder, "{programdir}", "@_programdir}");
        charutil.replace_sub_string(stringBuilder, stringBuilder, "{coredir}", "@_coredir}");
        return stringBuilder.toString();
    }

    public synchronized boolean isTokenDefined(String string) {
        if (this.AppMain != null && this.AppMain.isTokenDefined(string)) {
            return true;
        }
        return this.AppToken != null && this.AppToken.isTokenDefined(string);
    }

    public String getAspectHashID() {
        if (tokenAspectHashID.length() == 0) {
            tokenAspectHashID = this.getTokenValue("AspectHashID");
        }
        return tokenAspectHashID;
    }

    public String getTemporaryFiles() {
        if (tokenTemporaryFiles.length() == 0) {
            tokenTemporaryFiles = this.getTokenValue("Temporary_Files");
        }
        return tokenTemporaryFiles;
    }

    public String getHomeDir() {
        if (tokenHomeDir.length() == 0 || tokenHomeDir.toUpperCase().indexOf("DEVELOPMENT") >= 0) {
            tokenHomeDir = this.getTokenValue("HomeDir");
        }
        return tokenHomeDir;
    }
}

