/*
 * Decompiled with CFR 0.152.
 */
package resources;

import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TPackage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import resources.TAppBase;
import resources.TAppMainObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.dosutil;
import utility.netutil;

public class TAppMain
extends TAppBase {
    Hashtable hashPackageLocalUrl = new Hashtable();
    Hashtable hashPackageSourceUrl = new Hashtable();
    Hashtable hashPackageName = new Hashtable();
    StringBuilder WorkingDir = null;

    public TAppMain(TApplication tApplication) {
        super(tApplication);
    }

    @Override
    public void get_file_names() {
        StringBuilder stringBuilder = new StringBuilder(this.Application.ExecDirectory);
        dosutil.add_trailing_slash(stringBuilder, stringBuilder, "/");
        stringBuilder.append("main.asp");
        dosutil.formatURL(stringBuilder, stringBuilder);
        this.AltFileName = this.FileName = stringBuilder.toString();
    }

    @Override
    public String getResourceDescription() {
        return "Main";
    }

    @Override
    public String getResourceName() {
        return "Main";
    }

    @Override
    public int required_fields() {
        return 0;
    }

    @Override
    public Object create_resource_object(String string, TApplication tApplication, int n, int n2, long l, long l2, StringBuilder stringBuilder, String[] stringArray) {
        TAppMainObject tAppMainObject = new TAppMainObject(string, tApplication, n, n2, l, l2, stringBuilder);
        if (tAppMainObject.TokenID.length() == 0) {
            return null;
        }
        for (int i = 0; i < this.ResourceColl.size(); ++i) {
            TAppMainObject tAppMainObject2 = (TAppMainObject)this.ResourceColl.get(i);
            if (tAppMainObject.TokenID.equalsIgnoreCase("!Action") || tAppMainObject.TokenID.equalsIgnoreCase("!!Action") || !tAppMainObject.TokenID.equalsIgnoreCase(tAppMainObject2.TokenID)) continue;
            tAppMainObject2.Value.setLength(0);
            tAppMainObject2.Value.append((CharSequence)tAppMainObject.Value);
            return null;
        }
        return tAppMainObject;
    }

    public void initializePackageHashtables() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        String string2 = "";
        this.hashPackageLocalUrl.clear();
        this.hashPackageSourceUrl.clear();
        this.hashPackageName.clear();
        TAspectDriver tAspectDriver = new TAspectDriver("PackageWrapper", 0, false, true, "");
        if (tAspectDriver.isValid()) {
            for (int i = 0; i < tAspectDriver.getRecordCount(); ++i) {
                String string3;
                TPackage tPackage = new TPackage(tAspectDriver, i);
                if (tPackage.isDeleted() || !tPackage.getEnabled() || (string3 = tPackage.getPackageID().toUpperCase()).equalsIgnoreCase("aspect_software_net_core") || string3.equalsIgnoreCase("aspect_software_net_common")) continue;
                string = tPackage.getLocalLocation();
                string2 = tPackage.getSourceLocation();
                this.hashPackageLocalUrl.put(string3, dosutil.addTrailingSlash(string));
                this.hashPackageSourceUrl.put(string3, dosutil.addTrailingSlash(string2));
                this.hashPackageName.put(string3, tPackage.getPackageName());
            }
        }
        tAspectDriver.dispose();
        String string4 = this.Application.AspectCoreUrl;
        if (string4.toUpperCase().startsWith("FILE:")) {
            string4 = string4.substring(5);
        }
        string = string4;
        string2 = string4;
        this.hashPackageLocalUrl.put("ASPECT_SOFTWARE_NET_CORE", dosutil.addTrailingSlash(string));
        this.hashPackageLocalUrl.put("ASPECT_SOFTWARE_NET_COMMON", dosutil.addTrailingSlash(string));
        this.hashPackageSourceUrl.put("ASPECT_SOFTWARE_NET_CORE", dosutil.addTrailingSlash(string2));
        this.hashPackageSourceUrl.put("ASPECT_SOFTWARE_NET_COMMON", dosutil.addTrailingSlash(string2));
        this.hashPackageName.put("ASPECT_SOFTWARE_NET_CORE", dosutil.addTrailingSlash("Aspect Core"));
        this.hashPackageName.put("ASPECT_SOFTWARE_NET_COMMON", dosutil.addTrailingSlash("Aspect Common"));
    }

    public int parse_application_defined_values(StringBuilder stringBuilder, String string) {
        Object v;
        String string2;
        Object object;
        if (string.length() == 0) {
            return 0;
        }
        stringBuilder.setLength(0);
        if (string.startsWith("@")) {
            TFormulaEvaluator tFormulaEvaluator = new TFormulaEvaluator();
            String string3 = string.substring(1);
            Object object2 = tFormulaEvaluator.getFormulaValue(string3, -1, -1);
            string3 = TFormulaEvaluator.convertToString(object2);
            stringBuilder.append(string3);
            return 1;
        }
        if (string.equalsIgnoreCase("br")) {
            stringBuilder.append("<br>");
            return 1;
        }
        if (string.equalsIgnoreCase("h1")) {
            stringBuilder.append("<h1>");
            return 1;
        }
        if (string.equalsIgnoreCase("/h1")) {
            stringBuilder.append("</h1>");
            return 1;
        }
        if (string.equalsIgnoreCase("h2")) {
            stringBuilder.append("<h2>");
            return 1;
        }
        if (string.equalsIgnoreCase("/h2")) {
            stringBuilder.append("</h2>");
            return 1;
        }
        if (string.equalsIgnoreCase("h3")) {
            stringBuilder.append("<h3>");
            return 1;
        }
        if (string.equalsIgnoreCase("/h3")) {
            stringBuilder.append("</h3>");
            return 1;
        }
        if (string.equalsIgnoreCase("table")) {
            stringBuilder.append("<table>");
            return 1;
        }
        if (string.equalsIgnoreCase("/table")) {
            stringBuilder.append("</table>");
            return 1;
        }
        if (string.equalsIgnoreCase("tr")) {
            stringBuilder.append("<tr>");
            return 1;
        }
        if (string.equalsIgnoreCase("/tr")) {
            stringBuilder.append("</tr>");
            return 1;
        }
        if (string.equalsIgnoreCase("td")) {
            stringBuilder.append("<td>");
            return 1;
        }
        if (string.equalsIgnoreCase("/td")) {
            stringBuilder.append("</td>");
            return 1;
        }
        if (string.equalsIgnoreCase("th")) {
            stringBuilder.append("<th>");
            return 1;
        }
        if (string.equalsIgnoreCase("/th")) {
            stringBuilder.append("</th>");
            return 1;
        }
        if (string.equalsIgnoreCase("feval_resultcache_enabled")) {
            stringBuilder.append(Boolean.toString(TFormulaEvaluator.EnableResultCaching));
            return 1;
        }
        if (string.equalsIgnoreCase("feval_resultcache_debug")) {
            stringBuilder.append(Boolean.toString(TFormulaEvaluator.ResultCachingDebug));
            return 1;
        }
        if (string.equalsIgnoreCase("feval_resultcache_attempted")) {
            stringBuilder.append(Integer.toString(TFormulaEvaluator.cCachedResultsAttempted));
            return 1;
        }
        if (string.equalsIgnoreCase("feval_resultcache_retrieved")) {
            stringBuilder.append(Integer.toString(TFormulaEvaluator.cCachedResultsRetrieved));
            return 1;
        }
        if (string.equalsIgnoreCase("feval_resultcache_error")) {
            stringBuilder.append(Integer.toString(TFormulaEvaluator.cCachedResultsError));
            return 1;
        }
        if (string.equalsIgnoreCase("feval_resultcache_put")) {
            stringBuilder.append(Integer.toString(TFormulaEvaluator.cCachedResultsPut));
            return 1;
        }
        if (string.equalsIgnoreCase("feval_resultcache_ms")) {
            stringBuilder.append(Long.toString(TFormulaEvaluator.cEvalFuncMilliseconds));
            return 1;
        }
        if (string.equalsIgnoreCase("functions")) {
            Enumeration enumeration = this.Application.AppFunction.getFunctionNames().keys();
            while (enumeration.hasMoreElements()) {
                stringBuilder.append((String)enumeration.nextElement() + "|");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            return 1;
        }
        if (string.equalsIgnoreCase("HashedDocumentCount")) {
            stringBuilder.append(TFormulaEvaluator.getHashedDocumentCount());
            return 1;
        }
        if (string.equalsIgnoreCase("GreenLightSocketRequests")) {
            stringBuilder.append(TFormulaEvaluator.intSocketRequests);
            return 1;
        }
        if (string.equalsIgnoreCase("GreenLightSocketRequestsProcessed")) {
            stringBuilder.append(TFormulaEvaluator.intSocketProcessed);
            return 1;
        }
        if (string.equalsIgnoreCase("GreenLightSocketRequestsIgnored")) {
            stringBuilder.append(TFormulaEvaluator.intSocketIgnored);
            return 1;
        }
        if (string.equalsIgnoreCase("GreenLightSocketQueueTime")) {
            stringBuilder.append(TFormulaEvaluator.intSocketQueueTime);
            return 1;
        }
        if (string.equalsIgnoreCase("PID")) {
            stringBuilder.append(dosutil.getPID());
            return 1;
        }
        if (string.equalsIgnoreCase("AspectServerIP")) {
            stringBuilder.append(TMainWin.AspectServerIP);
            return 1;
        }
        if (string.equalsIgnoreCase("AspectServerPort")) {
            stringBuilder.append(TMainWin.AspectServerPort);
            return 1;
        }
        if (string.equalsIgnoreCase("AspectSSLServerPort")) {
            stringBuilder.append(TMainWin.AspectSSLServerPort);
            return 1;
        }
        if (string.equalsIgnoreCase(" ")) {
            stringBuilder.append(TMainWin.AspectServerIP + ":" + TMainWin.AspectServerPort);
            return 1;
        }
        if (string.equalsIgnoreCase("AspectSSLServer")) {
            stringBuilder.append(TMainWin.AspectServerIP + ":" + TMainWin.AspectSSLServerPort);
            return 1;
        }
        if (string.equalsIgnoreCase("JavaVersion") && (object = System.getProperties()) != null && (string2 = ((Properties)object).getProperty("java.version")) != null) {
            stringBuilder.append(string2);
            return 1;
        }
        if (string.equalsIgnoreCase("OSVersion") && (object = System.getProperties()) != null && (string2 = ((Properties)object).getProperty("os.version")) != null) {
            stringBuilder.append(string2);
            return 1;
        }
        if (string.equalsIgnoreCase("OSName") && (object = System.getProperties()) != null && (string2 = ((Properties)object).getProperty("os.name")) != null) {
            stringBuilder.append(string2);
            return 1;
        }
        if (string.equalsIgnoreCase("TimeZone") && (object = System.getProperties()) != null && (string2 = ((Properties)object).getProperty("user.timezone")) != null) {
            stringBuilder.append(string2);
            return 1;
        }
        if (string.equalsIgnoreCase("UserName") && (object = System.getProperties()) != null && (string2 = ((Properties)object).getProperty("user.name")) != null) {
            stringBuilder.append(string2);
            return 1;
        }
        if (string.equalsIgnoreCase("JavaHome") && (object = System.getProperties()) != null && (string2 = ((Properties)object).getProperty("java.home")) != null) {
            stringBuilder.append(string2);
            return 1;
        }
        if (string.toUpperCase().startsWith("NOW")) {
            object = "MM-dd-yyyy HH:mm:ss";
            int n = string.indexOf(":");
            if (n >= 0) {
                object = string.substring(n + 1);
            }
            stringBuilder.append(new SimpleDateFormat((String)object).format(new Date()));
            return 1;
        }
        if (string.toUpperCase().startsWith("PACKAGEURL_") && (v = this.hashPackageLocalUrl.get(string2 = string.substring(11).toUpperCase())) != null) {
            stringBuilder.append((String)v);
            return 1;
        }
        if (string.toUpperCase().startsWith("PACKAGESOURCEURL_") && (v = this.hashPackageSourceUrl.get(string2 = string.substring(17).toUpperCase())) != null) {
            stringBuilder.append((String)v);
            return 1;
        }
        if (string.toUpperCase().startsWith("PACKAGENAME_") && (v = this.hashPackageName.get(string2 = string.substring(12).toUpperCase())) != null) {
            stringBuilder.append((String)v);
            return 1;
        }
        if (string.equalsIgnoreCase("\\r")) {
            stringBuilder.append('\r');
            return 1;
        }
        if (string.equalsIgnoreCase("\\n")) {
            stringBuilder.append('\n');
            return 1;
        }
        if (string.equalsIgnoreCase("\\r\\n")) {
            stringBuilder.append('\r');
            stringBuilder.append('\n');
            return 1;
        }
        if (string.equalsIgnoreCase("tab")) {
            stringBuilder.append('\b');
            return 1;
        }
        if (string.equalsIgnoreCase("comma") || string.equalsIgnoreCase(",")) {
            stringBuilder.append(',');
            return 1;
        }
        if (string.equalsIgnoreCase("quote") || string.charAt(0) == '\"') {
            stringBuilder.append('\"');
            return 1;
        }
        if (string.equalsIgnoreCase("MaxMemory")) {
            Runtime runtime = Runtime.getRuntime();
            stringBuilder.append(Long.toString(runtime.maxMemory() / 1000L));
            return 1;
        }
        if (string.equalsIgnoreCase("AllocatedMemory")) {
            Runtime runtime = Runtime.getRuntime();
            stringBuilder.append(Long.toString(runtime.totalMemory() / 1000L));
            return 1;
        }
        if (string.equalsIgnoreCase("UsedMemory")) {
            Runtime runtime = Runtime.getRuntime();
            long l = (runtime.totalMemory() - runtime.freeMemory()) / 1000L;
            stringBuilder.append(Long.toString(l));
            return 1;
        }
        if (string.equalsIgnoreCase("AvailableMemory")) {
            Runtime runtime = Runtime.getRuntime();
            long l = (runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory())) / 1000L;
            stringBuilder.append(Long.toString(l));
            return 1;
        }
        if (string.equalsIgnoreCase("LocalHostName")) {
            stringBuilder.append(netutil.getLocalHostName());
            return 1;
        }
        if (string.equalsIgnoreCase("InternalIPAddress")) {
            stringBuilder.append(netutil.getLocalIP());
            return 1;
        }
        if (string.equalsIgnoreCase("ExternalIPAddress")) {
            stringBuilder.append(netutil.getExternalIP());
            return 1;
        }
        if (string.equalsIgnoreCase("ExternalHostName")) {
            stringBuilder.append(netutil.getHostName(netutil.getExternalIP()));
            return 1;
        }
        if (string.equalsIgnoreCase("execdir")) {
            stringBuilder.setLength(0);
            stringBuilder.append(this.Application.ExecDirectory);
            return 1;
        }
        if (string.equalsIgnoreCase("workingdir")) {
            if (this.WorkingDir == null) {
                this.WorkingDir = new StringBuilder();
                dosutil.get_current_dir(this.WorkingDir);
                dosutil.add_trailing_slash(this.WorkingDir, this.WorkingDir, "/");
            }
            stringBuilder.setLength(0);
            stringBuilder.append((CharSequence)this.WorkingDir);
            return 1;
        }
        if (string.equalsIgnoreCase("homedir") || string.equalsIgnoreCase("programdir")) {
            stringBuilder.setLength(0);
            stringBuilder.append(this.Application.HomeDirectory);
            dosutil.add_trailing_slash(stringBuilder, stringBuilder, "/");
            return 1;
        }
        if (string.equalsIgnoreCase("temporary_files")) {
            stringBuilder.setLength(0);
            stringBuilder.append(this.Application.HomeDirectory);
            dosutil.add_trailing_slash(stringBuilder, stringBuilder, "/");
            stringBuilder.append("temporary_files/");
            return 1;
        }
        if (string.equalsIgnoreCase("coredir")) {
            stringBuilder.setLength(0);
            stringBuilder.append(this.Application.AspectCoreUrl);
            dosutil.add_trailing_slash(stringBuilder, stringBuilder, "/");
            return 1;
        }
        if (string.equalsIgnoreCase("execmode")) {
            stringBuilder.setLength(0);
            if (this.Application.getDevelopmentMode() == 0) {
                stringBuilder.append("Development");
            } else {
                stringBuilder.append("Deployed");
            }
            return 1;
        }
        if (string.length() >= 5 && string.substring(0, 5).equalsIgnoreCase("args[")) {
            StringBuilder stringBuilder2 = new StringBuilder(string);
            StringBuilder stringBuilder3 = new StringBuilder();
            charutil.getsubstring(stringBuilder3, stringBuilder2, 0, '[', true);
            if (!charutil.nullstr(stringBuilder2) && stringBuilder2.charAt(stringBuilder2.length() - 1) == ']') {
                charutil.left(stringBuilder2, stringBuilder2, stringBuilder2.length() - 1);
            }
            int n = charutil.ival(stringBuilder2);
            stringBuilder2.setLength(0);
            if (this.Application.CommandLineArgs != null && n < this.Application.CommandLineArgs.length) {
                stringBuilder2 = new StringBuilder(this.Application.CommandLineArgs[n]);
            }
            stringBuilder.setLength(0);
            stringBuilder.append((CharSequence)stringBuilder2);
            return 1;
        }
        return 0;
    }

    public synchronized int getTokenValue(StringBuilder stringBuilder, String string) {
        TAppMainObject tAppMainObject = null;
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        StringBuilder stringBuilder4 = new StringBuilder();
        boolean bl = false;
        stringBuilder.setLength(0);
        if (this.parse_application_defined_values(stringBuilder2, string) > 0) {
            bl = true;
        } else {
            Iterator iterator = this.ResourceColl.iterator();
            while (!bl && iterator.hasNext()) {
                tAppMainObject = (TAppMainObject)iterator.next();
                if (tAppMainObject.TokenID.compareToIgnoreCase(string) != 0) continue;
                stringBuilder2 = new StringBuilder(tAppMainObject.Value.toString());
                bl = true;
            }
        }
        if (bl) {
            while (charutil.get_token_string(stringBuilder4, stringBuilder2, 0) >= 0) {
                this.getTokenValue(stringBuilder3, charutil.remove_braces(stringBuilder4, "{}"));
                charutil.replace_sub_string(stringBuilder2, stringBuilder2, stringBuilder4, stringBuilder3);
            }
            stringBuilder.append((CharSequence)stringBuilder2);
            return 1;
        }
        return 0;
    }

    public synchronized boolean isTokenDefined(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string.startsWith("@")) {
            return true;
        }
        if (this.parse_application_defined_values(stringBuilder, string) > 0) {
            return true;
        }
        Iterator iterator = this.ResourceColl.iterator();
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            TAppMainObject tAppMainObject = (TAppMainObject)iterator.next();
            if (tAppMainObject.TokenID.compareToIgnoreCase(string) != 0) continue;
            return true;
        }
        return false;
    }

    public synchronized int setTokenValue(String string, String string2, boolean bl) {
        TAppMainObject tAppMainObject2 = null;
        for (TAppMainObject tAppMainObject2 : this.ResourceColl) {
            if (charutil.strcmpi(tAppMainObject2.TokenID, string) != 0) continue;
            tAppMainObject2.Value = new StringBuilder(string2);
            return 1;
        }
        if (bl) {
            this.ResourceColl.add(new TAppMainObject(string, string2));
            return 1;
        }
        return 0;
    }
}

