/*
 * Decompiled with CFR 0.152.
 */
package resources;

import aspect.Aspect;
import aspect.TMainWin;
import collections.TComboBoxColl;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import gnu.io.CommPortIdentifier;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import resources.TAppActionObject;
import resources.TAppBase;
import resources.TAppBaseObject;
import resources.TAppCollectionsObject;
import resources.TAppDialogsObject;
import resources.TAppDriverCmdObject;
import resources.TAppDriverStructObject;
import resources.TAppDriversObject;
import resources.TAppFunctionObject;
import resources.TAppMenuObject;
import resources.TAppReportsObject;
import resources.TAppScriptsObject;
import resources.TAppTablesObject;
import resources.TAppTokenObject;
import resources.TAppToolbarObject;
import resources.TApplication;
import scripts.TExecScript;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.objectutil;
import utility.security.TPasswordService;

public class TAppCollections
extends TAppBase {
    private TMainWin MainWin = Aspect.MainWin;
    private ArrayList arSearchHistory = new ArrayList();
    private ArrayList arReplaceHistory = new ArrayList();
    private TComboBoxColl StructureFieldCollection = null;
    private boolean Debug = false;
    private TComboBoxColl StructureFieldCollection2 = null;
    private String StructureFieldCollection2ID = "";
    private TComboBoxColl StructureFieldCollection3 = null;
    private String StructureFieldCollection3ID = "";
    private TComboBoxColl StructureFieldCollection4 = null;
    private String StructureFieldCollection4ID = "";
    private static long elapsedCacheColl = 0L;
    private static long elapsedOrigColl = 0L;

    public TAppCollections(TApplication tApplication) {
        super(tApplication);
    }

    @Override
    public Object create_resource_object(String string, TApplication tApplication, int n, int n2, long l, long l2, StringBuilder stringBuilder, String[] stringArray) {
        tApplication.setTokenValue("TAppCollections_Updated", Long.toString(new Date().getTime()));
        return new TAppCollectionsObject(string, tApplication, n, n2, l, l2, stringBuilder, stringArray);
    }

    @Override
    public String getResourceDescription() {
        return "Collections";
    }

    @Override
    public String getResourceName() {
        return "AppCollctnFile";
    }

    @Override
    public int required_fields() {
        return 16;
    }

    public TAppCollectionsObject getAppCollectionsObject(String string) {
        int n = this.ResourceColl.size();
        for (int i = 0; i < n; ++i) {
            TAppCollectionsObject tAppCollectionsObject = (TAppCollectionsObject)this.ResourceColl.get(i);
            if (!string.equalsIgnoreCase(tAppCollectionsObject.CollectionID.toString())) continue;
            return tAppCollectionsObject;
        }
        return null;
    }

    public synchronized String addCollection(String string, String string2, String string3, String string4) {
        String string5 = TPasswordService.generateSalt(5);
        this.ResourceColl.add(new TAppCollectionsObject(string5, string, string2, string3, string4));
        return string5;
    }

    public synchronized boolean removeCollection(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.ResourceColl.size()) {
            TAppCollectionsObject tAppCollectionsObject = (TAppCollectionsObject)this.ResourceColl.get(n);
            if (tAppCollectionsObject.CollectionID.toString().equalsIgnoreCase(string)) {
                this.ResourceColl.remove(n);
                bl = true;
                continue;
            }
            ++n;
        }
        return bl;
    }

    public void clearCache() {
        if (this.StructureFieldCollection != null) {
            this.StructureFieldCollection.clear();
            this.StructureFieldCollection = null;
        }
        if (this.StructureFieldCollection2 != null) {
            this.StructureFieldCollection2.clear();
            this.StructureFieldCollection2 = null;
            this.StructureFieldCollection2ID = "";
        }
        if (this.StructureFieldCollection3 != null) {
            this.StructureFieldCollection3.clear();
            this.StructureFieldCollection3 = null;
            this.StructureFieldCollection3ID = "";
        }
        if (this.StructureFieldCollection4 != null) {
            this.StructureFieldCollection4.clear();
            this.StructureFieldCollection4 = null;
            this.StructureFieldCollection4ID = "";
        }
    }

    public TComboBoxColl getCollection(String string) {
        return this.getCollection(string, null, null, false, "", "");
    }

    public TComboBoxColl getCollection(String string, String string2, String string3) {
        return this.getCollection(string, new StringBuilder(string2), null, false, string3, "");
    }

    public TComboBoxColl getCollection(String string, StringBuilder stringBuilder, TFormulaEvaluator tFormulaEvaluator, boolean bl, String string2, String string3) {
        Object object;
        if (!TMainWin.Application.getTokenValue("Aspect_Initialized").equalsIgnoreCase("true")) {
            return this.createCollection(string, stringBuilder, tFormulaEvaluator, string2, string3);
        }
        Date date = new Date();
        TAppCollectionsObject tAppCollectionsObject = this.getAppCollectionsObject(string);
        if (tAppCollectionsObject == null) {
            this.MainWin.appendToLog("TAppCollections", "getCollection", Thread.currentThread(), null, 4, "Invalid collection ID: " + string);
            return new TComboBoxColl(false, 100);
        }
        String string4 = TMainWin.Application.getTokenValue("AspectHashID");
        String string5 = "";
        boolean bl2 = false;
        String string6 = "";
        String string7 = "";
        String string8 = "CollectionID=" + string;
        if (stringBuilder == null) {
            string8 = string8 + "&Filter=";
        } else {
            string8 = string8 + "&Filter=" + stringBuilder;
            if (tFormulaEvaluator != null && stringBuilder.length() > 0 && (object = tFormulaEvaluator.getVariableValue(null, stringBuilder, true, tFormulaEvaluator.getAltRecordNumber(), 0, null)) != null) {
                string8 = string8 + "&EvalFilter=" + objectutil.convertToString(object);
            }
        }
        string8 = string8 + "&DriverParams=" + string2;
        string8 = string8 + "&SystemDriverName=" + string3;
        string8 = string8 + "&CacheTtl=" + Integer.toString(tAppCollectionsObject.TTL);
        object = TFormulaEvaluator.getCache().getCachedContent(5, string4, string8, bl2, string6, string7, null, "", "", tFormulaEvaluator);
        TComboBoxColl tComboBoxColl = new TComboBoxColl(false, 100);
        String[] stringArray = charutil.getSubStringArray((String)object, '|', false);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n = stringArray[i].indexOf(61);
                if (n <= 0) continue;
                String string9 = charutil.replaceAllSubstrings(charutil.replaceAllSubstrings(charutil.replaceAllSubstrings(stringArray[i].substring(0, n), "%pipe%", "|"), "%equal%", "="), "%qt%", "\"");
                String string10 = "";
                if (stringArray[i].length() >= n + 1) {
                    string10 = charutil.replaceAllSubstrings(charutil.replaceAllSubstrings(charutil.replaceAllSubstrings(stringArray[i].substring(n + 1), "%pipe%", "|"), "%equal%", "="), "%qt%", "\"");
                }
                tComboBoxColl.add(string9, string10);
            }
        }
        Date date2 = new Date();
        elapsedCacheColl += date2.getTime() - date.getTime();
        return tComboBoxColl;
    }

    public TComboBoxColl createCollection(String string, StringBuilder stringBuilder, TFormulaEvaluator tFormulaEvaluator, String string2, String string3) {
        TAppCollectionsObject tAppCollectionsObject = null;
        TAppDriversObject tAppDriversObject = null;
        TFormulaEvaluator tFormulaEvaluator2 = null;
        TDriverStructRecord tDriverStructRecord = null;
        TDriverStructRecord tDriverStructRecord2 = null;
        Object object = null;
        Object object2 = null;
        Object var13_13 = null;
        TComboBoxColl tComboBoxColl = null;
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        StringBuilder stringBuilder4 = new StringBuilder();
        this.Debug = false;
        if (this.Debug) {
            stringBuilder2.append("TAppCollections:createCollection[" + string + "] started.");
            if (stringBuilder != null && stringBuilder.length() > 0) {
                stringBuilder2.append(" (Filter = " + stringBuilder + ")");
            }
            this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 10, stringBuilder2.toString());
            stringBuilder2.setLength(0);
        }
        tAppCollectionsObject = this.getAppCollectionsObject(string);
        boolean bl = true;
        if (tAppCollectionsObject != null && tAppCollectionsObject.Sort == 0) {
            bl = false;
        }
        int n = charutil.get_substring_index(string, "Fonts|FontStyle|ResourceActions|ResourceCollections|ResourceCollectionsParsed|ResourceDialogs|ResourceDrivers|ResourceDriversParsed|ResourceToolbars|ActionTypes|StructureFields|SearchHistory|ReplaceHistory|ResourceDriversLookupStructure|ResourceTables|ResourceMenus|ResourceDriverStruct|ResourceDriverStructParsed|ResourceDriverCmd|ResourceScripts|Printers|ResourceReports|SerialPorts|StructureFields2|StructureFields3|StructureFields4|StructureFields5|StructureFields5WithSelect|ResourceFunctions|ResourceFunctionsUsage|ResourceTokens|Counters|YDimensionFields|XDimensionFields|MeasurementFields|AllStructureFieldsWithSelect", '|');
        if (this.Debug) {
            this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 10, "TAppCollections:createCollection Int1=" + n);
        }
        if (n >= 0) {
            switch (n) {
                case 0: {
                    tComboBoxColl = this.makeFontCollection(bl);
                    break;
                }
                case 1: {
                    tComboBoxColl = this.makeFontStyleCollection(bl);
                    break;
                }
                case 2: {
                    tComboBoxColl = this.makeResourceActionCollection(bl);
                    break;
                }
                case 3: {
                    tComboBoxColl = this.makeResourceCollectionsCollection(bl, false);
                    break;
                }
                case 4: {
                    tComboBoxColl = this.makeResourceCollectionsCollection(bl, true);
                    break;
                }
                case 5: {
                    tComboBoxColl = this.makeResourceDialogsCollection(bl);
                    break;
                }
                case 6: {
                    tComboBoxColl = this.makeResourceDriversCollection(bl, false);
                    break;
                }
                case 7: {
                    tComboBoxColl = this.makeResourceDriversCollection(bl, true);
                    break;
                }
                case 8: {
                    tComboBoxColl = this.makeResourceToolbarsCollection(bl);
                    break;
                }
                case 9: {
                    tComboBoxColl = this.makeActionTypeCollection(bl);
                    break;
                }
                case 10: {
                    tComboBoxColl = this.makeStructureFieldCollection(bl, tFormulaEvaluator, stringBuilder);
                    break;
                }
                case 11: {
                    tComboBoxColl = this.makeSearchHistoryCollection(bl);
                    break;
                }
                case 12: {
                    tComboBoxColl = this.makeReplaceHistoryCollection(bl);
                    break;
                }
                case 13: {
                    tComboBoxColl = this.makeResourceDriversLookupStructure(bl);
                    break;
                }
                case 14: {
                    tComboBoxColl = this.makeResourceTablesCollection(bl);
                    break;
                }
                case 15: {
                    tComboBoxColl = this.makeResourceMenusCollection(bl);
                    break;
                }
                case 16: {
                    tComboBoxColl = this.makeResourceDriverStructCollection(bl, false);
                    break;
                }
                case 17: {
                    tComboBoxColl = this.makeResourceDriverStructCollection(bl, true);
                    break;
                }
                case 18: {
                    tComboBoxColl = this.makeResourceDriverCmdCollection(bl);
                    break;
                }
                case 19: {
                    tComboBoxColl = this.makeResourceScriptsCollection(bl);
                    break;
                }
                case 20: {
                    tComboBoxColl = this.makePrinterCollection(bl);
                    break;
                }
                case 21: {
                    tComboBoxColl = this.makeResourceReportsCollection(bl);
                    break;
                }
                case 22: {
                    tComboBoxColl = this.makeSerialPortCollection(bl);
                    break;
                }
                case 23: {
                    tComboBoxColl = this.makeStructureFieldCollection2(bl, stringBuilder);
                    break;
                }
                case 24: {
                    tComboBoxColl = this.makeStructureFieldCollection3(bl, stringBuilder);
                    break;
                }
                case 25: {
                    tComboBoxColl = this.makeStructureFieldCollection4(bl, stringBuilder);
                    break;
                }
                case 26: {
                    tComboBoxColl = this.makeStructureFieldCollection5(bl, tFormulaEvaluator, stringBuilder);
                    break;
                }
                case 27: {
                    tComboBoxColl = this.makeStructureFieldCollection5(bl, tFormulaEvaluator, stringBuilder);
                    tComboBoxColl.insert(0, 0, "-- Select --");
                    break;
                }
                case 28: {
                    tComboBoxColl = this.makeResourceFunctionsCollection(bl);
                    break;
                }
                case 29: {
                    tComboBoxColl = this.makeResourceFunctionsUsageCollection(bl);
                    break;
                }
                case 30: {
                    tComboBoxColl = this.makeResourceTokensCollection(bl);
                    break;
                }
                case 31: {
                    tComboBoxColl = this.makeCounterCollection(bl);
                    break;
                }
                case 32: {
                    tComboBoxColl = this.makeDimensionalFieldsCollection("Y", bl, tFormulaEvaluator, stringBuilder.toString());
                    break;
                }
                case 33: {
                    tComboBoxColl = this.makeDimensionalFieldsCollection("X", bl, tFormulaEvaluator, stringBuilder.toString());
                    break;
                }
                case 34: {
                    tComboBoxColl = this.makeDimensionalFieldsCollection("M", bl, tFormulaEvaluator, stringBuilder.toString());
                    break;
                }
                case 35: {
                    if (stringBuilder.toString().trim().length() == 0) {
                        tComboBoxColl = new TComboBoxColl(bl, 1);
                        break;
                    }
                    tComboBoxColl = this.makeStructureFieldCollection(bl, tFormulaEvaluator, stringBuilder);
                    tComboBoxColl.insert(0, 0, "-- Select --");
                }
            }
            return tComboBoxColl;
        }
        if (tAppCollectionsObject == null) {
            this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "Invalid collection ID: " + string);
        }
        if (tAppCollectionsObject != null) {
            int n2;
            Object object3;
            tComboBoxColl = new TComboBoxColl(bl, 100);
            if (tAppCollectionsObject.Sort == 4 || tAppCollectionsObject.Sort == 5 || tAppCollectionsObject.Sort == 6) {
                tComboBoxColl.setSortDescending(true);
            }
            if (stringBuilder != null) {
                charutil.trimstr(stringBuilder4, stringBuilder);
            }
            if (this.Debug) {
                this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] creating collection from file");
            }
            if (!charutil.nullstr(tAppCollectionsObject.DriverID)) {
                boolean bl2;
                object3 = null;
                boolean bl3 = bl2 = string3.trim().length() > 0;
                if (bl2) {
                    if (this.Debug) {
                        this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] using system driver: " + string3);
                    }
                    if ((object3 = TFormulaEvaluator.getSystemDriver(string3, false)) == null) {
                        System.out.println("Error opening system driver named " + string3 + " while creating collection: " + string);
                    }
                } else {
                    String string4 = null;
                    if (("|" + string2.toUpperCase()).indexOf("|HASHID=") >= 0) {
                        string4 = charutil.getParamValue(string2, "HashID", '|');
                    }
                    if (string4 != null) {
                        System.out.println("Opening collection " + string + " using cache driver.  HashID=" + string4);
                        if (this.Debug) {
                            this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] using cache driver: " + tAppCollectionsObject.DriverID.toString() + " HashID: " + string4);
                        }
                        object3 = TFormulaEvaluator.getCache().openCacheDriver(string4, tAppCollectionsObject.DriverID.toString(), 1, string2);
                    } else {
                        if (this.Application.AppDrivers != null) {
                            tAppDriversObject = this.Application.AppDrivers.getAppDriversObject(tAppCollectionsObject.DriverID);
                        }
                        if (this.Debug) {
                            this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] using driver: " + tAppDriversObject.DriverID);
                        }
                        if (tAppDriversObject != null) {
                            block120: {
                                if (this.Debug) {
                                    this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] executeDriverPreActions");
                                }
                                this.MainWin.executeDriverPreActions(tAppDriversObject);
                                if (this.Debug) {
                                    this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] executeDriverPreActions complete");
                                }
                                if (this.Debug) {
                                    this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] opening driver: " + tAppDriversObject.DriverID);
                                }
                                try {
                                    object3 = new TAspectDriver(this.Application, tAppDriversObject, 1, false, string2);
                                }
                                catch (Exception exception) {
                                    this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:Error opening driver: " + tAppDriversObject.DriverID.toString() + ": " + exception.toString());
                                    if (object3 == null) break block120;
                                    ((TAspectDriver)object3).dispose();
                                    object3 = null;
                                }
                            }
                            if (this.Debug) {
                                this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 3, "TAppCollections:createCollection[" + string + "] opening driver: " + tAppDriversObject.DriverID + " complete");
                            }
                            if (object3 != null) {
                                ((TAspectDriver)object3).setUndoRecording(false);
                                if (!((TAspectDriver)object3).isValid()) {
                                    System.out.println("Error opening driver with ID=" + tAppDriversObject.DriverID + " while creating collection: " + string + " Filename=" + tAppDriversObject.FileName + " DriverParams=" + string2);
                                }
                            }
                        } else {
                            System.out.println("Cannot locate driver with ID=" + tAppCollectionsObject.DriverID + " while creating collection: " + string);
                        }
                    }
                }
                if (object3 != null) {
                    if (this.Debug) {
                        this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] adding values");
                    }
                    if ((tFormulaEvaluator2 = ((TAspectDriver)object3).getFormulaEvaluator()) != null && tFormulaEvaluator != null) {
                        tFormulaEvaluator2.setAltFormulaEvaluator(tFormulaEvaluator);
                        tFormulaEvaluator2.setAltRecordNumber(tFormulaEvaluator.getAltRecordNumber());
                    }
                    tDriverStructRecord = ((TAspectDriver)object3).DriverStruct.getField(tAppCollectionsObject.ValueFieldName);
                    tDriverStructRecord2 = ((TAspectDriver)object3).DriverStruct.getField(tAppCollectionsObject.IndexFieldName);
                    if (tDriverStructRecord != null && tDriverStructRecord2 != null) {
                        int n3 = ((TAspectDriver)object3).getRecordCount();
                        if (this.Debug) {
                            this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] Len=" + n3);
                        }
                        long l = new Date().getTime();
                        for (n2 = 0; n2 < n3; ++n2) {
                            long l2;
                            long l3;
                            if (n2 % 1000 == 0 && (l3 = (l2 = new Date().getTime()) - l) > 20000L) {
                                System.out.println("TAppCollections.createCollection CollectionID=" + string + " Elapsed=" + l3 + " Record " + n2 + " of " + n3);
                            }
                            if (this.Debug && n2 % 100 == 0) {
                                this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] Adding value " + n2 + " of " + n3);
                            }
                            if (!((TAspectDriver)object3).isDeleted(n2)) {
                                object2 = ((TAspectDriver)object3).getField(tDriverStructRecord, n2);
                                object = ((TAspectDriver)object3).getField(tDriverStructRecord2, n2);
                                if (object2 != null && object != null) {
                                    boolean bl4 = false;
                                    if (object2 instanceof String) {
                                        if (charutil.nullstr((String)object2)) {
                                            bl4 = true;
                                        } else {
                                            object2 = this.Application.parse_tokens((String)object2);
                                        }
                                    }
                                    if (object instanceof String) {
                                        if (charutil.nullstr((String)object)) {
                                            bl4 = true;
                                        } else {
                                            object = this.Application.parse_tokens((String)object);
                                        }
                                    }
                                    if (!bl4) {
                                        if (tAppCollectionsObject.IndexOffset != 0) {
                                            if (object instanceof Byte) {
                                                object = new Byte((byte)((Byte)object + tAppCollectionsObject.IndexOffset));
                                            } else if (object instanceof Short) {
                                                object = new Short((short)((Short)object + tAppCollectionsObject.IndexOffset));
                                            } else if (object instanceof Integer) {
                                                object = new Integer((Integer)object + tAppCollectionsObject.IndexOffset);
                                            } else if (object instanceof Float) {
                                                object = new Float(((Float)object).floatValue() + (float)tAppCollectionsObject.IndexOffset);
                                            } else if (object instanceof Double) {
                                                object = new Double((Double)object + (double)tAppCollectionsObject.IndexOffset);
                                            }
                                        }
                                        if ((tAppCollectionsObject.FilterMask.length() == 0 || ((TAspectDriver)object3).isInFilter(n2, tAppCollectionsObject.FilterMask)) && (stringBuilder4 == null || stringBuilder4.length() == 0 || ((TAspectDriver)object3).isInFilter(n2, stringBuilder4))) {
                                            tComboBoxColl.add(object, object2);
                                        }
                                    }
                                }
                            }
                            if (!(Math.random() < 0.1)) continue;
                            try {
                                Thread.sleep(1L);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (this.Debug) {
                            this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] all values added");
                        }
                    } else {
                        if (tDriverStructRecord == null) {
                            System.out.println("Cannot find structure record for value field:" + tAppCollectionsObject.ValueFieldName + " while creating collection " + string + " with filter [" + stringBuilder + "]");
                        }
                        if (tDriverStructRecord2 == null) {
                            System.out.println("Cannot find structure record for index field:" + tAppCollectionsObject.IndexFieldName + " while creating collection " + string + " with filter [" + stringBuilder + "]");
                        }
                        ((TAspectDriver)object3).DriverStruct.outputFieldsForDebugging();
                    }
                    if (!bl2) {
                        ((TAspectDriver)object3).dispose();
                    }
                }
            } else if (this.Debug) {
                this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] AspectDriver is null");
            }
            if (tAppCollectionsObject.Sort != 3) {
                tComboBoxColl.setSort(false);
            }
            if (tAppCollectionsObject.Host.trim().length() > 0) {
                String[] stringArray;
                String string5;
                if (this.Debug) {
                    this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] getting collection from host: " + tAppCollectionsObject.Host);
                }
                object3 = string;
                if (tAppCollectionsObject.RemoteID.trim().length() > 0) {
                    object3 = tAppCollectionsObject.RemoteID;
                }
                TExecScript tExecScript = new TExecScript("Aspect_Core_Http_Get", null, new TFormulaEvaluator());
                String[] stringArray2 = new String[6];
                String string6 = string5 = TMainWin.Application.parse_tokens(tAppCollectionsObject.Host);
                String string7 = "80";
                if (string5.indexOf(58) > 0 && (stringArray = charutil.getSubStringArray(string5, ':', true)) != null && stringArray.length > 1) {
                    string6 = stringArray[0];
                    string7 = stringArray[1];
                }
                stringArray2[0] = string6;
                stringArray2[1] = "/";
                stringArray2[2] = "Network=GreenLight&ID=getCollection&CollectionID=" + (String)object3;
                stringArray2[3] = string7;
                stringArray2[4] = "120000";
                stringArray2[5] = "false";
                if (tAppCollectionsObject.Secure) {
                    stringArray2[5] = "true";
                }
                tExecScript.setParameters(stringArray2);
                tExecScript.executeScript();
                if (tExecScript.getScriptResult() != null && (stringArray = charutil.getSubStringArray(string5 = (String)tExecScript.getScriptResult(), '|', true)) != null) {
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        String[] stringArray3 = charutil.getSubStringArray(stringArray[n2], '=', true);
                        if (stringArray3 == null || stringArray3.length <= 1) continue;
                        tComboBoxColl.add(stringArray3[0], stringArray3[1]);
                    }
                }
            }
            if (this.Debug) {
                this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] adding additional elements");
            }
            charutil.strcpy(stringBuilder2, tAppCollectionsObject.AdditionalElements);
            while (!charutil.nullstr(stringBuilder2)) {
                charutil.getsubstring(stringBuilder3, stringBuilder2, 0, ',', true);
                n = charutil.ival(stringBuilder3);
                object = stringBuilder3.toString();
                charutil.getsubstring(stringBuilder3, stringBuilder2, 0, ',', true);
                if (this.Debug) {
                    this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] adding " + object + "=" + stringBuilder3.toString());
                }
                if (charutil.nullstr(stringBuilder3)) continue;
                if (tAppCollectionsObject.Sort == 2 || tAppCollectionsObject.Sort == 5) {
                    tComboBoxColl.insert(n, object, stringBuilder3.toString());
                    continue;
                }
                tComboBoxColl.add(object, stringBuilder3.toString());
            }
        }
        if (this.Debug) {
            this.MainWin.appendToLog("TAppCollections", "makeCollection", Thread.currentThread(), null, 4, "TAppCollections:createCollection[" + string + "] complete");
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makePrinterCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        if (printServiceArray != null) {
            for (int i = 0; i < printServiceArray.length; ++i) {
                String string = printServiceArray[i].getName();
                tComboBoxColl.add(string, string);
            }
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeFontCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = null;
        try {
            fontArray = graphicsEnvironment.getAllFonts();
        }
        catch (Exception exception) {
            return tComboBoxColl;
        }
        for (int i = 0; i < fontArray.length; ++i) {
            String string = fontArray[i].getName();
            tComboBoxColl.add(string, string);
        }
        tComboBoxColl.insert(0, "Default", "Default");
        return tComboBoxColl;
    }

    public TComboBoxColl makeFontStyleCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 4);
        tComboBoxColl.add("0", "Plain");
        tComboBoxColl.add("1", "Bold");
        tComboBoxColl.add("2", "Italic");
        tComboBoxColl.add("3", "Bold Italic");
        return tComboBoxColl;
    }

    public TComboBoxColl makeActionTypeCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 33);
        tComboBoxColl.add("0", "-- None --");
        tComboBoxColl.add("1", "Execute another action");
        tComboBoxColl.add("2", "Execute function");
        tComboBoxColl.add("3", "Set token");
        tComboBoxColl.add("4", "System Command");
        tComboBoxColl.add("5", "Open Table Window");
        tComboBoxColl.add("11", "Window - Close");
        tComboBoxColl.add("13", "Window - Cascade");
        tComboBoxColl.add("14", "Window - Tile");
        tComboBoxColl.add("15", "Window - Close All");
        tComboBoxColl.add("16", "Reload Resources");
        tComboBoxColl.add("17", "Execute Dialog");
        tComboBoxColl.add("28", "Launch External Viewer");
        tComboBoxColl.add("29", "Play Media");
        tComboBoxColl.add("31", "Execute Driver Command");
        tComboBoxColl.add("38", "Launch External Application");
        tComboBoxColl.add("39", "Driver Command Message");
        tComboBoxColl.add("40", "Execute Script");
        tComboBoxColl.add("41", "Open Report Window");
        tComboBoxColl.add("42", "Load Desktop");
        return tComboBoxColl;
    }

    public TComboBoxColl makeResourceActionCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        tComboBoxColl.add("0", "-- None --");
        for (int i = 0; i < this.Application.AppAction.ResourceColl.size(); ++i) {
            TAppActionObject tAppActionObject = (TAppActionObject)this.Application.AppAction.ResourceColl.get(i);
            tComboBoxColl.add(tAppActionObject.UnparsedID, tAppActionObject.Description);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeResourceCollectionsCollection(boolean bl, boolean bl2) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        tComboBoxColl.add("0", "-- None --");
        for (int i = 0; i < this.Application.AppCollections.ResourceColl.size(); ++i) {
            TAppCollectionsObject tAppCollectionsObject = (TAppCollectionsObject)this.Application.AppCollections.ResourceColl.get(i);
            if (bl2) {
                tComboBoxColl.add(tAppCollectionsObject.CollectionID, tAppCollectionsObject.Description);
                continue;
            }
            tComboBoxColl.add(tAppCollectionsObject.UnparsedID, tAppCollectionsObject.Description);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeResourceDialogsCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        tComboBoxColl.add("0", "-- None --");
        for (int i = 0; i < this.Application.AppDialogs.ResourceColl.size(); ++i) {
            TAppDialogsObject tAppDialogsObject = (TAppDialogsObject)this.Application.AppDialogs.ResourceColl.get(i);
            tComboBoxColl.add(tAppDialogsObject.UnparsedID, tAppDialogsObject.Description);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeResourceTablesCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        tComboBoxColl.add("0", "-- None --");
        for (int i = 0; i < this.Application.AppTables.ResourceColl.size(); ++i) {
            TAppTablesObject tAppTablesObject = (TAppTablesObject)this.Application.AppTables.ResourceColl.get(i);
            tComboBoxColl.add(tAppTablesObject.UnparsedID, tAppTablesObject.Description);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeResourceReportsCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        tComboBoxColl.add("0", "-- None --");
        for (int i = 0; i < this.Application.AppReports.ResourceColl.size(); ++i) {
            TAppReportsObject tAppReportsObject = (TAppReportsObject)this.Application.AppReports.ResourceColl.get(i);
            tComboBoxColl.add(tAppReportsObject.ReportID, tAppReportsObject.Description);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeResourceMenusCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        tComboBoxColl.add("0", "-- None --");
        for (int i = 0; i < this.Application.AppMenu.ResourceColl.size(); ++i) {
            TAppMenuObject tAppMenuObject = (TAppMenuObject)this.Application.AppMenu.ResourceColl.get(i);
            tComboBoxColl.add(tAppMenuObject.UnparsedID, tAppMenuObject.UnparsedID);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeResourceDriversCollection(boolean bl, boolean bl2) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        tComboBoxColl.add("0", "-- None --");
        for (int i = 0; i < this.Application.AppDrivers.ResourceColl.size(); ++i) {
            TAppDriversObject tAppDriversObject = (TAppDriversObject)this.Application.AppDrivers.ResourceColl.get(i);
            if (bl2) {
                tComboBoxColl.add(tAppDriversObject.DriverID, tAppDriversObject.Description);
                continue;
            }
            tComboBoxColl.add(tAppDriversObject.UnparsedID, tAppDriversObject.Description);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeResourceFunctionsCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        for (int i = 0; i < this.Application.AppFunction.ResourceColl.size(); ++i) {
            TAppFunctionObject tAppFunctionObject = (TAppFunctionObject)this.Application.AppFunction.ResourceColl.get(i);
            tComboBoxColl.add(Integer.toString(tAppFunctionObject.FunctionID), tAppFunctionObject.FunctionName);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeResourceFunctionsUsageCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        for (int i = 0; i < this.Application.AppFunction.ResourceColl.size(); ++i) {
            TAppFunctionObject tAppFunctionObject = (TAppFunctionObject)this.Application.AppFunction.ResourceColl.get(i);
            tComboBoxColl.add(Integer.toString(tAppFunctionObject.FunctionID), tAppFunctionObject.Usage);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeResourceDriverCmdCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        tComboBoxColl.add("0", "-- None --");
        for (int i = 0; i < this.Application.AppDriverCmd.ResourceColl.size(); ++i) {
            TAppDriverCmdObject tAppDriverCmdObject = (TAppDriverCmdObject)this.Application.AppDriverCmd.ResourceColl.get(i);
            tComboBoxColl.add(tAppDriverCmdObject.ID, tAppDriverCmdObject.Description);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeResourceDriverStructCollection(boolean bl, boolean bl2) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        tComboBoxColl.add("0", "-- None --");
        for (int i = 0; i < this.Application.AppDriverStruct.ResourceColl.size(); ++i) {
            TAppDriverStructObject tAppDriverStructObject = (TAppDriverStructObject)this.Application.AppDriverStruct.ResourceColl.get(i);
            if (bl2) {
                tComboBoxColl.add(tAppDriverStructObject.StructureID, tAppDriverStructObject.StructureDescription);
                continue;
            }
            tComboBoxColl.add(tAppDriverStructObject.UnparsedID, tAppDriverStructObject.StructureDescription);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeResourceToolbarsCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        tComboBoxColl.add("0", "-- none --");
        for (int i = 0; i < this.Application.AppToolbar.ResourceColl.size(); ++i) {
            TAppToolbarObject tAppToolbarObject = (TAppToolbarObject)this.Application.AppToolbar.ResourceColl.get(i);
            if (tAppToolbarObject.UnparsedID.length() <= 0 || tAppToolbarObject.Description.length() <= 0) continue;
            tComboBoxColl.add(tAppToolbarObject.UnparsedID, tAppToolbarObject.Description);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeResourceScriptsCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        tComboBoxColl.add("0", "-- none --");
        for (int i = 0; i < this.Application.AppScripts.ResourceColl.size(); ++i) {
            TAppScriptsObject tAppScriptsObject = (TAppScriptsObject)this.Application.AppScripts.ResourceColl.get(i);
            if (tAppScriptsObject.ScriptName.length() <= 0 || tAppScriptsObject.ScriptID.length() <= 0) continue;
            tComboBoxColl.add(tAppScriptsObject.ScriptID, tAppScriptsObject.ScriptName);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeResourceTokensCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        for (TAppBaseObject tAppBaseObject : this.Application.AppMain.ResourceColl) {
            tComboBoxColl.add(tAppBaseObject.TokenID, tAppBaseObject.Value.toString());
        }
        for (TAppBaseObject tAppBaseObject : this.Application.AppToken.ResourceColl) {
            tComboBoxColl.add(((TAppTokenObject)tAppBaseObject).TokenID, ((TAppTokenObject)tAppBaseObject).Value.toString());
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeCounterCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        Enumeration enumeration = TFormulaEvaluator.getCounters().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            tComboBoxColl.add(string, string);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeDimensionalFieldsCollection(String string, boolean bl, TFormulaEvaluator tFormulaEvaluator, String string2) {
        Object object;
        System.out.println(")makeDimensionalFieldsCollection AFilter=" + string2);
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        if (string2.trim().length() == 0) {
            return tComboBoxColl;
        }
        String string3 = "";
        Object object2 = tFormulaEvaluator.getVariableValue(null, new StringBuilder(string2), true, tFormulaEvaluator.getAltRecordNumber(), 0, null);
        if (object2 != null) {
            string3 = objectutil.convertToString(object2);
        }
        System.out.println(")makeDimensionalFieldsCollection StructureID=" + string3);
        if (string3.trim().length() > 0 && this.Application.AppDriverStruct.getResourceElements(string3).size() == 0) {
            object = this.Application.AppDrivers.getAppDriversObject(string3);
            if (object != null) {
                string3 = ((TAppDriversObject)object).StructureIndex.toString();
                System.out.println(")makeDimensionalFieldsCollection getting StructureID from DriverID.  StructureID=" + string3);
            } else {
                System.out.println(")makeDimensionalFieldsCollection getting StructureID from DriverID.  AppDriversObject=null");
            }
        }
        if (string3.trim().length() > 0 && this.Application.AppDriverStruct.getResourceElements(string3).size() > 0) {
            object = new TDriverStruct(this.Application, string3);
            for (int i = 0; i < ((TDriverStruct)object).FieldColl.size(); ++i) {
                TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)((TDriverStruct)object).FieldColl.get(i);
                tComboBoxColl.add(tDriverStructRecord.FullID, tDriverStructRecord.Description);
            }
        }
        System.out.println(")makeDimensionalFieldsCollection returning collection with " + tComboBoxColl.size() + " elements");
        return tComboBoxColl;
    }

    public TComboBoxColl makeStructureFieldCollection(boolean bl, TFormulaEvaluator tFormulaEvaluator, StringBuilder stringBuilder) {
        TAppDriversObject tAppDriversObject;
        Object object;
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = "";
        if (charutil.nullstr(stringBuilder)) {
            // empty if block
        }
        if (tFormulaEvaluator != null && stringBuilder != null && stringBuilder.length() > 0 && (object = tFormulaEvaluator.getVariableValue(null, stringBuilder, true, tFormulaEvaluator.getAltRecordNumber(), 0, null)) != null) {
            string = objectutil.convertToString(object);
        }
        if (string.trim().length() > 0 && this.Application.AppDriverStruct.getResourceElements(string).size() == 0 && (tAppDriversObject = this.Application.AppDrivers.getAppDriversObject(string)) != null) {
            string = tAppDriversObject.StructureIndex.toString();
        }
        for (int i = 0; i < this.Application.AppDriverStruct.ResourceColl.size(); ++i) {
            TAppDriverStructObject tAppDriverStructObject = (TAppDriverStructObject)this.Application.AppDriverStruct.ResourceColl.get(i);
            if (hashtable.contains(tAppDriverStructObject.StructureID) || string.length() != 0 && !tAppDriverStructObject.StructureID.equalsIgnoreCase(string)) continue;
            TDriverStruct tDriverStruct = new TDriverStruct(this.Application, tAppDriverStructObject.StructureID);
            for (int j = 0; j < tDriverStruct.FieldColl.size(); ++j) {
                TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(j);
                tComboBoxColl.add(tDriverStructRecord.FullID, tDriverStructRecord.Description);
            }
            if (string.length() > 0) {
                return tComboBoxColl;
            }
            hashtable.put(tAppDriverStructObject.StructureID, tAppDriverStructObject.StructureID);
        }
        if (this.StructureFieldCollection == null) {
            this.StructureFieldCollection = tComboBoxColl;
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeStructureFieldCollection2(boolean bl, StringBuilder stringBuilder) {
        if (stringBuilder.toString().equalsIgnoreCase(this.StructureFieldCollection2ID)) {
            return this.StructureFieldCollection2;
        }
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        TDriverStruct tDriverStruct = new TDriverStruct(this.Application, stringBuilder.toString());
        System.out.println("got driverstruct size=" + tDriverStruct.FieldColl.size());
        for (int i = 0; i < tDriverStruct.FieldColl.size(); ++i) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(i);
            String string = tDriverStructRecord.Description;
            if (string.startsWith("<")) {
                string = charutil.replaceAllSubstrings(string, "<", "&lt;");
                string = charutil.replaceAllSubstrings(string, ">", "&gt;");
            }
            tComboBoxColl.add(tDriverStructRecord.FullID, string);
        }
        this.StructureFieldCollection2ID = stringBuilder.toString();
        this.StructureFieldCollection2 = tComboBoxColl;
        return tComboBoxColl;
    }

    public TComboBoxColl makeStructureFieldCollection3(boolean bl, StringBuilder stringBuilder) {
        if (stringBuilder.toString().equalsIgnoreCase(this.StructureFieldCollection3ID)) {
            return this.StructureFieldCollection3;
        }
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        TDriverStruct tDriverStruct = new TDriverStruct(this.Application, stringBuilder.toString());
        for (int i = 0; i < tDriverStruct.FieldColl.size(); ++i) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(i);
            if (tDriverStructRecord.IsCalculated || tDriverStructRecord.IsVirtual) continue;
            String string = tDriverStructRecord.Description;
            if (string.startsWith("<")) {
                string = charutil.replaceAllSubstrings(string, "<", "&lt;");
                string = charutil.replaceAllSubstrings(string, ">", "&gt;");
            }
            tComboBoxColl.add(tDriverStructRecord.FullID, string);
        }
        this.StructureFieldCollection3ID = stringBuilder.toString();
        this.StructureFieldCollection3 = tComboBoxColl;
        return tComboBoxColl;
    }

    public TComboBoxColl makeStructureFieldCollection4(boolean bl, StringBuilder stringBuilder) {
        if (stringBuilder.toString().equalsIgnoreCase(this.StructureFieldCollection4ID)) {
            return this.StructureFieldCollection4;
        }
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        TDriverStruct tDriverStruct = new TDriverStruct(this.Application, stringBuilder.toString());
        for (int i = 0; i < tDriverStruct.FieldColl.size(); ++i) {
            TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(i);
            if (!tDriverStructRecord.IsLookup) continue;
            String string = tDriverStructRecord.Description;
            if (string.startsWith("<")) {
                string = charutil.replaceAllSubstrings(string, "<", "&lt;");
                string = charutil.replaceAllSubstrings(string, ">", "&gt;");
            }
            tComboBoxColl.add(tDriverStructRecord.FullID, string);
        }
        this.StructureFieldCollection4ID = stringBuilder.toString();
        this.StructureFieldCollection4 = tComboBoxColl;
        return tComboBoxColl;
    }

    public TComboBoxColl makeStructureFieldCollection5(boolean bl, TFormulaEvaluator tFormulaEvaluator, StringBuilder stringBuilder) {
        Object object;
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = "";
        if (charutil.nullstr(stringBuilder)) {
            // empty if block
        }
        if (tFormulaEvaluator != null && stringBuilder != null && stringBuilder.length() > 0 && (object = tFormulaEvaluator.getVariableValue(null, stringBuilder, true, tFormulaEvaluator.getAltRecordNumber(), 0, null)) != null) {
            string = (String)object;
        }
        for (int i = 0; i < this.Application.AppDriverStruct.ResourceColl.size(); ++i) {
            TAppDriverStructObject tAppDriverStructObject = (TAppDriverStructObject)this.Application.AppDriverStruct.ResourceColl.get(i);
            if (hashtable.contains(tAppDriverStructObject.StructureID) || string.length() != 0 && !tAppDriverStructObject.StructureID.equalsIgnoreCase(string)) continue;
            TDriverStruct tDriverStruct = new TDriverStruct(this.Application, tAppDriverStructObject.StructureID);
            for (int j = 0; j < tDriverStruct.FieldColl.size(); ++j) {
                TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(j);
                if (!tDriverStructRecord.Visible) continue;
                tComboBoxColl.add(tDriverStructRecord.FullID, tDriverStructRecord.Description, tDriverStructRecord.Tooltip);
            }
            if (string.length() > 0) {
                return tComboBoxColl;
            }
            hashtable.put(tAppDriverStructObject.StructureID, tAppDriverStructObject.StructureID);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeResourceDriversLookupStructure(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        for (int i = 0; i < this.Application.AppDrivers.ResourceColl.size(); ++i) {
            TAppDriversObject tAppDriversObject = (TAppDriversObject)this.Application.AppDrivers.ResourceColl.get(i);
            tComboBoxColl.add(tAppDriversObject.UnparsedID, tAppDriversObject.UnparsedStructId);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeSerialPortCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            tComboBoxColl.add(commPortIdentifier.getName(), commPortIdentifier.getName());
        }
        return tComboBoxColl;
    }

    public void addToSearchHistory(String string) {
        for (int i = 0; i < this.arSearchHistory.size(); ++i) {
            if (!((String)this.arSearchHistory.get(i)).equalsIgnoreCase(string)) continue;
            return;
        }
        this.arSearchHistory.add(string);
    }

    public TComboBoxColl makeSearchHistoryCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        for (int i = 0; i < this.arSearchHistory.size(); ++i) {
            String string = (String)this.arSearchHistory.get(i);
            tComboBoxColl.add(string, string);
        }
        return tComboBoxColl;
    }

    public TComboBoxColl makeReplaceHistoryCollection(boolean bl) {
        TComboBoxColl tComboBoxColl = new TComboBoxColl(bl, 100);
        for (int i = 0; i < this.arReplaceHistory.size(); ++i) {
            String string = (String)this.arReplaceHistory.get(i);
            tComboBoxColl.add(string, string);
        }
        return tComboBoxColl;
    }

    public boolean isResourceDefined(String string) {
        for (int i = 0; i < this.ResourceColl.size(); ++i) {
            TAppCollectionsObject tAppCollectionsObject = (TAppCollectionsObject)this.ResourceColl.get(i);
            if (!tAppCollectionsObject.CollectionID.toString().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

