/*
 * Decompiled with CFR 0.152.
 */
package resources;

import resources.TActionObject;
import resources.TAppBaseObject;
import resources.TApplication;
import utility.charutil;

public class TAppActionObject
extends TAppBaseObject {
    public String ActionID = "";
    public String UnparsedID = "";
    public String Description = "";
    public String Accelerator = "";
    public int ActionType;
    public String DriverID = "";
    public String Params = "";
    public String ImageName = "";
    public String ToolTip = "";
    public String DisabledIconName = "";
    public String Notes = "";
    public String DriverCmd = "";
    public String ScriptID = "";
    public int HorzLabelPosition = 0;
    public int VertLabelPosition = 0;
    public int HorzIconPosition = 0;
    public int VertIconPosition = 0;
    public TActionObject ActionObject = null;
    public String ReportID = "";

    public TAppActionObject(String string, TApplication tApplication, int n, int n2, long l, long l2, StringBuilder stringBuilder, String[] stringArray) {
        super(string, n, n2, l, l2);
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        this.Description = stringArray[0];
        this.UnparsedID = stringArray[1];
        this.ActionID = tApplication.parse_tokens(stringArray[1]);
        stringBuilder2.setLength(0);
        stringBuilder2.append(stringArray[2].toLowerCase());
        if (stringBuilder2.length() == 0 || stringBuilder2.toString().equals("0")) {
            this.Accelerator = "";
        } else {
            int n3 = stringBuilder2.lastIndexOf(" ");
            if (n3 > 0) {
                for (int i = n3; i < stringBuilder2.length(); ++i) {
                    stringBuilder3.append(stringBuilder2.charAt(i));
                }
                stringBuilder2.setLength(n3);
                stringBuilder2.append(stringBuilder3.toString().toUpperCase());
                this.Accelerator = stringBuilder2.toString();
            } else {
                this.Accelerator = stringBuilder2.toString().toUpperCase();
            }
        }
        this.ActionType = charutil.ival(stringArray[3]);
        this.DriverID = tApplication.parse_tokens(stringArray[4]);
        if (this.DriverID.equals("0")) {
            this.DriverID = "";
        }
        this.Params = stringArray[5];
        if (this.Params.equals("0")) {
            this.Params = "";
        }
        this.ImageName = tApplication.parse_tokens(stringArray[6]);
        if (this.ImageName.equals("0")) {
            this.ImageName = "";
        }
        this.ToolTip = tApplication.parse_tokens(stringArray[7]);
        if (this.ToolTip.trim().length() == 0 || this.ToolTip.equals("0")) {
            this.ToolTip = this.Description;
        }
        this.DisabledIconName = tApplication.parse_tokens(stringArray[8]);
        if (this.DisabledIconName.equals("0")) {
            this.DisabledIconName = "";
        }
        this.Notes = stringArray[9];
        this.DriverCmd = stringArray[10];
        this.ScriptID = stringArray[11];
        this.HorzLabelPosition = charutil.ival(stringArray[12]);
        this.VertLabelPosition = charutil.ival(stringArray[13]);
        this.HorzIconPosition = charutil.ival(stringArray[14]);
        this.VertIconPosition = charutil.ival(stringArray[15]);
        this.ReportID = stringArray[16];
        this.ActionObject = this.makeActionObject(tApplication);
    }

    public int compareTo(Object object) {
        return this.ActionID.compareToIgnoreCase(((TAppActionObject)object).ActionID);
    }

    public TActionObject makeActionObject(TApplication tApplication) {
        TActionObject tActionObject = null;
        Object var3_3 = null;
        StringBuilder stringBuilder = new StringBuilder();
        tActionObject = new TActionObject(tApplication.MainWin);
        tActionObject.putValue("Name", this.Description);
        tActionObject.putValue("ShortDescription", charutil.wrapAsHtml(this.ToolTip));
        tActionObject.putValue("LongDescription", charutil.wrapAsHtml(this.ToolTip));
        if (!charutil.nullstr(this.Accelerator)) {
            tActionObject.putValue("ActionAccelerator", this.Accelerator);
        }
        tActionObject.putValue("ActionID", this.ActionID.toString());
        tActionObject.putValue("ActionType", new Integer(this.ActionType));
        tActionObject.putValue("ActionDriverID", this.DriverID);
        tActionObject.putValue("ActionDriverCmd", this.DriverCmd);
        tActionObject.putValue("ActionParameters", this.Params.toString());
        tActionObject.putValue("ActionScriptID", this.ScriptID);
        tActionObject.putValue("HorzLabelPosition", new Integer(this.HorzLabelPosition));
        tActionObject.putValue("VertLabelPosition", new Integer(this.VertLabelPosition));
        tActionObject.putValue("HorzIconPosition", new Integer(this.HorzIconPosition));
        tActionObject.putValue("VertIconPosition", new Integer(this.VertIconPosition));
        tActionObject.putValue("ActionReportID", this.ReportID);
        tActionObject.setIcon(this.ImageName, this.DisabledIconName);
        return tActionObject;
    }
}

