/*
 * Decompiled with CFR 0.152.
 */
package networking.driverserver;

import aspect.Aspect;
import aspect.TMainWin;
import collections.TComboBoxColl;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverListenerEvent;
import drivers.aspect.TDriverListenerInterface;
import drivers.aspect.TDriverStructRecord;
import java.net.Socket;
import java.util.ArrayList;
import resources.TAppDialogsObject;
import resources.TAppDisplaysObject;
import resources.TAppDriversObject;
import resources.TAppTablesObject;
import resources.TApplication;
import utility.charutil;
import utility.objectutil;
import utility.sockets.TSSLSocketWrapper;

public class TDriverServerSocket
extends Thread
implements TDriverListenerInterface {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTDriverServerSocket");
    TSSLSocketWrapper socket = null;
    TApplication Application = null;
    TAspectDriver AspectDriver = null;
    TAppDriversObject AppDriversObj = null;
    TAppDriversObject ParsedAppDriversObj = null;
    ArrayList arFieldID = new ArrayList();
    int ErrorNo = 0;
    boolean CloseSocket = false;
    boolean IsValid = true;
    String DriverParams = "";
    String RemoteDriverParams = "";

    public TDriverServerSocket(TApplication tApplication, Socket socket, String string) {
        super("TDriverServerSocket");
        this.Application = tApplication;
        this.DriverParams = string;
        this.socket = new TSSLSocketWrapper(this.Application, socket);
    }

    @Override
    public void run() {
        Object var2_1 = null;
        StringBuilder stringBuilder = new StringBuilder();
        Object var4_3 = null;
        int n = 0;
        do {
            n = this.socket.readCommand();
            switch (n) {
                case 1: {
                    this.ErrorNo = this.handshakeGetDriverID();
                    break;
                }
                case 2: {
                    this.ErrorNo = this.handshakeParseFilename();
                    break;
                }
                case 4: {
                    this.ErrorNo = this.handshakeSendRecordCount();
                    break;
                }
                case 5: {
                    this.ErrorNo = this.handshakeSendDriverStruct();
                    break;
                }
                case 6: {
                    this.ErrorNo = this.handshakeCoordinateFieldList();
                    break;
                }
                case 14: {
                    this.ErrorNo = this.handshakeSendDialogResource();
                    break;
                }
                case 15: {
                    this.ErrorNo = this.handshakeSendTableResource();
                    break;
                }
                case 16: {
                    this.ErrorNo = this.handshakeSendDisplaysResource();
                    break;
                }
                case 7: {
                    this.ErrorNo = this.handshakeComplete();
                    break;
                }
                default: {
                    this.ErrorNo = 8;
                }
            }
        } while (this.ErrorNo == 0 && n != 7);
        if (this.ErrorNo == 0) {
            this.manageRequests();
        } else {
            MainWin.appendToLog("TSocketDriver", "makeEditableFile", Thread.currentThread(), null, 9, "Socket Server Handshake failed Error: " + this.ErrorNo);
        }
        if (this.AspectDriver != null) {
            this.AspectDriver.dispose();
        }
        if (this.Debug) {
            MainWin.appendToLog("TDriverServerSocket", "run", Thread.currentThread(), null, 3, "Closing driver server socket");
        }
        this.arFieldID.clear();
        this.socket.dispose();
    }

    private int handshakeGetDriverID() {
        if (this.Debug) {
            MainWin.appendToLog("TDriverServerSocket", "handshakeGetDriverID", Thread.currentThread(), null, 3, "Server: Get Driver ID");
        }
        String string = this.socket.readString();
        this.AppDriversObj = this.Application.AppDrivers.getAppDriversObject(string);
        if (this.AppDriversObj != null) {
            this.socket.writeCommand(1, false);
            this.socket.writeString(this.AppDriversObj.toString(), true);
        } else {
            MainWin.appendToLog("TDriverServerSocket", "handshakeGetDriverID", Thread.currentThread(), null, 4, "Server: Client requested a driver that does not exist on the server: " + string);
            this.socket.writeCommand(9, true);
            this.IsValid = false;
        }
        return 0;
    }

    private int handshakeParseFilename() {
        if (this.Debug) {
            MainWin.appendToLog("TDriverServerSocket", "handshakeParseFilename", Thread.currentThread(), null, 3, "Server: Parsing filename");
        }
        this.socket.writeCommand(2, true);
        this.socket.writeString(this.AppDriversObj.FileName.toString(), true);
        this.ParsedAppDriversObj = new TAppDriversObject(this.AppDriversObj);
        this.ParsedAppDriversObj.FileName = new StringBuilder(this.socket.readString());
        this.Application.parse_tokens(this.ParsedAppDriversObj.FileName, this.ParsedAppDriversObj.FileName);
        this.RemoteDriverParams = this.socket.readString();
        if (this.RemoteDriverParams.length() > 0 && this.DriverParams.length() > 0 && !this.RemoteDriverParams.startsWith("|")) {
            this.RemoteDriverParams = "|" + this.RemoteDriverParams;
        }
        this.AspectDriver = new TAspectDriver(this.Application, this.ParsedAppDriversObj, 1, false, this.DriverParams + this.RemoteDriverParams);
        this.AspectDriver.F.addDriverListener(this);
        this.socket.writeCommand(2, true);
        return 0;
    }

    private int handshakeSendRecordCount() {
        if (this.Debug) {
            MainWin.appendToLog("TDriverServerSocket", "handshakeSendRecordCount", Thread.currentThread(), null, 3, "Server: Sending record count");
        }
        this.socket.writeCommand(4, true);
        this.socket.writeInt(this.AspectDriver.getAbsoluteRecordCount(), true);
        return 0;
    }

    private int handshakeSendDriverStruct() {
        this.socket.writeCommand(5, true);
        int n = this.AspectDriver.DriverStruct.FieldColl.size();
        if (this.Debug) {
            MainWin.appendToLog("TDriverServerSocket", "handshakeSendDriverStruct", Thread.currentThread(), null, 3, "Server: Sending driver structure (" + n + " records)");
        }
        this.socket.writeInt(n, false);
        for (int i = 0; i < n; ++i) {
            this.socket.writeString(((TDriverStructRecord)this.AspectDriver.DriverStruct.FieldColl.get(i)).toString(), false);
        }
        this.socket.flush();
        return 0;
    }

    private int handshakeCoordinateFieldList() {
        int n;
        if (this.Debug) {
            MainWin.appendToLog("TDriverServerSocket", "handshakeCoordinateFieldList", Thread.currentThread(), null, 3, "Server: Coordinating driver structure");
        }
        this.socket.writeCommand(6, true);
        int n2 = this.socket.readInt();
        for (n = 0; n < n2; ++n) {
            String string = this.socket.readString();
            TDriverStructRecord tDriverStructRecord = this.AspectDriver.DriverStruct.getField(string);
            if (tDriverStructRecord == null) continue;
            this.arFieldID.add(string);
        }
        this.socket.writeCommand(6, false);
        this.socket.writeInt(this.arFieldID.size(), false);
        for (n = 0; n < this.arFieldID.size(); ++n) {
            this.socket.writeString((String)this.arFieldID.get(n), false);
        }
        this.socket.flush();
        return 0;
    }

    private int handshakeSendDialogResource() {
        if (this.Debug) {
            MainWin.appendToLog("TDriverServerSocket", "handshakeSendDialogResource", Thread.currentThread(), null, 3, "Server: Sending dialog resource");
        }
        this.socket.writeCommand(14, true);
        ArrayList arrayList = TMainWin.Application.AppDialogs.getResourceElements(this.AspectDriver.AppDriverObj.DialogIDStart.toString());
        this.socket.writeInt(arrayList.size(), false);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.socket.writeString(((TAppDialogsObject)arrayList.get(i)).toString(), false);
        }
        this.socket.flush();
        return 0;
    }

    private int handshakeSendTableResource() {
        if (this.Debug) {
            MainWin.appendToLog("TDriverServerSocket", "handshakeSendTableResource", Thread.currentThread(), null, 3, "Server: Sending table resource");
        }
        this.socket.writeCommand(15, true);
        ArrayList arrayList = TMainWin.Application.AppTables.getResourceElements(this.AspectDriver.AppDriverObj.TableID.toString());
        this.socket.writeString(((TAppTablesObject)arrayList.get(0)).toString(), false);
        this.socket.flush();
        return 0;
    }

    private int handshakeSendDisplaysResource() {
        if (this.Debug) {
            MainWin.appendToLog("TDriverServerSocket", "handshakeSendDisplaysResource", Thread.currentThread(), null, 3, "Server: Sending displays resource");
        }
        this.socket.writeCommand(16, true);
        ArrayList arrayList = this.Application.AppDisplays.getDisplayNames(this.AspectDriver.AppDriverObj.DriverID.toString());
        this.socket.writeInt(arrayList.size(), false);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            this.socket.writeString(string, false);
            ArrayList arrayList2 = this.Application.AppDisplays.getDisplayRecords(stringBuilder, string, this.AspectDriver.AppDriverObj.DriverID.toString(), false);
            this.socket.writeInt(arrayList2.size(), false);
            for (int j = 0; j < arrayList2.size(); ++j) {
                this.socket.writeString(((TAppDisplaysObject)arrayList2.get(j)).toString(), false);
            }
        }
        this.socket.flush();
        return 0;
    }

    private int handshakeComplete() {
        if (this.Debug) {
            MainWin.appendToLog("TDriverServerSocket", "handshakeCoordinateFieldList", Thread.currentThread(), null, 3, "Server: Handshake complete.");
        }
        this.socket.writeCommand(7, true);
        if (this.Debug) {
            MainWin.appendToLog("TSocketDriver", "handshakeComplete", Thread.currentThread(), null, 3, "Bytes Sent: " + this.socket.getBytesWritten() + " Bytes Read: " + this.socket.getBytesRead() + " Flush: " + this.socket.getFlushCount());
        }
        return 0;
    }

    public void manageRequests() {
        if (this.Debug) {
            System.out.println("TServerSocketDriver.manageRequests()");
        }
        block6: while (this.socket.isConnected() && !this.CloseSocket) {
            if (!this.socket.available()) continue;
            switch (this.socket.readCommand()) {
                case 12: {
                    int n = this.socket.readInt();
                    int n2 = this.socket.readInt();
                    int n3 = this.socket.readInt();
                    this.sendData(n, n2, n3);
                    break;
                }
                case 9: {
                    int n = this.socket.readInt();
                    for (int i = 0; i < n; ++i) {
                        TDriverStructRecord tDriverStructRecord;
                        int n4 = this.socket.readInt();
                        int n5 = this.socket.readInt();
                        Object object = this.socket.readData();
                        for (int j = this.AspectDriver.getRecordCount(); j < n4 + 1; ++j) {
                            if (this.Debug) {
                                MainWin.appendToLog("TDriverServerSocket", "manageRequests", Thread.currentThread(), null, 3, "Server: Adding new record at index " + j);
                            }
                            for (i = 0; i < this.AspectDriver.DriverStruct.FieldColl.size(); ++i) {
                                tDriverStructRecord = (TDriverStructRecord)this.AspectDriver.DriverStruct.FieldColl.get(i);
                                if (tDriverStructRecord.IsVirtual) continue;
                                Object object2 = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, "", j);
                                this.AspectDriver.putField(tDriverStructRecord, j, object2);
                            }
                        }
                        if (n5 >= this.arFieldID.size()) continue;
                        tDriverStructRecord = this.AspectDriver.DriverStruct.getField((String)this.arFieldID.get(n5));
                        this.AspectDriver.putField(tDriverStructRecord, n4, object);
                    }
                    continue block6;
                }
                case 13: {
                    this.sendCollection();
                    break;
                }
                case 8: {
                    this.CloseSocket = true;
                }
            }
        }
        if (this.Debug) {
            if (this.CloseSocket) {
                MainWin.appendToLog("TDriverServerSocket", "manageRequests", Thread.currentThread(), null, 3, "Driver server terminated at request of client");
            } else {
                MainWin.appendToLog("TDriverServerSocket", "manageRequests", Thread.currentThread(), null, 3, "Driver server terminated unexpectedly");
            }
        }
    }

    public void sendData(int n, int n2, int n3) {
        int n4 = this.arFieldID.size();
        int n5 = n3;
        int n6 = this.AspectDriver.getRecordCount();
        int n7 = n6 - n;
        if (n5 > n7) {
            n5 = n7;
        }
        TDriverStructRecord tDriverStructRecord = this.AspectDriver.DriverStruct.getField((String)this.arFieldID.get(n2));
        if (n5 > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n5; ++i) {
                stringBuilder.append("\"");
                String string = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, this.AspectDriver.F.getField(tDriverStructRecord, n + i));
                stringBuilder.append(charutil.replaceAllSubstrings(string, "\"", "%22"));
                stringBuilder.append("\"");
                if (i >= n5 - 1) continue;
                stringBuilder.append(",");
            }
            this.socket.writeCommand(9, false);
            this.socket.writeInt(n, false);
            this.socket.writeInt(n2, false);
            this.socket.writeString(stringBuilder.toString(), true);
            if (this.Debug) {
                MainWin.appendToLog("TDriverServerSocket", "sendCollection", Thread.currentThread(), null, 3, "Server: Ttl Bytes Recv:" + this.socket.getBytesRead() + " Sent:" + this.socket.getBytesWritten() + " Flushes:" + this.socket.getFlushCount() + " Send Data: (" + n5 + " records) for field " + tDriverStructRecord.FullID);
            }
        }
    }

    public int sendCollection() {
        String string = this.socket.readString();
        String string2 = this.socket.readString();
        String string3 = this.socket.readString();
        String string4 = this.socket.readString();
        int n = this.socket.readInt();
        this.socket.writeCommand(13, false);
        this.socket.writeString(string2, false);
        TComboBoxColl tComboBoxColl = null;
        tComboBoxColl = string.length() == 0 ? this.AspectDriver.getComboBoxColl(string2, "", null, false, n) : this.AspectDriver.getComboBoxColl(string, new StringBuilder(string3), null, false, false, n);
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = tComboBoxColl.size();
        for (int i = 0; i < n2; ++i) {
            String string5 = tComboBoxColl.getKeyOfIndex(i);
            String string6 = tComboBoxColl.getValueOfIndex(i);
            if (string5.indexOf("\"") >= 0) {
                string5 = charutil.replaceAllSubstrings(string5, "\"", "%22");
            }
            if (string6.indexOf("\"") >= 0) {
                string6 = charutil.replaceAllSubstrings(string5, "\"", "%22");
            }
            stringBuilder.append("\"\"" + string5 + "\",");
            stringBuilder.append("\"" + string6 + "\"\"");
            if (i >= n2 - 1) continue;
            stringBuilder.append("|");
        }
        this.socket.writeString(stringBuilder.toString(), true);
        if (this.Debug) {
            MainWin.appendToLog("TDriverServerSocket", "sendCollection", Thread.currentThread(), null, 3, "Server: Ttl Bytes Recv:" + this.socket.getBytesRead() + " Sent:" + this.socket.getBytesWritten() + " Flushes:" + this.socket.getFlushCount() + " Send Collection: " + string2 + " (" + tComboBoxColl.size() + " elements)");
        }
        return 0;
    }

    @Override
    public void dataChanged(TDriverListenerEvent tDriverListenerEvent) {
    }
}

