/*
 * Decompiled with CFR 0.152.
 */
package networking.dnsserver;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import networking.dnsserver.TDnsPacketContent;
import utility.charutil;

public class TDnsPacket {
    private byte[] arBuffer = new byte[512];
    private int PacketLength = 12;
    private InetAddress PacketAddress = null;
    private int PacketPort = -1;
    private static boolean Debug = false;

    public TDnsPacket(DatagramPacket datagramPacket) {
        this.PacketAddress = datagramPacket.getAddress();
        this.PacketPort = datagramPacket.getPort();
        this.PacketLength = datagramPacket.getLength();
        byte[] byArray = datagramPacket.getData();
        for (int i = 0; i < this.PacketLength && i < this.arBuffer.length; ++i) {
            this.arBuffer[i] = byArray[i];
        }
    }

    public DatagramPacket getDatagramPacket(SocketAddress socketAddress) {
        DatagramPacket datagramPacket = null;
        try {
            datagramPacket = new DatagramPacket(this.arBuffer, 0, this.PacketLength, socketAddress);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.toString());
        }
        return datagramPacket;
    }

    public static int ival(String string) {
        try {
            return (int)Double.parseDouble(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getID() {
        return charutil.unsignedByteToInt(this.arBuffer[0]) * 256 + charutil.unsignedByteToInt(this.arBuffer[1]);
    }

    public void setMessageType(int n) {
        this.arBuffer[2] = n == 0 ? (byte)(this.arBuffer[2] & 0x7F) : (byte)(this.arBuffer[2] | 0x80);
    }

    public int getMessageType() {
        if ((this.arBuffer[2] & 0x80) > 0) {
            return 1;
        }
        return 0;
    }

    public byte getOpCode() {
        byte by = (byte)(this.arBuffer[2] & 0x78);
        return (byte)(by >>> 3);
    }

    public boolean isAuthority() {
        return (this.arBuffer[2] & 4) > 0;
    }

    public void setTruncation(boolean bl) {
        this.arBuffer[2] = bl ? (byte)(this.arBuffer[2] | 2) : (byte)(this.arBuffer[2] & 0xFFFFFFFD);
    }

    public boolean isTruncated() {
        return (this.arBuffer[2] & 2) > 0;
    }

    public boolean isRecursionDesired() {
        return (this.arBuffer[2] & 1) > 0;
    }

    public void setRecursionWasAvailable(boolean bl) {
        this.arBuffer[3] = bl ? (byte)(this.arBuffer[3] | 0x80) : (byte)(this.arBuffer[3] & 0xFFFFFF7F);
    }

    public boolean getRecursionWasAvailable() {
        return (this.arBuffer[3] & 0x80) > 0;
    }

    public int getResponseCode() {
        return this.arBuffer[3] & 0xF;
    }

    public void setQueryCount(int n) {
        this.arBuffer[4] = (byte)(n / 256);
        this.arBuffer[5] = (byte)(n % 256);
    }

    public int getQueryCount() {
        return this.arBuffer[4] * 256 + this.arBuffer[5];
    }

    public int getSectionCount(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = this.getQueryCount();
                break;
            }
            case 1: {
                n2 = this.getAnswerCount();
                break;
            }
            case 2: {
                n2 = this.getNameServerCount();
                break;
            }
            case 3: {
                n2 = this.getAdditionalEntriesCount();
            }
        }
        return n2;
    }

    public void setAnswerCount(int n) {
        this.arBuffer[6] = (byte)(n / 256);
        this.arBuffer[7] = (byte)(n % 256);
    }

    public int getAnswerCount() {
        return this.arBuffer[6] * 256 + this.arBuffer[7];
    }

    public void setNameServerCount(int n) {
        this.arBuffer[8] = (byte)(n / 256);
        this.arBuffer[9] = (byte)(n % 256);
    }

    public int getNameServerCount() {
        return this.arBuffer[8] * 256 + this.arBuffer[9];
    }

    public void setAdditionalEntriesCount(int n) {
        this.arBuffer[10] = (byte)(n / 256);
        this.arBuffer[11] = (byte)(n % 256);
    }

    public int getAdditionalEntriesCount() {
        return this.arBuffer[10] * 256 + this.arBuffer[11];
    }

    public TDnsLabel getLabel(int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n;
        stringBuilder.setLength(0);
        do {
            if ((n2 = charutil.unsignedByteToInt(this.arBuffer[n3])) <= 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            if (n2 > 63) {
                int n4 = 256 * (charutil.unsignedByteToInt(this.arBuffer[n3]) & 0x3F);
                TDnsLabel tDnsLabel = this.getLabel(n4 += charutil.unsignedByteToInt(this.arBuffer[n3 + 1]));
                stringBuilder.append(tDnsLabel.LabelStr);
                return new TDnsLabel(stringBuilder.toString(), n3 + 1);
            }
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append((char)this.arBuffer[++n3]);
            }
            ++n3;
        } while (n2 > 0 && n3 < this.PacketLength);
        return new TDnsLabel(stringBuilder.toString(), n3);
    }

    public ArrayList getContents() {
        int n;
        ArrayList<TDnsPacketContent> arrayList = new ArrayList<TDnsPacketContent>();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 12;
        if (Debug) {
            System.out.println("\n======================================================");
            for (n = 1; n <= this.PacketLength; ++n) {
                System.out.print(charutil.unsignedByteToInt(this.arBuffer[n - 1]));
                if (n % 16 == 0) {
                    System.out.println();
                    continue;
                }
                System.out.print(',');
            }
            System.out.println("\n======================================================");
        }
        for (int i = 0; i < 3; ++i) {
            int n3 = this.getSectionCount(i);
            for (n = 0; n < n3; ++n) {
                TDnsPacketContent tDnsPacketContent = new TDnsPacketContent();
                tDnsPacketContent.setContentSection(i);
                TDnsLabel tDnsLabel = this.getLabel(n2);
                n2 = tDnsLabel.EndOffset + 1;
                tDnsPacketContent.setContentName(tDnsLabel.LabelStr);
                int n4 = charutil.unsignedByteToInt(this.arBuffer[n2]) * 256 + charutil.unsignedByteToInt(this.arBuffer[n2 + 1]);
                tDnsPacketContent.setContentType(n4);
                n4 = charutil.unsignedByteToInt(this.arBuffer[n2 += 2]) * 256 + charutil.unsignedByteToInt(this.arBuffer[n2 + 1]);
                n2 += 2;
                tDnsPacketContent.setContentClass(n4);
                if (i > 0) {
                    long l = charutil.unsignedByteToInt(this.arBuffer[n2]) * 0x1000000 + charutil.unsignedByteToInt(this.arBuffer[n2 + 1]) * 65536 + charutil.unsignedByteToInt(this.arBuffer[n2 + 2]) * 256 + charutil.unsignedByteToInt(this.arBuffer[n2 + 3]);
                    tDnsPacketContent.setContentTtl(l);
                    int n5 = charutil.unsignedByteToInt(this.arBuffer[n2 += 4]) * 256 + charutil.unsignedByteToInt(this.arBuffer[n2 + 1]);
                    n2 += 2;
                    stringBuilder.setLength(0);
                    if (tDnsPacketContent.getContentType() == 1) {
                        for (int j = 0; j < n5; ++j) {
                            n4 = charutil.unsignedByteToInt(this.arBuffer[n2]);
                            stringBuilder.append(Integer.toString(n4));
                            ++n2;
                            if (j >= n5 - 1) continue;
                            stringBuilder.append('.');
                        }
                        tDnsPacketContent.setContentData(stringBuilder.toString());
                    } else {
                        tDnsLabel = this.getLabel(n2);
                        n2 = tDnsLabel.EndOffset + 1;
                        tDnsPacketContent.setContentData(tDnsLabel.LabelStr);
                    }
                }
                arrayList.add(tDnsPacketContent);
            }
        }
        return arrayList;
    }

    public void clearContents() {
        this.PacketLength = 12;
        this.setQueryCount(0);
        this.setAnswerCount(0);
        this.setNameServerCount(0);
        this.setAdditionalEntriesCount(0);
    }

    public void setResponseFields() {
        this.setMessageType(1);
        this.setTruncation(false);
        this.setRecursionWasAvailable(true);
    }

    public void addContent(TDnsPacketContent tDnsPacketContent) {
        String[] stringArray;
        int n = tDnsPacketContent.getContentSection();
        switch (n) {
            case 0: {
                this.setQueryCount(this.getQueryCount() + 1);
                break;
            }
            case 1: {
                this.setAnswerCount(this.getAnswerCount() + 1);
                break;
            }
            case 2: {
                this.setNameServerCount(this.getNameServerCount() + 1);
                break;
            }
            case 3: {
                this.setAdditionalEntriesCount(this.getAdditionalEntriesCount() + 1);
            }
        }
        if (n == 0) {
            stringArray = charutil.getSubStringArray(tDnsPacketContent.getContentName(), '.', false);
            for (int i = 0; i < stringArray.length; ++i) {
                this.arBuffer[this.PacketLength++] = (byte)stringArray[i].length();
                for (int j = 0; j < stringArray[i].length(); ++j) {
                    this.arBuffer[this.PacketLength++] = (byte)stringArray[i].charAt(j);
                }
            }
            this.arBuffer[this.PacketLength++] = 0;
        } else {
            this.arBuffer[this.PacketLength++] = 64;
            this.arBuffer[this.PacketLength++] = 12;
        }
        this.arBuffer[this.PacketLength++] = (byte)(tDnsPacketContent.getContentType() / 256);
        this.arBuffer[this.PacketLength++] = (byte)(tDnsPacketContent.getContentType() % 256);
        this.arBuffer[this.PacketLength++] = (byte)(tDnsPacketContent.getContentClass() / 256);
        this.arBuffer[this.PacketLength++] = (byte)(tDnsPacketContent.getContentClass() % 256);
        if (n != 0) {
            long l = tDnsPacketContent.getContentTtl();
            long l2 = l / 0xFFFFFFL;
            long l3 = (l - l2 * 0xFFFFFFL) / 65535L;
            long l4 = (l - l2 * 0xFFFFFFL - l3 * 65535L) / 255L;
            long l5 = l - l2 * 0xFFFFFFL - l3 * 65535L - l4 * 255L;
            this.arBuffer[this.PacketLength++] = (byte)l2;
            this.arBuffer[this.PacketLength++] = (byte)l3;
            this.arBuffer[this.PacketLength++] = (byte)l4;
            this.arBuffer[this.PacketLength++] = (byte)l5;
            if (tDnsPacketContent.getContentType() == 1) {
                this.arBuffer[this.PacketLength++] = 0;
                this.arBuffer[this.PacketLength++] = 4;
                stringArray = charutil.getSubStringArray(tDnsPacketContent.getContentData(), '.', false);
                for (int i = 0; i < 4; ++i) {
                    this.arBuffer[this.PacketLength++] = (byte)TDnsPacket.ival(stringArray[i]);
                }
            } else {
                this.arBuffer[this.PacketLength++] = 0;
                this.arBuffer[this.PacketLength++] = (byte)(tDnsPacketContent.getContentData().length() + 1);
                stringArray = charutil.getSubStringArray(tDnsPacketContent.getContentData(), '.', false);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.arBuffer[this.PacketLength++] = (byte)stringArray[i].length();
                    for (int j = 0; j < stringArray[i].length(); ++j) {
                        this.arBuffer[this.PacketLength++] = (byte)stringArray[i].charAt(j);
                    }
                }
                this.arBuffer[this.PacketLength++] = 0;
            }
        }
    }

    public void outputPacketForDebugging() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.setLength(0);
        stringBuilder.append(Integer.toString(this.getMessageType()));
        if (this.getMessageType() == 0) {
            stringBuilder.append(" (Query)");
        } else {
            stringBuilder.append(" (Response)");
        }
        System.out.println("MessageType         = " + stringBuilder);
        System.out.println("ID                  = " + this.getID());
        System.out.println("OpCode              = " + this.getOpCode());
        System.out.println("IsAuthority         = " + this.isAuthority());
        System.out.println("IsTruncated         = " + this.isTruncated());
        System.out.println("IsRecursionDesired  = " + this.isRecursionDesired());
        System.out.println("RecursionWasAvail   = " + this.getRecursionWasAvailable());
        System.out.println("ResponseCode        = " + this.getResponseCode());
        System.out.println("QueryCount          = " + this.getQueryCount());
        System.out.println("AnswerCount         = " + this.getAnswerCount());
        System.out.println("NameServerCount     = " + this.getNameServerCount());
        System.out.println("AddlEntriesCount    = " + this.getAdditionalEntriesCount());
        ArrayList arrayList = this.getContents();
        System.out.println("\n\tContents:");
        System.out.println("\t--------");
        if (arrayList.size() == 0) {
            System.out.println("\tContents are empty");
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                TDnsPacketContent tDnsPacketContent = (TDnsPacketContent)arrayList.get(i);
                System.out.print("\tContentSection = ");
                switch (tDnsPacketContent.getContentSection()) {
                    case 0: {
                        System.out.println("Query");
                        break;
                    }
                    case 1: {
                        System.out.println("Answer");
                        break;
                    }
                    case 2: {
                        System.out.println("Name Server");
                        break;
                    }
                    case 3: {
                        System.out.println("Additional");
                        break;
                    }
                    default: {
                        System.out.println("Unknown");
                    }
                }
                System.out.println("\tContentName    = " + tDnsPacketContent.getContentName());
                System.out.println("\tContentType    = " + tDnsPacketContent.getContentType());
                System.out.println("\tContentClass   = " + tDnsPacketContent.getContentClass());
                System.out.println("\tContentTtl     = " + tDnsPacketContent.getContentTtl());
                System.out.println("\tContentData    = " + tDnsPacketContent.getContentData());
                System.out.println("\n");
            }
        }
    }

    public class TDnsLabel {
        String LabelStr;
        int EndOffset;

        public TDnsLabel(String string, int n) {
            this.LabelStr = string;
            this.EndOffset = n;
        }
    }
}

