/*
 * Decompiled with CFR 0.152.
 */
package metrics;

import aspect.Aspect;
import aspect.TMainWin;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Timer;
import resources.TApplication;
import utility.TFile;
import utility.charutil;
import utility.security.TPasswordService;

public class TStaticPageQueue
implements ActionListener {
    private TMainWin MainWin = Aspect.MainWin;
    private TApplication Application = TMainWin.Application;
    private String Filename = null;
    private long TimeLastFlush = 0L;
    private RandomAccessFile F = null;
    private DateFormat dateFormat = DateFormat.getInstance();
    private StringBuilder LogBuffer = new StringBuilder();
    private Timer CallbackTimer = null;

    public TStaticPageQueue() {
        ((SimpleDateFormat)this.dateFormat).applyPattern("yyyyMMdd");
        this.Filename = this.getLogFilename(new Date());
        this.openLogFile();
        this.CallbackTimer = new Timer(60000, this);
        this.CallbackTimer.start();
    }

    public String getLogFilename(Date date) {
        String string = this.dateFormat.format(date);
        string = this.Application.getHomeDir() + "aspectlogs/staticpageview_" + string + ".txt";
        return string;
    }

    public boolean openLogFile() {
        if (this.F != null) {
            try {
                this.F.close();
                this.F = null;
            }
            catch (Exception exception) {
                System.out.println("Error closing log file: " + exception.toString());
            }
        }
        if (this.Filename == null) {
            System.out.println("Error: Filename not initialized");
            return false;
        }
        try {
            new TFile(this.Filename).validatePathToFile(true);
            this.F = new RandomAccessFile(this.Filename, "rwd");
            return true;
        }
        catch (Exception exception) {
            System.out.println("Error opening log file: " + this.Filename);
            System.out.println(exception.toString());
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.LogBuffer.length() == 0) {
            return;
        }
        this.flushBuffer();
    }

    public synchronized void flushBuffer() {
        this.TimeLastFlush = new Date().getTime();
        if (this.LogBuffer.length() == 0) {
            return;
        }
        try {
            this.F.seek(this.F.length());
            this.F.writeBytes(this.LogBuffer.toString() + "\r\n");
        }
        catch (Exception exception) {
            System.out.println("Error writing to log file: " + exception.toString());
        }
        this.LogBuffer.setLength(0);
    }

    public void recordStaticPageView(String string, String string2, String string3, String string4, String string5) {
        Date date = new Date();
        String string6 = this.getLogFilename(date);
        if (!string6.equals(this.Filename)) {
            this.flushBuffer();
            this.Filename = string6;
            this.openLogFile();
        }
        String string7 = charutil.replaceAllSubstrings(string, "\r", "");
        string7 = charutil.replaceAllSubstrings(string7, "\n", "");
        string7 = charutil.replaceAllSubstrings(string7, ",", "");
        String string8 = charutil.replaceAllSubstrings(string4, "\r", "");
        string8 = charutil.replaceAllSubstrings(string8, "\n", "");
        string8 = charutil.replaceAllSubstrings(string8, ",", "");
        String string9 = charutil.replaceAllSubstrings(string3, "\r", "");
        string9 = charutil.replaceAllSubstrings(string9, "\n", "");
        string9 = charutil.replaceAllSubstrings(string9, ",", "");
        String string10 = TPasswordService.generateSalt(8);
        string10 = string10 + ",true";
        string10 = string10 + "," + Long.toString(date.getTime());
        string10 = string10 + "," + string7;
        string10 = string10 + "," + string2;
        string10 = string10 + "," + string9;
        string10 = string10 + "," + string8;
        string10 = string10 + "," + string5;
        if (this.LogBuffer.length() > 0) {
            this.LogBuffer.append("\r\n");
        }
        this.LogBuffer.append(string10);
        if (date.getTime() - this.TimeLastFlush > 60000L) {
            this.flushBuffer();
        }
    }
}

