/*
 * Decompiled with CFR 0.152.
 */
package investing.options;

public class TOrder
implements Comparable {
    String Symbol;
    String OrderType;
    String OptionType;
    double Strike;
    double Premium;
    int Quantity;
    double Bid;
    double Ask;
    double Delta;
    boolean IsBuy;
    boolean IsSell;

    public TOrder(String string, String string2, String string3, double d, double d2, int n, double d3, double d4, double d5) {
        this.Symbol = string;
        this.OptionType = string3;
        this.OrderType = string2;
        this.Strike = d;
        this.Premium = d2;
        this.Quantity = n;
        this.Bid = d3;
        this.Ask = d4;
        this.Delta = d5;
        this.IsBuy = this.OrderType.toUpperCase().startsWith("B");
        this.IsSell = this.OrderType.toUpperCase().startsWith("S");
    }

    public boolean isPut() {
        return this.OptionType.toUpperCase().startsWith("P");
    }

    public boolean isEmpty() {
        return this.OrderType.trim().length() == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Symbol: " + this.Symbol);
        stringBuilder.append("\tOrderType: " + this.OrderType);
        stringBuilder.append("\tOptionType: " + this.OptionType);
        stringBuilder.append("\tStrike: " + this.Strike);
        return stringBuilder.toString();
    }

    public int compareTo(Object object) {
        int n;
        int n2;
        TOrder tOrder = (TOrder)object;
        if (this.isEmpty() && !tOrder.isEmpty()) {
            return 1;
        }
        if (!this.isEmpty() && tOrder.isEmpty()) {
            return -1;
        }
        int n3 = this.IsSell ? -1 : 1;
        int n4 = n2 = tOrder.IsSell ? -1 : 1;
        if (n3 < n2) {
            return -1;
        }
        if (n3 > n2) {
            return 1;
        }
        int n5 = this.isPut() ? -1 : 1;
        int n6 = n = tOrder.isPut() ? -1 : 1;
        if (n5 < n) {
            return -1;
        }
        if (n5 > n) {
            return 1;
        }
        if (this.Strike < tOrder.Strike) {
            return -1;
        }
        return 1;
    }
}

