/*
 * Decompiled with CFR 0.152.
 */
package investing.DataSeries;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import investing.DataSeries.DataSeriesInfo;
import investing.DataSeries.TSeriesValuesObj;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;

public class TSeriesValuesColl {
    private TMainWin MainWin = Aspect.MainWin;
    private TApplication Application = TMainWin.Application;
    private static Hashtable hashSeriesValues = new Hashtable();

    public String getID(String string, String string2) {
        String string3 = (string + string2).toUpperCase();
        return string3;
    }

    public ArrayList getValues(String string, Date date, Date date2, String string2) {
        String string3;
        boolean bl = false;
        if (bl) {
            System.out.println("TSeriesValuesColl getValues(" + string + "," + dateutil.formatDate(date, "MM-dd-yyyy") + "," + dateutil.formatDate(date2, "MM-dd-yyyy") + "," + string2 + ")");
        }
        if (hashSeriesValues.containsKey(string3 = this.getID(string, string2))) {
            TSeriesValuesEntry tSeriesValuesEntry = (TSeriesValuesEntry)hashSeriesValues.get(string3);
            if (bl) {
                System.out.println("TSeriesValuesColl found existing entry for " + string3);
            }
            if (bl) {
                System.out.println("TSeriesValuesColl Filemodified=" + dateutil.formatDate(tSeriesValuesEntry.getFileModified(), "MM-dd-yyyy HH:mm:ss"));
            }
            ArrayList arrayList = tSeriesValuesEntry.getValues(date, date2);
            if (bl) {
                System.out.println("a.size=" + arrayList.size() + " Outputting 20 values:");
                for (int i = 0; i < 20 && i < arrayList.size(); ++i) {
                    TSeriesValuesObj tSeriesValuesObj = (TSeriesValuesObj)arrayList.get(i);
                    System.out.println("a[" + i + "] Date=" + dateutil.formatDate(tSeriesValuesObj.date) + " value=" + tSeriesValuesObj.DoubleValue());
                }
            }
            return arrayList;
        }
        if (bl) {
            System.out.println("TSeriesValuesColl creating entry for " + string3);
        }
        TSeriesValuesEntry tSeriesValuesEntry = new TSeriesValuesEntry(string, string2);
        if (hashSeriesValues.size() > 175) {
            Enumeration enumeration = hashSeriesValues.keys();
            hashSeriesValues.remove(enumeration.nextElement());
        }
        hashSeriesValues.put(string3, tSeriesValuesEntry);
        return tSeriesValuesEntry.getValues(date, date2);
    }

    public static String toString(ArrayList arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < arrayList.size(); ++i) {
            TSeriesValuesObj tSeriesValuesObj = (TSeriesValuesObj)arrayList.get(i);
            stringBuilder.append("|");
            stringBuilder.append(dateutil.formatDate(new Date(tSeriesValuesObj.date), "MM-dd-yyyy") + ",");
            if (tSeriesValuesObj.Value instanceof Double) {
                stringBuilder.append(charutil.formatNumber(tSeriesValuesObj.DoubleValue(), "0.000"));
                continue;
            }
            stringBuilder.append(tSeriesValuesObj.Value.toString());
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(0);
        }
        return stringBuilder.toString();
    }

    public class TSeriesValuesEntry {
        public String SeriesID;
        boolean IsFred = false;
        boolean IsAlphaVantage = false;
        long FileModified = 0L;
        long FirstDateInFile = 0L;
        long LastDateInFile = 0L;
        public String FieldID;
        public Hashtable values = new Hashtable();

        TSeriesValuesEntry(String string, String string2) {
            this.SeriesID = string;
            this.FieldID = string2;
            if (DataSeriesInfo.isFredDataSeries(this.SeriesID)) {
                this.IsFred = true;
            } else if (DataSeriesInfo.isAlphaVantageDataSeries(this.SeriesID)) {
                this.IsAlphaVantage = true;
            } else {
                System.out.println("Error: Unrecognized series ID: " + this.SeriesID);
            }
        }

        public String getDriverID() {
            if (this.IsFred) {
                return "Investing_Fred_Time_Series_With_Dates_Added";
            }
            if (this.IsAlphaVantage) {
                return "Investing_Alpha_Vantage_Stock_Quote_With_Dates_Added";
            }
            return null;
        }

        public String getFilename() {
            if (TSeriesValuesColl.this.Application == null) {
                return "c:\\aspect7\\temporary_files\\" + this.SeriesID + "_dates_added.$$$";
            }
            return TSeriesValuesColl.this.Application.getTokenValue("temporary_files") + this.SeriesID + "_dates_added.$$$";
        }

        public String getSourceFilename() {
            if (TSeriesValuesColl.this.Application == null) {
                if (this.IsFred) {
                    return "c:\\aspect7\\Investing\\observations\\fred\\" + this.SeriesID + ".txt";
                }
                return "c:\\aspect7\\Investing\\observations\\alphavantage\\" + this.SeriesID + ".csv";
            }
            if (this.IsFred) {
                return TSeriesValuesColl.this.Application.getTokenValue("homedir") + "Investing\\observations\\fred\\" + this.SeriesID + ".txt";
            }
            return TSeriesValuesColl.this.Application.getTokenValue("homedir") + "Investing\\observations\\alphavantage\\" + this.SeriesID + ".csv";
        }

        public boolean fileExists() {
            return dosutil.fileExists(this.getFilename());
        }

        public boolean sourceFileExists() {
            return dosutil.fileExists(this.getSourceFilename());
        }

        public Date getFileModified() {
            String string = this.getFilename();
            if (dosutil.fileExists(string)) {
                return dosutil.fileModified(string);
            }
            return new Date(0L);
        }

        public Date getSourceFileModified() {
            String string = this.getSourceFilename();
            if (dosutil.fileExists(string)) {
                return dosutil.fileModified(string);
            }
            return new Date(0L);
        }

        public TAspectDriver openDriver(Date date) {
            boolean bl = false;
            String string = "SeriesID=" + this.SeriesID + "|NoDepend|DateTo=" + dateutil.formatDate(date, "MM-dd-yyyy");
            long l = this.getSourceFileModified().getTime();
            long l2 = this.getFileModified().getTime();
            if (bl) {
                System.out.println("TSeriesValuesColl openDriver dtSource=" + dateutil.formatDate(new Date(l), "MM-dd-yyyy"));
            }
            if (bl) {
                System.out.println("TSeriesValuesColl openDriver dtAddedDates=" + dateutil.formatDate(new Date(l2), "MM-dd-yyyy"));
            }
            if (bl) {
                System.out.println("TSeriesValuesColl openDriver _dateTo=" + dateutil.formatDate(date, "MM-dd-yyyy"));
            }
            if (l > l2 || l2 < date.getTime()) {
                System.out.println("TSeriesValueColl updating driver.  Modified: " + dateutil.formatDate(this.getFileModified(), "MM-dd-yyyy HH:mm:ss") + " _dateTo: " + dateutil.formatDate(date, "MM-dd-yyyy HH:mm:ss"));
                String string2 = this.getDriverID();
                if (string2 == null) {
                    System.out.println("Error: Cannot get driver ID for series: " + this.SeriesID);
                } else {
                    String string3 = (String)TFormulaEvaluator.eval("updateDependentDriver(\"" + this.getDriverID() + "\",\"SeriesID=" + this.SeriesID + "|DateTo=" + dateutil.formatDate(date, "MM-dd-yyyy") + "\",false)");
                    if (bl) {
                        System.out.println("TSeriesValuesColl openDriver updated driver: " + string3);
                    }
                }
            } else if (bl) {
                System.out.println("TSeriesValuesColl openDriver did not update driver");
            }
            if (this.getDriverID() == null) {
                return null;
            }
            TAspectDriver tAspectDriver = new TAspectDriver(this.getDriverID(), 0, true, false, string);
            return tAspectDriver;
        }

        public int getRecordForDate(TAspectDriver tAspectDriver, Date date) {
            Object object;
            TDriverStructRecord tDriverStructRecord = tAspectDriver.getDriverStructRecord("date");
            int n = tAspectDriver.F.getRecordCount();
            int n2 = 0;
            int n3 = n;
            int n4 = -1;
            if (this.IsFred) {
                object = tAspectDriver.F.getField(tDriverStructRecord, 1);
                if (object != null) {
                    this.FirstDateInFile = ((Date)object).getTime();
                }
                if ((object = tAspectDriver.F.getField(tDriverStructRecord, n - 1)) != null) {
                    this.LastDateInFile = ((Date)object).getTime();
                }
            } else {
                object = tAspectDriver.F.getField(tDriverStructRecord, n - 1);
                if (object != null) {
                    this.FirstDateInFile = ((Date)object).getTime();
                }
                if ((object = tAspectDriver.F.getField(tDriverStructRecord, 1)) != null) {
                    this.LastDateInFile = ((Date)object).getTime();
                }
            }
            boolean bl = false;
            while (!bl) {
                int n5 = (int)Math.floor(n2 + (n3 - n2) / 2);
                if (n5 == n4) {
                    return -1;
                }
                if (n5 == n2 || n5 == n3) {
                    return -1;
                }
                Date date2 = (Date)tAspectDriver.F.getField(tDriverStructRecord, n5);
                if (date2.getTime() == date.getTime()) {
                    return n5;
                }
                if (this.IsFred) {
                    if (date2.getTime() > date.getTime()) {
                        n3 = n5;
                    } else {
                        n2 = n5;
                    }
                } else if (date2.getTime() < date.getTime()) {
                    n3 = n5;
                } else {
                    n2 = n5;
                }
                n4 = n5;
            }
            return -1;
        }

        public void readDataFromFile(Date date, Date date2) {
            boolean bl = false;
            if (bl) {
                System.out.println("readDataFromFile " + this.SeriesID + "\t" + this.FieldID + "\t" + dateutil.formatDate(date) + " To " + dateutil.formatDate(date2));
            }
            this.FileModified = this.getSourceFileModified().getTime();
            TAspectDriver tAspectDriver = this.openDriver(date2);
            if (tAspectDriver == null) {
                return;
            }
            TDriverStructRecord tDriverStructRecord = tAspectDriver.getDriverStructRecord("date");
            TDriverStructRecord tDriverStructRecord2 = tAspectDriver.getDriverStructRecord("is_added_date");
            TDriverStructRecord tDriverStructRecord3 = tAspectDriver.getDriverStructRecord(this.FieldID);
            int n = tAspectDriver.F.getRecordCount();
            if (n == 0) {
                System.out.println("Aborting because there are no records in the driver");
                tAspectDriver.dispose();
                return;
            }
            if (this.IsFred) {
                int n2 = this.getRecordForDate(tAspectDriver, dateutil.date(date));
                int n3 = this.getRecordForDate(tAspectDriver, dateutil.date(date2));
                if (n3 < 0) {
                    n3 = n - 1;
                }
                long l = ((Date)tAspectDriver.F.getField(tDriverStructRecord, 1)).getTime();
                long l2 = ((Date)tAspectDriver.F.getField(tDriverStructRecord, n - 1)).getTime();
                if (bl) {
                    System.out.println("Raw_Date=" + tAspectDriver.F.getField("Raw_Date", n - 1));
                    System.out.println("Filename=" + this.getFilename());
                    System.out.println("DSRecDate.FullID=" + tDriverStructRecord.FullID);
                    System.out.println("c=" + n + " dtFirst=" + new Date(l) + " dtLast=" + new Date(l2));
                }
                if (date.getTime() > l2) {
                    System.out.println("Aborting1 because _dateFrom:" + dateutil.formatDate(date, "MM-dd-yyyy") + " is beyond the last date in the file: " + dateutil.formatDate(new Date(l2), "MM-dd-yyyy"));
                    tAspectDriver.dispose();
                    return;
                }
                if (date2.getTime() < l) {
                    System.out.println("Aborting1 because _dateTo:" + dateutil.formatDate(date2, "MM-dd-yyyy") + " is earlier than the first date in the file: " + dateutil.formatDate(new Date(l), "MM-dd-yyyy"));
                    tAspectDriver.dispose();
                    return;
                }
                if (date.getTime() < l) {
                    n2 = 0;
                }
                if (date2.getTime() > l2) {
                    n3 = n - 1;
                    if (bl) {
                        System.out.println("set iEnd to c-1: " + n3);
                    }
                }
                if (n2 < 0) {
                    n2 = 0;
                    System.out.println("TSeriesValuesColl set iStart=0 for " + this.SeriesID);
                    System.out.println("_dateFrom=" + date + " _dateTo=" + date2);
                }
                if (bl) {
                    System.out.println("Reading records " + n2 + " to " + n3);
                }
                for (int i = n2; i <= n3; ++i) {
                    long l3 = ((Date)tAspectDriver.F.getField(tDriverStructRecord, i)).getTime();
                    Long l4 = new Long(l3);
                    if (this.values.containsKey(l4)) continue;
                    boolean bl2 = (Boolean)tAspectDriver.F.getField(tDriverStructRecord2, i);
                    Object object = tAspectDriver.F.getField(tDriverStructRecord3, i);
                    this.values.put(l4, new TSeriesValuesObj(l3, object, bl2));
                }
            } else {
                Object object;
                int n4 = this.getRecordForDate(tAspectDriver, dateutil.date(date));
                int n5 = this.getRecordForDate(tAspectDriver, dateutil.date(date2));
                if (bl) {
                    System.out.println("iEnd=" + n5 + " _dateTo=" + dateutil.formatDate(date2, "MM-dd-yyyy"));
                }
                if (bl) {
                    System.out.println("TSeriesValuesColl c=" + n);
                }
                if ((object = tAspectDriver.F.getField(tDriverStructRecord, n - 1)) == null) {
                    if (bl) {
                        System.out.println("Aborting3 because the staring date is null");
                    }
                    tAspectDriver.dispose();
                    return;
                }
                long l = ((Date)object).getTime();
                object = tAspectDriver.F.getField(tDriverStructRecord, 1);
                if (object == null) {
                    if (bl) {
                        System.out.println("Aborting3 because the ending date is null");
                    }
                    tAspectDriver.dispose();
                    return;
                }
                long l5 = ((Date)object).getTime();
                if (date.getTime() > l5) {
                    if (bl) {
                        System.out.println("Aborting3 because _dateFrom:" + dateutil.formatDate(date, "MM-dd-yyyy") + " is beyond the last date in the file: " + dateutil.formatDate(new Date(l5), "MM-dd-yyyy"));
                    }
                    tAspectDriver.dispose();
                    return;
                }
                if (date2.getTime() < l) {
                    if (bl) {
                        System.out.println("Aborting3 because _dateTo:" + dateutil.formatDate(date2, "MM-dd-yyyy") + " is earlier than the first date in the file: " + dateutil.formatDate(new Date(l), "MM-dd-yyyy"));
                    }
                    tAspectDriver.dispose();
                    return;
                }
                if (date.getTime() < l) {
                    n4 = n - 1;
                }
                if (date2.getTime() > l5) {
                    n5 = 1;
                }
                if (bl) {
                    System.out.println("Reading records " + n4 + " to " + n5);
                }
                for (int i = n4; i >= n5; --i) {
                    long l6 = ((Date)tAspectDriver.F.getField(tDriverStructRecord, i)).getTime();
                    Long l7 = new Long(l6);
                    if (this.values.containsKey(l7)) continue;
                    boolean bl3 = (Boolean)tAspectDriver.F.getField(tDriverStructRecord2, i);
                    object = tAspectDriver.F.getField(tDriverStructRecord3, i);
                    if (bl) {
                        System.out.println("i=" + i + " date: " + dateutil.formatDate(new Date(l6), "MM-dd-yyyy HH:mm:ss:SSS") + " o=" + object);
                    }
                    this.values.put(l7, new TSeriesValuesObj(l6, object, bl3));
                }
            }
            tAspectDriver.dispose();
        }

        public ArrayList getValues(Date date, Date date2) {
            Comparable<Date> comparable;
            Comparable<Date> comparable2;
            if (this.getDriverID() == null) {
                System.out.println("Error: Invalid series ID in TSeriesValuesColl: " + this.SeriesID);
                return new ArrayList();
            }
            boolean bl = false;
            Date date3 = this.getSourceFileModified();
            if (this.FirstDateInFile > 0L && date2.getTime() < this.FirstDateInFile) {
                if (bl) {
                    System.out.println("getValues returns empty array because dates are earlier than first date: " + dateutil.formatDate(this.FirstDateInFile));
                }
                return new ArrayList();
            }
            if (date3.getTime() > this.FileModified) {
                this.values.clear();
            }
            Date date4 = dateutil.date(date);
            Date date5 = dateutil.date(date2);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date4);
            ArrayList<Comparable<Date>> arrayList = new ArrayList<Comparable<Date>>();
            boolean bl2 = true;
            while (gregorianCalendar.getTime().getTime() <= date5.getTime()) {
                comparable2 = new Long(gregorianCalendar.getTime().getTime());
                if (this.values.containsKey(comparable2)) {
                    comparable = (TSeriesValuesObj)this.values.get(comparable2);
                    int n = Collections.binarySearch(arrayList, comparable);
                    arrayList.add(Math.abs(n + 1), comparable);
                    if (bl) {
                        System.out.println("Adding existing object key" + comparable2 + " value=" + ((TSeriesValuesObj)comparable).Value + " DoubleValue=" + ((TSeriesValuesObj)comparable).DoubleValue() + " date=" + dateutil.formatDate(((TSeriesValuesObj)comparable).date));
                    }
                } else if (this.FirstDateInFile == 0L) {
                    if (bl) {
                        System.out.println("cannot find date1: " + dateutil.formatDate(gregorianCalendar.getTime()) + " DateFrom=" + dateutil.formatDate(date) + " DateTo=" + dateutil.formatDate(date2));
                    }
                    bl2 = false;
                } else if (gregorianCalendar.getTime().getTime() >= this.FirstDateInFile) {
                    if (this.LastDateInFile == 0L || gregorianCalendar.getTime().getTime() <= this.LastDateInFile) {
                        bl2 = false;
                        break;
                    }
                    if (bl) {
                        System.out.println("key not found1: " + comparable2 + " FirstDateInFile=" + this.FirstDateInFile);
                    }
                } else if (bl) {
                    System.out.println("key not found2: " + comparable2 + " FirstDateInFile=" + this.FirstDateInFile);
                }
                gregorianCalendar.add(5, 1);
            }
            if (bl) {
                System.out.println("IsComplete=" + bl2);
            }
            if (bl2) {
                return arrayList;
            }
            comparable2 = date4;
            comparable = date5;
            Comparable<Calendar> comparable3 = new GregorianCalendar();
            Comparable<Calendar> comparable4 = new GregorianCalendar();
            comparable3.setTime((Date)comparable2);
            comparable4.setTime((Date)comparable);
            comparable3.add(1, -3);
            comparable4.add(1, 3);
            comparable2 = comparable3.getTime();
            comparable = comparable4.getTime();
            if (bl) {
                System.out.println("fileExists: " + this.getSourceFilename() + ": " + this.fileExists());
            }
            if (this.sourceFileExists()) {
                long l = date3.getTime();
                long l2 = ((Date)comparable).getTime();
                long l3 = Math.min(l, l2);
                l3 = Math.max(l3, date4.getTime());
                GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
                gregorianCalendar2.setTime(new Date());
                gregorianCalendar2.set(11, 0);
                gregorianCalendar2.set(12, 0);
                gregorianCalendar2.set(13, 0);
                gregorianCalendar2.set(14, 0);
                l3 = Math.min(l3, gregorianCalendar2.getTime().getTime());
                comparable = new Date(l3);
            }
            if (bl) {
                System.out.println("Extended date range from " + dateutil.formatDate(date4) + " to " + dateutil.formatDate(comparable2) + " - " + dateutil.formatDate(comparable));
            }
            if (bl) {
                System.out.println("calling readDataFromFile dt1a=" + dateutil.formatDate(comparable2, "MM-dd-yyyy") + " dt2a=" + dateutil.formatDate(comparable, "MM-dd-yyyy"));
            }
            this.readDataFromFile((Date)comparable2, (Date)comparable);
            arrayList.clear();
            gregorianCalendar.setTime(date4);
            while (gregorianCalendar.getTime().getTime() <= date5.getTime()) {
                int n;
                comparable3 = new Long(gregorianCalendar.getTime().getTime());
                if (this.values.containsKey(comparable3)) {
                    comparable4 = (TSeriesValuesObj)this.values.get(comparable3);
                    n = Collections.binarySearch(arrayList, comparable4);
                    arrayList.add(Math.abs(n + 1), comparable4);
                } else {
                    comparable4 = new TSeriesValuesObj(gregorianCalendar.getTime().getTime(), 0);
                    n = Collections.binarySearch(arrayList, comparable4);
                    arrayList.add(Math.abs(n + 1), comparable4);
                    if (bl) {
                        System.out.println("cannot find date2: " + dateutil.formatDate(gregorianCalendar.getTime()) + " DateFrom=" + dateutil.formatDate(date4) + " DateTo=" + dateutil.formatDate(date5));
                    }
                }
                gregorianCalendar.add(5, 1);
            }
            return arrayList;
        }
    }
}

