/*
 * Decompiled with CFR 0.152.
 */
package investing.DataSeries;

import aspect.Aspect;
import aspect.TMainWin;
import collections.TComboBoxColl;
import drivers.files.TBinaryFile;
import java.io.File;
import java.util.Hashtable;
import resources.TAppDriversObject;
import utility.TFormulaEvaluator;

public class DataSeriesInfo {
    private static TMainWin MainWin = Aspect.MainWin;
    private static Hashtable hashSeriesSource = new Hashtable();
    public static String FredSeriesID = "";
    public static String AlphaVantageSeriesID = "";
    private static Hashtable hashDataSeriesName = new Hashtable();
    private static TComboBoxColl collIndustry = null;
    private static TComboBoxColl collIndustryCRC = null;
    private static TComboBoxColl collSector = null;
    private static TComboBoxColl collSIC = null;

    public static String getDataSeriesName(String string, boolean bl) {
        String string2 = string.toUpperCase();
        if (hashDataSeriesName.containsKey(string2)) {
            return (String)hashDataSeriesName.get(string2);
        }
        if (hashDataSeriesName.size() > 2500) {
            hashDataSeriesName.clear();
        }
        if (DataSeriesInfo.isFredDataSeries(string, bl)) {
            TAppDriversObject tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject("Investing_Fred_Time_Series_ID");
            TBinaryFile tBinaryFile = new TBinaryFile(TMainWin.Application, tAppDriversObject, 1, false);
            try {
                tBinaryFile.makeEditableFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = tBinaryFile.getMatchingRecord("Series_ID=\"" + string + "\"", 0);
            if (n >= 0) {
                String string3 = (String)tBinaryFile.getField("Description", n);
                hashDataSeriesName.put(string2, string3);
                tBinaryFile.dispose();
                return string3;
            }
            tBinaryFile.dispose();
            return "Unrecognized Fred SeriesID";
        }
        if (DataSeriesInfo.isAlphaVantageDataSeries(string)) {
            TAppDriversObject tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject("Investing_Alpha_Vantage_Time_Series_ID");
            TBinaryFile tBinaryFile = new TBinaryFile(TMainWin.Application, tAppDriversObject, 1, false);
            try {
                tBinaryFile.makeEditableFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = tBinaryFile.getMatchingRecord("Series_ID=\"" + string + "\"", 0);
            if (n >= 0) {
                String string4 = (String)tBinaryFile.getField("Description", n);
                hashDataSeriesName.put(string2, string4);
                tBinaryFile.dispose();
                return string4;
            }
            tBinaryFile.dispose();
            return "Unrecognized AlphaVantage SeriesID";
        }
        return "Unrecognized SeriesID";
    }

    public static boolean isFredDataSeries(String string) {
        return DataSeriesInfo.isFredDataSeries(string, true);
    }

    public static boolean isFredDataSeries(String string, boolean bl) {
        Object v = hashSeriesSource.get(string.toUpperCase());
        if (v != null) {
            return ((String)v).equals("FRED");
        }
        boolean bl2 = false;
        if (bl) {
            if (FredSeriesID.length() == 0) {
                String string2 = "getCollection(Investing_Fred_Time_Series_Observation_ID_No_Sort,true,\"\",\"\",\"|\",\"Keys\")";
                FredSeriesID = "|" + ((String)TFormulaEvaluator.eval(string2)).toUpperCase() + "|";
            }
            bl2 = FredSeriesID.indexOf("|" + string.toUpperCase() + "|") >= 0;
        } else {
            TAppDriversObject tAppDriversObject = TMainWin.Application.AppDrivers.getAppDriversObject("Investing_Fred_Time_Series_ID");
            TBinaryFile tBinaryFile = new TBinaryFile(TMainWin.Application, tAppDriversObject, 1, false);
            try {
                tBinaryFile.makeEditableFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string3 = "Series_ID=\"" + string + "\"";
            int n = tBinaryFile.getMatchingRecord(string3, 0);
            bl2 = n >= 0;
            tBinaryFile.dispose();
        }
        if (bl2) {
            hashSeriesSource.put(string.toUpperCase(), "FRED");
        }
        return bl2;
    }

    public static boolean isAlphaVantageDataSeries(String string) {
        boolean bl;
        if (string.equalsIgnoreCase("GDP")) {
            return false;
        }
        Object v = hashSeriesSource.get(string.toUpperCase());
        if (v != null) {
            return ((String)v).equals("ALPHAVANTAGE");
        }
        if (AlphaVantageSeriesID.length() == 0) {
            String string2 = "getCollection(Investing_Alpha_Vantage_Time_Series_Observation_ID,true,\"\",\"\",\"|\",\"Keys\")";
            AlphaVantageSeriesID = "|" + ((String)TFormulaEvaluator.eval(string2)).toUpperCase() + "|";
        }
        boolean bl2 = bl = AlphaVantageSeriesID.indexOf("|" + string.toUpperCase() + "|") > 0;
        if (bl) {
            hashSeriesSource.put(string.toUpperCase(), "ALPHAVANTAGE");
        }
        return bl;
    }

    public static String getFredFilename(String string) {
        return TMainWin.Application.getTokenValue("homedir") + "Investing\\observations\\fred\\" + string + ".txt";
    }

    public static String getAlphaVantageFilename(String string) {
        if (MainWin == null) {
            return "c:\\aspect7\\Investing\\observations\\alphavantage\\" + string + ".csv";
        }
        return TMainWin.Application.getTokenValue("homedir") + "Investing\\observations\\alphavantage\\" + string + ".csv";
    }

    public static String getSeriesFilename(String string) {
        if (DataSeriesInfo.isAlphaVantageDataSeries(string)) {
            return DataSeriesInfo.getAlphaVantageFilename(string);
        }
        if (DataSeriesInfo.isFredDataSeries(string)) {
            return DataSeriesInfo.getFredFilename(string);
        }
        return "";
    }

    public static long getFileModified(String string) {
        if (DataSeriesInfo.isAlphaVantageDataSeries(string)) {
            String string2 = DataSeriesInfo.getAlphaVantageFilename(string);
            File file = new File(string2);
            if (file.exists()) {
                return file.lastModified();
            }
            return -1L;
        }
        if (DataSeriesInfo.isFredDataSeries(string)) {
            String string3 = DataSeriesInfo.getFredFilename(string);
            File file = new File(string3);
            if (file.exists()) {
                return file.lastModified();
            }
            return -1L;
        }
        return -1L;
    }

    public static String updateDependentDriver(String string) {
        if (DataSeriesInfo.isFredDataSeries(string)) {
            System.out.println("DataSeriesUtility updating dependent Fred driver: " + string);
            String string2 = (String)TFormulaEvaluator.eval("updateDependentDriver(Investing_Fred_Time_Series,\"NoDepend|SeriesID=" + string + "\",false)");
            return string2;
        }
        if (DataSeriesInfo.isAlphaVantageDataSeries(string)) {
            System.out.println("DataSeriesUtility updating dependent AlphaVantage driver: " + string);
            String string3 = (String)TFormulaEvaluator.eval("updateDependentDriver(Investing_Alpha_Vantage_Stock_Quote,\"NoDepend|SeriesID=" + string + "\",false)");
            return string3;
        }
        return "Error: Unreocgnized series";
    }

    public static String getIndustry(String string) {
        String string2;
        if (collIndustry == null) {
            collIndustry = TMainWin.Application.AppCollections.getCollection("Investing_Stock_Industries_by_Symol", new StringBuilder(), null, false, "", "");
        }
        if ((string2 = (String)collIndustry.getValueOfKey(string)) == null) {
            string2 = "";
        }
        return string2;
    }

    public static String getIndustryCRC(String string) {
        String string2;
        if (collIndustryCRC == null) {
            collIndustryCRC = TMainWin.Application.AppCollections.getCollection("Investing_Stock_IndustryCRC_by_Symbol", new StringBuilder(), null, false, "", "");
        }
        if ((string2 = (String)collIndustryCRC.getValueOfKey(string)) == null) {
            string2 = "";
        }
        return string2;
    }

    public static String getSector(String string) {
        String string2;
        if (collSector == null) {
            collSector = TMainWin.Application.AppCollections.getCollection("Investing_Stock_Sectors_by_Symbol", new StringBuilder(), null, false, "", "");
        }
        if ((string2 = (String)collSector.getValueOfKey(string)) == null) {
            string2 = "";
        }
        return string2;
    }

    public static String getSICCode(String string) {
        String string2;
        if (collSIC == null) {
            collSIC = TMainWin.Application.AppCollections.getCollection("Investing_Alpha_Vantage_SIC_Code_by_Symbol", new StringBuilder(), null, false, "", "");
        }
        if ((string2 = (String)collSIC.getValueOfKey(string)) == null) {
            string2 = "";
        }
        return string2;
    }
}

