/*
 * Decompiled with CFR 0.152.
 */
package drivers.serial;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.DataInputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JComponent;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.charutil;

public class TSerialPort
extends TAbstractDriver {
    private TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTSerialPort");
    private SerialPort serial_port = null;
    private int BaudRate = 9600;
    private int DataBits = 8;
    private int Parity = 0;
    private int StopBits = 1;
    private int FlowControl = 0;
    private DataInputStream inputstream = null;
    private PrintStream outputstream = null;

    public TSerialPort(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        if (this.Debug) {
            this.MainWin.appendToLog("TSerialPort", "executeDriverCommand", Thread.currentThread(), null, 10, "Initializing serial port driver");
        }
        this.DriverStruct = new TDriverStruct(tApplication, tAppDriversObject.StructureIndex.toString());
        this.FormulaEvaluator = new TFormulaEvaluator(TMainWin.Application, this.DriverStruct, this);
    }

    @Override
    public void dispose() {
    }

    @Override
    public int getRecordCount() {
        if (this.serial_port == null) {
            return 0;
        }
        try {
            int n = this.inputstream.available();
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public boolean isDeleted(int n, StringBuilder stringBuilder) {
        return false;
    }

    @Override
    public boolean isInFilter(int n, StringBuilder stringBuilder) {
        return true;
    }

    @Override
    public Object getField(String string, int n) {
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        return this.getField(tDriverStructRecord, n);
    }

    @Override
    public Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        if (tDriverStructRecord == null) {
            return null;
        }
        Integer n2 = null;
        if (this.serial_port != null) {
            try {
                if (this.inputstream.available() > 0) {
                    n2 = charutil.unsignedByteToInt(this.inputstream.readByte());
                }
            }
            catch (Exception exception) {
                this.MainWin.appendToLog("TSerialPort", "executeDriverCommand", Thread.currentThread(), null, 4, "Error reading data from serial port");
            }
        }
        return n2;
    }

    @Override
    public synchronized Object getFieldForTable(TDriverStructRecord tDriverStructRecord, int n) {
        return this.getField(tDriverStructRecord, n);
    }

    @Override
    public int putField(String string, int n, Object object) {
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField(string);
        return this.putField(tDriverStructRecord, n, object);
    }

    @Override
    public int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        return 0;
    }

    @Override
    public ArrayList getSupportedDriverCommands() {
        ArrayList arrayList = super.getSupportedDriverCommands();
        arrayList.add("openSerialPort");
        arrayList.add("closeSerialPort");
        arrayList.add("setSerialPortParams");
        arrayList.add("setSerialPortFlowControl");
        arrayList.add("setSerialPortRTS");
        arrayList.add("setSerialPortDTR");
        return arrayList;
    }

    @Override
    public String executeDriverCommand(JComponent jComponent, String string, String string2) {
        String string3 = string2;
        String string4 = "ok";
        if (this.Debug) {
            this.MainWin.appendToLog("TSerialPort", "executeDriverCommand", Thread.currentThread(), null, 10, "Driver command = " + string);
        }
        string4 = string.equalsIgnoreCase("openSerialPort") ? this.openSerialPort(string3) : (string.equalsIgnoreCase("closeSerialPort") ? this.closeSerialPort() : (string.equalsIgnoreCase("setSerialPortParams") ? this.setSerialParams(string3) : (string.equalsIgnoreCase("setSerialPortFlowControl") ? this.setFlowControl(string3) : (string.equalsIgnoreCase("setSerialPortRTS") ? this.setRTS(string3) : (string.equalsIgnoreCase("setSerialPortDTR") ? this.setDTR(string3) : super.executeDriverCommand(jComponent, string, string2))))));
        return string4;
    }

    private String setRTS(String string) {
        if (this.Debug) {
            this.MainWin.appendToLog("TSerialPort", "executeDriverCommand", Thread.currentThread(), null, 10, "setRTS(" + string + ")");
        }
        if (this.serial_port != null) {
            this.serial_port.setRTS(charutil.boolval(string));
        }
        return "ok";
    }

    private String setDTR(String string) {
        if (this.Debug) {
            this.MainWin.appendToLog("TSerialPort", "executeDriverCommand", Thread.currentThread(), null, 10, "setDTR(" + string + ")");
        }
        if (this.serial_port != null) {
            this.serial_port.setDTR(charutil.boolval(string));
        }
        return "ok";
    }

    private String setFlowControl(String string) {
        String string2 = "ok";
        if (this.Debug) {
            this.MainWin.appendToLog("TSerialPort", "executeDriverCommand", Thread.currentThread(), null, 10, "setSerialParams(" + string + ")");
        }
        this.FlowControl = 0;
        String[] stringArray = charutil.getSubStringArray(string, '|', true);
        if (stringArray == null) {
            return "No parameters specified ni setFlowControl";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("NONE")) {
                this.FlowControl |= 0;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("RTSCTS_IN")) {
                this.FlowControl |= 1;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("RTSCTS_OUT")) {
                this.FlowControl |= 2;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("XONXOFF_IN")) {
                this.FlowControl |= 4;
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("XONXOFF_OUT")) continue;
            this.FlowControl |= 8;
        }
        if (this.serial_port != null) {
            try {
                this.serial_port.setFlowControlMode(this.FlowControl);
            }
            catch (Exception exception) {
                this.MainWin.appendToLog("TSerialPort", "executeDriverCommand", Thread.currentThread(), null, 4, "Error setting flow control");
            }
        }
        try {
            this.serial_port.setSerialPortParams(this.BaudRate, this.DataBits, this.StopBits, this.Parity);
        }
        catch (Exception exception) {
            String string3 = "Error setting serial port parameters";
            string2 = string3 + ": " + exception.toString();
            this.MainWin.appendToLog("TSerialPort", "executeDriverCommand", Thread.currentThread(), exception, 4, string3);
        }
        return string2;
    }

    private String setSerialParams(String string) {
        String[] stringArray;
        String string2 = "ok";
        if (this.Debug) {
            this.MainWin.appendToLog("TSerialPort", "executeDriverCommand", Thread.currentThread(), null, 10, "setSerialParams(" + string + ")");
        }
        if ((stringArray = charutil.getSubStringArray(string, '|', true)) == null) {
            return "No parameters given in setSerialParams";
        }
        if (stringArray.length > 0) {
            this.BaudRate = charutil.ival(stringArray[0]);
        }
        if (stringArray.length > 1) {
            switch (charutil.ival(stringArray[1])) {
                case 5: {
                    this.DataBits = 5;
                    break;
                }
                case 6: {
                    this.DataBits = 6;
                    break;
                }
                case 7: {
                    this.DataBits = 7;
                    break;
                }
                case 8: {
                    this.DataBits = 8;
                }
            }
        }
        if (stringArray.length > 2) {
            if (stringArray[2].equalsIgnoreCase("EVEN")) {
                this.Parity = 2;
            } else if (stringArray[2].equalsIgnoreCase("MARK")) {
                this.Parity = 3;
            } else if (stringArray[2].equalsIgnoreCase("ODD")) {
                this.Parity = 1;
            } else if (stringArray[2].equalsIgnoreCase("SPACE")) {
                this.Parity = 4;
            }
        }
        if (stringArray.length > 3) {
            if (stringArray[3].equalsIgnoreCase("1")) {
                this.StopBits = 1;
            } else if (stringArray[3].equalsIgnoreCase("1.5")) {
                this.StopBits = 3;
            } else if (stringArray[3].equalsIgnoreCase("2")) {
                this.StopBits = 2;
            }
        }
        return string2;
    }

    private String openSerialPort(String string) {
        String string2 = "ok";
        if (this.Debug) {
            this.MainWin.appendToLog("TSerialPort", "executeDriverCommand", Thread.currentThread(), null, 10, "openSerialPort(" + string + ")");
        }
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            if (!commPortIdentifier.getName().equalsIgnoreCase(string)) continue;
            try {
                this.serial_port = (SerialPort)commPortIdentifier.open("MyPort", 1000);
                this.serial_port.setSerialPortParams(this.BaudRate, this.DataBits, this.StopBits, this.Parity);
                this.inputstream = new DataInputStream(this.serial_port.getInputStream());
                this.outputstream = new PrintStream(this.serial_port.getOutputStream(), true);
            }
            catch (Exception exception) {
                String string3 = "Error opening serial port";
                string2 = string3 + ": " + exception.toString();
                this.MainWin.appendToLog("TSerialPort", "executeDriverCommand", Thread.currentThread(), exception, 4, string3);
            }
        }
        return string2;
    }

    private String closeSerialPort() {
        String string = "ok";
        if (this.Debug) {
            this.MainWin.appendToLog("TSerialPort", "executeDriverCommand", Thread.currentThread(), null, 10, "closeSerialPort()");
        }
        if (this.serial_port != null) {
            this.serial_port.close();
            this.serial_port = null;
            this.inputstream = null;
            this.outputstream = null;
        }
        return string;
    }
}

