/*
 * Decompiled with CFR 0.152.
 */
package drivers.other;

import aspect.TMainWin;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TDriverStructRecord;
import extensions.SwingWorker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.Timer;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.netutil;
import utility.objectutil;

public class TSystemPropertiesDriver
extends TAbstractDriver {
    Properties SystemProperties = null;
    TDriverStructRecord DSRecPropertyValue = this.DriverStruct.getField("PropertyValue");
    int cOtherProperties = 14;
    String LocalIPAddress = null;
    String LocalHostName = null;
    String ExternalIPAddress = null;
    String ExternalHostName = null;
    int cCallbacks = 0;
    Timer timer = null;

    public TSystemPropertiesDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        super(tApplication, tAppDriversObject, 1, bl);
        this.SystemProperties = System.getProperties();
        this.timer = new Timer(1000, new TimerListener());
        this.timer.setInitialDelay(5000);
        this.timer.start();
    }

    @Override
    public void dispose() {
        this.timer.stop();
        super.dispose();
    }

    @Override
    public int makeEditableFile() {
        new TSystemPropertiesDriverThread(this).start();
        return 1;
    }

    @Override
    public int getRecordCount() {
        if (this.SystemProperties == null) {
            return this.cOtherProperties;
        }
        return this.SystemProperties.size() + this.cOtherProperties;
    }

    @Override
    public boolean isDeleted(int n, StringBuilder stringBuilder) {
        return false;
    }

    @Override
    public Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        if (tDriverStructRecord == null) {
            return null;
        }
        Object object = null;
        String string = "";
        if (tDriverStructRecord.IsToken) {
            string = TMainWin.Application.getTokenValue(tDriverStructRecord.ID);
            object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, string, 0);
            return object;
        }
        if (tDriverStructRecord.IsCalculated) {
            object = this.calculateField(tDriverStructRecord, n);
            return object;
        }
        if (n < this.cOtherProperties) {
            if (tDriverStructRecord.FullID.equalsIgnoreCase("PropertyDescription")) {
                switch (n) {
                    case 0: {
                        object = "Date/Time";
                        break;
                    }
                    case 1: {
                        object = "Memory - Maximum allowable (kilobytes)";
                        break;
                    }
                    case 2: {
                        object = "Memory - Currently allocated for use (kilobytes)";
                        break;
                    }
                    case 3: {
                        object = "Memory - Unused (kilobytes)";
                        break;
                    }
                    case 4: {
                        object = "Memory - In use (kilobytes)";
                        break;
                    }
                    case 5: {
                        object = "Local IP Address";
                        break;
                    }
                    case 6: {
                        object = "Local Host Name";
                        break;
                    }
                    case 7: {
                        object = "External IP Address";
                        break;
                    }
                    case 8: {
                        object = "External Host Name";
                        break;
                    }
                    case 9: {
                        object = "Aspect Startup Directory";
                        break;
                    }
                    case 10: {
                        object = "Aspect Home Directory";
                        break;
                    }
                    case 11: {
                        object = "Aspect Core Package Location";
                        break;
                    }
                    case 12: {
                        object = "Aspect Exec Directory";
                        break;
                    }
                    case 13: {
                        object = "Aspect Execution Mode";
                    }
                }
            } else {
                Runtime runtime = Runtime.getRuntime();
                switch (n) {
                    case 0: {
                        Date date = new Date(System.currentTimeMillis());
                        object = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss").format(date);
                        break;
                    }
                    case 1: {
                        object = Long.toString(runtime.maxMemory() / 1000L);
                        break;
                    }
                    case 2: {
                        object = Long.toString(runtime.totalMemory() / 1000L);
                        break;
                    }
                    case 3: {
                        object = Long.toString(runtime.freeMemory() / 1000L);
                        break;
                    }
                    case 4: {
                        object = Long.toString((runtime.totalMemory() - runtime.freeMemory()) / 1000L);
                        break;
                    }
                    case 5: {
                        object = this.LocalIPAddress;
                        break;
                    }
                    case 6: {
                        object = this.LocalHostName;
                        break;
                    }
                    case 7: {
                        object = this.ExternalIPAddress;
                        break;
                    }
                    case 8: {
                        object = this.ExternalHostName;
                        break;
                    }
                    case 9: {
                        object = this.Application.parse_tokens("{workingdir}");
                        break;
                    }
                    case 10: {
                        object = this.Application.parse_tokens("{homedir}");
                        break;
                    }
                    case 11: {
                        object = this.Application.parse_tokens("{coredir}");
                        break;
                    }
                    case 12: {
                        object = this.Application.parse_tokens("{execdir}");
                        break;
                    }
                    case 13: {
                        object = this.Application.parse_tokens("{execmode}");
                    }
                }
            }
            return object;
        }
        if (this.SystemProperties == null) {
            return null;
        }
        if (this.SystemProperties.size() <= n) {
            return null;
        }
        Enumeration<Object> enumeration = this.SystemProperties.keys();
        for (int i = 0; i <= n - this.cOtherProperties && enumeration.hasMoreElements(); ++i) {
            string = (String)enumeration.nextElement();
        }
        if (tDriverStructRecord.FullID.equalsIgnoreCase("PropertyDescription")) {
            return string;
        }
        if (tDriverStructRecord.FullID.equalsIgnoreCase("PropertyValue")) {
            return (String)this.SystemProperties.get(string);
        }
        return null;
    }

    @Override
    public synchronized Object getFieldForTable(TDriverStructRecord tDriverStructRecord, int n) {
        return this.getField(tDriverStructRecord, n);
    }

    @Override
    public int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        this.notifyListeners(n, tDriverStructRecord.FullID, this.getField(tDriverStructRecord, n), object);
        return 0;
    }

    public void updateOtherProperties() {
        for (int i = 0; i < this.cOtherProperties; ++i) {
            this.putField(this.DSRecPropertyValue, i, this.getField(this.DSRecPropertyValue, i));
        }
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TSystemPropertiesDriver.this.cCallbacks > 0) {
                return;
            }
            ++TSystemPropertiesDriver.this.cCallbacks;
            SwingWorker swingWorker = new SwingWorker(){

                @Override
                public Object construct() {
                    return null;
                }

                @Override
                public void finished() {
                    TSystemPropertiesDriver.this.updateOtherProperties();
                    --TSystemPropertiesDriver.this.cCallbacks;
                }
            };
            swingWorker.start();
        }
    }

    public class TSystemPropertiesDriverThread
    extends Thread {
        TSystemPropertiesDriver SystemPropertiesDriver;

        public TSystemPropertiesDriverThread(TSystemPropertiesDriver tSystemPropertiesDriver2) {
            super("TSystemPropertiesDriverThread");
            this.SystemPropertiesDriver = tSystemPropertiesDriver2;
        }

        @Override
        public void run() {
            this.SystemPropertiesDriver.LocalIPAddress = netutil.getLocalIP();
            this.SystemPropertiesDriver.LocalHostName = netutil.getLocalHostName();
            this.SystemPropertiesDriver.ExternalIPAddress = netutil.getExternalIP();
            this.SystemPropertiesDriver.ExternalHostName = netutil.getHostName(this.SystemPropertiesDriver.ExternalIPAddress);
        }
    }
}

