/*
 * Decompiled with CFR 0.152.
 */
package drivers.files;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TDriverInterface;
import drivers.aspect.TDriverStructRecord;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import javax.swing.JComponent;
import performance.TPerformanceFileMark;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFile;
import utility.charutil;
import utility.dateutil;
import utility.dosutil;
import utility.objectutil;

public class TDbaseDriver
extends TAbstractDriver
implements TDriverInterface {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTDbaseDriver");
    private RandomAccessFile F = null;
    private String TempFileName;
    private String AccessMode;
    private TDbaseHeader DbaseHeader = null;
    private Hashtable hashedFields = new Hashtable();
    private byte[] arFieldBuffer = new byte[256];
    private StringBuilder strFieldBuffer = new StringBuilder();
    private StringBuilder WriteBuffer = new StringBuilder();
    private int WriteBufferSeek = 0;

    public TDbaseDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        super(tApplication, tAppDriversObject, n, bl);
        this.PerformanceMark = new TPerformanceFileMark("TBinaryBuffer", this.AppDriversObject.DriverID.toString(), this.AppDriversObject.FileName.toString(), this.AppDriversObject.DriverParams);
        switch (n) {
            case 0: {
                this.AccessMode = "r";
                this.IsWriteable = false;
                break;
            }
            case 1: {
                this.AccessMode = "rwd";
                this.IsWriteable = true;
            }
        }
    }

    @Override
    public void dispose() {
        this.commitWriteBuffer();
        super.dispose();
        this.clearBuffer();
        if (this.isModified() && this.Mode == 1) {
            this.DbaseHeader.updateHeader();
        }
        try {
            this.F.close();
        }
        catch (Exception exception) {
            MainWin.appendToLog("TBinaryFile", "dispose", Thread.currentThread(), exception, 3, "Error closing file: " + this.AppDriversObject.Description);
        }
    }

    @Override
    public int getRecordCount() {
        try {
            int n;
            if (this.DbaseHeader == null || this.DbaseHeader.cRecordBytes == 0) {
                return 0;
            }
            double d = (this.F.length() - (long)this.DbaseHeader.cHeaderBytes) / (long)this.DbaseHeader.cRecordBytes;
            if (d != (double)(n = (int)d)) {
                MainWin.appendToLog("TDbaseDriver", "getRecordCount", Thread.currentThread(), null, 4, "File size is not a multiple of the record size in " + this.AppDriversObject.Description);
            }
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public int makeEditableFile() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[65536];
        boolean bl = false;
        dosutil.formatURL(stringBuilder, new StringBuilder(this.FileName));
        URL uRL = new URL(stringBuilder.toString());
        if (uRL.getProtocol().toUpperCase().equals("FILE") && this.FileName.toUpperCase().indexOf(".ZIP") < 0 && this.FileName.toUpperCase().indexOf(".JAR") < 0) {
            this.IsLocal = true;
            if (this.getMode() == 1) {
                new TFile(this.FileName).validatePathToFile(true);
            }
            this.F = new RandomAccessFile(this.FileName, this.AccessMode);
            if (this.F.length() == 0L) {
                this.DbaseHeader = new TDbaseHeader();
                this.DbaseHeader.initialize();
            }
        } else {
            int n;
            this.IsLocal = false;
            this.IsWriteable = false;
            File file = dosutil.createTempFile("tmp");
            this.TempFileName = file.getPath();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(dosutil.getInputStream(this.FileName));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            do {
                if ((n = bufferedInputStream.read(byArray)) <= 0) continue;
                bufferedOutputStream.write(byArray, 0, n);
            } while (n > 0);
            bufferedInputStream.close();
            bufferedOutputStream.close();
            this.F = new RandomAccessFile(this.TempFileName, "r");
        }
        this.getFileHeader();
        return 0;
    }

    @Override
    public ArrayList getSupportedDriverCommands() {
        ArrayList arrayList = super.getSupportedDriverCommands();
        arrayList.add("dbaseSetFieldLength");
        return arrayList;
    }

    @Override
    public String executeDriverCommand(JComponent jComponent, String string, String string2) {
        String string3 = "ok";
        if (string.equalsIgnoreCase("dbaseSetFieldLength")) {
            String[] stringArray = charutil.getSubStringArray(string2, ',', true);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2 = charutil.getSubStringArray(stringArray[i], '=', true);
                    if (stringArray2 == null || stringArray2.length <= 1) continue;
                    this.DbaseHeader.setFieldLength(stringArray2[0], charutil.byteval(stringArray2[1]));
                }
            }
        } else {
            string3 = super.executeDriverCommand(jComponent, string, string2);
        }
        return string3;
    }

    @Override
    public void getFileHeader() {
        if (this.DbaseHeader == null) {
            this.DbaseHeader = new TDbaseHeader();
        }
        this.DbaseHeader.readHeader();
        this.setHeaderSize(this.DbaseHeader.cHeaderBytes);
        this.setHasHeader(true);
    }

    @Override
    public void f_create() {
        try {
            this.F.setLength(0L);
            this.DbaseHeader.initialize();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    @Override
    public synchronized void clearBuffer() {
        this.commitWriteBuffer();
        this.hashedFields.clear();
    }

    @Override
    public synchronized int initializeNewRecord(boolean bl) {
        int n = super.initializeNewRecord(bl);
        this.commitWriteBuffer();
        return n;
    }

    @Override
    public synchronized Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        if (this.F == null) {
            return null;
        }
        if (tDriverStructRecord == null) {
            return null;
        }
        this.commitWriteBuffer();
        Object object = null;
        String string = null;
        if (tDriverStructRecord.IsToken) {
            String string2 = TMainWin.Application.getTokenValue(tDriverStructRecord.ID);
            object = objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, string2, 0);
            return object;
        }
        Date date = new Date();
        ++this.PerformanceMark.cRead;
        if (!tDriverStructRecord.IsCalculated) {
            this.PerformanceMark.cReadBytes += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
        }
        if (this.BufferOn && (object = this.hashedFields.get(string = Integer.toString(n) + "|" + tDriverStructRecord.FullID)) != null) {
            ++this.PerformanceMark.cCached;
            this.PerformanceMark.cReadMs = (int)((long)this.PerformanceMark.cReadMs + (new Date().getTime() - date.getTime()));
            return object;
        }
        if (!tDriverStructRecord.IsVirtual && !tDriverStructRecord.IsCalculated) {
            TDbaseField tDbaseField = this.DbaseHeader.getDbaseField(tDriverStructRecord.ID);
            if (tDbaseField == null) {
                MainWin.appendToLog("TDbaseDriver", "getField", Thread.currentThread(), null, 4, "Error: dbase field: " + tDriverStructRecord.FullID + " not found in header");
                return null;
            }
            try {
                this.F.seek(this.DbaseHeader.cHeaderBytes + n * this.DbaseHeader.cRecordBytes + tDbaseField.Offset);
                this.F.read(this.arFieldBuffer, 0, tDbaseField.FieldLength);
            }
            catch (Exception exception) {
                MainWin.appendToLog("TDbaseDriver", "getField", Thread.currentThread(), exception, 4, "Error reading dbase field: " + tDriverStructRecord.FullID + " Record=" + n);
                return null;
            }
            this.strFieldBuffer.setLength(0);
            for (int i = 0; this.arFieldBuffer[i] != 0 && i < tDbaseField.FieldLength; ++i) {
                this.strFieldBuffer.append((char)this.arFieldBuffer[i]);
            }
            if (tDriverStructRecord.FieldType == 10) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.set(charutil.ival(new String(this.arFieldBuffer, 0, 4)), charutil.ival(new String(this.arFieldBuffer, 4, 2)) - 1, charutil.ival(new String(this.arFieldBuffer, 6, 2)), 0, 0, 0);
                object = gregorianCalendar.getTime();
            } else if (tDriverStructRecord.FieldType == 21) {
                String string3 = this.strFieldBuffer.toString().trim();
                if (string3.length() == 19) {
                    object = dateutil.parseDate(string3, "MM-dd-yyyy HH:mm:ss");
                } else if (string3.equalsIgnoreCase("0") || string3.trim().length() == 0) {
                    object = new Date(0L);
                } else {
                    System.out.println("invalid date/time in field " + tDriverStructRecord.ID + " value: " + string3);
                    if (string3.equalsIgnoreCase("114966")) {
                        new Throwable().printStackTrace();
                    }
                }
            } else {
                object = tDriverStructRecord.FieldType == 3 ? this.strFieldBuffer.toString().trim() : objectutil.convertStringToFieldType(tDriverStructRecord.FieldType, this.strFieldBuffer.toString(), n);
            }
        }
        if (tDriverStructRecord.IsCalculated) {
            object = this.calculateField(tDriverStructRecord, n);
        }
        if (this.BufferOn && object != null && !tDriverStructRecord.NoBuffer) {
            if (this.hashedFields.size() > 20000) {
                this.hashedFields.clear();
            }
            this.hashedFields.put(string, object);
        }
        ++this.PerformanceMark.cUpdated;
        this.PerformanceMark.cReadMs = (int)((long)this.PerformanceMark.cReadMs + (new Date().getTime() - date.getTime()));
        return object;
    }

    public synchronized void commitWriteBuffer() {
        if (this.WriteBuffer.length() > 0) {
            this.hashedFields.clear();
        }
        byte[] byArray = new byte[this.WriteBuffer.length()];
        for (int i = 0; i < this.WriteBuffer.length(); ++i) {
            byArray[i] = (byte)this.WriteBuffer.charAt(i);
        }
        try {
            this.F.seek(this.DbaseHeader.cHeaderBytes + this.WriteBufferSeek + 1);
            this.F.write(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            System.out.println("error in commitWriteBuffer: " + exception.toString());
        }
        this.WriteBufferSeek = 1;
        this.WriteBuffer.setLength(0);
    }

    @Override
    public synchronized int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        String string;
        StringBuilder stringBuilder;
        Comparable<Calendar> comparable;
        TDbaseField tDbaseField;
        if (this.F == null) {
            return 0;
        }
        if (tDriverStructRecord.IsToken) {
            String string2 = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
            TMainWin.Application.setTokenValue(tDriverStructRecord.ID, string2);
            return 1;
        }
        if (tDriverStructRecord.IsVirtual) {
            return 0;
        }
        if (object == null) {
            return 0;
        }
        ++this.PerformanceMark.cWrite;
        this.PerformanceMark.cWriteBytes += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
        Date date = new Date();
        if (this.undoManager != null && this.undoManager.isRecording()) {
            this.recordUndoEvent(tDriverStructRecord, n, this.getField(tDriverStructRecord, n), object);
        }
        if ((tDbaseField = this.DbaseHeader.getDbaseField(tDriverStructRecord.ID)) == null) {
            MainWin.appendToLog("TDbaseDriver", "putField", Thread.currentThread(), null, 4, "Dbase file does not contain field named " + tDriverStructRecord.ID);
            return 0;
        }
        if (tDriverStructRecord.FieldType == 10) {
            comparable = new GregorianCalendar();
            stringBuilder = new StringBuilder();
            ((Calendar)comparable).setTime((Date)object);
            stringBuilder.append(Integer.toString(((Calendar)comparable).get(1)));
            string = Integer.toString(((Calendar)comparable).get(2) + 1);
            if (string.length() < 2) {
                stringBuilder.append("0");
            }
            stringBuilder.append(string);
            string = Integer.toString(((Calendar)comparable).get(5));
            if (string.length() < 2) {
                stringBuilder.append("0");
            }
            stringBuilder.append(string);
            string = stringBuilder.toString();
        } else if (tDriverStructRecord.FieldType == 21) {
            comparable = new GregorianCalendar();
            stringBuilder = new StringBuilder();
            string = dateutil.formatDate((Date)object, "MM-dd-yyyy HH:mm:ss");
        } else {
            string = objectutil.convertFieldTypeToString(tDriverStructRecord.FieldType, object);
            if (objectutil.isNumberField(tDriverStructRecord.FieldType)) {
                while (string.length() < tDbaseField.FieldLength) {
                    string = " " + string;
                }
            }
        }
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append(string);
        if (tDbaseField.FieldLength < ((StringBuilder)comparable).length()) {
            ((StringBuilder)comparable).setLength(tDbaseField.FieldLength);
        } else {
            while (((StringBuilder)comparable).length() < tDbaseField.FieldLength) {
                ((StringBuilder)comparable).append(" ");
            }
        }
        int n2 = this.DbaseHeader.cHeaderBytes + n * this.DbaseHeader.cRecordBytes + tDbaseField.Offset;
        int n3 = this.DbaseHeader.cHeaderBytes + this.WriteBufferSeek + this.WriteBuffer.length() + 1;
        if (n3 == n2) {
            this.WriteBuffer.append((CharSequence)((Object)comparable));
        } else {
            this.commitWriteBuffer();
            this.WriteBuffer.append((CharSequence)((Object)comparable));
            this.WriteBufferSeek = n * this.DbaseHeader.cRecordBytes + tDbaseField.Offset - 1;
        }
        this.setModified(true);
        this.PerformanceMark.cWriteMs = (int)((long)this.PerformanceMark.cWriteMs + (new Date().getTime() - date.getTime()));
        return 1;
    }

    private class TDbaseField {
        String FieldName = null;
        char Type = '\u0000';
        byte[] MemAddr = new byte[4];
        int FieldLength = 0;
        byte DecimalCount = 0;
        byte[] Reserved1 = new byte[2];
        byte WorkArea = 0;
        byte[] MultiUser = new byte[2];
        byte SetFields = 0;
        byte[] Reserved2 = new byte[7];
        byte MdxIndex = 0;
        int Offset = 0;

        public String toString() {
            String string = "FieldName: " + this.FieldName + " Type: " + this.Type + " FieldLength; " + this.FieldLength;
            return string;
        }
    }

    private class TDbaseHeader {
        byte Version = 0;
        byte Year = 0;
        byte Month = 0;
        byte Day = 0;
        int cRecords = 0;
        short cHeaderBytes = 0;
        short cRecordBytes = 0;
        byte[] Reserved1 = new byte[2];
        byte Transaction = 0;
        byte Encrypted = 0;
        byte[] MultiUser = new byte[12];
        byte Production_Index = 0;
        byte Language_Driver = 0;
        byte[] Reserved2 = new byte[2];
        ArrayList arField = new ArrayList();
        Hashtable hashFieldNames = new Hashtable();

        public void outputHeader() {
            int n;
            System.out.println("Version=" + this.Version);
            System.out.println("Year=" + this.Year);
            System.out.println("Month=" + this.Month);
            System.out.println("Day=" + this.Day);
            System.out.println("cRecords=" + this.cRecords);
            System.out.println("cHeaderBytes=" + this.cHeaderBytes);
            System.out.println("cRecordBytes=" + this.cRecordBytes);
            System.out.println("Reserved1=" + this.Reserved1[0] + " " + this.Reserved1[1]);
            System.out.println("Transaction=" + this.Transaction);
            System.out.println("Encrypted=" + this.Encrypted);
            System.out.print("MultiUser=");
            for (n = 0; n < 12; ++n) {
                System.out.print(this.MultiUser[n] + " ");
            }
            System.out.println();
            System.out.println("Production_Index=" + this.Production_Index);
            System.out.println("Language_Driver=" + this.Language_Driver);
            System.out.println("Reserved2=" + this.Reserved2[0] + " " + this.Reserved2[1]);
            System.out.println();
            for (n = 0; n < this.arField.size(); ++n) {
                TDbaseField tDbaseField = (TDbaseField)this.arField.get(n);
                System.out.print(n + "\t");
                System.out.print("Name:\t" + tDbaseField.FieldName + "\t");
                System.out.print("Type:\t" + tDbaseField.Type + "\t");
                System.out.print("Len:\t" + tDbaseField.FieldLength + "\t");
            }
        }

        public void initialize() {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            int n = 0;
            gregorianCalendar.setTime(new Date());
            this.Version = (byte)3;
            this.Year = (byte)(gregorianCalendar.get(1) - 1900);
            this.Month = (byte)gregorianCalendar.get(2);
            this.Day = (byte)gregorianCalendar.get(5);
            this.cRecords = 0;
            this.cHeaderBytes = (short)32;
            this.cRecordBytes = 0;
            this.Reserved1[0] = 0;
            this.Reserved1[1] = 0;
            this.Transaction = 0;
            this.Encrypted = 0;
            this.MultiUser = new byte[12];
            this.Production_Index = 1;
            this.Language_Driver = 0;
            this.Reserved2[0] = 0;
            this.Reserved2[1] = 0;
            this.arField.clear();
            TDbaseField tDbaseField = new TDbaseField();
            tDbaseField.FieldName = "Deleted";
            tDbaseField.Type = (char)67;
            tDbaseField.Offset = n;
            tDbaseField.FieldLength = 1;
            this.arField.add(tDbaseField);
            n += tDbaseField.FieldLength;
            this.cHeaderBytes = (short)64;
            this.cRecordBytes = 1;
            for (int i = 0; i < TDbaseDriver.this.DriverStruct.FieldColl.size(); ++i) {
                int n2;
                TDriverStructRecord tDriverStructRecord = (TDriverStructRecord)TDbaseDriver.this.DriverStruct.FieldColl.get(i);
                if (tDriverStructRecord.IsToken || tDriverStructRecord.IsVirtual) continue;
                tDbaseField = new TDbaseField();
                if (tDriverStructRecord.ID.length() > 11) {
                    MainWin.appendToLog("TDbaseDriver", "DbaseHeader.Initialize", Thread.currentThread(), null, 4, "Field name '" + tDriverStructRecord.ID + "' in dBase file is more than 11 characters,");
                }
                stringBuilder.setLength(0);
                for (n2 = 0; n2 < 11 && n2 < tDriverStructRecord.ID.length(); ++n2) {
                    stringBuilder.append(tDriverStructRecord.ID.charAt(n2));
                }
                tDbaseField.FieldName = stringBuilder.toString();
                switch (tDriverStructRecord.FieldType) {
                    case 1: 
                    case 19: {
                        tDbaseField.Type = (char)76;
                        tDbaseField.FieldLength = 1;
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 12: {
                        tDbaseField.Type = (char)78;
                        tDbaseField.FieldLength = 10;
                        tDbaseField.DecimalCount = (byte)tDriverStructRecord.Decimals;
                        break;
                    }
                    case 3: 
                    case 11: 
                    case 15: 
                    case 16: 
                    case 20: 
                    case 22: 
                    case 24: 
                    case 25: 
                    case 26: {
                        tDbaseField.Type = (char)67;
                        tDbaseField.FieldLength = (byte)tDriverStructRecord.ArraySize;
                        break;
                    }
                    case 10: 
                    case 13: 
                    case 18: {
                        tDbaseField.Type = (char)68;
                        tDbaseField.FieldLength = 8;
                        break;
                    }
                    case 21: {
                        tDbaseField.Type = (char)67;
                        tDbaseField.FieldLength = 19;
                        break;
                    }
                    default: {
                        tDbaseField.Type = (char)67;
                        tDbaseField.FieldLength = (byte)tDriverStructRecord.ArraySize;
                    }
                }
                if (tDbaseField.FieldLength == 0) {
                    System.out.println("!!!!!!!!!!!!!!!FieldLength of " + tDbaseField.FieldName + " = 0");
                }
                if (tDbaseField.FieldLength > 127 || tDbaseField.FieldLength < 0) {
                    System.out.println("!!!!!!!!!!!!!!!FieldLength of " + tDbaseField.FieldName + " [" + tDbaseField.FieldLength + "] is over 127");
                }
                tDbaseField.Offset = n;
                n += tDbaseField.FieldLength;
                for (n2 = 0; n2 < 4; ++n2) {
                    tDbaseField.MemAddr[n2] = 0;
                }
                for (n2 = 0; n2 < 2; ++n2) {
                    tDbaseField.Reserved1[n2] = 0;
                }
                tDbaseField.WorkArea = 0;
                for (n2 = 0; n2 < 2; ++n2) {
                    tDbaseField.MultiUser[n2] = 0;
                }
                tDbaseField.SetFields = 0;
                for (n2 = 0; n2 < 7; ++n2) {
                    tDbaseField.Reserved2[n2] = 0;
                }
                tDbaseField.MdxIndex = 0;
                this.arField.add(tDbaseField);
                if (i > 0) {
                    this.cHeaderBytes = (short)(this.cHeaderBytes + 32);
                }
                this.cRecordBytes = (short)(this.cRecordBytes + tDbaseField.FieldLength);
            }
            this.cHeaderBytes = (short)(this.cHeaderBytes + 1);
            TDbaseDriver.this.HeaderSize = this.cHeaderBytes;
            TDbaseDriver.this.RecordSize = this.cRecordBytes;
            this.writeHeader();
        }

        public void readHeader() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            byte[] byArray = new byte[32];
            boolean bl = false;
            if (TDbaseDriver.this.Debug) {
                MainWin.appendToLog("TDbaseDriver", "TDbaseHeader.readHeader", Thread.currentThread(), null, 3, "Reading dBase header");
            }
            TDbaseDriver.this.HeaderSize = 0;
            TDbaseDriver.this.RecordSize = 0;
            try {
                TDbaseDriver.this.F.seek(0L);
                TDbaseDriver.this.F.read(byArray);
            }
            catch (Exception exception) {
                MainWin.appendToLog("TDbaseDriver", "TDbaseHeader.read", Thread.currentThread(), exception, 3, "Error reading dbase file header.");
            }
            this.Version = byArray[0];
            this.Year = byArray[1];
            this.Month = byArray[2];
            this.Day = byArray[3];
            this.cRecords = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt(4);
            this.cHeaderBytes = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getShort(8);
            this.cRecordBytes = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getShort(10);
            ByteBuffer.wrap(byArray, 12, 2).get(this.Reserved1, 0, 2);
            this.Transaction = byArray[14];
            this.Encrypted = byArray[15];
            ByteBuffer.wrap(byArray, 16, 12).get(this.MultiUser, 0, 12);
            this.Production_Index = byArray[28];
            this.Language_Driver = byArray[29];
            ByteBuffer.wrap(byArray, 30, 2).get(this.Reserved2, 0, 2);
            if (TDbaseDriver.this.Debug) {
                this.outputHeader();
            }
            this.arField.clear();
            TDbaseDriver.this.HeaderSize = 32;
            TDbaseField tDbaseField = new TDbaseField();
            tDbaseField.FieldName = "Deleted";
            tDbaseField.Type = (char)67;
            tDbaseField.Offset = n++;
            tDbaseField.FieldLength = 1;
            ++TDbaseDriver.this.RecordSize;
            this.arField.add(tDbaseField);
            this.hashFieldNames.put(tDbaseField.FieldName.toUpperCase().trim(), new Integer(this.arField.size() - 1));
            do {
                try {
                    TDbaseDriver.this.F.read(byArray);
                }
                catch (Exception exception) {
                    MainWin.appendToLog("TDbaseDriver", "TDbaseHeader.read", Thread.currentThread(), exception, 3, "Error reading dbase file header.");
                }
                if (byArray[0] == 13) {
                    bl = true;
                    ++TDbaseDriver.this.HeaderSize;
                    continue;
                }
                tDbaseField = new TDbaseField();
                stringBuilder.setLength(0);
                boolean bl2 = false;
                for (int i = 0; !bl2 && i < 11; ++i) {
                    if (byArray[i] > 0) {
                        stringBuilder.append((char)byArray[i]);
                        continue;
                    }
                    bl2 = true;
                }
                tDbaseField.FieldName = stringBuilder.toString();
                tDbaseField.Type = (char)byArray[11];
                ByteBuffer.wrap(byArray, 12, 4).get(tDbaseField.MemAddr, 0, 4);
                tDbaseField.FieldLength = 0xFF & byArray[16];
                tDbaseField.DecimalCount = byArray[17];
                ByteBuffer.wrap(byArray, 18, 2).get(tDbaseField.Reserved1, 0, 2);
                tDbaseField.WorkArea = byArray[20];
                ByteBuffer.wrap(byArray, 21, 2).get(tDbaseField.MultiUser, 0, 2);
                tDbaseField.SetFields = byArray[23];
                ByteBuffer.wrap(byArray, 24, 7).get(tDbaseField.Reserved2, 0, 7);
                tDbaseField.MdxIndex = byArray[31];
                tDbaseField.Offset = n;
                n += tDbaseField.FieldLength;
                if (TDbaseDriver.this.Debug) {
                    MainWin.appendToLog("TDbaseDriver", "TDbaseHeader.read", Thread.currentThread(), null, 3, "Dbase FieldName=" + tDbaseField.FieldName + " Type=" + tDbaseField.Type + " Length=" + tDbaseField.FieldLength + " Decimals=" + tDbaseField.DecimalCount);
                }
                this.arField.add(tDbaseField);
                this.hashFieldNames.put(tDbaseField.FieldName.toUpperCase().trim(), new Integer(this.arField.size() - 1));
                TDbaseDriver.this.HeaderSize += 32;
                TDbaseDriver.this.RecordSize += tDbaseField.FieldLength;
            } while (!bl);
            if (TDbaseDriver.this.HeaderSize != this.cHeaderBytes) {
                MainWin.appendToLog("TDbaseDriver", "TDbaseHeader.read", Thread.currentThread(), null, 3, "Error in dBase header size.  Physical size: " + TDbaseDriver.this.HeaderSize + " Reported size: " + this.cHeaderBytes + " Filename: " + TDbaseDriver.this.FileName);
            }
            if (TDbaseDriver.this.RecordSize != this.cRecordBytes) {
                MainWin.appendToLog("TDbaseDriver", "TDbaseHeader.read", Thread.currentThread(), null, 3, "Error in dBase record size.  Physical size: " + TDbaseDriver.this.RecordSize + " Reported size: " + this.cRecordBytes + " Filename: " + TDbaseDriver.this.FileName);
            }
        }

        public void writeHeader() {
            byte[] byArray = new byte[32];
            if (TDbaseDriver.this.Debug) {
                MainWin.appendToLog("TDbaseDriver", "TDbaseHeader.readHeader", Thread.currentThread(), null, 3, "Writing dBase header");
            }
            try {
                TDbaseDriver.this.F.seek(0L);
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(new Date());
                byArray[0] = this.Version;
                byArray[1] = (byte)(gregorianCalendar.get(1) - 1900);
                byArray[2] = (byte)(gregorianCalendar.get(2) + 1);
                byArray[3] = (byte)gregorianCalendar.get(5);
                ByteBuffer.wrap(byArray, 4, 4).order(ByteOrder.LITTLE_ENDIAN).putInt(this.cRecords);
                ByteBuffer.wrap(byArray, 8, 2).order(ByteOrder.LITTLE_ENDIAN).putShort(this.cHeaderBytes);
                ByteBuffer.wrap(byArray, 10, 2).order(ByteOrder.LITTLE_ENDIAN).putShort((short)TDbaseDriver.this.RecordSize);
                ByteBuffer.wrap(byArray, 12, 2).put(this.Reserved1, 0, 2);
                byArray[14] = this.Transaction;
                byArray[15] = this.Encrypted;
                ByteBuffer.wrap(byArray, 16, 12).put(this.MultiUser, 0, 12);
                byArray[28] = this.Production_Index;
                byArray[29] = this.Language_Driver;
                ByteBuffer.wrap(byArray, 30, 2).put(this.Reserved2, 0, 2);
                TDbaseDriver.this.F.write(byArray);
                for (int i = 1; i < this.arField.size(); ++i) {
                    int n;
                    TDbaseField tDbaseField = (TDbaseField)this.arField.get(i);
                    for (n = 0; n < byArray.length; ++n) {
                        byArray[n] = 0;
                    }
                    for (n = 0; n < 11 && n < tDbaseField.FieldName.length(); ++n) {
                        byArray[n] = (byte)tDbaseField.FieldName.charAt(n);
                    }
                    byArray[11] = (byte)tDbaseField.Type;
                    ByteBuffer.wrap(byArray, 12, 4).put(tDbaseField.MemAddr, 0, 4);
                    byArray[16] = (byte)tDbaseField.FieldLength;
                    byArray[17] = tDbaseField.DecimalCount;
                    ByteBuffer.wrap(byArray, 18, 2).put(tDbaseField.Reserved1, 0, 2);
                    byArray[20] = tDbaseField.WorkArea;
                    ByteBuffer.wrap(byArray, 21, 2).put(tDbaseField.MultiUser, 0, 2);
                    byArray[23] = tDbaseField.SetFields;
                    ByteBuffer.wrap(byArray, 24, 7).put(tDbaseField.Reserved2, 0, 7);
                    byArray[31] = tDbaseField.MdxIndex;
                    TDbaseDriver.this.F.write(byArray);
                }
                byArray[0] = 13;
                TDbaseDriver.this.F.write(byArray, 0, 1);
            }
            catch (Exception exception) {
                MainWin.appendToLog("TDbaseDriver", "TDbaseHeader.read", Thread.currentThread(), exception, 3, "Error initializing dBase file header.");
                new Throwable().printStackTrace();
            }
        }

        public void updateHeader() {
            byte[] byArray = new byte[32];
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            if (TDbaseDriver.this.Debug) {
                MainWin.appendToLog("TDbaseDriver", "TDbaseHeader.readHeader", Thread.currentThread(), null, 3, "Updating dBase header");
            }
            gregorianCalendar.setTime(new Date());
            try {
                TDbaseDriver.this.F.seek(1L);
                byArray[1] = (byte)(gregorianCalendar.get(1) - 1900);
                byArray[2] = (byte)(gregorianCalendar.get(2) + 1);
                byArray[3] = (byte)gregorianCalendar.get(5);
                ByteBuffer.wrap(byArray, 4, 4).order(ByteOrder.LITTLE_ENDIAN).putInt(TDbaseDriver.this.getRecordCount());
                TDbaseDriver.this.F.write(byArray, 1, 7);
                int n = this.cHeaderBytes + TDbaseDriver.this.getRecordCount() * this.cRecordBytes;
                if (TDbaseDriver.this.F.length() == (long)n) {
                    TDbaseDriver.this.F.seek(TDbaseDriver.this.F.length());
                    byArray[0] = 26;
                    TDbaseDriver.this.F.write(byArray, 0, 1);
                }
            }
            catch (Exception exception) {
                MainWin.appendToLog("TDbaseDriver", "TDbaseHeader.read", Thread.currentThread(), exception, 3, "Error updating dbase file header.");
            }
        }

        public TDbaseField getDbaseField(String string) {
            Object v = this.hashFieldNames.get(string.toUpperCase());
            if (v == null) {
                return null;
            }
            return (TDbaseField)this.arField.get((Integer)v);
        }

        public boolean setFieldLength(String string, byte by) {
            TDbaseField tDbaseField = this.getDbaseField(string);
            if (tDbaseField != null) {
                tDbaseField.FieldLength = by;
                if (TDbaseDriver.this.Debug) {
                    MainWin.appendToLog("TDbaseDriver", "setFieldLength", Thread.currentThread(), null, 3, "Set dbase Field length of " + string + " to " + by);
                }
                this.cRecordBytes = 0;
                for (int i = 0; i < this.arField.size(); ++i) {
                    tDbaseField = (TDbaseField)this.arField.get(i);
                    tDbaseField.Offset = this.cRecordBytes;
                    this.cRecordBytes = (short)(this.cRecordBytes + tDbaseField.FieldLength);
                }
                this.writeHeader();
                return true;
            }
            MainWin.appendToLog("TDbaseDriver", "setFieldLength", Thread.currentThread(), null, 3, "Error setting dbase Field length: " + string);
            return false;
        }
    }
}

