/*
 * Decompiled with CFR 0.152.
 */
package drivers.files;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TDriverInterface;
import drivers.files.TAspectFileHeader;
import drivers.files.TBinaryFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.dosutil;

public class TAspectFile
extends TBinaryFile
implements TDriverInterface {
    private TMainWin MainWin = Aspect.MainWin;
    private TAspectFileHeader FileHeaderRec = new TAspectFileHeader();

    public TAspectFile(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) throws IOException {
        super(tApplication, tAppDriversObject, n, bl);
    }

    public static int validateFileHeader(String string, int n, boolean bl) {
        RandomAccessFile randomAccessFile;
        long l = 0L;
        try {
            randomAccessFile = bl ? new RandomAccessFile(string, "rwd") : new RandomAccessFile(string, "r");
            l = randomAccessFile.length();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return -1;
        }
        long l2 = l - 290L;
        long l3 = l % (long)n;
        long l4 = l2 % (long)n;
        TAspectFileHeader tAspectFileHeader = TAspectFile.getFileHeader(randomAccessFile);
        System.out.println("Header Reserved=" + tAspectFileHeader.getReservedString());
        if (tAspectFileHeader.getReservedString().equalsIgnoreCase("aspect file header")) {
            if (l4 == 0L) {
                Aspect.MainWin.appendToLog("TAspectFile", "validateFileHeader", Thread.currentThread(), null, 3, "TAspectFile[0] Filename=" + string + " File size and header are valid");
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return 0;
            }
            if (bl) {
                String string2 = "aspect file header";
                for (int i = 0; i < string2.length(); ++i) {
                    tAspectFileHeader.Reserved[i] = (byte)string2.charAt(i);
                }
                tAspectFileHeader.RecSize = (short)n;
                tAspectFileHeader.Aspect_Version = 2.0f;
                tAspectFileHeader.Program_Version = 0.0f;
                TAspectFile.putFileHeader(randomAccessFile, tAspectFileHeader);
            }
            if (l3 == 0L) {
                Aspect.MainWin.appendToLog("TAspectFile", "validateFileHeader", Thread.currentThread(), null, 3, "TAspectFile[1] Filename=" + string + " File has a header but filesize is a multiple of the record size.");
                if (bl) {
                    long l5 = (long)Math.floor(l2 / (long)n);
                    long l6 = 290L + l5 * (long)n;
                    try {
                        randomAccessFile.setLength(l6);
                        Aspect.MainWin.appendToLog("TAspectFile", "validateFileHeader", Thread.currentThread(), null, 3, "TAspectFile[1] Filename=" + string + "  Corrected header and truncated file.to " + l5 + " records");
                    }
                    catch (Exception exception) {
                        Aspect.MainWin.appendToLog("TAspectFile", "validateFileHeader", Thread.currentThread(), null, 3, "TAspectFile[1] Filename=" + string + "  Unable to truncate file");
                    }
                }
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return 1;
            }
            Aspect.MainWin.appendToLog("TAspectFile", "validateFileHeader", Thread.currentThread(), null, 3, "TAspectFile[2] Filename=" + string + " File is an invalid size.");
            if (bl) {
                long l7 = (long)Math.floor(l2 / (long)n);
                long l8 = 290L + l7 * (long)n;
                try {
                    randomAccessFile.setLength(l8);
                    Aspect.MainWin.appendToLog("TAspectFile", "validateFileHeader", Thread.currentThread(), null, 3, "TAspectFile[2] Filename=" + string + "  Corrected header and truncated file.to " + l7 + " records");
                }
                catch (Exception exception) {
                    Aspect.MainWin.appendToLog("TAspectFile", "validateFileHeader", Thread.currentThread(), null, 3, "TAspectFile[2] Filename=" + string + "  Unable to truncate file");
                }
            }
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 2;
        }
        if (l3 == 0L) {
            Aspect.MainWin.appendToLog("TAspectFile", "validateFileHeader", Thread.currentThread(), null, 3, "TAspectFile[4] Filename=" + string + " File does not have a header and the file size is a multiple of the record size");
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                try {
                    String string3 = dosutil.getFileDrive(string) + dosutil.getFileDir(string) + dosutil.getFileName(string) + ".$$$";
                    File file = new File(string3);
                    if (file.exists()) {
                        dosutil.deleteFile(file);
                    }
                    File file2 = new File(string);
                    file2.renameTo(file);
                    randomAccessFile = new RandomAccessFile(string, "rwd");
                    String string4 = "aspect file header";
                    for (int i = 0; i < string4.length(); ++i) {
                        tAspectFileHeader.Reserved[i] = (byte)string4.charAt(i);
                    }
                    tAspectFileHeader.RecSize = (short)n;
                    tAspectFileHeader.Aspect_Version = 2.0f;
                    tAspectFileHeader.Program_Version = 0.0f;
                    TAspectFile.putFileHeader(randomAccessFile, tAspectFileHeader);
                    try {
                        randomAccessFile.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    dosutil.copyFile(string3, string, 0, true, "", "", "");
                    Aspect.MainWin.appendToLog("TAspectFile", "validateFileHeader", Thread.currentThread(), null, 3, "TAspectFile[4] Filename=" + string + " Added header to file");
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                }
            }
            return 3;
        }
        if (l4 == 0L) {
            System.out.println("TAspectFile[4] Filename=" + string + " File does not have a valid header but the size indicates it does.");
            if (bl) {
                String string5 = "aspect file header";
                for (int i = 0; i < string5.length(); ++i) {
                    tAspectFileHeader.Reserved[i] = (byte)string5.charAt(i);
                }
                tAspectFileHeader.RecSize = (short)n;
                tAspectFileHeader.Aspect_Version = 2.0f;
                tAspectFileHeader.Program_Version = 0.0f;
                TAspectFile.putFileHeader(randomAccessFile, tAspectFileHeader);
                Aspect.MainWin.appendToLog("TAspectFile", "validateFileHeader", Thread.currentThread(), null, 3, "TAspectFile[4] Filename=" + string + " Corrected file header.");
            }
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 4;
        }
        System.out.println("TAspectFile[5] Filename=" + string + "  File does not have a header and is invalid size.");
        if (bl) {
            long l9 = (long)Math.floor(l / (long)n);
            long l10 = l9 * (long)n;
            try {
                randomAccessFile.setLength(l10);
                Aspect.MainWin.appendToLog("TAspectFile", "validateFileHeader", Thread.currentThread(), null, 3, "TAspectFile[5] Filename=" + string + " Truncated file.to " + l9 + " records");
            }
            catch (Exception exception) {
                Aspect.MainWin.appendToLog("TAspectFile", "validateFileHeader", Thread.currentThread(), null, 3, "TAspectFile[5] Filename=" + string + "  Unable to truncate file");
            }
        }
        try {
            randomAccessFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 5;
    }

    @Override
    public void getFileHeader() {
        byte[] byArray = new byte[290];
        try {
            this.seek(0L);
            this.read(this.FileHeaderRec.Reserved);
            this.FileHeaderRec.RecSize = this.getShort();
            this.FileHeaderRec.Aspect_Version = this.getFloat();
            this.FileHeaderRec.Program_Version = this.getFloat();
            this.read(this.FileHeaderRec.Unused);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        String string = new String(this.FileHeaderRec.Reserved, 0, this.FileHeaderRec.Reserved.length);
        if (this.FileHeaderRec.getReservedString().equalsIgnoreCase("aspect file header")) {
            this.setHasHeader(true);
            this.setHeaderSize(290);
        }
    }

    public static TAspectFileHeader getFileHeader(RandomAccessFile randomAccessFile) {
        TAspectFileHeader tAspectFileHeader = new TAspectFileHeader();
        try {
            randomAccessFile.seek(0L);
            randomAccessFile.read(tAspectFileHeader.Reserved);
            tAspectFileHeader.RecSize = TBinaryFile.getShort(randomAccessFile);
            tAspectFileHeader.Aspect_Version = TAspectFile.getFloat(randomAccessFile);
            tAspectFileHeader.Program_Version = TAspectFile.getFloat(randomAccessFile);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        return tAspectFileHeader;
    }

    public static void putFileHeader(RandomAccessFile randomAccessFile, TAspectFileHeader tAspectFileHeader) {
        try {
            randomAccessFile.seek(0L);
            randomAccessFile.write(tAspectFileHeader.Reserved);
            TBinaryFile.putShort(randomAccessFile, tAspectFileHeader.RecSize);
            TBinaryFile.putFloat(randomAccessFile, tAspectFileHeader.Aspect_Version);
            TBinaryFile.putFloat(randomAccessFile, tAspectFileHeader.Program_Version);
            TBinaryFile.write(randomAccessFile, tAspectFileHeader.Unused);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }
}

