/*
 * Decompiled with CFR 0.152.
 */
package drivers.external_data;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TDriverStructRecord;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Hashtable;
import resources.TAppDriversObject;
import resources.TApplication;

public class TExternalDataDriver
extends TAbstractDriver {
    private TMainWin MainWin = Aspect.MainWin;
    public RandomAccessFile F;
    ArrayList arFields = new ArrayList();
    Hashtable hashDataID = new Hashtable();

    public TExternalDataDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        super(tApplication, tAppDriversObject, n, bl);
    }

    @Override
    public void dispose() {
        this.arFields.clear();
        this.hashDataID.clear();
        try {
            this.F.close();
        }
        catch (Exception exception) {
            this.MainWin.appendToLog("TExternalDataDriver", "dispose", Thread.currentThread(), exception, 3, "Error closing file: " + this.FileName);
        }
    }

    @Override
    public int makeEditableFile() {
        try {
            this.F = new RandomAccessFile(this.FileName, "rwd");
        }
        catch (Exception exception) {
            this.MainWin.appendToLog("TExternalDataDriver", "dispose", Thread.currentThread(), exception, 3, "Error opening file: " + this.FileName);
        }
        this.initializeHashtable();
        return 1;
    }

    @Override
    public int getRecordCount() {
        return this.arFields.size();
    }

    public boolean initializeHashtable() {
        this.arFields.clear();
        this.hashDataID.clear();
        try {
            this.F.seek(0L);
            byte[] byArray = new byte[4];
            byte[] byArray2 = new byte[65535];
            while (this.F.getFilePointer() < this.F.length()) {
                int n = (int)this.F.getFilePointer();
                StringBuilder stringBuilder = new StringBuilder();
                this.F.read(byArray2, 0, 9);
                for (int i = 0; i < 9; ++i) {
                    stringBuilder.append((char)byArray2[i]);
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                int n2 = this.F.readInt();
                this.F.read(byArray2, 0, n2);
                for (int i = 0; i < n2; ++i) {
                    stringBuilder2.append((char)byArray2[i]);
                }
                StringBuilder stringBuilder3 = new StringBuilder();
                n2 = this.F.readInt();
                this.F.read(byArray2, 0, n2);
                for (int i = 0; i < n2; ++i) {
                    stringBuilder3.append((char)byArray2[i]);
                }
                StringBuilder stringBuilder4 = new StringBuilder();
                n2 = this.F.readInt();
                this.F.read(byArray2, 0, n2);
                for (int i = 0; i < n2; ++i) {
                    stringBuilder4.append((char)byArray2[i]);
                }
                TExternalDataObj tExternalDataObj = new TExternalDataObj(this.arFields.size(), n, stringBuilder.toString(), stringBuilder2.toString(), stringBuilder3.toString(), stringBuilder4.toString());
                this.arFields.add(tExternalDataObj);
                this.hashDataID.put(tExternalDataObj.getDataID(), tExternalDataObj);
            }
        }
        catch (Exception exception) {
            this.MainWin.appendToLog("TExternalDataDriver", "readRecordHeaders", Thread.currentThread(), exception, 4, "Error initializing TExternalDataDriver: " + this.FileName);
        }
        return true;
    }

    public TExternalDataObj addRecord(TExternalDataObj tExternalDataObj) {
        this.arFields.add(tExternalDataObj);
        this.hashDataID.put(tExternalDataObj.getDataID(), tExternalDataObj);
        tExternalDataObj.Index = this.arFields.size() - 1;
        try {
            tExternalDataObj.Offset = (int)this.F.length();
        }
        catch (Exception exception) {
            tExternalDataObj.Offset = -1;
            this.MainWin.appendToLog("TExternalDataDriver", "addRecord", Thread.currentThread(), exception, 4, "Error setting offset");
        }
        System.out.println("addRecord: " + tExternalDataObj.toString());
        return tExternalDataObj;
    }

    public void writeRecord(TExternalDataObj tExternalDataObj) {
        try {
            this.F.seek(tExternalDataObj.Offset);
            this.F.writeBytes(tExternalDataObj.getHashID());
            this.F.writeInt(tExternalDataObj.getFieldIDLength());
            this.F.writeBytes(tExternalDataObj.getFieldID());
            this.F.writeInt(tExternalDataObj.getKeyLength());
            this.F.writeBytes(tExternalDataObj.getKey());
            this.F.writeInt(tExternalDataObj.getDataLength());
            this.F.writeBytes(tExternalDataObj.getData());
        }
        catch (Exception exception) {
            this.MainWin.appendToLog("TExternalDataDriver", "writeRecord", Thread.currentThread(), exception, 4, "Error in writeRecord");
        }
    }

    public void deleteRecord(TExternalDataObj tExternalDataObj) {
        tExternalDataObj.setHashID("*DELETED*");
        this.writeRecord(tExternalDataObj);
        this.hashDataID.remove(tExternalDataObj);
    }

    public boolean deleteRecord(String string, String string2, String string3) {
        TExternalDataObj tExternalDataObj = (TExternalDataObj)this.hashDataID.get(new TExternalDataObj(string, string2, string3).getDataID());
        if (tExternalDataObj == null) {
            return false;
        }
        this.deleteRecord(tExternalDataObj);
        return true;
    }

    public Object getField(String string, String string2, String string3) {
        TExternalDataObj tExternalDataObj = (TExternalDataObj)this.hashDataID.get(new TExternalDataObj(string, string2, string3).getDataID());
        if (tExternalDataObj == null) {
            return null;
        }
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField("Data");
        return this.getField(tDriverStructRecord, tExternalDataObj.getIndex());
    }

    @Override
    public Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        if (n >= this.arFields.size()) {
            this.MainWin.appendToLog("TExternalDataDriver", "getField", Thread.currentThread(), null, 4, "Record is out of bounds: " + n);
            return null;
        }
        TExternalDataObj tExternalDataObj = (TExternalDataObj)this.arFields.get(n);
        if (tDriverStructRecord.ID.equalsIgnoreCase("DataID")) {
            return tExternalDataObj.getDataID();
        }
        if (tDriverStructRecord.ID.equalsIgnoreCase("Index")) {
            return new Integer(tExternalDataObj.getIndex());
        }
        if (tDriverStructRecord.ID.equalsIgnoreCase("Offset")) {
            return new Integer(tExternalDataObj.getOffset());
        }
        if (tDriverStructRecord.ID.equalsIgnoreCase("HashID")) {
            return tExternalDataObj.getHashID();
        }
        if (tDriverStructRecord.ID.equalsIgnoreCase("FieldID_Length")) {
            return new Integer(tExternalDataObj.getFieldIDLength());
        }
        if (tDriverStructRecord.ID.equalsIgnoreCase("FieldID")) {
            return tExternalDataObj.getFieldID();
        }
        if (tDriverStructRecord.ID.equalsIgnoreCase("Key_Length")) {
            return new Integer(tExternalDataObj.getKeyLength());
        }
        if (tDriverStructRecord.ID.equalsIgnoreCase("Key")) {
            return tExternalDataObj.getKey();
        }
        if (tDriverStructRecord.ID.equalsIgnoreCase("Data_Length")) {
            return new Integer(tExternalDataObj.getDataLength());
        }
        if (tDriverStructRecord.ID.equalsIgnoreCase("Data")) {
            return tExternalDataObj.getData();
        }
        this.MainWin.appendToLog("TExternalDataDriver", "getField", Thread.currentThread(), null, 4, "Unrecognized Field ID in getField: " + tDriverStructRecord.ID);
        return null;
    }

    public int putField(String string, String string2, String string3, String string4) {
        TExternalDataObj tExternalDataObj = (TExternalDataObj)this.hashDataID.get(new TExternalDataObj(string, string2, string3).getDataID());
        if (tExternalDataObj == null) {
            tExternalDataObj = new TExternalDataObj(-1, -1, string, string2, string3, string4);
            this.addRecord(tExternalDataObj);
        }
        TDriverStructRecord tDriverStructRecord = this.DriverStruct.getField("Data");
        return this.putField(tDriverStructRecord, tExternalDataObj.getIndex(), (Object)string4);
    }

    @Override
    public int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        if (tDriverStructRecord.ID.equalsIgnoreCase("DATA") || tDriverStructRecord.ID.equalsIgnoreCase("HashID")) {
            TExternalDataObj tExternalDataObj = (TExternalDataObj)this.arFields.get(n);
            if (((String)object).length() == 0) {
                this.deleteRecord(tExternalDataObj);
                return 1;
            }
            TExternalDataObj tExternalDataObj2 = tExternalDataObj.duplicate();
            if (tDriverStructRecord.ID.equalsIgnoreCase("DATA")) {
                tExternalDataObj.setData((String)object);
            } else if (tDriverStructRecord.ID.equalsIgnoreCase("HashID")) {
                tExternalDataObj.setHashID((String)object);
            }
            if (tExternalDataObj.getSize() != tExternalDataObj2.getSize()) {
                this.deleteRecord(tExternalDataObj2);
                this.addRecord(tExternalDataObj);
            }
            this.writeRecord(tExternalDataObj);
            return 1;
        }
        this.MainWin.appendToLog("TExternalDataDriver", "putField", Thread.currentThread(), null, 3, "Unrecognized field ID in putField: " + tDriverStructRecord.ID);
        return 0;
    }

    private class TExternalDataObj {
        int Index = -1;
        int Offset = -1;
        StringBuilder HashID = new StringBuilder();
        StringBuilder FieldID = new StringBuilder();
        StringBuilder sKey = new StringBuilder();
        StringBuilder Data = new StringBuilder();

        TExternalDataObj(String string, String string2, String string3) {
            this.HashID.append(string);
            if (this.HashID.length() > 9) {
                this.HashID.setLength(9);
            }
            while (this.HashID.length() < 9) {
                this.HashID.append(" ");
            }
            this.FieldID.append(string2);
            this.sKey.append(string3);
        }

        TExternalDataObj(int n, int n2, String string, String string2, String string3, String string4) {
            this.Index = n;
            this.Offset = n2;
            this.HashID.append(string);
            if (this.HashID.length() > 9) {
                this.HashID.setLength(9);
            }
            while (this.HashID.length() < 9) {
                this.HashID.append(" ");
            }
            this.FieldID.append(string2);
            this.sKey.append(string3);
            this.Data.append(string4);
        }

        TExternalDataObj duplicate() {
            return new TExternalDataObj(this.Index, this.Offset, this.HashID.toString(), this.FieldID.toString(), this.sKey.toString(), this.Data.toString());
        }

        int getFieldIDLength() {
            return this.FieldID.length();
        }

        int getKeyLength() {
            return this.sKey.length();
        }

        int getDataLength() {
            return this.Data.length();
        }

        int getSize() {
            return this.HashID.length() + 4 + this.FieldID.length() + 4 + this.sKey.length() + 4 + this.Data.length();
        }

        String getDataID() {
            return this.getHashID() + "|" + this.FieldID.toString() + "|" + this.sKey.toString();
        }

        int getIndex() {
            return this.Index;
        }

        int getOffset() {
            return this.Offset;
        }

        void setHashID(String string) {
            this.HashID.setLength(0);
            this.HashID.append(string);
            if (this.HashID.length() > 9) {
                this.HashID.setLength(9);
            }
            while (this.HashID.length() < 9) {
                this.HashID.append(" ");
            }
        }

        String getHashID() {
            return this.HashID.toString();
        }

        String getFieldID() {
            return this.FieldID.toString();
        }

        String getKey() {
            return this.sKey.toString();
        }

        void setData(String string) {
            this.Data.setLength(0);
            this.Data.append(string);
        }

        String getData() {
            return this.Data.toString();
        }

        public String toString() {
            String string = "Index: " + this.Index;
            string = string + " Offset: " + this.Offset;
            string = string + " HashID: " + this.HashID.toString();
            string = string + " FieldID " + this.FieldID.toString();
            string = string + " Key: " + this.sKey.toString();
            string = string + " Data " + this.Data.toString().substring(0, Math.min(this.Data.length(), 24));
            return string;
        }
    }
}

