/*
 * Decompiled with CFR 0.152.
 */
package drivers.consolidated;

import aspect.Aspect;
import aspect.TMainWin;
import collections.TComboBoxColl;
import drivers.aspect.TAbstractDriver;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverInterface;
import drivers.aspect.TDriverStruct;
import drivers.aspect.TDriverStructRecord;
import drivers.consolidated.TEmbeddedDriver;
import java.util.ArrayList;
import resources.TAppDriversObject;
import resources.TApplication;
import utility.TFormulaEvaluator;
import utility.charutil;

public class TConsolidatedVertDriver
extends TAbstractDriver {
    private static TMainWin MainWin = Aspect.MainWin;
    private boolean Debug = TMainWin.Application.getTokenValueAsBool("DebugTConsolidatedVertDriver");
    private ArrayList arEmbeddedDrivers = new ArrayList();

    public TConsolidatedVertDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        super(tApplication, tAppDriversObject, 1, bl);
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.arEmbeddedDrivers.size(); ++i) {
            TEmbeddedDriver tEmbeddedDriver = (TEmbeddedDriver)this.arEmbeddedDrivers.get(i);
            tEmbeddedDriver.dispose();
        }
        this.arEmbeddedDrivers.clear();
        super.dispose();
    }

    @Override
    public int makeEditableFile() {
        return 1;
    }

    public void addDriver(String string, String string2, String string3, String string4) {
        TAspectDriver tAspectDriver = TFormulaEvaluator.getSystemDriver(string);
        if (tAspectDriver != null) {
            this.addDriver(tAspectDriver.F, string2, string3, string4);
        } else {
            MainWin.appendToLog("TConsolidatedVertDriver", "addDriver", Thread.currentThread(), null, 4, "Invalid driver in addDriver.  Name = " + string);
            MainWin.appendToLog("TConsolidatedVertDriver", "addDriver", Thread.currentThread(), null, 4, "Make sure the driver is opened as a system driver");
        }
    }

    public void addDriver(TDriverInterface tDriverInterface, String string, String string2, String string3) {
        TDriverStructRecord tDriverStructRecord;
        int n;
        if (this.Debug) {
            MainWin.appendToLog("TConsolidatedVertDriver", "addDriver", Thread.currentThread(), null, 3, "Embedding vertical driver");
        }
        TEmbeddedDriver tEmbeddedDriver = new TEmbeddedDriver(this.arEmbeddedDrivers.size(), tDriverInterface, string, string2, string3);
        this.arEmbeddedDrivers.add(tEmbeddedDriver);
        if (tEmbeddedDriver.driver == null) {
            return;
        }
        String string4 = tDriverInterface.getDriverParams();
        String string5 = charutil.getParamValue(string4, "ControllablesDriverID", '|');
        TDriverStruct tDriverStruct = tEmbeddedDriver.driver.getDriverStruct();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (n = 0; n < tDriverStruct.FieldColl.size(); ++n) {
            tDriverStructRecord = (TDriverStructRecord)tDriverStruct.FieldColl.get(n);
            String string6 = tDriverStructRecord.FullID;
            tDriverStructRecord = new TDriverStructRecord(tDriverStructRecord);
            if (!tEmbeddedDriver.isIncludedField(tDriverStructRecord.FullID)) continue;
            tDriverStructRecord.FullID = tEmbeddedDriver.getConsolidatedFieldID(tDriverStructRecord.FullID);
            if (this.DriverStruct.HashFields.containsKey(tDriverStructRecord.FullID.toUpperCase())) continue;
            if (tDriverStructRecord.IsRootNode) {
                this.DriverStruct.HasTreeNodes = true;
            }
            if (tDriverStructRecord.CalcSubtotal) {
                this.DriverStruct.HasSubtotals = true;
            }
            if (string6.equalsIgnoreCase("controllables_amount") && string5.length() > 0) {
                tDriverStructRecord.ControllablesDriverID = string5;
            }
            this.DriverStruct.FieldColl.add(tDriverStructRecord);
            this.DriverStruct.HashFields.put(tDriverStructRecord.FullID.toUpperCase(), new Integer(this.DriverStruct.FieldColl.size() - 1));
            stringBuilder.setLength(0);
            stringBuilder.append(tDriverStructRecord.Description.toUpperCase());
            charutil.replace_char(stringBuilder, stringBuilder, '\\', ' ');
            this.DriverStruct.HashDescriptions.put(stringBuilder.toString(), new Integer(this.DriverStruct.FieldColl.size() - 1));
            ++n2;
        }
        if (n2 > 0) {
            int n3 = 0;
            int n4 = 0;
            this.DriverStruct.RecordSize = 0;
            for (n = 0; n < this.DriverStruct.FieldColl.size(); ++n) {
                tDriverStructRecord = (TDriverStructRecord)this.DriverStruct.FieldColl.get(n);
                tDriverStructRecord.AbsoluteIndex = n3++;
                if (!tDriverStructRecord.IsVirtual) {
                    tDriverStructRecord.PhysicalIndex = n4++;
                }
                if (tDriverStructRecord.FieldType == 16) {
                    ++this.DriverStruct.RecordSize;
                    continue;
                }
                this.DriverStruct.RecordSize += tDriverStructRecord.DataSize * tDriverStructRecord.ArraySize;
            }
        }
        if (this.Debug) {
            MainWin.appendToLog("TConsolidatedVertDriver", "addDriver", Thread.currentThread(), null, 3, "Embedding vertical driver complete");
        }
    }

    public TEmbeddedDriver geTEmbeddedDriver(int n) {
        int n2 = -1;
        for (int i = 0; i < this.arEmbeddedDrivers.size(); ++i) {
            TEmbeddedDriver tEmbeddedDriver = (TEmbeddedDriver)this.arEmbeddedDrivers.get(i);
            if ((n2 += tEmbeddedDriver.getRecordCount()) < n) continue;
            return tEmbeddedDriver;
        }
        return null;
    }

    public int geTEmbeddedDriverRecord(int n) {
        int n2 = 0;
        for (int i = 0; i < this.arEmbeddedDrivers.size(); ++i) {
            TEmbeddedDriver tEmbeddedDriver = (TEmbeddedDriver)this.arEmbeddedDrivers.get(i);
            int n3 = tEmbeddedDriver.getRecordCount();
            if (n2 + n3 > n) {
                return n - n2;
            }
            n2 += n3;
        }
        return -1;
    }

    public TFormulaEvaluator getFormulaEvaluator(int n) {
        TEmbeddedDriver tEmbeddedDriver = this.geTEmbeddedDriver(n);
        if (tEmbeddedDriver != null) {
            return tEmbeddedDriver.getFormulaEvaluator();
        }
        return null;
    }

    public String getDriverParams(int n) {
        TEmbeddedDriver tEmbeddedDriver = this.geTEmbeddedDriver(n);
        if (tEmbeddedDriver != null) {
            return tEmbeddedDriver.getDriverParams();
        }
        return null;
    }

    @Override
    public TDriverStructRecord getVirtualIndexField() {
        TDriverStructRecord tDriverStructRecord = null;
        if (this.AspectDriver == null) {
            return null;
        }
        if (this.AspectDriver.AppDriverObj == null) {
            return null;
        }
        if (charutil.nullstr(this.AspectDriver.AppDriverObj.VirtualIndexField)) {
            return null;
        }
        String string = this.AspectDriver.AppDriverObj.VirtualIndexField;
        tDriverStructRecord = this.DriverStruct.getField(string);
        if (tDriverStructRecord == null) {
            return null;
        }
        if (tDriverStructRecord.FieldType != 7) {
            MainWin.appendToLog("TAbstractDriver", "getVirtualIndexField", Thread.currentThread(), null, 4, "Virtual index field '" + string + "' must be a long data type in driver: " + this.AppDriversObject.DriverID);
            return null;
        }
        return tDriverStructRecord;
    }

    @Override
    public int getRecordCount() {
        int n = 0;
        for (int i = 0; i < this.arEmbeddedDrivers.size(); ++i) {
            TEmbeddedDriver tEmbeddedDriver = (TEmbeddedDriver)this.arEmbeddedDrivers.get(i);
            n += tEmbeddedDriver.getRecordCount();
        }
        return n;
    }

    @Override
    public boolean isWriteable() {
        boolean bl = true;
        for (int i = 0; i < this.arEmbeddedDrivers.size(); ++i) {
            TEmbeddedDriver tEmbeddedDriver = (TEmbeddedDriver)this.arEmbeddedDrivers.get(i);
            bl &= tEmbeddedDriver.driver.isWriteable();
        }
        return bl;
    }

    @Override
    public boolean isInFilter(int n, StringBuilder stringBuilder) {
        TEmbeddedDriver tEmbeddedDriver = this.geTEmbeddedDriver(n);
        int n2 = this.geTEmbeddedDriverRecord(n);
        if (tEmbeddedDriver == null || n2 < 0) {
            return false;
        }
        if (tEmbeddedDriver.isDeleted(n2, tEmbeddedDriver.driver.AppDriversObject.DeleteMask)) {
            return false;
        }
        return tEmbeddedDriver.isInFilter(n2, stringBuilder);
    }

    @Override
    public boolean isDeleted(int n, StringBuilder stringBuilder) {
        TEmbeddedDriver tEmbeddedDriver = this.geTEmbeddedDriver(n);
        int n2 = this.geTEmbeddedDriverRecord(n);
        if (tEmbeddedDriver == null || n2 < 0) {
            return false;
        }
        return tEmbeddedDriver.isDeleted(n2, tEmbeddedDriver.driver.AppDriversObject.DeleteMask);
    }

    @Override
    public Object getField(TDriverStructRecord tDriverStructRecord, int n) {
        String string;
        TDriverStructRecord tDriverStructRecord2;
        TEmbeddedDriver tEmbeddedDriver = this.geTEmbeddedDriver(n);
        int n2 = this.geTEmbeddedDriverRecord(n);
        Object object = null;
        if (tDriverStructRecord.FullID.toUpperCase().startsWith("__CONSOLIDATEDVERTDRIVER__")) {
            if (tDriverStructRecord.FullID.equalsIgnoreCase("__ConsolidatedVertDriver__DriverName")) {
                if (tEmbeddedDriver != null) {
                    return tEmbeddedDriver.DriverName;
                }
                return "Error";
            }
            if (tDriverStructRecord.FullID.equalsIgnoreCase("__ConsolidatedVertDriver__Embedded_Record")) {
                return new Integer(n);
            }
            if (tDriverStructRecord.FullID.equalsIgnoreCase("__ConsolidatedVertDriver__Embedded_Filename")) {
                if (tEmbeddedDriver != null) {
                    return tEmbeddedDriver.driver.getFileName();
                }
                return "Error";
            }
            if (tDriverStructRecord.FullID.equalsIgnoreCase("__ConsolidatedVertDriver__Embedded_Driver_Number")) {
                if (tEmbeddedDriver != null) {
                    return tEmbeddedDriver.DriverNumber;
                }
                return new Integer(-1);
            }
            if (tDriverStructRecord.FullID.equalsIgnoreCase("__ConsolidatedVertDriver__Embedded_Driver_Params")) {
                if (tEmbeddedDriver != null) {
                    return tEmbeddedDriver.getDriverParams();
                }
                return new Integer(-1);
            }
        }
        if (tEmbeddedDriver != null && n2 >= 0 && (tDriverStructRecord2 = tEmbeddedDriver.driver.DriverStruct.getField(string = tEmbeddedDriver.getEmbeddedFieldID(tDriverStructRecord.FullID))) != null) {
            object = tEmbeddedDriver.getField(tDriverStructRecord2, n2);
        }
        return object;
    }

    @Override
    public int putField(TDriverStructRecord tDriverStructRecord, int n, Object object) {
        String string;
        TDriverStructRecord tDriverStructRecord2;
        TEmbeddedDriver tEmbeddedDriver = this.geTEmbeddedDriver(n);
        int n2 = this.geTEmbeddedDriverRecord(n);
        if (tEmbeddedDriver != null && n2 >= 0 && (tDriverStructRecord2 = tEmbeddedDriver.driver.DriverStruct.getField(string = tEmbeddedDriver.getEmbeddedFieldID(tDriverStructRecord.FullID))) != null) {
            return tEmbeddedDriver.putField(tDriverStructRecord2, n2, object);
        }
        return 0;
    }

    @Override
    public TComboBoxColl getComboBoxColl(String string, StringBuilder stringBuilder, TFormulaEvaluator tFormulaEvaluator, boolean bl, boolean bl2, int n) {
        TEmbeddedDriver tEmbeddedDriver = this.geTEmbeddedDriver(n);
        int n2 = this.geTEmbeddedDriverRecord(n);
        if (tEmbeddedDriver == null) {
            return new TComboBoxColl(false, 100);
        }
        return tEmbeddedDriver.getComboBoxColl(string, stringBuilder, tFormulaEvaluator, bl, bl2, n2);
    }

    @Override
    public TComboBoxColl getComboBoxColl(String string, String string2, TFormulaEvaluator tFormulaEvaluator, boolean bl, int n) {
        TEmbeddedDriver tEmbeddedDriver = this.geTEmbeddedDriver(n);
        int n2 = this.geTEmbeddedDriverRecord(n);
        return tEmbeddedDriver.getComboBoxColl(string, string2, tFormulaEvaluator, bl, n);
    }
}

