/*
 * Decompiled with CFR 0.152.
 */
package drivers.aspect;

import aspect.Aspect;
import aspect.TMainWin;
import drivers.aspect.TDriverInterface;
import java.util.Hashtable;
import java.util.Stack;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import resources.TAppDriversObject;

public class TUndoManager {
    TMainWin MainWin = Aspect.MainWin;
    TDriverInterface F;
    TAppDriversObject AppDriversObject = null;
    Stack stackUndo = new Stack();
    Stack stackRedo = new Stack();
    Hashtable DisabledThreads = new Hashtable();
    boolean InUndoOperation = false;
    boolean Debug = false;
    boolean IsRecording = true;

    public TUndoManager(TDriverInterface tDriverInterface) {
        this.AppDriversObject = tDriverInterface.getAppDriversObject();
        this.Debug = TMainWin.Application.getTokenValueAsBool("DebugTUndoManager");
        this.F = tDriverInterface;
        if (this.Debug) {
            this.MainWin.appendToLog("TUndoManager", "<init>", Thread.currentThread(), null, 10, "Undo manager initialized for " + this.getDriverName() + " (" + this.F.getFileName() + ")");
        }
    }

    public void dispose() {
        this.stackUndo.clear();
        this.stackRedo.clear();
        this.DisabledThreads.clear();
    }

    public String getDriverName() {
        if (this.AppDriversObject == null) {
            return "Unknown driver";
        }
        return this.AppDriversObject.Description.toString();
    }

    public void enableUndoActionTypes() {
        JMenu jMenu = null;
        TMainWin.Application.AppAction.enableDriverCommand("undo", this.stackUndo.size() > 0);
        TMainWin.Application.AppAction.enableDriverCommand("redo", this.stackRedo.size() > 0);
        if (TMainWin.MainMenu != null) {
            int n = 0;
            while (jMenu == null) {
                if (n >= TMainWin.MainMenu.getMenuCount()) break;
                if (TMainWin.MainMenu.getMenu(n).getText().equalsIgnoreCase("Edit")) {
                    jMenu = TMainWin.MainMenu.getMenu(n);
                    for (int i = 0; i < jMenu.getItemCount(); ++i) {
                        JMenuItem jMenuItem = jMenu.getItem(i);
                        if (jMenuItem == null) continue;
                        String string = jMenuItem.getText().toUpperCase();
                        if (string.startsWith("UNDO")) {
                            jMenuItem.setText("Undo " + this.getUndoDescription());
                            continue;
                        }
                        if (!string.startsWith("REDO")) continue;
                        jMenuItem.setText("Redo " + this.getRedoDescription());
                    }
                }
                ++n;
            }
        }
    }

    public void disableForThread(String string, boolean bl) {
        if (bl) {
            if (!this.DisabledThreads.contains(string)) {
                this.DisabledThreads.put(string, string);
            }
        } else if (this.DisabledThreads.contains(string)) {
            this.DisabledThreads.remove(string);
        }
    }

    public boolean isRecording() {
        return this.IsRecording;
    }

    public void setUndoRecording(boolean bl) {
        this.IsRecording = bl;
        if (this.Debug) {
            this.MainWin.appendToLog("TUndoManager", "setUndoRecording", Thread.currentThread(), null, 10, "Undo recording set to " + new Boolean(this.IsRecording).toString() + " for " + this.getDriverName() + " (" + this.F.getFileName() + ")");
        }
    }

    public boolean getUndoRecording() {
        return this.IsRecording;
    }

    public void beginNewUndoOperation(String string) {
        if (this.InUndoOperation) {
            return;
        }
        if (this.Debug) {
            this.MainWin.appendToLog("TUndoManager", "beginNewUndoOperation", Thread.currentThread(), null, 10, "Begin undo operation - " + string);
        }
        this.stackUndo.add(new TUndoOperation(string));
        this.stackRedo.clear();
    }

    public String getUndoDescription() {
        if (this.stackUndo.size() == 0) {
            return "";
        }
        TUndoOperation tUndoOperation = (TUndoOperation)this.stackUndo.peek();
        return tUndoOperation.Description;
    }

    public String getRedoDescription() {
        if (this.stackRedo.size() == 0) {
            return "";
        }
        TUndoOperation tUndoOperation = (TUndoOperation)this.stackRedo.peek();
        return tUndoOperation.Description;
    }

    public void removeLastUndo() {
        if (this.stackUndo.size() > 0) {
            this.stackUndo.pop();
        }
    }

    public void clear() {
        this.stackUndo.clear();
        this.stackRedo.clear();
        this.enableUndoActionTypes();
    }

    public void undo(boolean bl) {
        Stack stack;
        Stack stack2;
        this.InUndoOperation = true;
        if (bl) {
            stack2 = this.stackUndo;
            stack = this.stackRedo;
        } else {
            stack2 = this.stackRedo;
            stack = this.stackUndo;
        }
        if (stack2.size() > 0) {
            TUndoOperation tUndoOperation = (TUndoOperation)stack2.pop();
            TUndoOperation tUndoOperation2 = new TUndoOperation(tUndoOperation.Description);
            while (tUndoOperation.stackUndoEvent.size() > 0) {
                TUndoEvent tUndoEvent = (TUndoEvent)tUndoOperation.stackUndoEvent.pop();
                this.F.putField(tUndoEvent.FullID, tUndoEvent.Record, tUndoEvent.OriginalValue);
                tUndoOperation2.addUndoEvent(tUndoEvent.FullID, tUndoEvent.Record, tUndoEvent.NewValue, tUndoEvent.OriginalValue);
            }
            stack.push(tUndoOperation2);
        }
        this.enableUndoActionTypes();
        this.InUndoOperation = false;
    }

    public void undo() {
        if (this.Debug) {
            this.MainWin.appendToLog("TUndoManager", "undo", Thread.currentThread(), null, 10, "Undoing event");
        }
        this.undo(true);
    }

    public void redo() {
        if (this.Debug) {
            this.MainWin.appendToLog("TUndoManager", "redo", Thread.currentThread(), null, 10, "Redoing event");
        }
        this.undo(false);
    }

    public class TUndoEvent {
        int Record;
        int cRecords;
        String FullID;
        Object OriginalValue;
        Object NewValue;

        public TUndoEvent(String string, int n, Object object, Object object2) {
            this.Record = n;
            this.cRecords = TUndoManager.this.F.getRecordCount();
            this.FullID = string;
            this.OriginalValue = object;
            this.NewValue = object2;
        }
    }

    public class TUndoOperation {
        String Description;
        Stack stackUndoEvent = new Stack();

        public TUndoOperation(String string) {
            this.Description = string;
        }

        public void addUndoEvent(String string, int n, Object object, Object object2) {
            TUndoEvent tUndoEvent = new TUndoEvent(string, n, object, object2);
            this.stackUndoEvent.push(tUndoEvent);
        }
    }
}

