/*
 * Decompiled with CFR 0.152.
 */
package drivers.aspect;

import aspect.Aspect;
import aspect.TMainWin;
import drivercmd.core.TDriverCmdEditRecordWizard;
import drivers.aspect.TAbstractDriverWrapper;
import drivers.aspect.TAspectDriver;
import drivers.aspect.TDriverStructRecord;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import resources.TAppDriverStructObject;
import resources.TAppDriversObject;
import resources.TApplication;
import scripts.TExecScript;
import scrollwin.TScrollWin;
import scrollwin.table.TScrollTable;
import utility.TFormulaEvaluator;
import utility.asciifiles.TAsciiInput;
import utility.charutil;
import utility.dosutil;
import utility.objectutil;
import utility.sql.TSqlField;

public class TEditStructuresDriver
extends TAbstractDriverWrapper {
    private TMainWin MainWin = Aspect.MainWin;
    public TAppDriversObject WrappedDriverObj;
    private static long starttime = new Date().getTime();

    public TEditStructuresDriver(TApplication tApplication, TAppDriversObject tAppDriversObject, int n, boolean bl) {
        super(tApplication, tAppDriversObject, n, bl);
        String string = this.Application.parse_tokens(this.AppDriversObject.WrapsDriverID1);
        this.WrappedDriverObj = this.Application.AppDrivers.getAppDriversObject(string);
        this.WrappedDriver = TAspectDriver.openDriver(tApplication, this.WrappedDriverObj, n, true);
        this.DriverStruct = this.WrappedDriver.getDriverStruct();
        if (!this.IsWrappedDriver) {
            this.FormulaEvaluator = new TFormulaEvaluator(tApplication, this.DriverStruct, this);
            this.WrappedDriver.setFormulaEvaluator(this.FormulaEvaluator);
        }
    }

    @Override
    public ArrayList getSupportedDriverCommands() {
        ArrayList arrayList = super.getSupportedDriverCommands();
        arrayList.add("InitStructFromFile");
        arrayList.add("InitStructFromDatabase");
        arrayList.add("PreviewEditRecordWizard");
        return arrayList;
    }

    public boolean initializeAStructureFromDbase(TScrollTable tScrollTable, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        byte[] byArray = new byte[32];
        boolean bl = false;
        if (string.length() == 0) {
            JOptionPane.showMessageDialog(null, "Missing file name.", "Problem", 1);
            return false;
        }
        InputStream inputStream = dosutil.getInputStream(string);
        if (inputStream == null) {
            JOptionPane.showMessageDialog(null, "Invalid file.", "Problem", 1);
            return false;
        }
        TDriverStructRecord tDriverStructRecord = tScrollTable.AspectDriver.getVirtualIndexField();
        try {
            n = tScrollTable.AspectDriver.initializeNewRecord();
            if (n >= 0) {
                tScrollTable.AspectDriver.putFieldAbsolute(tDriverStructRecord, n, (Object)new Integer(tScrollTable.AspectDriver.getNextVirtualIndex()));
                tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_StructureName", n, (Object)string2);
                tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_ID", n, (Object)string3);
                tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_FieldID", n, (Object)"Deleted");
                tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_Description", n, (Object)"Deleted");
                tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_Decimals", n, (Object)new Integer(0));
                tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_FieldType", n, (Object)new Integer(3));
                tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_ArraySize", n, (Object)new Integer(1));
                tScrollTable.AspectDriver.addToFilterList(n);
            }
            inputStream.read(byArray);
            do {
                short s;
                int n2;
                inputStream.read(byArray);
                if (byArray[0] == 13) {
                    bl = true;
                    continue;
                }
                stringBuilder.setLength(0);
                for (int i = 0; i < 11; ++i) {
                    if (byArray[i] <= 0) continue;
                    stringBuilder.append((char)byArray[i]);
                }
                String string4 = stringBuilder.toString();
                byte by = byArray[11];
                short s2 = byArray[16];
                byte by2 = byArray[17];
                if (by >= 97) {
                    by = (byte)(by - 32);
                }
                if ((n = tScrollTable.AspectDriver.initializeNewRecord()) < 0) continue;
                tScrollTable.AspectDriver.putFieldAbsolute(tDriverStructRecord, n, (Object)new Integer(tScrollTable.AspectDriver.getNextVirtualIndex()));
                tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_StructureName", n, (Object)string2);
                tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_ID", n, (Object)string3);
                tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_FieldID", n, (Object)string4);
                tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_Description", n, (Object)string4);
                tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_Decimals", n, (Object)new Integer(by2));
                switch ((char)by) {
                    case 'B': 
                    case 'C': 
                    case 'G': 
                    case 'M': {
                        n2 = 3;
                        s = s2;
                        break;
                    }
                    case 'D': {
                        n2 = 10;
                        s = 1;
                        break;
                    }
                    case 'F': 
                    case 'N': {
                        n2 = 7;
                        if (by2 > 0) {
                            n2 = 9;
                        }
                        s = 1;
                        break;
                    }
                    case 'L': {
                        n2 = 1;
                        s = 1;
                        break;
                    }
                    default: {
                        n2 = 3;
                        s = s2;
                    }
                }
                tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_FieldType", n, (Object)new Integer(n2));
                tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_ArraySize", n, (Object)new Integer(s));
                tScrollTable.AspectDriver.addToFilterList(n);
            } while (!bl);
            inputStream.close();
            if (n >= 0) {
                tScrollTable.refreshTable();
                tScrollTable.setSelectedRow(tScrollTable.AspectDriver.getFilteredIndex(n), true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean initializeAStructureFromCSV(TScrollTable tScrollTable, String string, String string2, String string3, char c) {
        int n;
        int n2;
        if (string.length() == 0) {
            JOptionPane.showMessageDialog(null, "Missing file name.", "Problem", 1);
            return false;
        }
        TAsciiInput tAsciiInput = new TAsciiInput(string, c);
        if (!tAsciiInput.isValid()) {
            JOptionPane.showMessageDialog(null, "Invalid file.", "Problem", 1);
            return false;
        }
        TDriverStructRecord tDriverStructRecord = tScrollTable.AspectDriver.getVirtualIndexField();
        StringBuilder stringBuilder = new StringBuilder();
        tAsciiInput.get_string(stringBuilder);
        System.out.println("initializeAStructureFromCSV header line=" + stringBuilder.toString() + " chDelimit=" + c);
        String[] stringArray = charutil.getSubStringArray(stringBuilder, c, true);
        if (stringArray == null || stringArray.length == 0) {
            JOptionPane.showMessageDialog(null, "No field descriptions found in file.", "Problem", 1);
            tAsciiInput.dispose();
            return false;
        }
        int[] nArray = new int[stringArray.length];
        int[] nArray2 = new int[stringArray.length];
        int[] nArray3 = new int[stringArray.length];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            nArray[n2] = 7;
            nArray2[n2] = 1;
            nArray3[n2] = 0;
        }
        while (tAsciiInput.get_string(stringBuilder) > 0) {
            String[] stringArray2 = charutil.getSubStringArray(stringBuilder, c, true);
            block8: for (n = 0; n < stringArray2.length && n < stringArray.length; ++n) {
                switch (nArray[n]) {
                    case 7: {
                        if (!charutil.isNumber(stringArray2[n])) {
                            if (stringArray2[n].equalsIgnoreCase("true") || stringArray2[n].equalsIgnoreCase("false")) {
                                nArray[n] = 19;
                                continue block8;
                            }
                            nArray[n] = 3;
                            nArray2[n] = ((int)Math.floor(stringArray2[n].length() / 128) + 1) * 128;
                            continue block8;
                        }
                        if (stringArray2[n].indexOf(46) <= 0) continue block8;
                        nArray[n] = 9;
                        String[] stringArray3 = charutil.getSubStringArray(stringArray2[n], '.', true);
                        if (stringArray3 == null || stringArray3.length <= 1) continue block8;
                        nArray3[n] = stringArray3[1].length();
                        continue block8;
                    }
                    case 19: {
                        if (stringArray2[n].equalsIgnoreCase("true") || stringArray2[n].equalsIgnoreCase("false")) continue block8;
                        nArray[n] = 3;
                        nArray2[n] = ((int)Math.floor(stringArray2[n].length() / 128) + 1) * 128;
                        continue block8;
                    }
                    case 9: {
                        if (!charutil.isNumber(stringArray2[n])) {
                            nArray[n] = 3;
                            nArray2[n] = ((int)Math.floor(stringArray2[n].length() / 128) + 1) * 128;
                            continue block8;
                        }
                        String[] stringArray4 = charutil.getSubStringArray(stringArray2[n], '.', true);
                        if (stringArray4 == null || stringArray4.length <= 1 || stringArray4[1].length() <= nArray3[n]) continue block8;
                        nArray3[n] = stringArray4[1].length();
                        continue block8;
                    }
                    case 3: {
                        int n3 = ((int)Math.floor(stringArray2[n].length() / 128) + 1) * 128;
                        if (n3 <= nArray2[n]) continue block8;
                        nArray2[n] = n3;
                    }
                }
            }
        }
        n2 = -1;
        for (n = 0; n < stringArray.length; ++n) {
            n2 = tScrollTable.AspectDriver.initializeNewRecord();
            if (n2 < 0) continue;
            tScrollTable.AspectDriver.putFieldAbsolute(tDriverStructRecord, n2, (Object)new Integer(tScrollTable.AspectDriver.getNextVirtualIndex()));
            tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_StructureName", n2, (Object)string2);
            tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_ID", n2, (Object)string3);
            tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_FieldID", n2, (Object)stringArray[n]);
            tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_Description", n2, (Object)stringArray[n]);
            tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_FieldType", n2, (Object)new Integer(nArray[n]));
            tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_ArraySize", n2, (Object)new Integer(nArray2[n]));
            tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_Decimals", n2, (Object)new Integer(nArray3[n]));
            tScrollTable.AspectDriver.addToFilterList(n2);
        }
        if (n2 >= 0) {
            tScrollTable.refreshTable();
            tScrollTable.setSelectedRow(tScrollTable.AspectDriver.getFilteredIndex(n2), true);
        }
        tAsciiInput.dispose();
        return true;
    }

    public void initializeStructFromFile(TScrollTable tScrollTable) {
        String[] stringArray;
        Object object;
        Object object2;
        String string = this.Application.getTokenValue("Packages_Loaded_Package");
        if (string.length() == 0) {
            System.out.println("No package loaded");
            return;
        }
        String[] stringArray2 = charutil.getSubStringArray(charutil.replaceChar(string, '\\', '/'), '/', true);
        String string2 = stringArray2[stringArray2.length - 1];
        if (string2.trim().length() == 0) {
            string2 = stringArray2[stringArray2.length - 2];
        }
        String string3 = string + "drivers.asp";
        String string4 = TMainWin.executeDialog("InitStructFromFile");
        if (!string4.equalsIgnoreCase("ok")) {
            return;
        }
        int n = charutil.ival(this.Application.getTokenValue("$InitStructFromFile_Delimiter"));
        char c = ',';
        switch (n) {
            case 0: {
                c = ',';
                break;
            }
            case 1: {
                c = '|';
                break;
            }
            case 2: {
                c = '\t';
                break;
            }
            case 3: {
                c = '=';
                break;
            }
            case 4: {
                c = ' ';
                break;
            }
            case 5: {
                c = '~';
                break;
            }
            case 6: {
                c = '^';
                break;
            }
            case 7: {
                c = '`';
                break;
            }
            default: {
                c = ',';
            }
        }
        System.out.println("initializeStructFromFile chDelimit=" + c);
        String string5 = this.Application.getTokenValue("$InitStructFromFile_CreateDriver");
        boolean bl = charutil.boolval(string5);
        TScrollTable tScrollTable2 = null;
        TAspectDriver tAspectDriver = null;
        if (bl) {
            object2 = this.MainWin.getScrollWinWithDriverID("PackageSource_Driver_Drivers");
            tScrollTable2 = object2 != null ? ((TScrollWin)object2).TablePanel.Table : this.MainWin.getTablePanelWithDriverID("PackageSource_Driver_Drivers");
            if (tScrollTable2 != null) {
                tAspectDriver = tScrollTable2.AspectDriver;
            } else {
                System.out.println("Cannot locate table of drivers");
            }
        }
        object2 = this.Application.getTokenValue("$InitStructFromFile_FileName");
        boolean bl2 = false;
        if (dosutil.isDirectory((String)object2)) {
            object = dosutil.listFiles((String)object2, 0, true, false);
            stringArray = charutil.getSubStringArray((String)object, '|', true);
            bl2 = true;
        } else {
            stringArray = new String[]{object2};
        }
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string6 = this.Application.getTokenValue("$InitStructFromFile_StructureName").trim();
                String string7 = "";
                string7 = bl2 ? string2 + "_" + dosutil.getFileName(stringArray[i]) : (string6.length() > 0 ? string6 : string2 + "_" + dosutil.getFileName(stringArray[i]));
                String string8 = charutil.replaceChar(string7, ' ', '_');
                int n2 = tScrollTable.AspectDriver.getMatchingRecord("Aspect_Structures_ID=\"" + string7 + '\"', 0);
                boolean bl3 = true;
                boolean bl4 = false;
                if (n2 >= 0) {
                    System.out.println("Skipping creation of " + string7 + " because a structure with that ID already exists");
                } else if (dosutil.getFileExt(stringArray[i]).equalsIgnoreCase(".dbf")) {
                    bl3 = this.initializeAStructureFromDbase(tScrollTable, stringArray[i], string7, string8);
                    bl4 = true;
                } else {
                    bl3 = this.initializeAStructureFromCSV(tScrollTable, stringArray[i], string7, string8, c);
                }
                if (!bl3 || !bl || tScrollTable2 == null) continue;
                n2 = tAspectDriver.getMatchingRecord("Aspect_Driver_ID=\"" + string7 + '\"', 0);
                if (n2 >= 0) {
                    System.out.println("Skipping creation of " + string7 + " because a driver with that ID already exists");
                    continue;
                }
                n2 = tAspectDriver.initializeNewRecord();
                tAspectDriver.putFieldAbsolute("Aspect_Driver_Description", n2, (Object)string7);
                tAspectDriver.putFieldAbsolute("Aspect_Driver_ID", n2, (Object)string8);
                tAspectDriver.putFieldAbsolute("Aspect_Driver_StructureID", n2, (Object)string8);
                tAspectDriver.putFieldAbsolute("Aspect_Driver_FileName", n2, (Object)("\"" + stringArray[i] + "\""));
                if (bl4) {
                    tAspectDriver.putFieldAbsolute("Aspect_Driver_FileType", n2, (Object)3);
                } else {
                    tAspectDriver.putFieldAbsolute("Aspect_Driver_FileType", n2, (Object)4);
                    tAspectDriver.putFieldAbsolute("Aspect_Driver_Delimiter", n2, (Object)new Integer(n));
                }
                tScrollTable2.AspectDriver.addToFilterList(n2);
                tScrollTable2.refreshTable();
                tScrollTable2.setSelectedRow(tScrollTable.AspectDriver.getFilteredIndex(n2), true);
            }
        }
        if (bl && tScrollTable2 != null && new Date().getTime() - starttime > 60000L) {
            this.Application.setTokenValue("Packages_Desktop_Source_Modified", "Modified");
            object = new TExecScript("Packages_updateModifiedIndicator", null, null);
            ((TExecScript)object).setParameters("PackageSource_Driver_Drivers");
            ((Thread)object).start();
            long l = 0L;
            while (((Thread)object).isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (l <= 100L) continue;
                System.out.println("TEditStructuresDriver thread stuck n=" + l);
            }
        }
    }

    public void initializeStructFromDatabase(TScrollTable tScrollTable) {
        Object object;
        Object object2;
        String string = this.Application.getTokenValue("Packages_Loaded_Package");
        if (string.length() == 0) {
            System.out.println("No package loaded");
            return;
        }
        String[] stringArray = charutil.getSubStringArray(charutil.replaceChar(string, '\\', '/'), '/', true);
        String string2 = stringArray[stringArray.length - 1];
        if (string2.trim().length() == 0) {
            string2 = stringArray[stringArray.length - 2];
        }
        String string3 = string + "drivers.asp";
        String string4 = TMainWin.executeDialog("InitStructFromDatabase");
        if (!string4.equalsIgnoreCase("ok")) {
            return;
        }
        String string5 = this.Application.getTokenValue("$Database_Source");
        if (string5.trim().length() == 0) {
            string5 = this.Application.getAspectHashID();
        }
        String string6 = this.Application.getTokenValue("$Database_Type").trim();
        String string7 = this.Application.getTokenValue("$Database_Cred").trim();
        String string8 = this.Application.getTokenValue("$Database_Name");
        String string9 = this.Application.getTokenValue("$User_Name");
        String string10 = this.Application.getTokenValue("$Password");
        String string11 = this.Application.getTokenValue("$Table_Name");
        boolean bl = charutil.boolval(this.Application.getTokenValue("$CreateDriver"));
        if (string6.length() == 0 || string6.equalsIgnoreCase("-1")) {
            System.out.println("Error: No database type selected");
        }
        TScrollTable tScrollTable2 = null;
        TAspectDriver tAspectDriver = null;
        if (bl) {
            object2 = this.MainWin.getScrollWinWithDriverID("PackageSource_Driver_Drivers");
            tScrollTable2 = object2 != null ? ((TScrollWin)object2).TablePanel.Table : this.MainWin.getTablePanelWithDriverID("PackageSource_Driver_Drivers");
            if (tScrollTable2 != null) {
                tAspectDriver = tScrollTable2.AspectDriver;
            } else {
                System.out.println("Cannot locate table of drivers");
            }
        }
        object2 = tScrollTable.AspectDriver.getVirtualIndexField();
        System.out.println("Adding table: " + string11);
        String string12 = string2 + " " + string8 + " " + string11;
        String string13 = charutil.replaceChar(string12, ' ', '_');
        int n = tScrollTable.AspectDriver.getMatchingRecord("Aspect_Structures_ID=\"" + string13 + '\"', 0);
        if (n < 0) {
            int n2;
            object = "Source=" + string5 + "&DocumentID=K4Ui6j3Y1rwlvukPkOqn25Em&Widget=Notification Queries&query=getDatabaseFields&dbType=" + string6;
            object = string7.length() > 0 && !string7.equalsIgnoreCase("0") ? (String)object + "&dbCred=" + string7 : (String)object + "&dbName=" + string8 + "&dbUser=" + string9 + "&dbPass=" + string10;
            object = (String)object + "&dbTable=" + string11;
            String string14 = (String)new TFormulaEvaluator().getFormulaValue("getWidget(\"" + (String)object + "\")");
            if (string14.trim().length() == 0) {
                System.out.println("No fields returned for table");
                return;
            }
            String[] stringArray2 = charutil.getSubStringArray(string14.trim(), '\n', false);
            TSqlField[] tSqlFieldArray = new TSqlField[stringArray2.length];
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                tSqlFieldArray[n2] = new TSqlField(stringArray2[n2]);
            }
            if (tSqlFieldArray != null) {
                for (n2 = 0; n2 < tSqlFieldArray.length; ++n2) {
                    String string15 = tSqlFieldArray[n2].getName();
                    String string16 = tSqlFieldArray[n2].getLabel();
                    if (string16.length() == 0) {
                        string16 = string15;
                    }
                    int n3 = 3;
                    int n4 = 1;
                    int n5 = 0;
                    switch (tSqlFieldArray[n2].getSqlType()) {
                        case 16: {
                            n3 = 19;
                            break;
                        }
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            n3 = 7;
                            break;
                        }
                        case 1: 
                        case 12: {
                            n3 = 3;
                            n4 = tSqlFieldArray[n2].getPrecision();
                            if (n4 != 0) break;
                            n4 = 256;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 6: 
                        case 7: 
                        case 8: {
                            n5 = tSqlFieldArray[n2].getScale();
                            if (n5 == 0) {
                                n3 = 7;
                                break;
                            }
                            n3 = 9;
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            n3 = 21;
                        }
                    }
                    n = tScrollTable.AspectDriver.initializeNewRecord();
                    if (n < 0) continue;
                    tScrollTable.AspectDriver.putFieldAbsolute((TDriverStructRecord)object2, n, (Object)new Integer(tScrollTable.AspectDriver.getNextVirtualIndex()));
                    tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_StructureName", n, (Object)string12);
                    tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_ID", n, (Object)string13);
                    tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_FieldID", n, (Object)string15);
                    tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_Description", n, (Object)string16);
                    tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_Decimals", n, (Object)new Integer(n5));
                    tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_FieldType", n, (Object)new Integer(n3));
                    tScrollTable.AspectDriver.putFieldAbsolute("Aspect_Structures_ArraySize", n, (Object)new Integer(n4));
                    tScrollTable.AspectDriver.addToFilterList(n);
                }
                if (n >= 0) {
                    tScrollTable.refreshTable();
                    tScrollTable.setSelectedRow(tScrollTable.AspectDriver.getFilteredIndex(n), true);
                }
            }
        } else {
            System.out.println("Structure named " + string13 + " already exists");
        }
        if (bl && tScrollTable2 != null) {
            n = tAspectDriver.getMatchingRecord("Aspect_Driver_ID=\"" + string13 + '\"', 0);
            if (n < 0) {
                object = "Name=" + string8 + "|Table=" + string11 + "|User=" + string9 + "|pass=" + string10;
                n = tAspectDriver.initializeNewRecord();
                tAspectDriver.putFieldAbsolute("Aspect_Driver_Description", n, (Object)string12);
                tAspectDriver.putFieldAbsolute("Aspect_Driver_ID", n, (Object)string13);
                tAspectDriver.putFieldAbsolute("Aspect_Driver_StructureID", n, (Object)string13);
                tAspectDriver.putFieldAbsolute("Aspect_Driver_FileName", n, (Object)"\"\"");
                tAspectDriver.putFieldAbsolute("Aspect_Driver_FileType", n, (Object)29);
                tScrollTable2.AspectDriver.addToFilterList(n);
                tScrollTable2.refreshTable();
                tScrollTable2.setSelectedRow(tScrollTable.AspectDriver.getFilteredIndex(n), true);
            } else {
                System.out.println("Skipping creation of " + string13 + " because a driver with that ID already exists");
            }
        }
        if (bl && tScrollTable2 != null && new Date().getTime() - starttime > 60000L) {
            this.Application.setTokenValue("Packages_Desktop_Source_Modified", "Modified");
            object = new TExecScript("Packages_updateModifiedIndicator", null, null);
            ((TExecScript)object).setParameters("PackageSource_Driver_Drivers");
            ((Thread)object).start();
        }
    }

    public ArrayList getStructResourceElements(String string) {
        int n;
        ArrayList<TAppDriverStructObject> arrayList = new ArrayList<TAppDriverStructObject>();
        StringBuilder stringBuilder = new StringBuilder();
        TDriverStructRecord tDriverStructRecord = this.getVirtualIndexField();
        TDriverStructRecord tDriverStructRecord2 = this.DriverStruct.getField("Aspect_Structures_ID");
        if (tDriverStructRecord == null || tDriverStructRecord2 == null) {
            return arrayList;
        }
        TDriverStructRecord[] tDriverStructRecordArray = new TDriverStructRecord[this.DriverStruct.FieldColl.size() - 5];
        for (n = 5; n < this.DriverStruct.FieldColl.size(); ++n) {
            tDriverStructRecordArray[n - 5] = this.DriverStruct.getDriverStructRecord(n);
        }
        for (n = 0; n < this.getRecordCount(); ++n) {
            Object object = this.getField(tDriverStructRecord2, n);
            String string2 = this.Application.parse_tokens((String)object);
            if (!string2.equalsIgnoreCase(string)) continue;
            Object object2 = this.getField(tDriverStructRecord, n);
            int n2 = (Integer)object2;
            stringBuilder.setLength(0);
            for (int i = 0; i < tDriverStructRecordArray.length; ++i) {
                if (tDriverStructRecordArray[i].IsVirtual) continue;
                object = this.getField(tDriverStructRecordArray[i], n);
                stringBuilder.append('\"' + objectutil.convertToString(object) + '\"');
                if (i >= tDriverStructRecordArray.length - 1) continue;
                stringBuilder.append(",");
            }
            String[] stringArray = charutil.getSubStringArray(stringBuilder, ',', true);
            TAppDriverStructObject tAppDriverStructObject = (TAppDriverStructObject)this.Application.AppDriverStruct.create_resource_object("", this.Application, -1, -1, -1L, n2, stringBuilder, stringArray);
            if ((n2 = Collections.binarySearch(arrayList, tAppDriverStructObject)) >= 0) continue;
            arrayList.add(Math.abs(n2 + 1), tAppDriverStructObject);
        }
        return arrayList;
    }

    public void previewWizard(TScrollTable tScrollTable) {
        int n = tScrollTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        Object object = this.AspectDriver.getField("Aspect_Structures_ID", n);
        if (object == null || !(object instanceof String)) {
            return;
        }
        String string = this.Application.parse_tokens((String)object);
        ArrayList arrayList = this.getStructResourceElements(string);
        ArrayList arrayList2 = this.Application.AppDriverStruct.removeResource(string);
        this.Application.AppDriverStruct.addResource(arrayList);
        TAppDriversObject tAppDriversObject = new TAppDriversObject("", string);
        tAppDriversObject.FileType = 22;
        TAspectDriver tAspectDriver = new TAspectDriver(this.Application, tAppDriversObject, 1, false, "");
        TDriverCmdEditRecordWizard tDriverCmdEditRecordWizard = new TDriverCmdEditRecordWizard("", "Record=New,Placement=Insert");
        tAspectDriver.setUndoRecording(false);
        tDriverCmdEditRecordWizard.setAspectDriver(tAspectDriver);
        tDriverCmdEditRecordWizard.initialize();
        tDriverCmdEditRecordWizard.run();
        tAspectDriver.dispose();
        this.Application.AppDriverStruct.removeResource(string);
        this.Application.AppDriverStruct.addResource(arrayList2);
    }

    @Override
    public String executeDriverCommand(JComponent jComponent, String string, String string2) {
        String string3 = "ok";
        if (jComponent instanceof TScrollTable) {
            if (string.equalsIgnoreCase("InitStructFromFile")) {
                this.initializeStructFromFile((TScrollTable)jComponent);
            }
            if (string.equalsIgnoreCase("InitStructFromDatabase")) {
                this.initializeStructFromDatabase((TScrollTable)jComponent);
            } else if (string.equalsIgnoreCase("PreviewEditRecordWizard")) {
                this.previewWizard((TScrollTable)jComponent);
            } else {
                super.executeDriverCommand(jComponent, string, string2);
            }
        } else {
            string3 = super.executeDriverCommand(jComponent, string, string2);
        }
        return string3;
    }
}

